/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.charva;

import charva.awt.Component;
import charva.awt.Insets;
import com.iscobol.gui.ParamElementWindowLocation;
import com.iscobol.gui.ParamLocationRet;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.charva.BorderedFrame;
import com.iscobol.gui.client.charva.GuiFactoryImpl;
import com.iscobol.gui.client.charva.RemoteBaseGUIControl;
import com.iscobol.gui.client.charva.RemoteBaseGUIWindow;
import com.iscobol.gui.client.charva.RemoteDisplayWindow;
import com.iscobol.gui.client.charva.Terminal;
import com.iscobol.gui.client.charva.TerminalModel;
import java.awt.Color;
import java.awt.Rectangle;

public class RemoteSubWindow
extends RemoteBaseGUIWindow {
    protected int theObject;
    protected RemoteDisplayWindow parent;
    private Color foreground;
    private Color background;
    private int foregroundIndex = -1;
    private int backgroundIndex = -1;
    private int width;
    private int height;
    private int line;
    private int column;
    private boolean active;
    private String title;
    private String title2;
    private int titlePosition = 2;
    private int titlePosition2 = 2;
    private boolean firsttitleset;
    private boolean boxed;
    private boolean shadow;
    private boolean wrap;
    private boolean scroll;
    private boolean alReadyPaint = false;
    private boolean initialized;
    private Terminal charTerminal;
    private TerminalModel.Area saveArea;
    private TerminalModel.Area popupArea;
    private float savecurrentline = -1.0f;
    private float savecurrentcolumn = -1.0f;
    private float initsavecurrentline = -1.0f;
    private float initsavecurrentcolumn = -1.0f;
    private int savetermattr = -1;
    private int savebackcolor = -1;
    private int initsavetermattr = -1;
    private int initsavebackcolor = -1;

    public RemoteSubWindow(GuiFactoryImpl gf, int pwId) {
        super(gf);
        this.parent = (RemoteDisplayWindow)gf.getClient().getId(pwId);
        this.charTerminal = this.parent.getMainWindow().getCharTerminal();
        this.mapSrvClId = this.parent.mapSrvClId;
        this.parent.setCurrentSW(this);
    }

    public void initialize() {
        if (!this.initialized) {
            if (this.column < 0) {
                this.column = 0;
            }
            if (this.line < 0) {
                this.line = 0;
            }
            this.mysetPopupArea();
            this.initsavetermattr = this.charTerminal.getTerminalModel().getTermAttr();
            this.initsavebackcolor = this.charTerminal.getTerminalModel().getBackColor();
            this.charTerminal.getTerminalModel().setSubwindow(this.column, this.line, this.column + this.width, this.line + this.height);
            if (this.background == null) {
                this.background = this.parent.getBackground();
            }
            if (this.foreground == null) {
                this.foreground = this.parent.getForeground();
            }
            if (this.foreground != null) {
                this.charTerminal.setForeColor(new charva.awt.Color(this.foreground.getRed(), this.foreground.getGreen(), this.foreground.getBlue()));
            }
            if (this.background != null) {
                this.charTerminal.setBackColor(new charva.awt.Color(this.background.getRed(), this.background.getGreen(), this.background.getBlue()));
            }
            this.initialized = true;
            this.drawStyle();
            this.initsavecurrentline = this.parent.getCurrentLine();
            this.initsavecurrentcolumn = this.parent.getCurrentColumn();
            this.parent.setCurrentLine(null, 1.0f);
            this.parent.setCurrentColumn(null, 1.0f);
        }
    }

    public boolean getAlReadyPaint() {
        return this.alReadyPaint;
    }

    public void setAlReadyPaint(boolean b) {
        this.alReadyPaint = b;
    }

    public void setId(int wId) {
        this.theObject = wId;
    }

    @Override
    public boolean isMainApplicationWindow() {
        return false;
    }

    public BorderedFrame getMainWindow() {
        return null;
    }

    @Override
    public void setFont(int f) {
    }

    @Override
    public int setFont(String n, int s, int t) {
        return -1;
    }

    @Override
    public Insets getInsets() {
        return null;
    }

    @Override
    public void setLocation(int x, int y) {
        this.line = x;
        this.column = y;
        this.initialize();
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    @Override
    public void setDefaultLocation(int f) {
    }

    public void setOffsetToolbar(int ot) {
    }

    @Override
    public void setSize(float cols, float lines) {
        this.width = (int)cols;
        this.height = (int)lines;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public void remove(int controlID) {
    }

    @Override
    public void add(int controlID) {
    }

    @Override
    public void add(int controlID, int index) {
    }

    public final int getMenu() {
        return -1;
    }

    public void setMenu(int menuID) {
    }

    @Override
    public void setActiveWindow(boolean a) {
        TerminalModel tm = this.charTerminal.getTerminalModel();
        this.active = a;
        if (this.active) {
            this.charTerminal.getTerminalModel().setSubwindow(this.column, this.line, this.column + this.width, this.line + this.height);
            this.drawStyle(false);
            this.parent.setCurrentSW(this);
        } else {
            tm.resetSubwindow();
            if (this.parent.getCurrentSW() == this) {
                this.parent.setCurrentSW(null);
            }
        }
    }

    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setTitle(String t) {
        if (!this.boxed) {
            return;
        }
        if (!(this.title != null && this.title.length() != 0 || t != null && t.length() != 0)) {
            return;
        }
        if (!this.firsttitleset) {
            this.firsttitleset = true;
            this.title = t.trim();
            this.title2 = null;
        } else {
            this.title2 = t.trim();
        }
        this.drawStyle(false);
    }

    @Override
    public void setTitlePosition(int t) {
        if (!this.firsttitleset) {
            this.titlePosition = t;
        } else {
            this.titlePosition2 = t;
        }
    }

    @Override
    public void setBackground(int r, int b, int g) {
        this.background = new Color(r, g, b);
    }

    @Override
    public void setBackgroundIdx(int idx) {
        Color c = this.gf.getRemotePalette().getDefaultColor(idx);
        if (c != null) {
            this.backgroundIndex = idx;
            this.background = c;
            if (this.initialized) {
                this.charTerminal.setBackColor(new charva.awt.Color(c.getRed(), c.getGreen(), c.getBlue()));
                this.drawStyle(false);
            }
        }
    }

    @Override
    public void setForeground(int r, int b, int g) {
        this.foreground = new Color(r, g, b);
    }

    @Override
    public void setForegroundIdx(int idx) {
        Color c = this.gf.getRemotePalette().getDefaultColor(idx);
        if (c != null) {
            this.foregroundIndex = idx;
            this.foreground = c;
            if (this.initialized) {
                this.charTerminal.setForeColor(new charva.awt.Color(c.getRed(), c.getGreen(), c.getBlue()));
                this.drawStyle(false);
            }
        }
    }

    public int getType() {
        return -1;
    }

    @Override
    public void destroy() {
        if (this.parent != null) {
            this.parent.removeChildSubWindow(this);
        }
        this.gf.getClient().delId(this.theObject);
    }

    @Override
    public void toFront() {
    }

    @Override
    public Rectangle getMainBounds() {
        return null;
    }

    @Override
    public Rectangle getBounds() {
        return null;
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public int getBackgroundIdx() {
        return this.backgroundIndex;
    }

    @Override
    public boolean getBoxed() {
        return this.boxed;
    }

    public boolean getShadow() {
        return this.shadow;
    }

    @Override
    public int getFont() {
        return -1;
    }

    @Override
    public Color getForeground() {
        return this.foreground;
    }

    @Override
    public int getForegroundIdx() {
        return this.foregroundIndex;
    }

    public int getTheObjectId() {
        return this.theObject;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean getWrap() {
        return this.wrap;
    }

    @Override
    public boolean isGraphical() {
        return false;
    }

    @Override
    public void setAutoResize(boolean as) {
    }

    public boolean getAutoResize() {
        return false;
    }

    public void setMaxHeight(int mh) {
    }

    public int getMaxHeight() {
        return this.height;
    }

    @Override
    public void setMaxLines(int maxLines) {
    }

    @Override
    public void setMaxSize(int maxSize) {
    }

    public void setMaxWidth(int mw) {
    }

    public int getMaxWidth() {
        return this.width;
    }

    public void setMinHeight(int mh) {
    }

    public int getMinHeight() {
        return this.height;
    }

    @Override
    public void setMinLines(int minLines) {
    }

    @Override
    public void setMinSize(int minSize) {
    }

    public void setMinWidth(int mw) {
    }

    public int getMinWidth() {
        return this.width;
    }

    @Override
    public void setPopupArea() {
        this.popupArea = this.saveArea;
        this.savecurrentline = this.initsavecurrentline;
        this.savecurrentcolumn = this.initsavecurrentcolumn;
        this.savetermattr = this.initsavetermattr;
        this.savebackcolor = this.initsavebackcolor;
    }

    private void mysetPopupArea() {
        TerminalModel tm = this.charTerminal.getTerminalModel();
        if (this.column >= 0 && this.line > 0) {
            int okcolumn = this.column;
            if (this.column >= 0) {
                okcolumn = this.column > 0 ? this.column - 1 : this.column;
            }
            this.saveArea = tm.getArea(okcolumn, this.line - 1, this.width + 3, this.height + 3);
        } else {
            this.saveArea = tm.getArea(this.column, this.line, this.width + 1, this.height + 1);
        }
    }

    public void restorePopupArea(boolean nodisplay) {
        if (!nodisplay && this.popupArea != null) {
            TerminalModel tm = this.charTerminal.getTerminalModel();
            if (this.boxed && this.column >= 0 && this.line > 0) {
                int okcolumn = this.column;
                if (this.column >= 0) {
                    int n = okcolumn = this.column > 0 ? this.column - 1 : this.column;
                }
                if (this.shadow || this.column == 0) {
                    tm.restoreArea(this.popupArea, okcolumn, this.line - 1, this.width + 3, this.height + 3);
                } else {
                    tm.restoreArea(this.popupArea, okcolumn, this.line - 1, this.width + 2, this.height + 2);
                }
            } else if (this.shadow) {
                tm.restoreArea(this.popupArea, this.column, this.line, this.width + 1, this.height + 1);
            } else {
                tm.restoreArea(this.popupArea, this.column, this.line, this.width, this.height);
            }
            this.charTerminal.repaint();
        }
        if (this.popupArea != null) {
            this.parent.setCurrentLine(null, this.savecurrentline);
            this.parent.setCurrentColumn(null, this.savecurrentcolumn);
            this.charTerminal.getTerminalModel().setBackColor(this.savebackcolor);
            this.charTerminal.getTerminalModel().setTermAttr(this.savetermattr);
        }
    }

    @Override
    public void setResizable(boolean r) {
    }

    public boolean getResizable() {
        return false;
    }

    @Override
    public void setScroll(boolean s) {
        this.scroll = s;
    }

    @Override
    public void setEnabled(boolean b) {
    }

    @Override
    public void setVisible(boolean b) {
    }

    @Override
    public void setWithSystemMenu(boolean b) {
    }

    @Override
    public int getCellHeight() {
        return this.parent.getCellHeight();
    }

    @Override
    public int getCellWidth() {
        return this.parent.getCellWidth();
    }

    @Override
    public void setCellHeight(float ch) {
    }

    @Override
    public void setCellWidth(float cw) {
    }

    @Override
    public void setCellWidth(String fontName, int fontStyle, int fontSize) {
    }

    @Override
    public void setCellHeight(String fontName, int fontStyle, int fontSize) {
    }

    public void handleResponse(int eventAction, int eventId) {
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setModal(boolean m) {
    }

    public void setPopupMenu(int menuId) {
    }

    @Override
    public void setStyle(int v) {
        if (v == 23) {
            this.boxed = true;
            this.drawStyle();
        } else if (v == 219) {
            this.shadow = true;
            this.drawStyle();
        }
    }

    @Override
    public void setAction(float cv) {
        switch ((int)cv) {
            case 21: {
                break;
            }
            case 20: {
                break;
            }
            case 22: {
                break;
            }
        }
    }

    @Override
    public void setTitleBar(boolean b) {
    }

    @Override
    public void unsetStyle(int s) {
    }

    public void erase(int flg, int col, int line) {
        TerminalModel tm = this.charTerminal.getTerminalModel();
        switch (flg) {
            case 2: {
                tm.move(col, line);
                tm.clrtoeol();
                break;
            }
            case 1: {
                tm.move(col, line);
                tm.clrtobot();
                break;
            }
            case 3: {
                tm.erase();
            }
        }
        this.charTerminal.repaint();
    }

    private void drawStyle() {
        this.drawStyle(true);
    }

    private void drawStyle(boolean clear) {
        if (this.initialized) {
            TerminalModel tm = this.charTerminal.getTerminalModel();
            int okcolumn = this.column;
            if (this.column >= 0) {
                int n = okcolumn = this.column > 0 ? this.column - 1 : this.column;
            }
            if (this.boxed && this.column >= 0 && this.line > 0) {
                charva.awt.Color cfore = new charva.awt.Color(this.foreground.getRed(), this.foreground.getGreen(), this.foreground.getBlue());
                charva.awt.Color cback = new charva.awt.Color(this.background.getRed(), this.background.getGreen(), this.background.getBlue());
                tm.setBackColor(cback);
                tm.setForeColor(cfore);
                tm.box(okcolumn, this.line - 1, this.width + 2, this.height + 2, cfore, 0, cback, new String[]{this.title, this.title2}, new int[]{this.titlePosition, this.titlePosition2}, false, this.parent.getMainWindow().getCharTerminal().getGraphics());
                if (clear) {
                    tm.clrarea(okcolumn, this.line, this.width, this.height);
                }
            }
            if (this.shadow) {
                if (this.boxed && this.column >= 0 && this.line > 0) {
                    tm.shadow(okcolumn, this.line - 1, this.width + 2, this.height + 2, true);
                } else {
                    tm.shadow(okcolumn, this.line, this.width, this.height, false);
                }
            }
        }
    }

    @Override
    public void paramsetLocation(ParamElementWindowLocation pwl) {
    }

    @Override
    public int[] componentsetErase(int flgerase, int col, int row, charva.awt.Color bgColor, int[] fieldsid) {
        return this.parent.componentsetErase(flgerase, col, row, bgColor, fieldsid);
    }

    @Override
    public void remove(int controlID, boolean wait) {
        this.parent.remove(controlID, wait);
    }

    @Override
    public int[] componentsetEraseArea(int[] limit) {
        this.erase(limit[0], 0, 0);
        return this.parent.componentsetEraseArea(limit, false);
    }

    @Override
    protected synchronized void repaintTerminal(Component cc) {
        this.firsttitleset = false;
        if (cc != null) {
            super.repaintTerminal(cc);
        } else {
            this.charTerminal.repaint();
        }
    }

    @Override
    public void addMnemonic(char c, RemoteBaseGUIControl comp) {
        this.parent.addMnemonic(c, comp);
    }

    @Override
    public void removeMnemonic(RemoteBaseGUIControl comp) {
        this.parent.removeMnemonic(comp);
    }

    @Override
    public void setCurrentLine(ParamLocationRet pl, float l) {
        this.parent.setCurrentLine(null, l);
    }

    @Override
    public void setCurrentColumn(ParamLocationRet pl, float l) {
        this.parent.setCurrentColumn(null, l);
    }
}

