/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.Constants;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.swing.ChipsBoxElement;
import com.iscobol.gui.client.swing.NotifyMouseEvent;
import com.iscobol.gui.client.swing.NotifyMouseListener;
import com.iscobol.gui.client.swing.RemoteChipsBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseListener;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class ChipsBoxContainer
extends JScrollPane
implements Constants {
    private static final long serialVersionUID = 1L;
    RemoteChipsBox parent;
    JPanel jpcb = new JPanel();
    Vector<ChipsBoxElement> cpvector = new Vector();
    private Image image;
    private Image imagemouseentered;
    private Image imagemouseexited;
    private int imageHeight = -1;
    private int imageWidth = -1;
    private int bitmapNumber = -1;
    private Dimension origSize;
    private Color background;
    private Color foreground;
    private Font font;
    private MouseListener ml = null;
    private int chipstype = 1;
    private int textheight = -1;
    private int chipsradius = 100;
    private int chipsborderwidth = -1;
    private int chipsrolloverborderwidth = -1;
    private NotifyMouseListener nmListener = null;
    private boolean unsorted;
    private static Comparator<ChipsBoxElement> ignoreCaseComparator = (item1, item2) -> item1.getItemText().compareToIgnoreCase(item2.getItemText());

    public ChipsBoxContainer(RemoteChipsBox parent) {
        this.parent = parent;
        this.setHorizontalScrollBarPolicy(31);
        this.setViewportView(this.jpcb);
        this.jpcb.setLayout(new IsWrapLayout(3));
        this.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JScrollPane scrollPane = (JScrollPane)e.getComponent();
                JViewport viewport = scrollPane.getViewport();
                Dimension d = viewport.getSize();
                viewport.getView().setSize(d);
            }
        });
    }

    public void setType(int chipstype) {
        this.chipstype = chipstype;
    }

    @Override
    public void addMouseListener(MouseListener ml) {
        super.addMouseListener(ml);
        this.ml = ml;
    }

    public MouseListener getMouseListener() {
        return this.ml;
    }

    private Icon getIcon(int strip) {
        return null;
    }

    public void setImage(Image image, int width, int height) {
        if (this.image != image || this.imageWidth != width || this.imageHeight != height) {
            this.image = image;
            this.imageHeight = height;
            this.imageWidth = width;
            if (this.bitmapNumber == 0) {
                this.bitmapNumber = 1;
            }
        }
    }

    public void setImageMouseEntered(Image me) {
        this.imagemouseentered = me;
    }

    public void setImageMouseExited(Image me) {
        this.imagemouseexited = me;
    }

    public int itemToAdd(String text, int textwidth, int textheight, int chipsradius) {
        int index = -1;
        this.textheight = textheight;
        this.setChipsRadius(chipsradius);
        ChipsBoxElement cbe = new ChipsBoxElement(this, this.jpcb, text, textwidth, textheight, this.imagemouseentered, this.imagemouseexited, this.chipstype, chipsradius, this.chipsborderwidth, this.chipsrolloverborderwidth);
        if (this.foreground != null) {
            cbe.setForegroundAndCheck(this.foreground);
        }
        if (this.background != null && this.parent != null && this.parent.isBackgroundSet()) {
            cbe.setBackgroundAndCheck(this.background);
        }
        if (this.font != null) {
            cbe.setFont(this.font);
        }
        if (this.unsorted) {
            this.cpvector.add(cbe);
            this.jpcb.add(cbe);
            index = this.cpvector.size();
        } else {
            index = ScreenUtility.getInsertionIndex(this.cpvector, cbe, ignoreCaseComparator);
            this.cpvector.add(index, cbe);
            this.jpcb.add((Component)cbe, index);
            ++index;
        }
        this.jpcb.doLayout();
        this.getViewport().validate();
        return index;
    }

    public int itemToDelete(int idx) {
        int Return2 = -1;
        if (idx < 0 || idx > this.cpvector.size()) {
            return Return2;
        }
        ChipsBoxElement cbe = this.cpvector.elementAt(idx);
        if (cbe != null) {
            this.jpcb.remove(cbe);
            this.jpcb.doLayout();
            this.getViewport().validate();
            this.repaint();
            if (this.cpvector.indexOf(cbe) >= 0) {
                this.cpvector.remove(cbe);
            }
        }
        return Return2;
    }

    public void resetList() {
        this.jpcb.removeAll();
        this.jpcb.doLayout();
        this.getViewport().validate();
        this.repaint();
        this.cpvector.clear();
    }

    public void setBitmapNumber(int idx, int bitmapnumber) {
        if (idx < 0 || idx > this.cpvector.size()) {
            return;
        }
        ChipsBoxElement cbe = this.cpvector.elementAt(idx);
        if (cbe != null) {
            cbe.setBitmapNumber(bitmapnumber);
        }
    }

    public void setBitmapWidth(int idx, int bitmapwidth) {
        if (idx < 0 || idx > this.cpvector.size()) {
            return;
        }
        ChipsBoxElement cbe = this.cpvector.elementAt(idx);
        if (cbe != null) {
            cbe.setBitmapWidth(bitmapwidth);
        }
    }

    public void setBitmap(int idx, int bitmapid, Image bitmap) {
        if (idx < 0 || idx > this.cpvector.size()) {
            return;
        }
        ChipsBoxElement cbe = this.cpvector.elementAt(idx);
        if (cbe != null) {
            cbe.setBitmap(bitmapid, bitmap, false);
        }
    }

    public void setItemText(int idx, String text, int textwidth, int textheight) {
        if (idx < 0 || idx > this.cpvector.size()) {
            return;
        }
        this.textheight = textheight;
        ChipsBoxElement cbe = this.cpvector.elementAt(idx);
        if (cbe != null) {
            cbe.setItemText(text, textwidth, textheight);
            this.doLayout();
        }
    }

    public void msgClose(int idx) {
        if (idx < 0 || idx > this.cpvector.size()) {
            return;
        }
        ChipsBoxElement cbe = this.cpvector.elementAt(idx);
        if (cbe != null) {
            this.jpcb.remove(cbe);
            if (this.cpvector.indexOf(cbe) >= 0) {
                this.cpvector.remove(cbe);
            }
            this.jpcb.doLayout();
            this.getViewport().validate();
            this.repaint();
        }
    }

    public void setFontDimension(int fontheight) {
        int save = this.textheight;
        this.textheight = fontheight;
        ChipsBoxElement cbe = null;
        if (this.jpcb != null) {
            for (int i = 0; i < this.cpvector.size(); ++i) {
                cbe = this.cpvector.elementAt(i);
                cbe.setTextHeight(this.textheight);
            }
            this.jpcb.doLayout();
            this.getViewport().validate();
            this.repaint();
        }
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.font = f;
        ChipsBoxElement cbe = null;
        if (this.jpcb != null) {
            for (int i = 0; i < this.cpvector.size(); ++i) {
                cbe = this.cpvector.elementAt(i);
                cbe.setFont(f);
            }
        }
    }

    @Override
    public void setForeground(Color f) {
        this.foreground = f;
        ChipsBoxElement cbe = null;
        if (this.jpcb != null) {
            for (int i = 0; i < this.cpvector.size(); ++i) {
                cbe = this.cpvector.elementAt(i);
                cbe.setForegroundAndCheck(f);
            }
        }
    }

    @Override
    public void setBackground(Color f) {
        if (this.parent != null && this.parent.isBackgroundSet()) {
            this.background = f;
        }
        ChipsBoxElement cbe = null;
        if (this.jpcb != null) {
            for (int i = 0; i < this.cpvector.size(); ++i) {
                cbe = this.cpvector.elementAt(i);
                cbe.setBackgroundAndCheck(f);
            }
        }
    }

    public void setChipsRadius(int chipsradius) {
        if (this.chipsradius != chipsradius && chipsradius >= 0 && chipsradius <= 100) {
            this.chipsradius = chipsradius;
            ChipsBoxElement cbe = null;
            if (this.jpcb != null) {
                for (int i = 0; i < this.cpvector.size(); ++i) {
                    cbe = this.cpvector.elementAt(i);
                    cbe.setChipsRadius(chipsradius);
                }
                this.repaint();
                this.doLayout();
                this.validate();
            }
        }
    }

    public RemoteChipsBox getCBParent() {
        return this.parent;
    }

    private ColorCmp setColor(ColorCmp color, int value) {
        return this.setColor(color, value, false, false, false);
    }

    private ColorCmp setColor(ColorCmp color, int value, boolean isbg, boolean isrgb) {
        return this.setColor(color, value, true, isbg, isrgb);
    }

    private ColorCmp setColor(ColorCmp color, int value, boolean isfb, boolean isbg, boolean isrgb) {
        if (value == 0 && !isrgb) {
            return null;
        }
        if (isfb) {
            if (color == null) {
                color = new ColorCmp(true);
            }
            if (isbg) {
                if (isrgb || ColorCmp.isRGB(value)) {
                    color.setBackRGB(value);
                } else {
                    color.setBackground(value);
                }
            } else if (isrgb || ColorCmp.isRGB(value)) {
                color.setForeRGB(value);
            } else {
                color.setForeground(value);
            }
        } else {
            if (color == null) {
                color = new ColorCmp(true);
            }
            color.setColor(value, true);
        }
        return color;
    }

    public int getCBColor(int idx, boolean isfg, boolean isbg, boolean isrgb) {
        int Return2 = -1;
        if (idx < 0 || idx > this.cpvector.size()) {
            return Return2;
        }
        ChipsBoxElement cbe = this.cpvector.elementAt(idx);
        if (cbe != null) {
            Return2 = cbe.getCBColor(isfg, isbg, isrgb);
        }
        return Return2;
    }

    public void setCBColor(int idx, int c, boolean isfg, boolean isbg, boolean isrgb) {
        if (idx < 0 || idx > this.cpvector.size()) {
            return;
        }
        ChipsBoxElement cbe = this.cpvector.elementAt(idx);
        ColorCmp cc = null;
        if (isfg || isbg || isrgb) {
            cc = cbe.getCBColor();
        }
        cbe.setCBColor(this.setColor(cc, c, isfg, isbg, isrgb), c, isfg, isbg, isrgb);
    }

    public int getCBRolloverColor(int idx, boolean isfg, boolean isbg, boolean isrgb) {
        int Return2 = -1;
        if (idx < 0 || idx > this.cpvector.size()) {
            return Return2;
        }
        ChipsBoxElement cbe = this.cpvector.elementAt(idx);
        if (cbe != null) {
            Return2 = cbe.getCBRolloverColor(isfg, isbg, isrgb);
        }
        return Return2;
    }

    public void setCBRolloverColor(int idx, int c, boolean isfg, boolean isbg, boolean isrgb) {
        if (idx < 0 || idx > this.cpvector.size()) {
            return;
        }
        ChipsBoxElement cbe = this.cpvector.elementAt(idx);
        ColorCmp cc = null;
        if (isfg || isbg || isrgb) {
            cc = cbe.getCBRolloverColor();
        }
        cbe.setCBRolloverColor(this.setColor(cc, c, isfg, isbg, isrgb), c, isfg, isbg, isrgb);
    }

    public int getCBBorderColor(int idx, boolean isrgb) {
        int Return2 = -1;
        if (idx < 0 || idx > this.cpvector.size()) {
            return Return2;
        }
        ChipsBoxElement cbe = this.cpvector.elementAt(idx);
        if (cbe != null) {
            Return2 = cbe.getCBBorderColor(isrgb);
        }
        return Return2;
    }

    public void setCBBorderColor(int idx, Color b, int c, boolean isrgb) {
        if (idx < 0 || idx > this.cpvector.size()) {
            return;
        }
        ChipsBoxElement cbe = this.cpvector.elementAt(idx);
        cbe.setCBBorderColor(b, c, isrgb);
    }

    public int getCBRolloverBorderColor(int idx, boolean isrgb) {
        int Return2 = -1;
        if (idx < 0 || idx > this.cpvector.size()) {
            return Return2;
        }
        ChipsBoxElement cbe = this.cpvector.elementAt(idx);
        if (cbe != null) {
            Return2 = cbe.getCBRolloverBorderColor(isrgb);
        }
        return Return2;
    }

    public void setCBRolloverBorderColor(int idx, Color b, int c, boolean isrgb) {
        if (idx < 0 || idx > this.cpvector.size()) {
            return;
        }
        ChipsBoxElement cbe = this.cpvector.elementAt(idx);
        cbe.setCBRolloverBorderColor(b, c, isrgb);
    }

    public Color getColor(int idx) {
        return this.parent.getColor(idx);
    }

    public void setHiddenData(int idx, Object value) {
        if (idx < 0 || idx > this.cpvector.size()) {
            return;
        }
        ChipsBoxElement cbe = this.cpvector.elementAt(idx);
        if (cbe != null) {
            cbe.setHiddenData(value);
        }
    }

    public Object getHiddenData(int idx) {
        if (idx < 0 || idx > this.cpvector.size()) {
            return null;
        }
        ChipsBoxElement cbe = this.cpvector.elementAt(idx);
        if (cbe != null) {
            return cbe.getHiddenData();
        }
        return null;
    }

    public void sendClose(ChipsBoxElement cbe) {
        this.parent.sendClose(this.cpvector.indexOf(cbe));
    }

    public void sendClicked(ChipsBoxElement cbe) {
        this.parent.sendClicked(this.cpvector.indexOf(cbe));
    }

    public void sendMouseEntered(ChipsBoxElement cbe) {
        if (this.nmListener != null) {
            this.nmListener.sendNotifyMouseData(new NotifyMouseEvent(cbe, 17023, this.cpvector.indexOf(cbe) + 1, 1));
        }
    }

    public void sendMouseExited(ChipsBoxElement cbe) {
        if (this.nmListener != null) {
            this.nmListener.sendNotifyMouseData(new NotifyMouseEvent(cbe, 17024, 0, 0));
        }
    }

    public int getLastChip() {
        return this.cpvector.size();
    }

    public String getItemText(int idx) {
        String Return2 = "";
        if (idx < 0 || idx > this.cpvector.size()) {
            return Return2;
        }
        ChipsBoxElement cbe = this.cpvector.elementAt(idx);
        if (cbe != null) {
            Return2 = cbe.getItemText();
        }
        return Return2;
    }

    public int getBitmap(int idx) {
        int Return2 = -1;
        if (idx < 0 || idx > this.cpvector.size()) {
            return Return2;
        }
        ChipsBoxElement cbe = this.cpvector.elementAt(idx);
        if (cbe != null) {
            Return2 = cbe.getBitmap();
        }
        return Return2;
    }

    public int getBitmapNumber(int idx) {
        int Return2 = -1;
        if (idx < 0 || idx > this.cpvector.size()) {
            return Return2;
        }
        ChipsBoxElement cbe = this.cpvector.elementAt(idx);
        if (cbe != null) {
            Return2 = cbe.getBitmapNumber();
        }
        return Return2;
    }

    public int getBitmapWidth(int idx) {
        int Return2 = -1;
        if (idx < 0 || idx > this.cpvector.size()) {
            return Return2;
        }
        ChipsBoxElement cbe = this.cpvector.elementAt(idx);
        if (cbe != null) {
            Return2 = cbe.getBitmapWidth();
        }
        return Return2;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.jpcb != null) {
            this.jpcb.doLayout();
        }
    }

    public void setBorderWidth(int chipsborderwidth) {
        this.chipsborderwidth = chipsborderwidth;
    }

    public int getBorderWidth() {
        return this.chipsborderwidth;
    }

    public void setRolloverBorderWidth(int chipsrolloverborderwidth) {
        this.chipsrolloverborderwidth = chipsrolloverborderwidth;
    }

    public int getRolloverBorderWidth() {
        return this.chipsrolloverborderwidth;
    }

    public void addNotifyMouseListener(NotifyMouseListener nmListener) {
        this.nmListener = nmListener;
    }

    public void removeNotifyMouseListener() {
        this.nmListener = null;
    }

    public void setUnsorted(boolean unsorted) {
        this.unsorted = unsorted;
    }

    public class IsWrapLayout
    extends FlowLayout {
        private Dimension preferredLayoutSize;

        public IsWrapLayout() {
        }

        public IsWrapLayout(int align) {
            super(align);
        }

        public IsWrapLayout(int align, int hgap, int vgap) {
            super(align, hgap, vgap);
        }

        @Override
        public Dimension preferredLayoutSize(Container target) {
            return this.layoutSize(target, true);
        }

        @Override
        public Dimension minimumLayoutSize(Container target) {
            return this.layoutSize(target, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container target, boolean preferred) {
            Object object = target.getTreeLock();
            synchronized (object) {
                int targetWidth = target.getSize().width;
                if (targetWidth == 0) {
                    targetWidth = Integer.MAX_VALUE;
                }
                int hgap = this.getHgap();
                int vgap = this.getVgap();
                Insets insets = target.getInsets();
                int maxWidth = targetWidth - (insets.left + insets.right + hgap * 2);
                Dimension dim = new Dimension(0, 0);
                int rowWidth = 0;
                int rowHeight = 0;
                int nmembers = target.getComponentCount();
                for (int i = 0; i < nmembers; ++i) {
                    Dimension d;
                    Component m = target.getComponent(i);
                    if (!m.isVisible()) continue;
                    Dimension dimension = d = preferred ? m.getPreferredSize() : m.getMinimumSize();
                    if (rowWidth + d.width > maxWidth) {
                        this.addRow(dim, rowWidth, rowHeight);
                        rowWidth = 0;
                        rowHeight = 0;
                    }
                    if (rowWidth > 0) {
                        rowWidth += hgap;
                    }
                    rowWidth += d.width;
                    rowHeight = Math.max(rowHeight, d.height);
                }
                this.addRow(dim, rowWidth, rowHeight);
                dim.width += insets.left + insets.right + hgap * 2;
                dim.height += insets.top + insets.bottom + vgap * 2;
                return dim;
            }
        }

        private void addRow(Dimension dim, int rowWidth, int rowHeight) {
            dim.width = Math.max(dim.width, rowWidth);
            if (dim.height > 0) {
                dim.height += this.getVgap();
            }
            dim.height += rowHeight;
        }

        @Override
        public void layoutContainer(Container target) {
            Dimension size = this.preferredLayoutSize(target);
            if (size.equals(this.preferredLayoutSize)) {
                super.layoutContainer(target);
            } else {
                this.preferredLayoutSize = size;
                target.invalidate();
                Container top = target;
                if (top.getParent() != null) {
                    top = top.getParent();
                }
                top.validate();
            }
        }
    }
}

