/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.swing.BaseRemoteObject;
import com.iscobol.gui.client.swing.EditableTextField;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteMenu;
import com.iscobol.rts.Factory;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class PopupListener
extends MouseAdapter {
    private JPopupMenu defaultPopup;
    private JMenuItem undo;
    private JMenuItem redo;
    private JMenuItem cut;
    private JMenuItem copy;
    private JMenuItem paste;
    private JMenuItem delete;
    private JMenuItem selectAll;
    private RemoteMenu popup;
    private BaseRemoteObject invoker;
    private EditableTextField textField;

    public PopupListener(BaseRemoteObject invoker, RemoteMenu pm) {
        this.popup = pm;
        this.invoker = invoker;
    }

    public PopupListener(EditableTextField textField) {
        this.textField = textField;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    public void maybeShowPopup(MouseEvent e) {
        this.maybeShowPopup(e, false);
    }

    public void maybeShowPopup(MouseEvent e, boolean force) {
        if (e.isPopupTrigger() || force) {
            boolean cenabled = true;
            Component c = (Component)e.getSource();
            if (c != null) {
                cenabled = c.isEnabled();
            }
            if (!cenabled) {
                return;
            }
            if (this.popup != null) {
                int x = e.getX();
                int y = e.getY();
                if (this.invoker instanceof RemoteBaseGUIControl) {
                    Point p = ((RemoteBaseGUIControl)this.invoker).getReferencedPopupLocation(e);
                    x = (int)p.getX();
                    y = (int)p.getY();
                }
                this.popup.firePopupMenuEvents(this.invoker, x, y);
            } else {
                this.getDefaultPopup().show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }

    private JPopupMenu getDefaultPopup() {
        if (this.defaultPopup == null) {
            this.defaultPopup = new JPopupMenu();
            this.undo = new JMenuItem(Factory.getSysMsg("undo"));
            this.undo.addActionListener(e -> this.textField.undo());
            this.defaultPopup.add(this.undo);
            this.redo = new JMenuItem(Factory.getSysMsg("redo"));
            this.redo.addActionListener(e -> this.textField.redo());
            this.defaultPopup.add(this.redo);
            this.defaultPopup.addSeparator();
            this.cut = new JMenuItem(Factory.getSysMsg("cut"));
            this.cut.addActionListener(e -> this.textField.cut());
            this.defaultPopup.add(this.cut);
            this.copy = new JMenuItem(Factory.getSysMsg("copy"));
            this.copy.addActionListener(e -> this.textField.copy());
            this.defaultPopup.add(this.copy);
            this.paste = new JMenuItem(Factory.getSysMsg("paste"));
            this.paste.addActionListener(e -> this.textField.paste());
            this.defaultPopup.add(this.paste);
            this.delete = new JMenuItem(Factory.getSysMsg("delete"));
            this.delete.addActionListener(e -> this.textField.replaceSelection(""));
            this.defaultPopup.add(this.delete);
            this.defaultPopup.addSeparator();
            this.selectAll = new JMenuItem(Factory.getSysMsg("selectall"));
            this.selectAll.addActionListener(e -> SwingUtilities.invokeLater(() -> this.textField.selectAll()));
            this.defaultPopup.add(this.selectAll);
        }
        int textLen = this.textField.getText().length();
        boolean hasSel = this.textField.hasSelection();
        boolean isEditable = this.textField.isEditable();
        this.undo.setEnabled(this.textField.canUndo() && isEditable);
        this.redo.setEnabled(this.textField.canRedo() && isEditable);
        this.cut.setEnabled(hasSel && isEditable);
        this.copy.setEnabled(hasSel);
        this.paste.setEnabled(ScreenUtility.canPaste(this.textField.getClass()) && isEditable);
        this.delete.setEnabled(hasSel && isEditable);
        this.selectAll.setEnabled(textLen > 0);
        return this.defaultPopup;
    }

    public boolean isDefaultPopupVisible() {
        return this.defaultPopup != null && this.defaultPopup.isVisible();
    }

    public JPopupMenu getPopupMenu() {
        return this.popup != null ? this.popup.menuPopup : this.getDefaultPopup();
    }
}

