/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.MyTransferable;
import com.iscobol.gui.PagedListBoxEvent;
import com.iscobol.gui.PagedListBoxListener;
import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.LocalImage;
import com.iscobol.gui.client.ZoomLayout;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.GradientManager;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.ListBox;
import com.iscobol.gui.client.swing.MassUpdatePanel;
import com.iscobol.gui.client.swing.NotifyMouseEvent;
import com.iscobol.gui.client.swing.NotifyMouseListener;
import com.iscobol.gui.client.swing.PicobolListBox;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.SwingListBoxDataProvider;
import com.iscobol.gui.client.swing.SwingWorker;
import com.iscobol.gui.export.ExportUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class RemoteListBox
extends RemoteBaseGUIControl
implements PagedListBoxListener,
NotifyMouseListener {
    private static final float DEFAULT_INSETS = 0.8f;
    private static final float DEFAULT_WIDTH = 8.0f;
    public static final int SINGLE_SELECTION = 1;
    public static final int SINGLE_INTERVAL_SELECTION = 2;
    public static final int MULTIPLE_INTERVAL_SELECTION = 4;
    private boolean notifySelChange;
    private boolean notifyDblClik;
    private boolean unsorted;
    private boolean noSearch;
    private boolean _3d;
    private boolean boxed;
    private boolean noBox;
    private boolean lower;
    private boolean upper;
    private boolean checkList;
    private int insertionIndex;
    private int[] lastSelectedIndices = new int[0];
    private String lastSelectionValue;
    private int selectionIndex = -1;
    private int queryIndex;
    private int resetList;
    private int thumbPosition;
    private boolean paged;
    private int sortOrder = -1;
    private int massUpdate;
    private Vector items = new Vector();
    private Vector dataColumns = new Vector();
    private Vector displayColumns = new Vector();
    private Vector alignments = new Vector();
    private Vector separators = new Vector();
    private Vector dividers = new Vector();
    private Vector rowColorPatterns = new Vector();
    private String valueStr = "";
    private boolean dataColumnsChanged;
    private boolean displayColumnsChanged;
    private boolean alignmentsChanged;
    private boolean separatorsChanged;
    private boolean dividersChanged;
    private boolean rowColorPatternsChanged;
    private int mousewheellinestoscroll = 1;
    private ListBox.ListItem curritem;
    private Color borderColor;
    private ColorCmp borderColorCmp;
    private int borderColorIdx;
    private Integer lmOnColumns;
    private PropertyChangeListener pcListener;
    private boolean pagedListenerAdded;
    private boolean useDefaultBorderWithBoxedStyle;
    private Border defaultBorder;
    private int selectionMode;
    private String exportFileName;
    private String exportFileFormat;
    private boolean exportFileopen;
    private boolean f4ShowsSearchBox;
    private final boolean acuCompatibility;
    private Integer selectionColor;
    private Integer selectionBackgroundColor;
    private Integer selectionForegroundColor;
    private boolean selectionBackgroundRgb;
    private boolean selectionForegroundRgb;
    private GradientManager gradientMgr = new GradientManager();
    private int searchpanel = 0;
    private String matchingTextColor;
    private boolean lastmousevalueisexit = true;
    private boolean[] searchPanelSettings;
    private int matchNodeIdx;
    private int currNodeMatchIdx = -1;

    public RemoteListBox(GuiFactoryImpl gf) {
        super(gf);
        this.useDefaultBorderWithBoxedStyle = gf.getCsProperty().get("iscobol.gui.native_style", false);
        this.f4ShowsSearchBox = gf.getCsProperty().get("iscobol.key.f4.system", true);
        this.acuCompatibility = gf.getCsProperty().get("iscobol.properties.acu_compat", false);
        this.matchingTextColor = gf.getCsProperty().get("iscobol.gui.matching_text_color", null);
        this.setSearchPanelSettings(gf.getCsProperty().get("iscobol.gui.search_panel_settings", "1012"));
        this.pcListener = evt -> {
            if (gf != null) {
                String key = evt.getPropertyName();
                if (key.equals("iscobol.gui.list.lm_on_columns")) {
                    if (this.lmOnColumns != null) {
                        this.setLmOnColumns();
                    }
                } else if (key.equals("iscobol.gui.matching_text_color")) {
                    this.setMatchingTextColor(gf.getCsProperty().get(key, null));
                } else if (key.equals("iscobol.key.f4.system")) {
                    this.setF4ShowsSearchBox(gf.getCsProperty().get(key, true));
                } else if (key.equals("iscobol.gui.search_panel_settings")) {
                    this.setSearchPanelSettings(gf.getCsProperty().get(key, "0011"));
                }
            }
        };
        gf.getCsProperty().addPropertyChangeListener(this.pcListener);
    }

    private void setF4ShowsSearchBox(boolean b) {
        this.f4ShowsSearchBox = b;
        if (this.guiComponent != null) {
            this.getListBox().setF4ShowsSearchBox(this.f4ShowsSearchBox);
        }
    }

    private PicobolListBox getListBox() {
        if (this.guiComponent != null) {
            return (PicobolListBox)((MassUpdatePanel)this.guiComponent).getComponent();
        }
        return null;
    }

    @Override
    public void displayProp() {
        Enumeration en;
        boolean needsBuildColumns;
        PicobolListBox list = this.getListBox();
        boolean bl = needsBuildColumns = this.dataColumnsChanged || this.displayColumnsChanged || this.separatorsChanged || this.dividersChanged || this.alignmentsChanged || this.rowColorPatternsChanged;
        if (this.dataColumnsChanged) {
            en = this.dataColumns.elements();
            while (en.hasMoreElements()) {
                list.addDataColumn((Integer)en.nextElement());
            }
            this.dataColumns.clear();
            this.dataColumnsChanged = false;
        }
        if (this.displayColumnsChanged) {
            en = this.displayColumns.elements();
            while (en.hasMoreElements()) {
                list.addDisplayColumn((Integer)en.nextElement());
            }
            this.displayColumns.clear();
            this.displayColumnsChanged = false;
        }
        if (this.separatorsChanged) {
            en = this.separators.elements();
            while (en.hasMoreElements()) {
                list.addSeparator((Integer)en.nextElement());
            }
            this.separators.clear();
            this.separatorsChanged = false;
        }
        if (this.dividersChanged) {
            en = this.dividers.elements();
            while (en.hasMoreElements()) {
                list.addDivider((Integer)en.nextElement());
            }
            this.dividers.clear();
            this.dividersChanged = false;
        }
        if (this.alignmentsChanged) {
            en = this.alignments.elements();
            while (en.hasMoreElements()) {
                list.addAlignment((String)en.nextElement());
            }
            this.alignments.clear();
            this.alignmentsChanged = false;
        }
        if (this.rowColorPatternsChanged) {
            list.setRowColorPattern(this.rowColorPatterns);
        }
        if (needsBuildColumns) {
            this.getListBox().buildColumns();
        }
    }

    @Override
    public float getDefaultHeight() {
        return 0.8f;
    }

    @Override
    public float getDefaultWidth() {
        return 8.0f;
    }

    private Insets getBorderInsets() {
        if (this.guiComponent != null) {
            PicobolListBox lb = this.getListBox();
            Border border = lb.getBorder();
            if (border != null) {
                return border.getBorderInsets(lb);
            }
            return new Insets(0, 0, 0, 0);
        }
        Border border = this.createBorder();
        if (border != null) {
            return border.getBorderInsets(new JList());
        }
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public int getGUIControlHeight(float height) {
        int Return2 = Math.round((float)this.font.getHeight() * height);
        Insets ins = this.getBorderInsets();
        return Return2 += ins.top + ins.bottom;
    }

    @Override
    public int getGUIControlWidth(float width) {
        int param = this.font.computeScreenWidth("0");
        if (this.font.getCellWidth() > 0) {
            param = this.font.getCellWidth();
        }
        int Return2 = Math.round((float)param * width);
        Return2 += ListBox.BUTTON_PANEL_WIDTH;
        Insets ins = this.getBorderInsets();
        Return2 += ins.right + ins.left;
        for (int i = 0; i < this.dividers.size(); ++i) {
            Return2 += ((Integer)this.dividers.elementAt(i)).intValue();
        }
        return Return2;
    }

    @Override
    public String getProp(int key) {
        if (this.guiComponent == null) {
            return "";
        }
        PicobolListBox list = this.getListBox();
        switch (key) {
            case 2075: {
                return "" + this.gradientMgr.getOrientation();
            }
            case 2076: {
                return this.gradientMgr.getColor1AsString();
            }
            case 2078: {
                return this.gradientMgr.getColor2AsString();
            }
            case 355: {
                return this.exportFileFormat != null ? this.exportFileFormat : "";
            }
            case 354: {
                return this.exportFileName != null ? this.exportFileName : "";
            }
            case 426: {
                return this.exportFileopen ? "1" : "0";
            }
            case 330: {
                StringBuffer sb = new StringBuffer();
                int[] selIdxs = list.getSelectedIndicesModel();
                if (selIdxs.length > 0) {
                    sb.append(selIdxs[0] + 1);
                }
                for (int i = 1; i < selIdxs.length; ++i) {
                    sb.append(' ');
                    sb.append(selIdxs[i] + 1);
                }
                return sb.toString();
            }
            case 329: {
                return "" + this.selectionMode;
            }
            case 132: {
                if (this.queryIndex > 0 && this.queryIndex <= list.getItemCount()) {
                    return list.getItemAt(this.queryIndex - 1);
                }
                return null;
            }
            case 210: {
                if (this.paged) {
                    return list.getSearchText();
                }
                return "";
            }
            case 212: {
                int selIdx = list.getSelectedIndexModel();
                if (selIdx > -1) {
                    ++selIdx;
                }
                return "" + selIdx;
            }
            case 238: {
                this.thumbPosition = list.getThumbPosition();
                return "" + this.thumbPosition;
            }
            case 283: {
                return "" + this.mousewheellinestoscroll;
            }
            case 287: {
                if (!this.checkList && !this.selectionBackgroundRgb && this.selectionBackgroundColor != null) {
                    return this.selectionBackgroundColor.toString();
                }
                ColorCmp cmp = new ColorCmp(true);
                cmp.setBackRGB(list.getSelectionBackground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(cmp.getBackground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 288: {
                if (!this.checkList && !this.selectionForegroundRgb && this.selectionForegroundColor != null) {
                    return this.selectionForegroundColor.toString();
                }
                ColorCmp cmp = new ColorCmp(true);
                cmp.setForeRGB(list.getSelectionForeground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(cmp.getForeground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 383: {
                if (this.selectionColor != null) {
                    return this.selectionColor.toString();
                }
                return "0";
            }
            case 325: {
                if (this.borderColorCmp != null) {
                    return Integer.toString(this.borderColorIdx >= 0 ? this.borderColorIdx : this.borderColorCmp.getForeground());
                }
                return null;
            }
            case 369: {
                if (this.curritem != null) {
                    return Integer.toString(this.curritem.getColor());
                }
                return null;
            }
            case 372: {
                if (this.curritem != null) {
                    return Integer.toString(this.curritem.getForegroundColor());
                }
                return null;
            }
            case 370: {
                if (this.curritem != null) {
                    return Integer.toString(this.curritem.getBackgroundColor());
                }
                return null;
            }
        }
        return super.getProp(key);
    }

    @Override
    public Object getPropObject(int key) {
        Object Return2 = null;
        PicobolListBox list = this.getListBox();
        switch (key) {
            case 115: {
                Return2 = list.getHiddenDataItemAt(this.queryIndex - 1);
            }
        }
        return Return2;
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public String getValue() {
        if (this.guiComponent == null) {
            return "";
        }
        PicobolListBox list = this.getListBox();
        String Return2 = list.getSelectedIndexModel() >= 0 ? list.getSelectedValueModel() : "";
        if (Return2 == null) {
            Return2 = "";
        }
        return Return2;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (!evt.isConsumed() && evt.getClickCount() == 2 && this.notifyDblClik) {
            this.selectionIndex = this.getListBox().getSelectedIndexModel() + 1;
            CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(16, 18, (short)this.selectionIndex));
            this.pushEvent(cc);
            evt.consume();
        }
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        switch (evt.getKeyCode()) {
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 40: {
                return;
            }
            case 115: {
                if (!this.paged || this.noSearch || !this.f4ShowsSearchBox) break;
                return;
            }
        }
        super.keyPressed(evt);
    }

    private void responseOnAction(int state) {
        if ((RemoteDisplayWindow)this.parentWindow != null) {
            ((RemoteDisplayWindow)this.parentWindow).stopTimer();
        }
        PicobolListBox list = this.getListBox();
        if (state == 1) {
            int[] currSelectedIndices = list.getSelectedIndices();
            boolean eq = this.equal(this.lastSelectedIndices, currSelectedIndices);
            if (this.notifySelChange && !eq) {
                short ed1 = 0;
                int idx = list.getLastMouseSelectedIndex();
                if (idx >= -1) {
                    ed1 = (short)(idx + 1);
                } else {
                    int newSelLen;
                    int selLen = this.lastSelectedIndices != null ? this.lastSelectedIndices.length : 0;
                    int n = newSelLen = currSelectedIndices != null ? currSelectedIndices.length : 0;
                    if (selLen == newSelLen) {
                        ed1 = (short)(currSelectedIndices[0] + 1);
                    } else if (selLen > newSelLen) {
                        if (newSelLen > 0) {
                            for (int idx1 : this.lastSelectedIndices) {
                                boolean found = false;
                                for (int idx2 : currSelectedIndices) {
                                    if (idx1 != idx2) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                ed1 = (short)(idx1 + 1);
                                break;
                            }
                        } else {
                            ed1 = (short)(this.lastSelectedIndices[0] + 1);
                        }
                    } else if (selLen > 0) {
                        for (int idx1 : currSelectedIndices) {
                            boolean found = false;
                            for (int idx2 : this.lastSelectedIndices) {
                                if (idx1 != idx2) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            ed1 = (short)(idx1 + 1);
                            break;
                        }
                    } else {
                        ed1 = (short)(currSelectedIndices[0] + 1);
                    }
                }
                ed1 = (short)(list.convertRowIndexToModel(ed1 - 1) + 1);
                CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4099, ed1, 0, true, true, true));
                this.pushEvent(cc);
            }
            if (!eq) {
                this.setSelectionIndices(currSelectedIndices);
            }
            this.valueStr = this.lastSelectedIndices.length > 0 ? list.getItemAt(this.lastSelectedIndices[this.lastSelectedIndices.length - 1]) : "";
        }
    }

    private boolean equal(int[] i1, int[] i2) {
        if (i1.length != i2.length) {
            return false;
        }
        for (int i = 0; i < i1.length; ++i) {
            if (i1[i] == i2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void initialize() {
        if (this.guiComponent != null) {
            return;
        }
        PicobolListBox list = new PicobolListBox(this.gf, this.paged, this.noSearch, this.checkList, this.useDefaultBorderWithBoxedStyle, this.gradientMgr);
        list.setUpperLowerMethod(this.gf.getUpperLowerMethod());
        list.setPW(this.getParentWindow().getMainWindow().getMyWindow().getRootWindow());
        MassUpdatePanel mup = new MassUpdatePanel(list);
        mup.setMassUpdate(this.massUpdate != 0);
        this.guiComponent = mup;
        if (this.useDefaultBorderWithBoxedStyle) {
            this.defaultBorder = new JTextField().getBorder();
        }
        super.intInitialize();
        this.intSetBorder();
        this.guiComponent.setSize(this.width, this.height);
        list.setUnsorted(this.unsorted);
        if (this.upper) {
            list.setUpper(this.upper);
        } else if (this.lower) {
            list.setLower(this.lower);
        } else {
            list.setLower(this.gf.getGuiKdbLower());
            list.setUpper(this.gf.getGuiKdbUpper());
        }
        list.setF4ShowsSearchBox(this.f4ShowsSearchBox);
        if (this.selectionColor != null) {
            Color[] cs = this.getColors(this.selectionColor);
            list.setSelectionBackground(cs[0]);
            list.setSelectionForeground(cs[1]);
        } else {
            if (this.selectionBackgroundColor != null) {
                Color bg = this.getBackgroundColor(this.selectionBackgroundColor, this.selectionBackgroundRgb);
                list.setSelectionBackground(bg);
            }
            if (this.selectionForegroundColor != null) {
                Color fg = this.getForegroundColor(this.selectionForegroundColor, this.selectionForegroundRgb);
                list.setSelectionForeground(fg);
            }
        }
        list.addItemListener(e -> this.responseOnAction(e.getStateChange()));
        list.addKeyListener(this);
        if (this.paged) {
            list.addPagedListBoxListener(this);
            this.pagedListenerAdded = true;
        }
        this.setSelectionMode(this.selectionMode);
        if (this.items.size() > 0) {
            Enumeration en = this.items.elements();
            while (en.hasMoreElements()) {
                list.addItem((ListBox.ListItem)en.nextElement(), -1);
            }
            this.items.clear();
        }
        if (this.sortOrder != -1) {
            list.setSortOrder(this.sortOrder);
        }
        if (this.selectionIndex > 0 && this.selectionIndex <= list.getItemCount()) {
            this.select(this.selectionIndex - 1);
        }
        if (this.valueStr != null) {
            this.setValue(this.valueStr);
        }
        list.setThumbPosition(this.thumbPosition);
        list.setMouseWheelLinesToScroll(this.mousewheellinestoscroll);
        this.setLmOnColumns();
        if (this.notifymouse) {
            list.addNotifyMouseListener(this);
        }
        this.setMatchingTextColor(this.matchingTextColor);
        if (this.searchPanelSettings != null) {
            list.setSettings(this.searchPanelSettings);
        }
        if (this.searchpanel != 0) {
            list.setSearchPanel(this.searchpanel);
        }
    }

    private void setLmOnColumns() {
        PicobolListBox list = this.getListBox();
        if (list != null) {
            if (this.lmOnColumns != null) {
                list.setLmOnColumns(this.lmOnColumns > 0);
            } else {
                list.setLmOnColumns(this.gf.getCsProperty().get("iscobol.gui.list.lm_on_columns", 1) > 0);
            }
        }
    }

    @Override
    public void search(PagedListBoxEvent e) {
        String searchText = e.getSearchText();
        CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4107, (short)searchText.length(), 0, true, true, true));
        this.pushEvent(cc);
    }

    @Override
    public void firstItem(PagedListBoxEvent e) {
        if (e.getCause() == 0) {
            this.lastSelectionValue = null;
            if (this.getListBox().getItemCount() > 0) {
                this.lastSelectedIndices = new int[]{0};
            }
        }
        CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4105, true, true, true));
        this.pushEvent(cc);
    }

    @Override
    public void lastItem(PagedListBoxEvent e) {
        if (e.getCause() == 0) {
            this.lastSelectionValue = null;
            int n = this.getListBox().getItemCount();
            if (n > 0) {
                this.lastSelectedIndices = new int[]{n - 1};
            }
        }
        CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4106, true, true, true));
        this.pushEvent(cc);
    }

    @Override
    public void prevItem(PagedListBoxEvent e) {
        if (e.getCause() == 0) {
            this.lastSelectionValue = null;
        }
        CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4102, true, true, true));
        this.pushEvent(cc);
    }

    @Override
    public void nextItem(PagedListBoxEvent e) {
        if (e.getCause() == 0) {
            this.lastSelectionValue = null;
        }
        CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4101, true, true, true));
        this.pushEvent(cc);
    }

    @Override
    public void prevPage(PagedListBoxEvent e) {
        if (e.getCause() == 0) {
            this.lastSelectionValue = null;
        }
        CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4104, true, true, true));
        this.pushEvent(cc);
    }

    @Override
    public void nextPage(PagedListBoxEvent e) {
        if (e.getCause() == 0) {
            this.lastSelectionValue = null;
        }
        CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(6, 96, 4103, true, true, true));
        this.pushEvent(cc);
    }

    @Override
    protected void intFocusGained(boolean restore) {
        PicobolListBox list = this.getListBox();
        if (list != null) {
            list.intFocusGained();
        }
    }

    @Override
    public boolean isSelfAct() {
        return false;
    }

    @Override
    public void setBorder(boolean t) {
    }

    @Override
    public void setElementAt(int idx) {
        this.queryIndex = idx;
        this.setCurrentItem(idx);
    }

    @Override
    public void setElementAt(int[] idxs) {
        this.setElementAt(idxs[0]);
    }

    @Override
    public void setImage(int viewWidth, int viewHeight, int imageId, int strip) {
    }

    private void setDataColumn(int intValue) {
        if (intValue == 0) {
            this.removeDataColumns();
        } else {
            this.addDataColumn(intValue);
        }
    }

    private void setDisplayColumn(int intValue) {
        if (intValue == 0) {
            this.removeDisplayColumns();
        } else {
            this.addDisplayColumn(intValue);
        }
    }

    private void setSeparation(int intValue) {
        if (intValue == -1) {
            this.removeSeparations();
        } else {
            this.addSeparator(intValue);
        }
    }

    private void setDivider(int intValue) {
        if (intValue == -1) {
            this.removeDividers();
        } else {
            this.addDivider(intValue);
        }
    }

    private void setRowColorPattern(int intValue) {
        if (intValue == -1) {
            this.removeRowColorPatterns();
        } else {
            this.addRowColorPattern(this.getColors(intValue));
        }
    }

    private void setRowForegroundColorPattern(int intValue, boolean rgb) {
        if (intValue == -1) {
            this.removeRowColorPatterns();
        } else {
            this.addRowForegroundColorPattern(this.getForegroundColor(intValue, rgb));
        }
    }

    private void setRowBackgroundColorPattern(int intValue, boolean rgb) {
        if (intValue == -1) {
            this.removeRowColorPatterns();
        } else {
            this.addRowBackgroundColorPattern(this.getBackgroundColor(intValue, rgb));
        }
    }

    @Override
    public String setProp(int key, int[] values) {
        int i = 0;
        switch (key) {
            case 67: {
                boolean changed = false;
                int valueold = 0;
                if (values.length == this.displayColumns.size()) {
                    for (i = 0; !changed && i < values.length; ++i) {
                        valueold = (Integer)this.displayColumns.elementAt(i);
                        if (values[i] == valueold) continue;
                        changed = true;
                    }
                } else {
                    changed = true;
                }
                if (!changed) break;
                this.removeDisplayColumns();
                this.setDisplayColumn(1);
                for (i = 0; i < values.length; ++i) {
                    if (values[i] == 1) continue;
                    this.setDisplayColumn(values[i]);
                }
                break;
            }
            case 63: {
                for (i = 0; i < values.length; ++i) {
                    this.setDataColumn(values[i]);
                }
                break;
            }
            case 217: {
                for (i = 0; i < values.length; ++i) {
                    this.setSeparation(values[i]);
                }
                break;
            }
            case 71: {
                for (i = 0; i < values.length; ++i) {
                    this.setDivider(values[i]);
                }
                break;
            }
            case 199: {
                for (i = 0; i < values.length; ++i) {
                    this.setRowColorPattern(values[i]);
                }
                break;
            }
            case 204: {
                for (i = 0; i < values.length; ++i) {
                    this.setRowForegroundColorPattern(values[i], false);
                }
                break;
            }
            case 205: {
                for (i = 0; i < values.length; ++i) {
                    this.setRowForegroundColorPattern(values[i], true);
                }
                break;
            }
            case 196: {
                for (i = 0; i < values.length; ++i) {
                    this.setRowBackgroundColorPattern(values[i], false);
                }
                break;
            }
            case 197: {
                for (i = 0; i < values.length; ++i) {
                    this.setRowBackgroundColorPattern(values[i], true);
                }
                break;
            }
        }
        return "1";
    }

    @Override
    public String setProp(Integer key, String[] values) {
        PicobolListBox list = this.getListBox();
        String Return2 = "0";
        if (values == null) {
            return "0";
        }
        int i = 0;
        switch (key) {
            case 129: {
                boolean notifySelChangeSave = this.notifySelChange;
                this.notifySelChange = false;
                for (i = 0; i < values.length; ++i) {
                    values[i] = ScreenUtility.rightTrim(values[i]);
                    if (values[i].length() <= 0) continue;
                    this.curritem = new ListBox.ListItem(values[i]);
                    if (this.guiComponent == null) {
                        this.items.add(this.curritem);
                        continue;
                    }
                    list.addItem(this.curritem, -1);
                }
                this.notifySelChange = notifySelChangeSave;
                Return2 = "1";
                break;
            }
            case 2: 
            case 63: 
            case 67: 
            case 71: 
            case 196: 
            case 197: 
            case 199: 
            case 204: 
            case 205: 
            case 217: {
                for (i = 0; i < values.length; ++i) {
                    this.setProp(key, values[i], values[i].length());
                }
                break;
            }
        }
        return Return2;
    }

    private ListBox.ListItem rightTrim(ListBox.ListItem item) {
        ListBox.ListItem Return2;
        int i;
        for (i = item.text.length() - 1; i >= 0 && item.text.charAt(i) == ' '; --i) {
        }
        int diff = item.text.length() - 1 - i;
        if (diff > 0) {
            byte[] newBytes = new byte[item.bytes.length - diff];
            System.arraycopy(item.bytes, 0, newBytes, 0, newBytes.length);
            Return2 = new ListBox.ListItem(newBytes);
        } else {
            Return2 = item;
        }
        return Return2;
    }

    @Override
    public String setProp(Integer key, byte[] value, int length) {
        String Return2 = "0";
        PicobolListBox list = this.getListBox();
        switch (key) {
            case 129: {
                ListBox.ListItem item = new ListBox.ListItem(value);
                this.curritem = item = this.rightTrim(item);
                if (item.text.length() > 0) {
                    if (this.guiComponent == null) {
                        this.items.add(item);
                    } else {
                        boolean notifySelChangeSave = this.notifySelChange;
                        this.notifySelChange = false;
                        int selIdx = this.lastSelectedIndices.length > 0 ? this.lastSelectedIndices[0] : -1;
                        String objselected = null;
                        if (!this.paged || this.noSearch || !list.isSearchBoxVisible()) {
                            objselected = this.lastSelectionValue;
                        }
                        list.addItem(item, this.insertionIndex - 1);
                        if (!(this.paged && !this.noSearch && list.isSearchBoxVisible() && list.findAndSelectSearchedText(false) || objselected != null && list.setSelectedValue(objselected) >= 0)) {
                            if (selIdx > -1) {
                                this.select(selIdx);
                            } else if (this.acuCompatibility && this.paged && this.valueStr.length() > 0) {
                                list.setSelectedValue(ScreenUtility.rightTrim(this.valueStr));
                            }
                        }
                        this.insertionIndex = 0;
                        this.notifySelChange = notifySelChangeSave;
                    }
                }
                Return2 = "1";
                break;
            }
            case 132: {
                if (list != null && this.queryIndex > 0 && this.queryIndex <= list.getItemCount()) {
                    ListBox.ListItem item = new ListBox.ListItem(value);
                    this.curritem = item = this.rightTrim(item);
                    list.removeItem(this.queryIndex - 1);
                    list.addItem(item, this.queryIndex - 1);
                }
                Return2 = "1";
                break;
            }
            case 115: {
                if (this.curritem != null) {
                    this.curritem.setHiddenData(value);
                }
                Return2 = "1";
            }
        }
        return Return2;
    }

    @Override
    public String setProp(Integer key, String value, int length) {
        PicobolListBox list = this.getListBox();
        String Return2 = "0";
        int intValue = -1;
        boolean error = false;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            error = true;
        }
        boolean isrgb = false;
        switch (key) {
            case 2086: {
                Object id = this.gf.getClient().getId(intValue);
                this.gradientMgr.setImage(id instanceof LocalImage ? ((LocalImage)id).getImage() : null);
                break;
            }
            case 2087: {
                this.gradientMgr.setImageScale(intValue);
                break;
            }
            case 2076: {
                this.gradientMgr.setColor1(intValue, false, this.gf);
                break;
            }
            case 2077: {
                this.gradientMgr.setColor1(intValue, true, this.gf);
                break;
            }
            case 2078: {
                this.gradientMgr.setColor2(intValue, false, this.gf);
                break;
            }
            case 2079: {
                this.gradientMgr.setColor2(intValue, true, this.gf);
                break;
            }
            case 2075: {
                this.gradientMgr.setOrientation(intValue);
                break;
            }
            case 355: {
                this.exportFileFormat = value != null ? value.trim() : null;
                break;
            }
            case 354: {
                this.exportFileName = value != null ? value.trim() : null;
                break;
            }
            case 426: {
                this.exportFileopen = intValue >= 1;
                break;
            }
            case 1: {
                if (error) break;
                this.setAction(intValue);
                Return2 = "1";
                break;
            }
            case 329: {
                this.setSelectionMode(intValue);
                Return2 = "1";
                break;
            }
            case 310: {
                this.lmOnColumns = intValue;
                this.setLmOnColumns();
                break;
            }
            case 326: {
                isrgb = true;
            }
            case 325: {
                if (intValue < 0 || isrgb) {
                    this.borderColorCmp = new ColorCmp(true);
                    this.borderColorIdx = -1;
                    this.borderColorCmp.setForeRGB(intValue);
                    this.borderColor = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(this.borderColorCmp.getForeground(), false));
                } else {
                    this.borderColorCmp = new ColorCmp(intValue);
                    this.borderColorIdx = intValue;
                    this.borderColor = this.gf.getRemotePalette().getDefaultColor(this.borderColorCmp.getForeground());
                }
                if (!this.isBoxed()) break;
                this.intSetBorder();
                break;
            }
            case 124: {
                if (error) break;
                this.insertionIndex = intValue;
                Return2 = "1";
                break;
            }
            case 177: {
                if (error) break;
                this.queryIndex = intValue;
                this.setCurrentItem(intValue);
                Return2 = "1";
                break;
            }
            case 142: {
                if (error) break;
                this.massUpdate = intValue;
                if (this.massUpdate != 0 && !this.isVisible() && this.parentWindow != null) {
                    this.parentWindow.showVisible(this);
                }
                if (list != null) {
                    boolean mu = this.massUpdate != 0;
                    boolean reqFocus = this.parentWindow != null && ((RemoteDisplayWindow)this.parentWindow).getFocusOwner() == this;
                    new IsguiWorker(true, () -> {
                        ((MassUpdatePanel)this.guiComponent).setMassUpdate(mu);
                        if (reqFocus) {
                            this.guiComponent.requestFocus();
                        }
                    }).start();
                }
                Return2 = "1";
                break;
            }
            case 212: {
                if (error) break;
                this.selectionIndex = intValue;
                if (this.selectionIndex == -1) {
                    this.deselect();
                } else {
                    this.select();
                }
                Return2 = "1";
                break;
            }
            case 190: {
                if (error) break;
                this.resetList = intValue;
                if (this.resetList != 0) {
                    this.removeAll();
                }
                this.curritem = null;
                Return2 = "1";
                break;
            }
            case 238: {
                if (error) break;
                this.thumbPosition = intValue;
                if (list != null) {
                    list.setThumbPosition(this.thumbPosition);
                }
                Return2 = "1";
                break;
            }
            case 224: {
                if (error) break;
                this.sortOrder = intValue;
                this.setSortOrder();
                Return2 = "1";
                break;
            }
            case 63: {
                if (error) break;
                this.setDataColumn(intValue);
                Return2 = "1";
                break;
            }
            case 67: {
                if (error) break;
                this.setDisplayColumn(intValue);
                Return2 = "1";
                break;
            }
            case 2: {
                String v = value.trim();
                if (v.length() == 0) {
                    this.removeAlignments();
                } else {
                    this.addAlignment(v);
                }
                Return2 = "1";
                break;
            }
            case 217: {
                if (error) break;
                this.setSeparation(intValue);
                Return2 = "1";
                break;
            }
            case 71: {
                if (error) break;
                this.setDivider(intValue);
                Return2 = "1";
                break;
            }
            case 199: {
                if (error) break;
                this.setRowColorPattern(intValue);
                Return2 = "1";
                break;
            }
            case 204: {
                if (error) break;
                this.setRowForegroundColorPattern(intValue, false);
                Return2 = "1";
                break;
            }
            case 205: {
                if (error) break;
                this.setRowForegroundColorPattern(intValue, true);
                Return2 = "1";
                break;
            }
            case 196: {
                if (error) break;
                this.setRowBackgroundColorPattern(intValue, false);
                Return2 = "1";
                break;
            }
            case 197: {
                if (error) break;
                this.setRowBackgroundColorPattern(intValue, true);
                Return2 = "1";
                break;
            }
            case 188: {
                this.removeDataColumns();
                this.removeDisplayColumns();
                this.removeAlignments();
                this.removeDividers();
                this.removeSeparations();
                Return2 = "1";
                break;
            }
            case 130: {
                if (error) break;
                if (intValue > 0) {
                    this.removeItem(intValue - 1);
                }
                Return2 = "1";
                break;
            }
            case 129: {
                String v = ScreenUtility.rightTrim(value);
                if (v.length() > 0) {
                    ListBox.ListItem item;
                    this.curritem = item = new ListBox.ListItem(v);
                    if (this.guiComponent == null) {
                        this.items.add(item);
                    } else {
                        boolean notifySelChangeSave = this.notifySelChange;
                        this.notifySelChange = false;
                        int selIdx = this.lastSelectedIndices.length > 0 ? this.lastSelectedIndices[0] : -1;
                        String objselected = this.lastSelectionValue;
                        list.addItem(item, this.insertionIndex - 1);
                        PicobolListBox lb = this.getListBox();
                        if (this.paged && !this.noSearch && lb.isSearchBoxVisible()) {
                            lb.findAndSelectSearchedText(false);
                        } else if (objselected != null) {
                            list.setSelectedValue(objselected);
                        } else if (selIdx > -1) {
                            this.select(selIdx);
                        } else if (this.acuCompatibility && this.paged && this.valueStr.length() > 0) {
                            list.setSelectedValue(ScreenUtility.rightTrim(this.valueStr));
                        }
                        this.insertionIndex = 0;
                        this.notifySelChange = notifySelChangeSave;
                    }
                }
                Return2 = "1";
                break;
            }
            case 132: {
                if (list != null && this.queryIndex > 0 && this.queryIndex <= list.getItemCount()) {
                    String v = ScreenUtility.rightTrim(value);
                    list.removeItem(this.queryIndex - 1);
                    this.curritem = new ListBox.ListItem(v);
                    list.addItem(this.curritem, this.queryIndex - 1);
                }
                Return2 = "1";
                break;
            }
            case 283: {
                this.mousewheellinestoscroll = intValue;
                if (list == null) break;
                list.setMouseWheelLinesToScroll(this.mousewheellinestoscroll);
                break;
            }
            case 115: {
                if (this.curritem == null) break;
                this.curritem.setHiddenData(value);
                break;
            }
            case 369: {
                if (error) break;
                if (this.curritem != null) {
                    this.curritem.setColor(intValue);
                    Color[] cs = this.getColors(intValue);
                    this.curritem.setBackground(cs[0]);
                    this.curritem.setForeground(cs[1]);
                    if (list != null) {
                        list.refreshItem(this.curritem);
                    }
                }
                Return2 = "1";
                break;
            }
            case 371: {
                isrgb = true;
            }
            case 370: {
                if (error) break;
                if (this.curritem != null) {
                    this.curritem.setBackgroundColor(intValue);
                    Color bg = this.getBackgroundColor(intValue, isrgb);
                    this.curritem.setBackground(bg);
                    if (list != null) {
                        list.refreshItem(this.curritem);
                    }
                }
                Return2 = "1";
                break;
            }
            case 373: {
                isrgb = true;
            }
            case 372: {
                if (error) break;
                if (this.curritem != null) {
                    this.curritem.setForegroundColor(intValue);
                    Color fg = this.getForegroundColor(intValue, isrgb);
                    this.curritem.setForeground(fg);
                    if (list != null) {
                        list.refreshItem(this.curritem);
                    }
                }
                Return2 = "1";
                break;
            }
            case 383: {
                if (error || this.checkList) break;
                this.selectionColor = intValue;
                if (list != null) {
                    Color[] cs = this.getColors(intValue);
                    list.setSelectionBackground(cs[0]);
                    list.setSelectionForeground(cs[1]);
                }
                Return2 = "1";
                break;
            }
            case 384: {
                isrgb = true;
            }
            case 287: {
                if (error || this.checkList) break;
                this.selectionBackgroundColor = intValue;
                this.selectionBackgroundRgb = isrgb;
                if (list != null) {
                    Color bg = this.getBackgroundColor(intValue, isrgb);
                    list.setSelectionBackground(bg);
                }
                Return2 = "1";
                break;
            }
            case 385: {
                isrgb = true;
            }
            case 288: {
                if (error || this.checkList) break;
                this.selectionForegroundColor = intValue;
                this.selectionForegroundRgb = isrgb;
                if (list != null) {
                    Color fg = this.getForegroundColor(intValue, isrgb);
                    list.setSelectionForeground(fg);
                }
                Return2 = "1";
                break;
            }
            case 374: {
                this.handleBorderWidths(value);
                if (!this.isBoxed()) break;
                this.setBoxedStyle();
                break;
            }
            case 330: {
                if (value != null) {
                    int itemCount;
                    if (value.trim().length() == 0) {
                        if (list != null) {
                            list.clearSelection();
                        }
                        Return2 = "1";
                        break;
                    }
                    ArrayList<Integer> idxList = new ArrayList<Integer>();
                    StringTokenizer stn = new StringTokenizer(value);
                    int n = itemCount = list != null ? list.getItemCount() : 0;
                    while (stn.hasMoreTokens()) {
                        try {
                            int idx = Integer.parseInt(stn.nextToken());
                            if (idx <= 0 || idx > itemCount) continue;
                            idxList.add(idx - 1);
                        }
                        catch (NumberFormatException e) {
                            idxList.clear();
                            break;
                        }
                    }
                    if (idxList.size() > 0) {
                        if (list != null) {
                            int[] idxs = new int[idxList.size()];
                            for (int i = 0; i < idxs.length; ++i) {
                                idxs[i] = (Integer)idxList.get(i);
                            }
                            list.select(idxs);
                        }
                        Return2 = "1";
                        break;
                    }
                    Return2 = "0";
                    break;
                }
                Return2 = "0";
                break;
            }
            case 393: {
                this.searchpanel = intValue;
                if (list == null) break;
                list.setSearchPanel(intValue);
                break;
            }
            default: {
                return super.setProp(key, value, length);
            }
        }
        return Return2;
    }

    protected void setBoxedStyle() {
        if (this.guiComponent != null) {
            Border border = this.borderColor != null ? BorderFactory.createLineBorder(this.borderColor) : (this.useDefaultBorderWithBoxedStyle ? this.defaultBorder : BorderFactory.createLineBorder(Color.darkGray));
            if (this.borderWidths != null && this.borderWidths.size() > 0) {
                this.getListBox().setBorder(new MatteBorder(this.getBorder(0), this.getBorder(1), this.getBorder(2), this.getBorder(3), this.borderColor != null ? this.borderColor : Color.darkGray));
            } else {
                this.getListBox().setBorder(border);
            }
        }
    }

    @Override
    protected void setAction(int action) {
        if (this.guiComponent == null) {
            return;
        }
        switch (action) {
            case 2: {
                this.Copy();
                break;
            }
            case 33: {
                SwingUtilities.invokeLater(() -> {
                    this.Export();
                    CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(7, 0, 31, 0, 0, false, false, true));
                    this.pushEvent(cc);
                });
                break;
            }
            case 8: {
                SwingUtilities.invokeLater(() -> {
                    CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(7, 0, 31, 0, 0, false, false, true));
                    this.pushEvent(cc);
                    PicobolListBox list = this.getListBox();
                    if (list != null && list.getSearchPanel() == 0) {
                        list.Find(8);
                    }
                });
                break;
            }
            default: {
                super.setAction(action);
            }
        }
    }

    private void Copy() {
        int i;
        ListBox.ListItem[] items;
        Color fg;
        Color bg;
        PicobolListBox list = this.getListBox();
        int[] selIdxs = list.getSelectedIndices();
        if (this.selectionMode <= 0 || selIdxs.length == 0) {
            bg = list.getBackground();
            fg = list.getForeground();
            items = new ListBox.ListItem[list.getItemCount()];
            for (i = 0; i < items.length; ++i) {
                items[i] = list.getListItemAt(i);
            }
        } else {
            bg = list.getSelectionBackground();
            fg = list.getSelectionForeground();
            items = new ListBox.ListItem[selIdxs.length];
            for (i = 0; i < items.length; ++i) {
                items[i] = list.getListItemAt(selIdxs[i]);
            }
        }
        if (items.length == 0) {
            return;
        }
        StringBuffer html = new StringBuffer();
        StringBuffer plain = new StringBuffer();
        String eol = System.getProperty("line.separator", "\n");
        html.append("<html>");
        html.append("<body>");
        html.append("<table style=\"font-family:");
        html.append(this.font.getFamily());
        html.append("; font-size:");
        html.append(this.font.getSize());
        html.append("pt;");
        if (this.font.isBold()) {
            html.append(" font-weight:bold;");
        }
        if (this.font.isItalic()) {
            html.append(" font-style:italic;");
        }
        html.append(" background-color:#");
        html.append(this.toHexString(bg));
        html.append("; color:#");
        html.append(this.toHexString(fg));
        html.append(";\">");
        int fontHeight = this.font.getHeight();
        ListBox.Column[] columns = list.getColumns();
        for (int i2 = 0; i2 < items.length; ++i2) {
            String[] tokens = list.buildTokens(items[i2]);
            html.append("<tr height=\"");
            html.append(fontHeight);
            html.append("\">");
            for (int c = 0; c < columns.length; ++c) {
                html.append("<td width=\"");
                html.append(columns[c].width);
                html.append("\">");
                String text = c < tokens.length ? tokens[c] : "";
                plain.append(text);
                if (columns[c].separator > 0 || columns[c].alignment != 0) {
                    html.append("<div style=\"");
                    if (columns[c].separator > 0) {
                        html.append("text-indent:");
                        html.append(columns[c].separator);
                        html.append("px; ");
                    }
                    switch (columns[c].alignment) {
                        case 1: {
                            html.append("text-align:center;");
                            break;
                        }
                        case 2: {
                            html.append("text-align:right;");
                        }
                    }
                    html.append("\">");
                    html.append(text);
                    html.append("</div>");
                } else {
                    html.append(text);
                }
                html.append("</td>");
            }
            html.append("</tr>");
            plain.append(eol);
        }
        html.append("</table>");
        html.append("</body>");
        html.append("</html>");
        Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
        c.setContents(new MyTransferable(plain.toString(), html.toString()), null);
    }

    private void Export() {
        PicobolListBox list = this.getListBox();
        ExportUtilities.exportExcel(false, list, this.exportFileName, this.exportFileFormat, "isCobolListBox", "com.iscobol.misc.export.xls.XLSListBoxExporter", "com.iscobol.misc.export.xlsx.XLSXListBoxExporter", "List-Box", new SwingListBoxDataProvider(list, this.selectionMode), this.exportFileopen, this.getGuiFactory().getIcon());
    }

    private String toHexString(Color c) {
        String h = Integer.toHexString(c.getRGB() & 0xFFFFFF);
        int n = 6 - h.length();
        for (int i = 0; i < n; ++i) {
            h = "0" + h;
        }
        return h;
    }

    protected boolean isBoxed() {
        return this.boxed || !this._3d && !this.noBox;
    }

    @Override
    public void setCols(float c) {
    }

    @Override
    public void setRows(float r) {
    }

    @Override
    public void setRowsCols(float rows, float cols) {
    }

    @Override
    public void setStyle(int s, boolean set) {
        PicobolListBox list = this.getListBox();
        if ((s & 0x200) == 512) {
            this.notifySelChange = set;
        }
        if ((s & 0x100) == 256) {
            this.notifyDblClik = set;
        }
        if ((s & 1) == 1) {
            this.unsorted = set;
        }
        if ((s & 0x400) == 1024) {
            this.paged = set;
            if (list != null) {
                list.setPaged(this.paged);
                if (this.paged && !this.pagedListenerAdded) {
                    list.addPagedListBoxListener(this);
                    this.pagedListenerAdded = true;
                }
            }
        }
        if ((s & 0x2000) == 8192) {
            this.noSearch = set;
            if (list != null) {
                list.setNoSearch(this.noSearch);
            }
        }
        if ((s & 2) == 2) {
            this.noBox = set;
        }
        if ((s & 4) == 4) {
            this.boxed = set;
        }
        if ((s & 0x2000000) == 0x2000000) {
            this._3d = set;
        }
        if ((s & 0x1000) == 4096) {
            this.lower = set;
        }
        if ((s & 0x800) == 2048) {
            this.upper = set;
        }
        if ((s & 0x8000) == 32768) {
            this.checkList = set;
            if (list != null) {
                list.setCheckList(this.checkList);
            }
        }
    }

    @Override
    public void setTitle(String v) {
    }

    @Override
    public String setValue(String v) {
        this.valueStr = v;
        if (this.guiComponent != null && v != null) {
            int idx;
            PicobolListBox list = this.getListBox();
            v = ScreenUtility.rightTrim(v);
            if (list.getItemCount() > 0 && (idx = list.setSelectedValue(v)) >= 0) {
                this.setSelectionIndices(new int[]{idx});
                return v;
            }
            this.deselect();
            return null;
        }
        return null;
    }

    private void removeAll() {
        this.items.clear();
        if (this.guiComponent != null) {
            PicobolListBox list = this.getListBox();
            list.removeAllItems();
        }
    }

    private void removeItem(int idx) {
        PicobolListBox list = this.getListBox();
        if (list != null && idx >= 0 && idx < list.getItemCount()) {
            list.removeItem(idx);
        }
    }

    private void deselect() {
        if (this.guiComponent != null) {
            this.setSelectionIndices(new int[0]);
            this.getListBox().clearSelection();
        }
    }

    private void select() {
        if (this.guiComponent != null) {
            PicobolListBox list = this.getListBox();
            if (this.selectionIndex > 0 && this.selectionIndex <= list.getItemCount()) {
                int newSelIdx = this.selectionIndex;
                if (!list.isVisible()) {
                    this.parentWindow.showVisible(this);
                }
                new SwingWorker(true, () -> {
                    list.select(newSelIdx - 1);
                    this.setSelectionIndices(new int[]{newSelIdx - 1});
                    this.valueStr = list.getItemAt(this.lastSelectedIndices[0]);
                }).start();
            }
        }
    }

    private void select(int idx) {
        if (this.guiComponent != null) {
            PicobolListBox list = this.getListBox();
            if (idx >= 0 && idx < list.getItemCount()) {
                new SwingWorker(true, () -> list.select(idx)).start();
            }
        }
    }

    public void addDataColumn(int i) {
        this.dataColumns.addElement(i);
        this.dataColumnsChanged = true;
    }

    public void addDisplayColumn(int i) {
        this.displayColumns.addElement(i);
        this.displayColumnsChanged = true;
    }

    public void addDivider(int i) {
        this.dividers.addElement(i);
        this.dividersChanged = true;
    }

    public void addRowColorPattern(Color[] c) {
        this.rowColorPatterns.add(c);
        this.rowColorPatternsChanged = true;
    }

    public void addRowForegroundColorPattern(Color c) {
        boolean found = false;
        for (int i = 0; i < this.rowColorPatterns.size() && !found; ++i) {
            Color[] cc = (Color[])this.rowColorPatterns.elementAt(i);
            if (cc[1] != null) continue;
            cc[1] = c;
            found = true;
        }
        if (!found) {
            this.rowColorPatterns.add(new Color[]{null, c});
        }
        this.rowColorPatternsChanged = true;
    }

    public void addRowBackgroundColorPattern(Color c) {
        boolean found = false;
        for (int i = 0; i < this.rowColorPatterns.size() && !found; ++i) {
            Color[] cc = (Color[])this.rowColorPatterns.elementAt(i);
            if (cc[0] != null) continue;
            cc[0] = c;
            found = true;
        }
        if (!found) {
            this.rowColorPatterns.add(new Color[]{c, null});
        }
        this.rowColorPatternsChanged = true;
    }

    public void addAlignment(String s) {
        this.alignments.addElement(s.toUpperCase());
        this.alignmentsChanged = true;
    }

    public void addSeparator(int i) {
        this.separators.addElement(i);
        this.separatorsChanged = true;
    }

    private void removeDataColumns() {
        this.dataColumns.clear();
        if (this.guiComponent != null) {
            this.getListBox().resetDataColumns();
        }
        this.dataColumnsChanged = true;
    }

    private void removeDisplayColumns() {
        this.displayColumns.clear();
        if (this.guiComponent != null) {
            this.getListBox().resetDisplayColumns();
        }
        this.displayColumnsChanged = true;
    }

    private void removeAlignments() {
        this.alignments.clear();
        if (this.guiComponent != null) {
            this.getListBox().resetAlignments();
        }
        this.alignmentsChanged = true;
    }

    private void removeSeparations() {
        this.separators.clear();
        if (this.guiComponent != null) {
            this.getListBox().resetSeparators();
        }
        this.separatorsChanged = true;
    }

    private void removeDividers() {
        this.dividers.clear();
        if (this.guiComponent != null) {
            this.getListBox().resetDividers();
        }
        this.dividersChanged = true;
    }

    private void removeRowColorPatterns() {
        this.rowColorPatterns.clear();
        if (this.guiComponent != null) {
            this.getListBox().setRowColorPattern(null);
        }
        this.rowColorPatternsChanged = true;
    }

    private void setSortOrder() {
        if (this.guiComponent != null) {
            this.getListBox().setSortOrder(this.sortOrder);
        }
    }

    @Override
    protected boolean requestFocusLostComponent(RemoteBaseGUIControl opposite, MouseEvent me, RemoteRecordAccept rra) {
        if (this.guiComponent != null) {
            this.getListBox().hideSearchBox();
        }
        return true;
    }

    private void intSetBorder() {
        if (this.guiComponent == null) {
            return;
        }
        Border b = this.createBorder();
        this.getListBox().setBorder(b);
    }

    private Border createBorder() {
        Object b = this._3d ? BorderFactory.createLoweredBevelBorder() : (this.noBox ? null : (this.useDefaultBorderWithBoxedStyle ? (this.borderColor != null ? BorderFactory.createLineBorder(this.borderColor) : this.defaultBorder) : (this.borderWidths != null && this.borderWidths.size() > 0 ? new MatteBorder(this.getBorder(0), this.getBorder(1), this.getBorder(2), this.getBorder(3), this.borderColor != null ? this.borderColor : Color.darkGray) : BorderFactory.createLineBorder(this.borderColor != null ? this.borderColor : Color.black))));
        return b;
    }

    @Override
    public void destroy() {
        if (this.gf != null && this.gf.getCsProperty() != null) {
            this.gf.getCsProperty().removePropertyChangeListener(this.pcListener);
        }
        PicobolListBox list = this.getListBox();
        this.pcListener = null;
        if (this.guiComponent != null) {
            this.getListBox().dispose();
        }
        super.destroy();
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
        super.handleResponse(eventAction, rra);
        if (rra.getEventType() == 4105 || rra.getEventType() == 4106) {
            this.guiComponent.repaint();
        }
    }

    @Override
    public boolean isInputField() {
        return true;
    }

    @Override
    protected float paramgetDefaultHeight(ParamElementSize ps, int origHeight) {
        return 5.0f;
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize ps, int origWidth) {
        if (ps.sizes > 0.0f) {
            return ps.sizes;
        }
        if (ps.ccPIClen != -1) {
            return ps.ccPIClen;
        }
        if (ps.ccOlen != -1) {
            return ps.ccOlen;
        }
        if (ps.ccIlen != -1) {
            return ps.ccIlen;
        }
        return super.paramgetDefaultWidth(ps, origWidth);
    }

    @Override
    public String getType() {
        return "listbox";
    }

    @Override
    public Point getReferencedPopupLocation(MouseEvent event) {
        if (this.guiComponent != null) {
            return this.getListBox().getReferencedPopupLocation(event);
        }
        return super.getReferencedPopupLocation(event);
    }

    private void setCurrentItem(int idx) {
        PicobolListBox list = this.getListBox();
        if (list == null) {
            if (this.items != null && idx > 0 && idx <= this.items.size()) {
                this.curritem = (ListBox.ListItem)this.items.elementAt(idx - 1);
            }
        } else {
            this.curritem = list.getListItemAt(idx - 1);
        }
    }

    @Override
    public void startCellEditing(boolean columnisalwaysshow, MouseEvent me) {
        PicobolListBox list = this.getListBox();
        if (list != null) {
            list.setFocusable(true);
            list.requestFocusInWindow();
            if (!this.checkList && columnisalwaysshow) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(SwingUtilities.convertMouseEvent((Component)me.getSource(), me, list.getList()));
            }
        }
    }

    @Override
    public RemoteBaseGUIControl renderClone() {
        return this.renderClone(false, null);
    }

    @Override
    public RemoteBaseGUIControl renderClone(boolean removelistener, Dimension scalebitmaptosize) {
        RemoteListBox clone = null;
        try {
            clone = (RemoteListBox)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        clone.setComponent(null);
        if (this.items != null && this.items.size() > 0) {
            clone.copyitems(this.items);
            clone.initialize();
        } else {
            clone.initialize();
            clone.copyitems2(this.getListBox());
        }
        return clone;
    }

    private void copyitems(Vector itemsource) {
        if (itemsource != null && itemsource.size() > 0) {
            this.items = new Vector();
            Enumeration en = itemsource.elements();
            while (en.hasMoreElements()) {
                this.items.add((String)en.nextElement());
            }
        }
    }

    public void copyitems2(PicobolListBox source) {
        PicobolListBox lb = this.getListBox();
        lb.copyItems(source);
    }

    private void setSelectionMode(int value) {
        PicobolListBox list = this.getListBox();
        int selMode = -1;
        switch (value) {
            default: {
                selMode = 0;
                break;
            }
            case 2: {
                selMode = 1;
                break;
            }
            case 4: {
                selMode = 2;
            }
        }
        this.selectionMode = value;
        if (list != null) {
            list.setSelectionMode(selMode);
        }
    }

    @Override
    public Rectangle getBoundsWithoutDefaultWidth() {
        Rectangle Return2 = super.getBounds();
        if (Return2 != null && Return2.width > 0) {
            Return2.width -= ListBox.BUTTON_PANEL_WIDTH;
        }
        return Return2;
    }

    @Override
    protected void addZoomLayoutDataFonts(ZoomLayout.ZoomLayoutData lData) {
        super.addZoomLayoutDataFonts(lData);
        lData.putAdditionalOrigFont(new ZoomLayout.FontProvider(){

            @Override
            public void setFont(Font f) {
                if (RemoteListBox.this.getListBox().getFindPanel() != null) {
                    RemoteListBox.this.getListBox().setFontFindComponents(f);
                }
            }

            @Override
            public Font getFont() {
                return RemoteListBox.this.getListBox().getFontFindComponents();
            }
        });
    }

    private void setSelectionIndices(int[] selIdxs) {
        this.lastSelectedIndices = selIdxs;
        this.lastSelectionValue = this.lastSelectedIndices.length > 0 ? this.getListBox().getItemAt(this.lastSelectedIndices[0]) : null;
    }

    @Override
    public RemoteRecordAccept getDropRRA(Point p) {
        return this.getDropRRA(p, null);
    }

    @Override
    public RemoteRecordAccept getDropRRA(Point p, Component c) {
        PicobolListBox list = this.getListBox();
        int idx = list.getDropRow(p);
        return new RemoteRecordAccept(7, 0, 17043, (short)(idx + 1), 0, false, false, true);
    }

    @Override
    public RemoteRecordAccept getDragRRA() {
        PicobolListBox list = this.getListBox();
        return new RemoteRecordAccept(7, 0, 17042, (short)(list.getSelectedIndexModel() + 1), 0, false, false, true);
    }

    @Override
    public JComponent getDragDropComponent() {
        PicobolListBox list = this.getListBox();
        if (list != null) {
            return list.getDragDropComponent();
        }
        return null;
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        if (!this.checkList) {
            if (!this.lastmousevalueisexit) {
                super.mouseExited(evt);
            }
            this.lastmousevalueisexit = true;
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void sendNotifyMouseData(NotifyMouseEvent nme) {
        if (nme.getMsg() != 17024 || !this.lastmousevalueisexit) {
            this.sendMsgNotifyMouse(nme.getMsg(), nme.getData1(), nme.getData2(), true);
        }
        this.lastmousevalueisexit = nme.getMsg() == 17024;
    }

    private void oldsetMatchingTextColor(String value) {
        this.matchingTextColor = value;
        PicobolListBox list = this.getListBox();
        if (list != null && this.matchingTextColor != null) {
            boolean[] applyAlways = new boolean[1];
            Color[] fieldColors = this.getFieldColors(this.matchingTextColor, applyAlways);
            if (applyAlways[0] && fieldColors[0] != null) {
                list.setMatchingTextColorBackground(fieldColors[0]);
            } else {
                list.setMatchingTextColorBackground(null);
            }
            if (applyAlways[0]) {
                list.setMatchingTextColorForeground(fieldColors[1]);
            } else {
                list.setMatchingTextColorForeground(null);
            }
        }
    }

    private void setMatchingTextColor(String value) {
        this.matchingTextColor = value;
        PicobolListBox list = this.getListBox();
        if (list != null && this.matchingTextColor != null) {
            Color[] fieldColors;
            String mtc2;
            String mtc1;
            int idx = this.matchingTextColor.indexOf(59);
            if (idx >= 0) {
                mtc1 = this.matchingTextColor.substring(0, idx);
                mtc2 = this.matchingTextColor.substring(idx + 1);
            } else {
                mtc1 = this.matchingTextColor;
                mtc2 = "";
            }
            boolean[] applyAlways = new boolean[1];
            if (mtc1.length() > 0) {
                fieldColors = this.getFieldColors(mtc1, applyAlways);
                if (applyAlways[0] && fieldColors[0] != null) {
                    list.setMatchingTextColorBackground(fieldColors[0]);
                } else {
                    list.setMatchingTextColorBackground(null);
                }
                if (applyAlways[0]) {
                    list.setMatchingTextColorForeground(fieldColors[1]);
                } else {
                    list.setMatchingTextColorForeground(null);
                }
            }
            if (mtc2.length() > 0) {
                fieldColors = this.getFieldColors(mtc2, applyAlways);
                if (applyAlways[0] && fieldColors[0] != null) {
                    list.setMatchingTextColor2Background(fieldColors[0]);
                } else {
                    list.setMatchingTextColorBackground(null);
                }
                if (applyAlways[0]) {
                    list.setMatchingTextColor2Foreground(fieldColors[1]);
                } else {
                    list.setMatchingTextColor2Foreground(null);
                }
            }
        }
    }

    public boolean[] getSearchPanelSettings() {
        return this.searchPanelSettings;
    }

    public void setSearchPanelSettings(String s) {
        PicobolListBox list = this.getListBox();
        this.searchPanelSettings = list != null ? ListBox.setSettings(s, this.getListBox().getFindPanel()) : ListBox.setSettings(s, null);
    }

    public void setSearchPanelSetting(short sIdx, boolean s) {
        this.searchPanelSettings[sIdx] = s;
        PicobolListBox list = this.getListBox();
        if (list != null) {
            list.setSearchPanelSetting(sIdx, s);
        }
    }
}

