/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.rts.Factory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SearchPanel
extends JPanel {
    private static final String placeholder = Factory.getSysMsg("enter_text_to_search");
    private static final String CS_IMAGE = "vV.png";
    private static final String CIS_IMAGE = "vV2.png";
    private JTextField searchText;
    private JButton closeBtn;
    private JCheckBox filterBtn;
    private JButton prevBtn;
    private JButton nextBtn;
    private JButton cleanBtn;
    private JButton caseBtn;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private boolean showFilterBtn;
    private boolean filterItems = true;
    private boolean filterCaseSensitive;
    private boolean showCSBtn;
    private boolean showCleanBtn;
    private boolean showNavBtns;
    private boolean showCloseBtn = true;
    private String filterText;
    private Vector<Notifier> spNotifiers = new Vector();
    private Timer findTimer;

    public SearchPanel(boolean showFilterBtn, boolean filterItems, boolean showCSBtn, boolean cs, boolean showCleanBtn, boolean showNavBtns, boolean showSearchBtns, int searchDelay) {
        super(new BorderLayout(0, 0));
        int cc;
        this.filterItems = filterItems;
        this.showFilterBtn = showFilterBtn;
        this.filterCaseSensitive = cs;
        this.showCSBtn = showCSBtn;
        this.showCleanBtn = showCleanBtn;
        this.showNavBtns = showNavBtns;
        this.searchText = new JTextField(){

            @Override
            public void paintComponent(Graphics g1) {
                super.paintComponent(g1);
                if (this.getText().length() == 0) {
                    Graphics2D g = (Graphics2D)g1;
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setColor(this.getDisabledTextColor());
                    int offsh = this.getInsets().left;
                    g.drawString(placeholder, offsh, g1.getFontMetrics().getMaxAscent() + this.getInsets().top);
                }
            }
        };
        this.leftPanel = new JPanel(new GridLayout(0, this.getLeftComponentCount()));
        this.closeBtn = new JButton(new ImageIcon(this.getClass().getResource("cancelfind.png")));
        Insets margins = new Insets(0, 1, 0, 1);
        this.closeBtn.setMargin(margins);
        this.closeBtn.setIconTextGap(0);
        this.closeBtn.setFocusable(false);
        this.leftPanel.add(this.closeBtn);
        this.filterBtn = new JCheckBox(new ImageIcon(this.getClass().getResource("funnel.png")));
        this.filterBtn.setFocusable(false);
        this.filterBtn.addActionListener(e -> {
            boolean b = this.filterBtn.isSelected();
            if (b) {
                this.filterBtn.setBorder(BorderFactory.createLoweredBevelBorder());
                this.filterBtn.setBorderPainted(true);
            } else {
                this.filterBtn.setBorder(BorderFactory.createRaisedBevelBorder());
                this.filterBtn.setBorderPainted(false);
            }
            this.intSetFilterItems(b);
        });
        this.filterBtn.setSelected(true);
        this.filterBtn.setBorder(BorderFactory.createLoweredBevelBorder());
        this.filterBtn.setBorderPainted(true);
        if (this.showFilterBtn) {
            this.leftPanel.add(this.filterBtn);
        }
        this.rightPanel = new JPanel(new GridLayout(0, (cc = this.getRightComponentCount()) > 0 ? cc : 1));
        this.prevBtn = new JButton(new ImageIcon(this.getClass().getResource("chevron_left2.png")));
        this.prevBtn.setMargin(margins);
        this.prevBtn.setIconTextGap(0);
        this.prevBtn.setFocusable(false);
        this.prevBtn.addActionListener(e -> {
            for (Notifier sp : this.spNotifiers) {
                sp.previousMatch();
            }
        });
        if (this.showNavBtns) {
            this.rightPanel.add(this.prevBtn);
        }
        this.nextBtn = new JButton(new ImageIcon(this.getClass().getResource("chevron_right2.png")));
        this.nextBtn.setMargin(margins);
        this.nextBtn.setIconTextGap(0);
        this.nextBtn.setFocusable(false);
        this.nextBtn.addActionListener(e -> {
            for (Notifier sp : this.spNotifiers) {
                sp.nextMatch();
            }
        });
        if (this.showNavBtns) {
            this.rightPanel.add(this.nextBtn);
        }
        this.cleanBtn = new JButton(new ImageIcon(this.getClass().getResource("cleanfind.png")));
        this.cleanBtn.setMargin(margins);
        this.cleanBtn.setIconTextGap(0);
        this.cleanBtn.setFocusable(false);
        this.cleanBtn.addActionListener(e -> this.searchText.setText(""));
        if (this.showCleanBtn) {
            this.rightPanel.add(this.cleanBtn);
        }
        this.caseBtn = new JButton(new ImageIcon(this.getClass().getResource(this.filterCaseSensitive ? CS_IMAGE : CIS_IMAGE)));
        this.caseBtn.setMargin(margins);
        this.caseBtn.setIconTextGap(0);
        this.caseBtn.setFocusable(false);
        this.caseBtn.setActionCommand(this.filterCaseSensitive ? CIS_IMAGE : CS_IMAGE);
        this.caseBtn.addActionListener(e -> {
            String ac = this.caseBtn.getActionCommand();
            this.caseBtn.setIcon(new ImageIcon(this.getClass().getResource(ac)));
            boolean b = CS_IMAGE.equals(ac);
            if (b) {
                this.caseBtn.setActionCommand(CIS_IMAGE);
            } else {
                this.caseBtn.setActionCommand(CS_IMAGE);
            }
            this.intSetFilterCaseSensitive(b);
        });
        if (this.showCSBtn) {
            this.rightPanel.add(this.caseBtn);
        }
        this.add((Component)this.searchText, "Center");
        this.add((Component)this.leftPanel, "West");
        if (showSearchBtns && cc > 0) {
            this.add((Component)this.rightPanel, "East");
        }
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        if (searchDelay > 0) {
            this.findTimer = new Timer(searchDelay, e -> this.setFilterText(this.searchText.getText()));
            this.findTimer.setRepeats(false);
        }
        this.searchText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchPanel.this.findTimer.restart();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchPanel.this.findTimer.restart();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.searchText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    for (Notifier sp : SearchPanel.this.spNotifiers) {
                        sp.escapeKeyPressed();
                    }
                }
            }
        });
        this.closeBtn.addActionListener(ActionEvent2 -> {
            for (Notifier sp : this.spNotifiers) {
                sp.closeButtonPressed();
            }
        });
    }

    private int getLeftComponentCount() {
        int count = 0;
        if (this.showCloseBtn) {
            ++count;
        }
        if (this.showFilterBtn) {
            ++count;
        }
        return count;
    }

    private int getRightComponentCount() {
        int count = 0;
        if (this.showNavBtns) {
            count += 2;
        }
        if (this.showCSBtn) {
            ++count;
        }
        if (this.showCleanBtn) {
            ++count;
        }
        return count;
    }

    public void resetSearchText() {
        this.searchText.setText("");
    }

    public void setFocus() {
        this.searchText.requestFocus();
    }

    public void setShowCloseButton(boolean v) {
        if (this.showCloseBtn != v) {
            this.showCloseBtn = v;
            this.updateLeftPanel(this.showCloseBtn);
        }
    }

    public boolean isShowCloseButton() {
        return this.showCloseBtn;
    }

    public void setSearchTextFont(Font f) {
        this.searchText.setFont(f);
    }

    public Font getSearchTextFont() {
        return this.searchText.getFont();
    }

    public JTextField getSearchText() {
        return this.searchText;
    }

    private void setFilterText(String text) {
        this.filterText = text;
        for (Notifier sp : this.spNotifiers) {
            sp.filterTextChanged(this.filterText);
        }
    }

    public String getFilterText() {
        return this.filterText;
    }

    public boolean isFilterItems() {
        return this.filterItems;
    }

    public boolean isFilterCaseSensitive() {
        return this.filterCaseSensitive;
    }

    private void intSetFilterItems(boolean b) {
        this.filterItems = b;
        for (Notifier sp : this.spNotifiers) {
            sp.filterItemsChanged(this.filterItems);
        }
    }

    public void setFilterItems(boolean b) {
        if (this.filterItems != b) {
            this.filterBtn.setSelected(b);
            this.filterBtn.setBorderPainted(b);
            if (b) {
                this.filterBtn.setBorder(BorderFactory.createLoweredBevelBorder());
            } else {
                this.filterBtn.setBorder(BorderFactory.createRaisedBevelBorder());
            }
            this.intSetFilterItems(b);
        }
    }

    public boolean isShowFilterButton() {
        return this.showFilterBtn;
    }

    public void setShowFilterButton(boolean b) {
        if (this.showFilterBtn != b) {
            this.showFilterBtn = b;
            this.updateLeftPanel(this.showFilterBtn);
        }
    }

    public boolean isShowCaseSensitiveButton() {
        return this.showCSBtn;
    }

    public void setShowCaseSensitiveButton(boolean b) {
        if (this.showCSBtn != b) {
            this.showCSBtn = b;
            this.updateRightPanel(this.showCSBtn);
        }
    }

    private void updateLeftPanel(boolean add) {
        int cc = this.getLeftComponentCount();
        this.leftPanel.removeAll();
        if (cc > 0) {
            ((GridLayout)this.leftPanel.getLayout()).setColumns(cc);
        }
        if (this.showCloseBtn) {
            this.leftPanel.add(this.closeBtn);
        }
        if (this.showFilterBtn) {
            this.leftPanel.add(this.filterBtn);
        }
        if (add) {
            if (cc == 1) {
                this.add((Component)this.leftPanel, "West");
            }
        } else if (cc == 0) {
            this.remove(this.leftPanel);
        }
        this.doLayout();
        this.leftPanel.doLayout();
    }

    private void updateRightPanel(boolean add) {
        int cc = this.getRightComponentCount();
        this.rightPanel.removeAll();
        if (cc > 0) {
            ((GridLayout)this.rightPanel.getLayout()).setColumns(cc);
        }
        if (this.showNavBtns) {
            this.rightPanel.add(this.prevBtn);
            this.rightPanel.add(this.nextBtn);
        }
        if (this.showCleanBtn) {
            this.rightPanel.add(this.cleanBtn);
        }
        if (this.showCSBtn) {
            this.rightPanel.add(this.caseBtn);
        }
        if (add) {
            if (cc == 1) {
                this.add((Component)this.rightPanel, "East");
            }
        } else if (cc == 0) {
            this.remove(this.rightPanel);
        }
        this.doLayout();
        this.rightPanel.doLayout();
    }

    public boolean isShowCleanButton() {
        return this.showCleanBtn;
    }

    public void setShowCleanButton(boolean b) {
        if (this.showCleanBtn != b) {
            this.showCleanBtn = b;
            this.updateRightPanel(this.showCleanBtn);
        }
    }

    public boolean isShowNavigationButtons() {
        return this.showNavBtns;
    }

    public void setShowNavigationButtons(boolean b) {
        if (this.showNavBtns != b) {
            this.showNavBtns = b;
            this.updateRightPanel(this.showNavBtns);
        }
    }

    public void setFilterCaseSensitive(boolean b) {
        if (this.filterCaseSensitive != b) {
            this.caseBtn.setIcon(new ImageIcon(this.getClass().getResource(b ? CS_IMAGE : CIS_IMAGE)));
            this.caseBtn.setActionCommand(b ? CIS_IMAGE : CS_IMAGE);
            this.intSetFilterCaseSensitive(b);
        }
    }

    private void intSetFilterCaseSensitive(boolean b) {
        this.filterCaseSensitive = b;
        for (Notifier sp : this.spNotifiers) {
            sp.filterCaseSensitiveChanged(this.filterCaseSensitive);
        }
    }

    public void addSearchPanelNotifier(Notifier spn) {
        this.spNotifiers.addElement(spn);
    }

    public void removeSearchPanelNotifier(Notifier spn) {
        this.spNotifiers.removeElement(spn);
    }

    public void setSettings(boolean[] s) {
        this.setFilterItems(s[0]);
        this.setShowFilterButton(s[1]);
        this.setShowNavigationButtons(s[2]);
        this.setShowCleanButton(s[3]);
        this.setFilterCaseSensitive(s[4]);
        this.setShowCaseSensitiveButton(s[5]);
    }

    public static boolean[] setSettings(String s, SearchPanel sp) {
        boolean[] b = new boolean[]{true, false, false, true, false, true};
        block0 : switch (s.length()) {
            case 4: {
                switch (s.charAt(3)) {
                    default: {
                        b[4] = false;
                        b[5] = false;
                        if (sp == null) break;
                        sp.setFilterCaseSensitive(false);
                        sp.setShowCaseSensitiveButton(false);
                        break;
                    }
                    case '1': {
                        b[4] = true;
                        b[5] = false;
                        if (sp == null) break;
                        sp.setFilterCaseSensitive(true);
                        sp.setShowCaseSensitiveButton(false);
                        break;
                    }
                    case '2': {
                        b[4] = false;
                        b[5] = true;
                        if (sp == null) break;
                        sp.setFilterCaseSensitive(false);
                        sp.setShowCaseSensitiveButton(true);
                        break;
                    }
                    case '3': {
                        b[4] = true;
                        b[5] = true;
                        if (sp == null) break;
                        sp.setFilterCaseSensitive(true);
                        sp.setShowCaseSensitiveButton(true);
                    }
                }
            }
            case 3: {
                switch (s.charAt(2)) {
                    default: {
                        b[3] = false;
                        if (sp == null) break;
                        sp.setShowCleanButton(false);
                        break;
                    }
                    case '1': {
                        b[3] = true;
                        if (sp == null) break;
                        sp.setShowCleanButton(true);
                    }
                }
            }
            case 2: {
                switch (s.charAt(1)) {
                    default: {
                        b[2] = false;
                        if (sp == null) break;
                        sp.setShowNavigationButtons(false);
                        break;
                    }
                    case '1': {
                        b[2] = true;
                        if (sp == null) break;
                        sp.setShowNavigationButtons(true);
                    }
                }
            }
            case 1: {
                switch (s.charAt(0)) {
                    default: {
                        b[0] = false;
                        b[1] = false;
                        if (sp == null) break block0;
                        sp.setFilterItems(false);
                        sp.setShowFilterButton(false);
                        break block0;
                    }
                    case '1': {
                        b[0] = true;
                        b[1] = false;
                        if (sp == null) break block0;
                        sp.setFilterItems(true);
                        sp.setShowFilterButton(false);
                        break block0;
                    }
                    case '2': {
                        b[0] = false;
                        b[1] = true;
                        if (sp == null) break block0;
                        sp.setFilterItems(false);
                        sp.setShowFilterButton(true);
                        break block0;
                    }
                    case '3': 
                }
                b[0] = true;
                b[1] = true;
                if (sp == null) break;
                sp.setFilterItems(true);
                sp.setShowFilterButton(true);
            }
        }
        return b;
    }

    public void setSearchPanelSetting(short sIdx, boolean s) {
        switch (sIdx) {
            case 0: {
                this.setFilterItems(s);
                break;
            }
            case 1: {
                this.setShowFilterButton(s);
                break;
            }
            case 2: {
                this.setShowNavigationButtons(s);
                break;
            }
            case 3: {
                this.setShowCleanButton(s);
                break;
            }
            case 4: {
                this.setFilterCaseSensitive(s);
                break;
            }
            case 5: {
                this.setShowCaseSensitiveButton(s);
            }
        }
    }

    public static interface Notifier {
        default public void nextMatch() {
        }

        default public void previousMatch() {
        }

        default public void escapeKeyPressed() {
        }

        default public void closeButtonPressed() {
        }

        default public void filterTextChanged(String newText) {
        }

        default public void filterItemsChanged(boolean newValue) {
        }

        default public void filterCaseSensitiveChanged(boolean newValue) {
        }
    }
}

