/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.ListBox;
import com.iscobol.gui.export.ListBoxDataProvider;
import com.iscobol.rts.Factory;
import java.awt.Color;
import java.awt.Font;
import java.util.HashSet;
import java.util.Set;

public class SwingListBoxDataProvider
implements ListBoxDataProvider {
    private ListBox list;
    private ListBox.Column[] columns;
    private Set selIdxs = new HashSet();

    public SwingListBoxDataProvider(ListBox list, int selectionMode) {
        this.list = list;
        this.columns = list.getColumns();
        if (selectionMode > 0) {
            int[] si = list.getSelectedIndices();
            for (int i = 0; i < si.length; ++i) {
                this.selIdxs.add(si[i]);
            }
        }
    }

    @Override
    public int getColumnCount() {
        return this.columns != null ? this.columns.length : 0;
    }

    @Override
    public int getColumnWidth(int colIdx) {
        return colIdx < this.getColumnCount() ? this.columns[colIdx].width : 0;
    }

    @Override
    public int getRowCount() {
        return this.list.getModelItemCount();
    }

    @Override
    public int getRowHeight(int rowIdx) {
        return this.list.getFixedCellHeight();
    }

    @Override
    public Color getBackgroundColor(int rowIdx) {
        if (this.selIdxs.contains(rowIdx)) {
            return this.list.getSelectionBackground();
        }
        Color c = this.list.getBackgroundColor(this.list.getModelListItemAt(rowIdx), rowIdx);
        return c != null ? c : this.list.getBackground();
    }

    @Override
    public Color getForegroundColor(int rowIdx) {
        if (this.selIdxs.contains(rowIdx)) {
            return this.list.getSelectionForeground();
        }
        Color c = this.list.getForegroundColor(this.list.getModelListItemAt(rowIdx), rowIdx);
        return c != null ? c : this.list.getForeground();
    }

    @Override
    public Font getFont() {
        return this.list.getFont();
    }

    @Override
    public int getColumnAlignment(int colIdx) {
        return colIdx < this.getColumnCount() ? this.columns[colIdx].alignment : 0;
    }

    @Override
    public String[] getCellData(int rowIdx) {
        String[] Return2 = this.list.buildTokens(this.list.getModelListItemAt(rowIdx));
        for (int i = 0; i < Return2.length; ++i) {
            Return2[i] = Factory.rightTrim(Return2[i]);
        }
        return Return2;
    }

    @Override
    public int getColumnDivider(int colIdx) {
        return colIdx < this.getColumnCount() ? this.columns[colIdx].divider : 0;
    }

    @Override
    public Color getDividerColor() {
        return Color.black;
    }
}

