/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.server;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.ParamElementInt;
import com.iscobol.gui.ParamVector;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.server.BaseGUIControl;
import com.iscobol.gui.server.CobolGUIEnvironment;
import com.iscobol.gui.server.CobolGUILabel;
import com.iscobol.gui.server.DisplayToolBar;
import com.iscobol.gui.server.DisplayWindow;
import com.iscobol.gui.server.TerminalEmulation;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IPicG;
import com.iscobol.rts.IPicN;
import com.iscobol.rts.IscobolSystem;
import java.io.IOException;

public class CobolGUITerminalDisplay
extends CobolGUILabel
implements TerminalEmulation {
    int colAdjust;
    private boolean isclone;

    @Override
    protected void clear() {
        this.baseclear();
        this.isclone = false;
        this.setSizes(this.getSizes() + (float)this.colAdjust);
        this.colAdjust = 0;
    }

    public CobolGUITerminalDisplay(String n, ICobolVar parent, CobolGUIEnvironment env) {
        super(n, parent, env);
        this.color = new ColorCmp(false);
        this.controlPeerType = 20;
        this.setAtLineInCell(true);
        this.setAtColumnInCell(true);
        this.setLinesInCell(true);
        this.setSizesInCell(true);
        this.setFont("FIXED-FONT");
    }

    @Override
    protected boolean initialize(DisplayWindow dw) {
        boolean Return2 = true;
        super.initialize(dw);
        this.controlPeerServerIdTerminalDisplay = this.controlPeerServerId;
        if (dw.getTerminalDisplayGateId() == 0) {
            dw.setTerminalDisplayGateId(this.controlPeerServerId);
        } else {
            Return2 = false;
            this.controlPeerServerId = dw.getTerminalDisplayGateId();
        }
        this.controlPeerType = 20;
        return Return2;
    }

    @Override
    protected void initialize() {
        super.initialize();
    }

    @Override
    public int getLenInChar() {
        return (int)this.getSizes();
    }

    @Override
    public float getAtColumn() {
        return super.getAtColumn() + (float)this.colAdjust;
    }

    @Override
    public Object clone(DisplayWindow dw) {
        CobolGUITerminalDisplay Return2 = null;
        try {
            Return2 = (CobolGUITerminalDisplay)super.clone(dw);
            Return2.remoteClone(dw);
            Return2.controlPeerinitialize();
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        return Return2;
    }

    @Override
    public void reclone(DisplayWindow dw, ParamVector param) {
        super.reclone();
        this.getClone(dw);
        this.controlpeersetParentControl(-1, dw.getParamCSWindow());
        this.clearChange();
    }

    @Override
    public BaseGUIControl getClone(DisplayWindow dw) {
        if (this.paramCS == null) {
            this.paramCS = new ParamVector(IscobolSystem.isAS());
        }
        try {
            this.buildRemoteObject(this, dw);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
        this.setVisible(true);
        this.isclone = true;
        this.destroyed = false;
        if (dw != null && !(dw instanceof DisplayToolBar)) {
            this.addToParamCS(new ParamElementInt(1024, dw.getTheObjectId()));
        }
        return this;
    }

    @Override
    public boolean isClone() {
        return this.isclone;
    }

    @Override
    public BaseGUIControl getLastClone() {
        if (this.isclone) {
            return this;
        }
        return null;
    }

    @Override
    public BaseGUIControl setNoecho(boolean b) {
        super.setNoecho(b);
        if (b) {
            this.styleoneset |= 0x80L;
        }
        return this;
    }

    @Override
    public BaseGUIControl setUnderline(boolean b) {
        super.setUnderline(b);
        if (b) {
            this.styleoneset |= 0x1000L;
        }
        return this;
    }

    @Override
    public void setUnderlineColor(boolean b) {
        super.setUnderlineColor(b);
        if (b) {
            this.styleoneset |= 0x1000L;
        }
    }

    @Override
    public BaseGUIControl setBlink(boolean b) {
        super.setBlink(b);
        if (b) {
            this.styleoneset |= 8L;
        }
        return this;
    }

    @Override
    public void setBlinkColor(boolean b) {
        super.setBlinkColor(b);
        if (b) {
            this.styleoneset |= 8L;
        }
    }

    @Override
    public BaseGUIControl setReverse(boolean b) {
        super.setReverse(b);
        if (b) {
            this.styleoneset |= 0x400000L;
        }
        return this;
    }

    @Override
    public BaseGUIControl setAll(boolean b) {
        super.setAll(b);
        if (b) {
            this.styleoneset |= 0x80000L;
        }
        return this;
    }

    @Override
    public BaseGUIControl setBeep(boolean b) {
        super.setBeep(b);
        if (b) {
            this.styleoneset |= 2L;
        }
        return this;
    }

    @Override
    public BaseGUIControl setHighlight(boolean b) {
        super.setHighlight(b);
        if (b) {
            this.styleoneset |= 0x8000L;
        }
        return this;
    }

    @Override
    protected long getStyleNumber(String s) {
        if (s.equalsIgnoreCase("RIGHT")) {
            return 1024L;
        }
        if (s.equalsIgnoreCase("LEFT")) {
            return 32L;
        }
        if (s.equalsIgnoreCase("CENTER") || s.equalsIgnoreCase("CENTERED")) {
            return 16L;
        }
        if (s.equalsIgnoreCase("NUMERIC")) {
            return 256L;
        }
        if (s.equalsIgnoreCase("NO-ECHO")) {
            return 128L;
        }
        if (s.equalsIgnoreCase("UNDERLINE")) {
            return 4096L;
        }
        if (s.equalsIgnoreCase("BLINK")) {
            return 8L;
        }
        if (s.equalsIgnoreCase("UPDATE")) {
            return 8192L;
        }
        if (s.equalsIgnoreCase("PROMPT")) {
            return 512L;
        }
        if (s.equalsIgnoreCase("UPPER")) {
            return 16384L;
        }
        if (s.equalsIgnoreCase("LOWER")) {
            return 64L;
        }
        if (s.equalsIgnoreCase("AUTO") || s.equalsIgnoreCase("AUTO-SKIP") || s.equalsIgnoreCase("AUTO-TERMINATION")) {
            return 1L;
        }
        if (s.equalsIgnoreCase("GRAPHICS")) {
            return 2048L;
        }
        return super.getStyleNumber(s);
    }

    @Override
    public float getWidthDimensionInCell() {
        ICobolVar cobolComponentPicture = this.getCobolComponentPicture();
        ICobolVar cobolComponentO = this.getCobolComponentO();
        if (this.getSizes() > 0.0f) {
            return this.sizes;
        }
        if (this.titleupdated != null) {
            return this.titleupdated.length();
        }
        String t = this.displaysetTitle(cobolComponentPicture);
        if (t != null) {
            return t.length();
        }
        if (cobolComponentO != null) {
            int len = Math.max(cobolComponentO.ieval().getLength(), cobolComponentPicture != null ? cobolComponentPicture.getLength() : 0);
            return len;
        }
        return 0.0f;
    }

    @Override
    public BaseGUIControl setTitle(String t) {
        this.title = t;
        return this;
    }

    @Override
    public void displaysetValue(ICobolVar picture) throws IOException {
        if (this.title != null && this instanceof CobolGUITerminalDisplay) {
            return;
        }
        super.displaysetValue(picture);
    }

    @Override
    void controlPeersetValue(String v) throws IOException {
        super.controlPeersetValue(v);
        this.strValue = v;
    }

    @Override
    public void displaysetStyle() {
        try {
            if (this.color != null && this.colorCV != null && this.colorCV.ieval() instanceof INumericVar) {
                if (this.underlinecolor && !this.underline) {
                    this.styleoneset &= 0xFFFFFFFFFFFFEFFFL;
                }
                if (this.blinkcolor && !this.blink) {
                    this.styleoneset &= 0xFFFFFFFFFFFFFFF7L;
                }
                this.styleoneset &= 0xFFFFFFFFFFFF7FFFL;
                this.color = new ColorCmp(false);
            }
            this.checkColorVars();
            if (this.color != null && this.colorCV != null && this.colorCV.ieval() instanceof INumericVar) {
                if (this.getReverseValue()) {
                    this.color.setReverse(this.getReverseValue());
                }
                if (this.highlight) {
                    this.setHighlight(this.highlight);
                }
                if (this.lowlight) {
                    this.color.setForeHighIntensity(!this.lowlight);
                }
                if (this.backhigh) {
                    this.color.setBackHighIntensity(this.backhigh);
                }
                if (this.backlow) {
                    this.color.setBackHighIntensity(!this.backlow);
                }
            }
            this.setUnderlineColor(this.color.getUnderline());
            this.setBlinkColor(this.color.getBlink());
            super.displaysetStyle();
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
    }

    @Override
    public final boolean isTerminalEmulation() {
        return true;
    }

    @Override
    public boolean getContainsChildTE() {
        return true;
    }

    @Override
    public void putControlInfo() {
        if (this.isValidRemoteControl() && (this.getCobolComponentO() instanceof IPicN || this.getCobolComponentO() instanceof IPicG)) {
            int Return2 = 2048;
            if (this.paramCS != null && this.clsentINFO != Return2) {
                this.clsentINFO = Return2;
                this.paramCS.addFirst(new ParamElementInt(1067, Return2));
            }
        }
    }
}

