/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.server;

import com.iscobol.as.ServerCallMessageLoop;
import com.iscobol.gui.JavaBeanParam;
import com.iscobol.gui.JavaBeanUtilities;
import com.iscobol.gui.ServerCall;
import com.iscobol.rmi.RemoteCaller;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rmi.server.ServerCaller;
import com.iscobol.rmi.server.ServerRemoteObject;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.Memory;
import com.iscobol.rts_n.Factory;
import com.iscobol.types.CobolVar;
import com.iscobol.types_n.NumericVar;
import com.iscobol.types_n.PicX;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.lang.reflect.InvocationTargetException;

public class ServerCallImpl
extends ServerRemoteObject
implements ServerCall {
    private static final long serialVersionUID = 222L;
    private transient ServerCallMessageLoop scMsgLoop;
    private int clientSessionId;

    public ServerCallImpl() {
        this.setCallTimeout(0);
    }

    public ServerCallImpl(ServerCallMessageLoop loop) {
        this();
        this.scMsgLoop = loop;
        this.clientSessionId = loop.getClientSessionId();
        ServerCaller caller = (ServerCaller)RemoteRegistry.getCaller(loop.getSessionId());
        this.registry = caller.getRegistry();
        this.ref = new Integer(this.registry.put(this));
    }

    @Override
    public Object[] callStaticMethod(final String className, final String methodName, final String signature, final Object[] arg) throws IOException {
        int i;
        StringBuffer sb = new StringBuffer(className);
        sb.append(".");
        sb.append(methodName);
        sb.append(" (");
        if (arg != null && arg.length > 0) {
            sb.append(arg[0]);
            for (i = 1; i < arg.length; ++i) {
                sb.append(" ").append(arg[i]);
            }
        }
        sb.append(")");
        for (i = 0; i < arg.length; ++i) {
            if (!(arg[i] instanceof JavaBeanParam)) continue;
            arg[i] = ((JavaBeanParam)arg[i]).toCobolVar();
        }
        MyRunnable run = new MyRunnable(sb.toString()){

            @Override
            public Object callMethod() throws Exception {
                return ServerCallImpl.this.myCallStaticMethod(className, methodName, signature, arg);
            }
        };
        this.scMsgLoop.putMessage(run);
        run.waitFor();
        Object[] Return2 = new Object[2];
        Return2[0] = run.result;
        if (run.exception != null) {
            Return2[1] = run.exception instanceof IscobolRuntimeException ? run.exception : new IscobolRuntimeException(run.exception);
        }
        if (Return2[0] instanceof PicX) {
            Return2[0] = new JavaBeanParam((PicX)Return2[0]);
        } else if (Return2[0] instanceof NumericVar) {
            Return2[0] = new JavaBeanParam((NumericVar)Return2[0]);
        }
        return Return2;
    }

    @Override
    public Object[] call(final String progName, final Object[] arg, final boolean isNew, boolean isCp) throws IOException {
        StringBuffer sb = new StringBuffer("CALL ");
        sb.append(progName);
        sb.append(" (");
        if (arg != null && arg.length > 0) {
            sb.append(arg[0]);
            for (int i = 1; i < arg.length; ++i) {
                sb.append(" ").append(arg[i]);
            }
        }
        sb.append(")");
        MyRunnable run = isCp ? new MyRunnable(sb.toString()){

            @Override
            public Object callMethod() throws Exception {
                return ServerCallImpl.this.myCallCp(progName, arg, isNew);
            }
        } : new MyRunnable(sb.toString()){

            @Override
            public Object callMethod() throws Exception {
                return ServerCallImpl.this.myCall(progName, arg, isNew);
            }
        };
        this.scMsgLoop.putMessage(run);
        run.waitFor();
        if (run.exception != null) {
            if (run.exception instanceof IscobolRuntimeException) {
                return new Object[]{run.exception};
            }
            return new Object[]{new IscobolRuntimeException(run.exception)};
        }
        return (Object[])run.result;
    }

    private String getAlias(String name, boolean loadProp, boolean useAliases) {
        String Return2;
        if (useAliases || Config.getProperty("iscobol.as.call.use_aliases", false)) {
            String alias = Config.getProperty("iscobol.as.call.alias." + name, null);
            if (alias != null) {
                int comma = alias.indexOf(44);
                if (comma >= 0) {
                    Return2 = alias.substring(0, comma);
                    if (loadProp) {
                        try {
                            Config.loadProperties(alias.substring(comma + 1), true);
                        }
                        catch (IOException _ex) {
                            throw new IscobolRuntimeException(_ex);
                        }
                    }
                } else {
                    Return2 = alias;
                }
            } else {
                Return2 = null;
            }
        } else {
            Return2 = name;
        }
        return Return2;
    }

    private Object myCallStaticMethod(String className, String methodName, String signature, Object[] parameters) throws Exception {
        String name = this.getAlias(className + "." + methodName, false, true);
        if (name == null) {
            throw new IscobolRuntimeException(5, "Alias name not found:'" + className + "'");
        }
        int idx = name.lastIndexOf(46);
        if (idx < 0 || idx == name.length() - 1) {
            throw new IscobolRuntimeException(6, "''");
        }
        methodName = name.substring(idx + 1);
        className = name.substring(0, idx);
        try {
            Class<?> clazz = Class.forName(className);
            return JavaBeanUtilities.callMethod(clazz, null, clazz.getMethods(), methodName, signature, parameters);
        }
        catch (ClassNotFoundException e) {
            throw new IscobolRuntimeException(5, "'" + className + "'");
        }
        catch (NoSuchMethodException ex) {
            throw new IscobolRuntimeException(6, "'" + methodName + "'");
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof IscobolRuntimeException) {
                throw (IscobolRuntimeException)cause;
            }
            if (cause != null) {
                throw new IscobolRuntimeException(cause);
            }
            throw new IscobolRuntimeException(ex);
        }
        catch (Throwable ex) {
            throw new IscobolRuntimeException(ex);
        }
    }

    private Object[] myCall(String name, Object[] arg, boolean isNew) {
        int argLen = arg == null ? 0 : arg.length;
        Object[] Return2 = new Object[argLen + 1];
        for (int i = 0; i < argLen; ++i) {
            if (arg[i] instanceof CobolVar && ((CobolVar)arg[i]).isByVal()) continue;
            Return2[i] = arg[i];
        }
        String progName = this.getAlias(name.toLowerCase(), true, false);
        if (progName == null) {
            Return2[argLen] = new IscobolRuntimeException(2, "Alias name not found:'" + name.toLowerCase() + "'");
            return Return2;
        }
        try {
            Return2[i] = com.iscobol.rts.Factory.call(progName, null, arg, isNew);
        }
        catch (Error _ex) {
            Return2[argLen] = _ex;
        }
        catch (IscobolRuntimeException _ex) {
            Return2[argLen] = _ex;
        }
        catch (Exception _ex) {
            Return2[argLen] = new IscobolRuntimeException(_ex);
        }
        return Return2;
    }

    private Object[] myCallCp(String name, Object[] arg, boolean isNew) {
        int argLen = arg == null ? 0 : arg.length;
        Object[] rArgs = new Object[argLen];
        Object[] Return2 = new Object[argLen + 1];
        for (int i = 0; i < argLen; ++i) {
            if (arg[i] instanceof CobolVar) {
                byte[] bval = ((CobolVar)arg[i]).getBytes();
                int blen = bval.length;
                Memory mem = Factory.getNotOptmzdMem(blen);
                rArgs[i] = new PicX(mem, 0, blen, null, null, null, false, false);
                ((PicX)rArgs[i]).set(bval, 0, blen, false);
                continue;
            }
            rArgs[i] = arg[i];
        }
        String progName = this.getAlias(name.toLowerCase(), true, false);
        if (progName == null) {
            Return2[argLen] = new IscobolRuntimeException(2, "Alias name not found:'" + name.toLowerCase() + "'");
            return Return2;
        }
        try {
            Return2[argLen] = Factory.call(progName, null, rArgs, isNew);
            if (Return2[argLen] instanceof com.iscobol.types_n.CobolVar) {
                Return2[argLen] = com.iscobol.rts.Factory.getNumLiteral(((com.iscobol.types_n.CobolVar)Return2[argLen]).toint(), 18, 0, false);
            }
            for (int i = 0; i < argLen; ++i) {
                if (!(rArgs[i] instanceof com.iscobol.types_n.CobolVar) || ((CobolVar)arg[i]).isByVal()) continue;
                com.iscobol.types_n.CobolVar cv = (com.iscobol.types_n.CobolVar)rArgs[i];
                CobolVar cn = (CobolVar)arg[i];
                int len = Math.min(cv.length(), cn.length());
                cn.set(cv.getBytes(), 0, len, true);
                Return2[i] = cn;
            }
        }
        catch (Error _ex) {
            Return2[argLen] = _ex;
        }
        catch (IscobolRuntimeException _ex) {
            Return2[argLen] = _ex;
        }
        catch (Exception _ex) {
            Return2[argLen] = new IscobolRuntimeException(_ex);
        }
        return Return2;
    }

    private void myCancel(String name, boolean isCp) {
        String progName = this.getAlias(name.toLowerCase(), false, false);
        if (progName != null) {
            if (isCp) {
                Factory.cancel(name);
            } else {
                com.iscobol.rts.Factory.cancel(progName);
            }
        }
    }

    @Override
    public void cancel(final String progName, final boolean isCp) throws IOException {
        MyRunnable run = new MyRunnable("CANCEL " + progName){

            @Override
            public Object callMethod() throws Exception {
                ServerCallImpl.this.myCancel(progName, isCp);
                return null;
            }
        };
        this.scMsgLoop.putMessage(run);
        run.waitFor();
    }

    @Override
    public void cancelAll(final boolean isCp) throws IOException {
        MyRunnable run = new MyRunnable("CANCEL ALL"){

            @Override
            public Object callMethod() throws Exception {
                if (isCp) {
                    Factory.cancelAll();
                } else {
                    com.iscobol.rts.Factory.cancelAll();
                }
                return null;
            }
        };
        this.scMsgLoop.putMessage(run);
        run.waitFor();
    }

    @Override
    public void shutdown() throws IOException {
        this.scMsgLoop.shutdown(null);
    }

    @Override
    public Object readResolve() throws ObjectStreamException {
        RemoteCaller c = RemoteRegistry.getCaller(this.clientSessionId);
        if (c != null) {
            return this.toStub(c);
        }
        return this;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.clientSessionId = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.clientSessionId);
    }

    private static abstract class MyRunnable
    implements Runnable {
        boolean done = false;
        Object result;
        Throwable exception;
        String name;

        MyRunnable(String name) {
            this.name = name;
        }

        @Override
        public void run() {
            try {
                this.result = this.callMethod();
            }
            catch (Exception e) {
                this.exception = e;
            }
            this.done();
        }

        synchronized void done() {
            this.done = true;
            this.notify();
        }

        synchronized void waitFor() {
            if (!this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        abstract Object callMethod() throws Exception;

        public String toString() {
            return this.name;
        }
    }
}

