/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Stack;

class MfFile {
    private final String idxExt = ".idx";
    private final File datFile;
    private File idxFile;
    private final RandomAccessFile idxRAFile;
    private final RandomAccessFile datRAFile;
    final int signature;
    final short idxSize;
    final short mfVersion;
    final long numOfRecords;
    final int maxRec;
    final int minRec;
    final int nKeys;
    final Key[] keys;
    final boolean gteq4095;
    final boolean compressed;
    private byte[] buffer;
    private byte[] sequence = null;
    private long primaryKeyRoot;
    private int tail;
    private Stack status;
    private static final String blanks = "                                            ";

    public MfFile(String fileName) throws IOException {
        int dot = fileName.lastIndexOf(46);
        String idxFileName = dot < 1 || fileName.lastIndexOf(File.separatorChar) > dot ? fileName + ".idx" : (fileName.toLowerCase().endsWith(".idx".toLowerCase()) ? fileName + ".idx" : fileName.substring(0, dot) + ".idx");
        this.datFile = new File(fileName);
        this.idxFile = new File(idxFileName);
        if (!this.idxFile.exists()) {
            this.idxFile = this.datFile;
            this.datRAFile = this.idxRAFile = new RandomAccessFile(this.idxFile, "r");
        } else {
            this.idxRAFile = new RandomAccessFile(this.idxFile, "r");
            this.datRAFile = new RandomAccessFile(this.datFile, "r");
        }
        try {
            this.signature = this.idxRAFile.readShort() & 0xFFFF;
            if (this.signature == 65107) {
                this.compressed = false;
                this.idxRAFile.seek(6L);
                short iSize = this.idxRAFile.readShort();
                this.mfVersion = (short)(256 - (iSize & 0xFF));
                this.idxSize = (short)(iSize + this.mfVersion);
                this.nKeys = this.idxRAFile.readShort() & 0xFFFF;
                this.idxRAFile.seek(13L);
                this.minRec = this.maxRec = this.idxRAFile.readShort() & 0xFFFF;
                this.gteq4095 = this.maxRec >= 4095;
                long firstKeyNode = (long)this.idxRAFile.readInt() & 0xFFFFFFFFL;
                this.idxRAFile.seek(33L);
                this.numOfRecords = (long)this.idxRAFile.readInt() & 0xFFFFFFFFL;
                this.keys = new Key[this.nKeys];
                this.readKeys(firstKeyNode);
                if (this.datRAFile == this.idxRAFile) {
                    throw new IOException("Invalid file!");
                }
                this.buffer = new byte[this.maxRec + 2];
            } else if ((this.signature & 0xF000) == 12288) {
                this.idxRAFile.seek(41L);
                this.compressed = this.idxRAFile.readByte() != 0;
                this.idxRAFile.seek(43L);
                this.mfVersion = (short)(this.idxRAFile.readByte() & 0xFF);
                this.idxRAFile.seek(54L);
                this.maxRec = this.idxRAFile.readInt();
                this.gteq4095 = this.maxRec >= 4095;
                this.idxRAFile.seek(58L);
                this.minRec = this.idxRAFile.readInt();
                this.idxRAFile.seek(64L);
                this.numOfRecords = this.idxRAFile.readLong();
                this.idxRAFile.seek(140L);
                this.nKeys = this.idxRAFile.readShort() & 0xFFFF;
                this.idxRAFile.seek(144L);
                long firstKeyAddr = this.idxRAFile.readLong();
                this.idxRAFile.seek(172L);
                this.idxSize = this.gteq4095 ? (short)(4 + this.idxRAFile.readInt()) : (short)(2 + this.idxRAFile.readInt());
                this.keys = new Key[this.nKeys];
                if (this.mfVersion == 8) {
                    this.readKeys8(firstKeyAddr);
                    this.status = new Stack();
                    this.status.push(new IndexNode(this.primaryKeyRoot));
                } else if (this.mfVersion == 3 || this.mfVersion == 4) {
                    if (this.datRAFile == this.idxRAFile) {
                        throw new IOException("Invalid file!");
                    }
                    this.readKeys(firstKeyAddr);
                    this.datRAFile.seek(128L);
                } else {
                    throw new IOException("Unsupported version " + this.mfVersion);
                }
                this.buffer = new byte[this.maxRec + this.tail + 3];
            } else {
                throw new IOException("Unsupported file!");
            }
            long datPointer = this.datRAFile.getFilePointer();
            try {
                int padding;
                byte flag;
                int rlen;
                if (this.gteq4095) {
                    rlen = this.datRAFile.readInt();
                    flag = (byte)((rlen & 0xF0000000) >>> 24);
                    padding = 4 - (rlen &= 0xFFFFFFF) % 4;
                } else {
                    rlen = this.datRAFile.readChar();
                    flag = (byte)((rlen & 0xF000) >>> 8);
                    padding = 4 - ((rlen &= 0xFFF) + 2) % 4;
                }
                if (rlen >= 256 && flag == 48) {
                    this.sequence = new byte[rlen + padding + this.tail];
                    rlen = this.datRAFile.read(this.sequence, 0, rlen + padding + this.tail);
                    if (new String(this.sequence).substring(3, 13).equals("0000000000")) {
                        this.sequence = null;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.datRAFile.seek(datPointer);
        }
        catch (IOException _ex) {
            this.close();
            throw _ex;
        }
    }

    private void readKeys8(long firstKeyAddr) throws IOException {
        long addr = firstKeyAddr;
        int i = 0;
        while (i < this.nKeys) {
            int pnt = 0;
            this.idxRAFile.seek(addr);
            this.idxRAFile.readShort();
            pnt += 2;
            if (this.gteq4095) {
                short nodeLenMaybe = this.idxRAFile.readShort();
                pnt += 2;
            }
            short nodeDim = this.idxRAFile.readShort();
            pnt += 2;
            int end = nodeDim - 2;
            this.idxRAFile.readShort();
            pnt += 2;
            addr = (long)this.idxRAFile.readInt() & 0xFFFFFFFFL;
            pnt += 4;
            while (pnt < end) {
                this.keys[i] = new Key();
                short keyDim = this.idxRAFile.readShort();
                int kend = (pnt += 2) + keyDim - 2;
                int unk2 = this.idxRAFile.readInt();
                pnt += 4;
                long unk3 = this.idxRAFile.readLong();
                pnt += 8;
                long root = this.idxRAFile.readLong();
                pnt += 8;
                if (this.primaryKeyRoot == 0L) {
                    this.primaryKeyRoot = root;
                }
                this.idxRAFile.readByte();
                ++pnt;
                byte kflags = this.idxRAFile.readByte();
                if ((kflags & 0x40) != 0) {
                    this.keys[i].duplicates = true;
                }
                ++pnt;
                int j = 0;
                while (pnt < kend) {
                    KeyPart kp = new KeyPart();
                    kp.length = this.idxRAFile.readShort() & 0xFFFF;
                    pnt += 2;
                    kp.offset = this.idxRAFile.readInt();
                    pnt += 4;
                    this.idxRAFile.readByte();
                    ++pnt;
                    this.idxRAFile.readByte();
                    ++pnt;
                    this.keys[i].length += kp.length;
                    this.keys[i].parts.add(kp);
                    ++j;
                }
                this.keys[i].nparts = j;
                ++i;
            }
        }
    }

    private static long getNumber(byte[] buf, int offs, int len) {
        long Return2 = 0L;
        switch (len) {
            case 8: {
                Return2 |= (long)(buf[offs++] & 0xFF) << 56;
            }
            case 7: {
                Return2 |= (long)(buf[offs++] & 0xFF) << 48;
            }
            case 6: {
                Return2 |= (long)(buf[offs++] & 0xFF) << 40;
            }
            case 5: {
                Return2 |= (long)(buf[offs++] & 0xFF) << 32;
            }
            case 4: {
                Return2 |= (long)(buf[offs++] & 0xFF) << 24;
            }
            case 3: {
                Return2 |= (long)(buf[offs++] & 0xFF) << 16;
            }
            case 2: {
                Return2 |= (long)(buf[offs++] & 0xFF) << 8;
            }
            case 1: {
                Return2 |= (long)(buf[offs] & 0xFF);
            }
        }
        return Return2;
    }

    private void readNode8(long addr) throws IOException {
        byte[] node = new byte[this.idxSize];
        this.idxRAFile.seek(addr);
        this.idxRAFile.read(node, 0, this.idxSize);
        int level = node[this.idxSize - 1] & 0x7F;
        int offs = 0;
        int signature = (int)MfFile.getNumber(node, offs, 2);
        int dim = (int)MfFile.getNumber(node, offs += 2, 2) & Short.MAX_VALUE;
        offs += 2;
        int kLen = this.keys[0].length;
        int kBlkLen = kLen + 6;
        if (level > 0) {
            while (offs < dim) {
                long nAddr = MfFile.getNumber(node, offs + kLen, 6);
                this.readNode8(nAddr);
                offs += kBlkLen;
            }
        } else {
            while (offs < dim) {
                long nAddr = MfFile.getNumber(node, offs + kLen, 6);
                System.out.println(">l>" + new String(node, offs, kLen) + "," + Long.toHexString(nAddr));
                offs += kBlkLen;
            }
        }
    }

    long getNextRecAddr() throws IOException {
        long Return2 = -1L;
        IndexNode n = (IndexNode)this.status.peek();
        while (true) {
            if ((Return2 = n.getNextAddress()) < 0L) {
                this.status.pop();
                if (this.status.isEmpty()) {
                    return Return2;
                }
                n = (IndexNode)this.status.peek();
                continue;
            }
            if (n.level == 0) {
                return Return2;
            }
            n = new IndexNode(Return2);
            this.status.push(n);
        }
    }

    private void readKeys(long firstKeyAddr) throws IOException {
        long addr = firstKeyAddr;
        int i = 0;
        while (i < this.nKeys) {
            if (this.mfVersion < 3) {
                this.idxRAFile.seek((addr - 1L) * (long)this.idxSize);
            } else {
                this.idxRAFile.seek(addr);
            }
            int pnt = 0;
            short nodeDim = this.idxRAFile.readShort();
            pnt += 2;
            int end = nodeDim - 2;
            addr = (long)this.idxRAFile.readInt() & 0xFFFFFFFFL;
            pnt += 4;
            while (pnt < end) {
                this.keys[i] = new Key();
                short keyDim = this.idxRAFile.readShort();
                int kend = (pnt += 2) + keyDim - 2;
                this.idxRAFile.readInt();
                pnt += 4;
                byte kflags = this.idxRAFile.readByte();
                ++pnt;
                int j = 0;
                while (pnt < kend) {
                    KeyPart kp = new KeyPart();
                    if ((this.idxRAFile.readByte() & 0x80) != 0) {
                        this.keys[i].duplicates = true;
                        if (this.mfVersion == 4) {
                            this.tail = this.tail == 0 ? 8 : (this.tail += 4);
                        }
                    }
                    ++pnt;
                    kp.length = this.idxRAFile.readByte() & 0xFF;
                    ++pnt;
                    kp.offset = this.idxRAFile.readShort() & 0xFFFF;
                    pnt += 2;
                    this.idxRAFile.readByte();
                    ++pnt;
                    this.keys[i].length += kp.length;
                    this.keys[i].parts.add(kp);
                    ++j;
                }
                this.keys[i].nparts = j;
                ++i;
            }
        }
    }

    String fmt(String Return2, int len, boolean left) {
        int sLen = Return2.length();
        if (sLen < len) {
            Return2 = left ? Return2 + blanks.substring(0, len - sLen) : blanks.substring(0, len - sLen) + Return2;
        }
        return Return2;
    }

    String fmt(String s, int len) {
        return this.fmt(s, len, false);
    }

    String fmt(long n, int len, boolean left) {
        String s = "" + n;
        return this.fmt(s, len, left);
    }

    String fmt(long n, int len) {
        return this.fmt(n, len, false);
    }

    public void printInfo() {
        System.out.println(this.datFile.getPath() + "  IDXFORMAT\"" + this.mfVersion + "\"");
        System.out.println("# of records:" + this.fmt(this.numOfRecords, 18));
        String c = this.compressed ? " compressed" : "";
        System.out.println("record size:" + this.fmt(this.maxRec, 19) + c);
        System.out.println("# of keys: " + this.fmt(this.nKeys, 20));
        System.out.println("Key  Dups    Seg-1     Seg-2     Seg-3     Seg-4     Seg-5     Seg-6");
        System.out.println("            (sz/of)   (sz/of)   (sz/of)   (sz/of)   (sz/of)   (sz/of)");
        System.out.println("");
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < this.nKeys; ++i) {
            out.delete(0, out.length());
            out.append(this.fmt(i, 3));
            out.append(this.fmt(this.keys[i].duplicates ? "Y" : "N", 5));
            out.append("  ");
            for (int j = 0; j < this.keys[i].nparts; ++j) {
                out.append(this.fmt(((KeyPart)this.keys[i].parts.get((int)j)).length, 3));
                out.append("/");
                out.append(this.fmt(((KeyPart)this.keys[i].parts.get((int)j)).offset, 6, true));
            }
            System.out.println(out);
        }
    }

    public long getValidRecordsNum() {
        return this.numOfRecords;
    }

    private int readNext1(byte[] record, int offs, int len) {
        int Return2;
        try {
            while ((Return2 = this.datRAFile.read(this.buffer, 0, this.maxRec + 1)) > 0 && this.buffer[this.maxRec] != 10) {
            }
            if (Return2 > 0) {
                Return2 = Math.min(len, this.maxRec);
                System.arraycopy(this.buffer, 0, record, offs, Return2);
            }
        }
        catch (IOException _ex) {
            Return2 = -1;
        }
        return Return2;
    }

    private int readNext2(byte[] record, int offs, int len) {
        int Return2;
        try {
            while ((Return2 = this.datRAFile.read(this.buffer, 0, this.maxRec + 2)) > 0 && this.buffer[this.maxRec + 1] != 10) {
            }
            if (Return2 > 0) {
                Return2 = Math.min(len, this.maxRec);
                System.arraycopy(this.buffer, 0, record, offs, Return2);
            }
        }
        catch (IOException _ex) {
            Return2 = -1;
        }
        return Return2;
    }

    private int readNext34(byte[] record, int offs, int len) {
        int Return2;
        try {
            byte flag;
            int rlen;
            do {
                int padding;
                if (this.gteq4095) {
                    rlen = this.datRAFile.readInt();
                    flag = (byte)((rlen & 0xF0000000) >>> 24);
                    padding = 4 - (rlen &= 0xFFFFFFF) % 4;
                } else {
                    rlen = this.datRAFile.readChar();
                    flag = (byte)((rlen & 0xF000) >>> 8);
                    padding = 4 - ((rlen &= 0xFFF) + 2) % 4;
                }
                if (padding < 4) {
                    if (this.buffer.length < rlen + padding + this.tail) {
                        this.buffer = new byte[rlen + padding + this.tail + 2];
                    }
                    rlen = this.datRAFile.read(this.buffer, 0, rlen + padding + this.tail);
                    continue;
                }
                rlen = this.datRAFile.read(this.buffer, 0, rlen + this.tail);
            } while (rlen > 0 && flag != 64);
            if (rlen > 0) {
                Return2 = Math.min(rlen, this.maxRec);
                System.arraycopy(this.buffer, 0, record, offs, Return2);
            } else {
                Return2 = -1;
            }
        }
        catch (IOException _ex) {
            Return2 = -1;
        }
        return Return2;
    }

    private int readNext8(byte[] record, int offs, int len) {
        int Return2;
        try {
            long addr = this.getNextRecAddr();
            if (addr > 0L) {
                int rlen;
                this.datRAFile.seek(addr);
                if (this.gteq4095) {
                    rlen = this.datRAFile.readInt();
                    byte flag = (byte)((rlen & 0xF0000000) >>> 24);
                    rlen &= 0xFFFFFFF;
                } else {
                    rlen = this.datRAFile.readChar();
                    byte flag = (byte)((rlen & 0xF000) >>> 8);
                    rlen &= 0xFFF;
                }
                Return2 = this.datRAFile.read(this.buffer, 0, rlen);
                if (rlen > 0) {
                    Return2 = Math.min(rlen, this.maxRec);
                    System.arraycopy(this.buffer, 0, record, offs, Return2);
                } else {
                    Return2 = -1;
                }
            } else {
                Return2 = -1;
            }
        }
        catch (IOException _ex) {
            Return2 = -1;
        }
        return Return2;
    }

    private int readNext3(byte[] record, int offs, int len) {
        return this.readNext34(record, offs, len);
    }

    private int readNext4(byte[] record, int offs, int len) {
        return this.readNext34(record, offs, len);
    }

    int readNext(byte[] record, int offs, int len) {
        switch (this.mfVersion) {
            case 1: {
                return this.readNext1(record, offs, len);
            }
            case 2: {
                return this.readNext2(record, offs, len);
            }
            case 3: {
                return this.readNext3(record, offs, len);
            }
            case 4: {
                return this.readNext4(record, offs, len);
            }
            case 8: {
                return this.readNext8(record, offs, len);
            }
        }
        return -1;
    }

    public void close() {
        if (this.idxRAFile != null) {
            try {
                this.idxRAFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.datRAFile != null && this.datRAFile != this.idxRAFile) {
            try {
                this.datRAFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public byte[] getSequence() {
        return this.sequence;
    }

    class IndexNode {
        private final long address;
        private final byte[] node;
        private final int level;
        private int offs;
        private final int signature;
        private final int dim;
        private final int kLen;
        private final int kBlkLen;

        IndexNode(long addr) throws IOException {
            this.address = addr;
            this.node = new byte[MfFile.this.idxSize];
            MfFile.this.idxRAFile.seek(this.address);
            MfFile.this.idxRAFile.read(this.node, 0, MfFile.this.idxSize);
            this.level = this.node[MfFile.this.idxSize - 1] & 0x7F;
            this.signature = (int)MfFile.getNumber(this.node, this.offs, 2);
            this.offs += 2;
            if (MfFile.this.gteq4095) {
                this.offs += 2;
            }
            this.dim = (int)MfFile.getNumber(this.node, this.offs, 2) & Short.MAX_VALUE;
            this.offs += 2;
            this.kLen = MfFile.this.keys[0].length;
            this.kBlkLen = this.kLen + 6;
        }

        long getNextAddress() {
            long Return2;
            if (this.offs < this.dim) {
                this.offs += this.kLen;
                Return2 = MfFile.getNumber(this.node, this.offs, 6);
                this.offs += 6;
            } else {
                Return2 = -1L;
            }
            return Return2;
        }
    }

    static class Key {
        int nparts;
        boolean duplicates;
        int length;
        ArrayList parts = new ArrayList();

        Key() {
        }
    }

    static class KeyPart {
        int offset;
        int length;

        KeyPart() {
        }
    }
}

