/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.AtEndException;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.PrinterFile;
import com.iscobol.rts.Config;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PrinterFileMF
extends PrinterFile
implements CobolFile,
RuntimeErrorsNumbers {
    private RandomAccessFile fileRewrite = null;
    private int offset = -1;
    private int bufLen = 0;

    public PrinterFileMF(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, boolean binary, Class clazz) {
        super(nam, maxLen, memBuf, minLen, opt, binary, clazz);
    }

    public PrinterFileMF(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, boolean binary, String clazz) {
        super(nam, maxLen, memBuf, minLen, opt, binary, clazz);
    }

    public PrinterFileMF(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt, boolean binary) {
        super(nam, maxLen, memBuf, minLen, opt, binary);
    }

    public PrinterFileMF(String nam, int maxLen, ICobolVar memBuf, int minLen, boolean opt) {
        super(nam, maxLen, memBuf, minLen, opt, false);
    }

    @Override
    public void peerOpen(String path, int openType, int lockType) {
        if (openType != 3) {
            super.peerOpen(path, openType, lockType);
        } else {
            this.offset = -1;
            super.peerOpen(path, 1, lockType);
            try {
                this.fileRewrite = new RandomAccessFile(path, "rw");
            }
            catch (Exception e) {
                CobolIOException.get(142, "e.getMessage()", this, 1);
            }
            this.setOpenMode(openType);
        }
        if (this.outFile != null) {
            int minRecSize = Config.getProperty(".file.min_rec_size", ".min_rec_size", 1);
            if (minRecSize < 0) {
                minRecSize = 0;
            }
            this.outFile.setMinRecSize(minRecSize);
        }
    }

    @Override
    public void rewrite(boolean lock, int len) {
        boolean opts = false;
        try {
            if (this.offset > 0) {
                this.fileRewrite.seek(this.offset - this.bufLen);
            }
            if (this.bufLen > 0) {
                this.fileRewrite.write(new String(this.getBufferAsVar().getBytes()).substring(0, this.bufLen - 1).getBytes());
            }
        }
        catch (Exception e) {
            CobolIOException.get(131, "e.getMessage()", this, 1);
        }
    }

    @Override
    public int readNext(boolean lock, ICobolVar into) {
        return this.readNext(lock ? 1 : 0, into);
    }

    @Override
    public int readNext(int lock, ICobolVar into) {
        int Return2 = 0;
        if (this.inpFile == null) {
            AtEndException.get(this, 6);
            return Return2;
        }
        try {
            byte[] in;
            this.offset = this.offset >= 0 ? ++this.offset : 0;
            if (this.isBinary()) {
                in = new byte[this.getBufferLength()];
                Return2 = this.inpFile.read(in, 0, this.getBufferLength());
                if (Return2 <= 0) {
                    AtEndException.get(this, 6);
                    return Return2;
                }
                this.bufLen = Return2;
                this.updateBuffer(in);
            } else {
                char[] inc = new char[2];
                String buff = "";
                int len = 1;
                this.bufLen = 0;
                while (len >= 0 && inc[0] != '\n') {
                    len = this.inpFile.read(inc, 0, 1);
                    if (len > 0 && inc[0] != '\n') {
                        ++this.bufLen;
                    }
                    if (len <= 0 || inc[0] == '\n' || inc[0] == '\r') continue;
                    buff = buff + inc[0];
                }
                if (len <= 0 && this.bufLen == 0) {
                    AtEndException.get(this, 6);
                    return Return2;
                }
                if (len < 0) {
                    ++this.bufLen;
                }
                Return2 = buff.length();
                in = buff.getBytes();
                this.updateBuffer(buff.getBytes());
            }
            Return2 = this.bufLen;
            this.offset += this.bufLen;
            if (into != null) {
                into.setUsingMaxLen(in);
            }
        }
        catch (IOException ex) {
            CobolIOException.get(ex, this, 6);
        }
        return Return2;
    }

    @Override
    protected void peerClose(int opts) {
        this.checkFilePageEject(opts);
        try {
            if (this.fileRewrite != null) {
                this.fileRewrite.close();
            } else {
                this.dfPeerClose(opts);
            }
        }
        catch (IOException ex) {
            CobolIOException.get(ex, this, 6);
        }
        this.offset = 0;
    }
}

