/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.lib;

import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.UserHandles;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import com.iscobol.types.ObjectVar;
import com.iscobol.types.PicX;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class C$XML
implements IscobolCall {
    static final int CXML_SUCCESS = 1;
    static final int CXML_ERROR = 0;
    static final int CXML_BAD_ARGUMENT = -1;
    static final int CXML_PARSE_FILE = 1;
    static final int CXML_RELEASE_PARSER = 2;
    static final int CXML_GET_FIRST_CHILD = 3;
    static final int CXML_GET_NEXT_SIBLING = 4;
    static final int CXML_GET_PARENT = 5;
    static final int CXML_GET_DATA = 6;
    static final int CXML_GET_ATTRIBUTE_COUNT = 7;
    static final int CXML_GET_ATTRIBUTE = 8;
    static final int CXML_GET_LAST_ERROR = 9;
    static final int CXML_OPEN_FILE = 10;
    static final int CXML_PARSE_STRING = 11;
    static final int CXML_PARSE_NEXT_RECORD = 12;
    static final int CXML_GET_PREV_SIBLING = 13;
    static final int CXML_NEW_PARSER = 14;
    static final int CXML_GET_ATTRIBUTE_BY_NAME = 15;
    static final int CXML_GET_CHILD_BY_NAME = 16;
    static final int CXML_GET_CHILD_BY_CDATA = 17;
    static final int CXML_GET_CHILD_BY_ATTR_NAME = 18;
    static final int CXML_GET_CHILD_BY_ATTR_VALUE = 19;
    static final int CXML_GET_SIBLING_BY_NAME = 20;
    static final int CXML_GET_SIBLING_BY_CDATA = 21;
    static final int CXML_GET_SIBLING_BY_ATTR_NAME = 22;
    static final int CXML_GET_SIBLING_BY_ATTR_VALUE = 23;
    static final int CXML_GET_COMMENT = 24;
    static final int CXML_SET_DATA = 25;
    static final int CXML_MODIFY_ATTRIBUTE_VALUE = 26;
    static final int CXML_ADD_CHILD = 27;
    static final int CXML_ADD_SIBLING = 28;
    static final int CXML_ADD_ATTRIBUTE = 29;
    static final int CXML_ADD_COMMENT = 30;
    static final int CXML_APPEND_COMMENT = 31;
    static final int CXML_DELETE_ATTRIBUTE = 32;
    static final int CXML_DELETE_ELEMENT = 33;
    static final int CXML_DELETE_COMMENT = 34;
    static final int CXML_WRITE_FILE = 35;
    static final int CXML_GET_PROC_INSTR_COUNT = 36;
    static final int CXML_GET_PROC_INSTR = 37;
    static final int CXML_SET_PROC_INSTR = 38;
    static final int CXML_GET_VERSION = 39;
    static final int CXML_SET_VERSION = 40;
    static final int CXML_GET_ENCODING = 41;
    static final int CXML_SET_ENCODING = 42;
    static final int CXML_GET_STANDALONE = 43;
    static final int CXML_SET_STANDALONE = 44;
    static final int CXML_GET_RAW_DOCTYPE_LEN = 45;
    static final int CXML_GET_RAW_DOCTYPE = 46;
    static final int CXML_SET_RAW_DOCTYPE = 47;
    static final int CXML_WRITE_STRING = 48;
    static final int CXML_NO_ERR = 0;
    static final int CXML_NO_MEMORY = 1;
    static final int CXML_EXPAT_ERROR = 2;
    static final int CXML_FILE_OPEN_ERROR = 3;
    static final int CXML_PARSE_ERROR = 4;
    static final int CXML_INVALID_PARSER_HANDLE = 5;
    static final int CXML_INVALID_ELEMENT_HANDLE = 6;
    static final int CXML_INVALID_ATTRIBUTE_NUMBER = 7;
    static final int CXML_URL_ERROR = 8;
    static final int CXML_NOT_AVAILABLE = 9;
    static final int CXML_NO_CHILDREN = 10;
    static final int CXML_NO_SIBLINGS = 11;
    static final int CXML_NO_PARENT = 12;
    static final int CXML_NO_VALUE = 13;
    static final int CXML_NO_ATTRIBUTES = 14;
    static final int CXML_REGEXP_ERROR = 15;
    static final int CXML_TOP_LEVEL = 16;
    static final int CXML_INVALID_PROC_INSTR_NUMBER = 17;
    static final int CXML_NO_PROCESSING_INSTRUCTIONS = 18;
    static final int INDENT = Config.getProperty(".cxml.indent_number", -1);
    protected static Hashtable errDesc = new Hashtable();
    protected static Hashtable stand;
    static final int errorNotSetted = 99999;
    static final Logger log;
    private int op_code;
    private int last_error = 99999;
    private int last_error_to_return = 0;
    byte[] RESULT$0 = Factory.getMem(8);
    NumericVar RESULT = Factory.getVarBinary(this.RESULT$0, 0, 8, false, null, null, null, "RETURN-CODE", false, 18, 0, true, false, false);
    private DocumentBuilderFactory factory = RtsUtil.newDocumentBuilderFactory();
    private DocumentBuilder builder = null;
    private Document doc = null;
    private Hashtable procs = new Hashtable();
    private Hashtable encoding = new Hashtable();
    private Vector procInstr = null;
    private ObjectVar HANDLE = Factory.getVarObject(new byte[4], 0, 4, false, null, null, null, "HANDLE", false, 0, 0, false, false, false);
    private ObjectVar HANDLE_READER = Factory.getVarObject(new byte[4], 0, 4, false, null, null, null, "HANDLE", false, 0, 0, false, false, false);
    private CobolVar HANDLE_VAR = null;
    private Node node = null;
    private Comment comm = null;

    @Override
    public Object call(Object[] argv) {
        CobolVar[] argv2;
        if (argv != null) {
            argv2 = new CobolVar[argv.length];
            for (int i = 0; i < argv.length; ++i) {
                argv2[i] = (CobolVar)argv[i];
            }
        } else {
            argv2 = new CobolVar[]{};
        }
        return this.call(argv2);
    }

    public Object call(CobolVar[] argv) {
        this.RESULT.set(CobolNum.noo(1L, 0), false, false);
        if (argv.length < 1) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        } else if (argv != null && argv.length > 0 && argv[0] instanceof NumericVar) {
            this.op_code = ((NumericVar)argv[0]).integer();
            if (log != null) {
                log.info("C$XML op=" + this.op_code + " parameters number=" + argv.length + "]");
            }
            try {
                if (this.op_code != 9) {
                    this.last_error = 99999;
                }
                switch (this.op_code) {
                    case 1: {
                        this.cxml_PARSE_FILE(argv);
                        break;
                    }
                    case 2: {
                        this.cxml_RELEASE_PARSER(argv);
                        break;
                    }
                    case 3: {
                        this.cxml_GET_FIRST_CHILD(argv);
                        break;
                    }
                    case 4: {
                        this.cxml_GET_NEXT_SIBLING(argv);
                        break;
                    }
                    case 5: {
                        this.cxml_GET_PARENT(argv);
                        break;
                    }
                    case 6: {
                        if (argv.length != 4 && argv.length != 5) {
                            this.last_error = -1;
                            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
                            break;
                        }
                        this.RESULT.set(CobolNum.noo(this.cxml_GET_DATA(argv), 0), false, false);
                        break;
                    }
                    case 7: {
                        if (argv.length != 2) {
                            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
                            break;
                        }
                        this.RESULT.set(CobolNum.noo(this.cxml_GET_ATTRIBUTE_COUNT(argv[1]), 0), false, false);
                        break;
                    }
                    case 8: {
                        if (argv.length != 5 && argv.length != 6) {
                            this.last_error = -1;
                            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
                            break;
                        }
                        this.RESULT.set(CobolNum.noo(this.cxml_GET_ATTRIBUTE(argv), 0), false, false);
                        break;
                    }
                    case 9: {
                        this.cxml_GET_LAST_ERROR(argv);
                        break;
                    }
                    case 10: {
                        this.cxml_OPEN_FILE(argv);
                        break;
                    }
                    case 11: {
                        this.cxml_PARSE_STRING(argv);
                        break;
                    }
                    case 12: {
                        this.cxml_PARSE_NEXT_RECORD(argv);
                        break;
                    }
                    case 13: {
                        this.cxml_GET_PREV_SIBLING(argv);
                        break;
                    }
                    case 14: {
                        this.cxml_NEW_PARSER(argv);
                        break;
                    }
                    case 15: {
                        this.cxml_GET_ATTRIBUTE_BY_NAME(argv);
                        break;
                    }
                    case 16: {
                        this.cxml_GET_CHILD_BY_NAME(argv);
                        break;
                    }
                    case 17: {
                        this.cxml_GET_CHILD_BY_CDATA(argv);
                        break;
                    }
                    case 18: {
                        this.cxml_GET_CHILD_BY_ATTR_NAME(argv);
                        break;
                    }
                    case 19: {
                        this.cxml_GET_CHILD_BY_ATTR_VALUE(argv);
                        break;
                    }
                    case 20: {
                        this.cxml_GET_SIBLING_BY_NAME(argv);
                        break;
                    }
                    case 21: {
                        this.cxml_GET_SIBLING_BY_CDATA(argv);
                        break;
                    }
                    case 22: {
                        this.cxml_GET_SIBLING_BY_ATTR_NAME(argv);
                        break;
                    }
                    case 23: {
                        this.cxml_GET_SIBLING_BY_ATTR_VALUE(argv);
                        break;
                    }
                    case 24: {
                        this.cxml_GET_COMMENT(argv);
                        break;
                    }
                    case 25: {
                        if (argv.length != 3 && argv.length != 4) {
                            this.last_error = -1;
                            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
                            break;
                        }
                        this.RESULT.set(CobolNum.noo(this.cxml_SET_DATA(argv), 0), false, false);
                        break;
                    }
                    case 26: {
                        if (argv.length != 4 && argv.length != 5) {
                            this.last_error = -1;
                            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
                            break;
                        }
                        this.RESULT.set(CobolNum.noo(this.cxml_MODIFY_ATTRIBUTE_VALUE(argv), 0), false, false);
                        break;
                    }
                    case 29: {
                        this.cxml_ADD_ATTRIBUTE(argv);
                        break;
                    }
                    case 27: {
                        this.cxml_ADD_CHILD(argv);
                        break;
                    }
                    case 30: {
                        this.cxml_ADD_COMMENT(argv);
                        break;
                    }
                    case 31: {
                        this.cxml_APPEND_COMMENT(argv);
                        break;
                    }
                    case 32: {
                        this.cxml_DELETE_ATTRIBUTE(argv);
                        break;
                    }
                    case 33: {
                        this.cxml_DELETE_ELEMENT(argv);
                        break;
                    }
                    case 34: {
                        this.cxml_DELETE_COMMENT(argv);
                        break;
                    }
                    case 28: {
                        this.cxml_ADD_SIBLING(argv);
                        break;
                    }
                    case 35: {
                        this.cxml_WRITE_FILE(argv);
                        break;
                    }
                    case 39: {
                        this.cxml_GET_VERSION(argv);
                        break;
                    }
                    case 40: {
                        this.cxml_SET_VERSION(argv);
                        break;
                    }
                    case 41: {
                        this.cxml_GET_ENCODING(argv);
                        break;
                    }
                    case 42: {
                        this.cxml_SET_ENCODING(argv);
                        break;
                    }
                    case 43: {
                        this.cxml_GET_STANDALONE(argv);
                        break;
                    }
                    case 44: {
                        this.cxml_SET_STANDALONE(argv);
                        break;
                    }
                    case 38: {
                        this.cxml_SET_PROC_INSTR(argv);
                        break;
                    }
                    case 37: {
                        this.cxml_GET_PROC_INSTR(argv);
                        break;
                    }
                    case 36: {
                        this.cxml_GET_PROC_INSTR_COUNT(argv);
                        break;
                    }
                    case 48: {
                        this.cxml_WRITE_STRING(argv);
                        break;
                    }
                    default: {
                        this.RESULT.set(CobolNum.noo(0L, 0), false, false);
                        this.last_error = 4;
                        break;
                    }
                }
            }
            catch (Exception _ex) {
                if (log != null) {
                    log.info("C$XML exception occurs _ex[" + _ex.getMessage() + "]");
                    StringWriter sw = new StringWriter();
                    _ex.printStackTrace(new PrintWriter(sw));
                    String exTraceString = sw.toString();
                    log.info("C$XML exception trace[" + exTraceString + "] last_error = " + this.last_error);
                }
                this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            }
        }
        if (log != null) {
            log.info("C$XML returning main[" + this.RESULT + "]");
        }
        return this.RESULT;
    }

    public void cxml_PARSE_FILE(CobolVar[] argv) throws Exception {
        if (argv.length != 2) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.node = this.parseStream(argv[1].toString().trim());
        if (this.node != null) {
            this.HANDLE.setId(this.node);
            this.HANDLE.moveTo(this.RESULT);
        } else {
            this.last_error = 3;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    public void cxml_RELEASE_PARSER(CobolVar[] argv) throws Exception {
        if (argv.length != 2) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        UserHandles.free(argv[1].toint());
    }

    public void cxml_GET_FIRST_CHILD(CobolVar[] argv) throws Exception {
        if (argv.length != 2) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        this.node = this.getFirstChild(this.HANDLE_VAR);
        if (this.node != null) {
            this.HANDLE.setId(this.node);
            this.HANDLE.moveTo(this.RESULT);
        } else {
            this.last_error = 10;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    public void cxml_GET_NEXT_SIBLING(CobolVar[] argv) throws Exception {
        if (argv.length != 2) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        this.node = this.getNextSibling(this.HANDLE_VAR);
        if (this.node != null) {
            this.HANDLE.setId(this.node);
            this.HANDLE.moveTo(this.RESULT);
        } else {
            this.last_error = 11;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    public void cxml_GET_PARENT(CobolVar[] argv) throws Exception {
        if (argv.length != 2) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        try {
            this.node = this.getId(argv[1]) instanceof BufferedReader ? (Node)this.HANDLE_READER.getId() : (Node)((Object)argv[1]);
            if (this.node != null) {
                this.HANDLE.setId(this.node.getParentNode());
                this.HANDLE.moveTo(this.RESULT);
            } else {
                this.RESULT.set(CobolNum.noo(0L, 0), false, false);
                this.last_error = 12;
            }
        }
        catch (Exception _ex) {
            this.HANDLE_VAR = argv[1];
            Element elem = (Element)this.getId(this.HANDLE_VAR);
            this.HANDLE.setId(elem.getParentNode());
            this.HANDLE.moveTo(this.RESULT);
        }
    }

    public void cxml_GET_LAST_ERROR(CobolVar[] argv) throws Exception {
        if (argv.length != 2) {
            this.last_error_to_return = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        if (this.last_error != 0 && this.last_error != 99999) {
            this.last_error_to_return = this.last_error;
        }
        argv[1].setValue(new PicX((String)errDesc.get(new Integer(this.last_error_to_return))));
    }

    public void cxml_OPEN_FILE(CobolVar[] argv) throws Exception {
        if (argv.length != 2) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        BufferedReader fileSeq = new BufferedReader(new FileReader(argv[1].toString().trim()));
        this.HANDLE.setId(fileSeq);
        this.HANDLE.moveTo(this.RESULT);
    }

    public void cxml_PARSE_STRING(CobolVar[] argv) throws Exception {
        if (argv.length != 2) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.node = this.parseString(argv[1].toString());
        if (this.node != null) {
            this.HANDLE.setId(this.node);
            this.HANDLE.moveTo(this.RESULT);
        } else {
            this.last_error = 3;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    public void cxml_PARSE_NEXT_RECORD(CobolVar[] argv) throws Exception {
        if (argv.length != 2) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        if (!(this.getId(argv[1]) instanceof BufferedReader)) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        BufferedReader fileSeq = (BufferedReader)this.getId(argv[1]);
        String record = fileSeq.readLine();
        String line = fileSeq.readLine();
        while (line != null) {
            record = record + "\n" + line;
            line = fileSeq.readLine();
        }
        this.node = this.parseString(record);
        if (this.node != null) {
            this.HANDLE.setId(this.node);
            this.HANDLE.moveTo(this.RESULT);
            this.HANDLE_READER.setId(this.node);
            this.HANDLE_READER.moveTo(this.RESULT);
        } else {
            this.last_error = 3;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    public void cxml_GET_PREV_SIBLING(CobolVar[] argv) throws Exception {
        if (argv.length != 2) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        this.node = this.getPrevSibling(this.HANDLE_VAR);
        if (this.node != null) {
            this.HANDLE.setId(this.node);
            this.HANDLE.moveTo(this.RESULT);
        } else {
            this.last_error = 11;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    public void cxml_NEW_PARSER(CobolVar[] argv) throws Exception {
        if (argv.length != 1) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        DocumentBuilderFactory docFact = RtsUtil.newDocumentBuilderFactory();
        DocumentBuilder docBuilder = docFact.newDocumentBuilder();
        this.doc = docBuilder.newDocument();
        if (this.doc != null) {
            this.HANDLE.setId(this.doc);
            this.HANDLE.moveTo(this.RESULT);
        } else {
            this.last_error = 3;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    public void cxml_GET_ATTRIBUTE_BY_NAME(CobolVar[] argv) throws Exception {
        if (argv.length < 5 || argv.length > 8) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        if (argv[3].toint() != 0 && argv[3].toint() != 1) {
            if (log != null) {
                log.info("C$XML CXML_GET_ATTRIBUTE_BY_NAME REGEXP flag not supported[" + argv[3].toint() + "]");
            }
            this.last_error = 15;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        this.node = this.getAttributeByName(argv);
        if (this.node != null) {
            this.HANDLE.setId(this.node);
            this.HANDLE.moveTo(this.RESULT);
        } else {
            this.last_error = 14;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    public void cxml_GET_CHILD_BY_NAME(CobolVar[] argv) throws Exception {
        if (argv.length != 3 && argv.length != 4) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        if (argv.length > 3 && argv[3].toint() != 0 && argv[3].toint() != 1) {
            if (log != null) {
                log.info("C$XML CXML_GET_CHILD_BY_NAME REGEXP flag not supported[" + argv[3].toint() + "]");
            }
            this.last_error = 15;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        this.node = argv.length > 3 ? this.getChildByName(this.HANDLE_VAR, this.getXmlValue(argv[2]), argv[3].toint()) : this.getChildByName(this.HANDLE_VAR, this.getXmlValue(argv[2]), 0);
        if (this.node != null) {
            this.HANDLE.setId(this.node);
            this.HANDLE.moveTo(this.RESULT);
        } else {
            this.last_error = 10;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    public void cxml_GET_CHILD_BY_CDATA(CobolVar[] argv) throws Exception {
        if (argv.length != 3 && argv.length != 4) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        if (argv.length > 3 && argv[3].toint() != 0 && argv[3].toint() != 1) {
            if (log != null) {
                log.info("C$XML CXML_GET_CHILD_BY_CDATA REGEXP flag not supported[" + argv[3].toint() + "]");
            }
            this.last_error = 15;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.node = argv.length > 3 ? this.getChildByCData(this.HANDLE_VAR, this.getXmlValue(argv[2]), argv[3].toint()) : this.getChildByCData(this.HANDLE_VAR, this.getXmlValue(argv[2]), 0);
        if (this.node != null) {
            this.HANDLE.setId(this.node);
            this.HANDLE.moveTo(this.RESULT);
        } else {
            this.last_error = 10;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    public void cxml_GET_CHILD_BY_ATTR_NAME(CobolVar[] argv) throws Exception {
        if (argv.length != 3 && argv.length != 4) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        if (argv.length > 3 && argv[3].toint() != 0 && argv[3].toint() != 1) {
            if (log != null) {
                log.info("C$XML CXML_GET_CHILD_BY_ATTR_NAME REGEXP flag not supported[" + argv[3].toint() + "]");
            }
            this.last_error = 15;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        this.node = argv.length > 3 ? this.getChildByAttrName(this.HANDLE_VAR, this.getXmlValue(argv[2]), argv[3].toint()) : this.getChildByAttrName(this.HANDLE_VAR, this.getXmlValue(argv[2]), 0);
        if (this.node != null) {
            this.HANDLE.setId(this.node);
            this.HANDLE.moveTo(this.RESULT);
        } else {
            this.last_error = 10;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    public void cxml_GET_CHILD_BY_ATTR_VALUE(CobolVar[] argv) throws Exception {
        if (argv.length != 3 && argv.length != 4) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        if (argv.length > 3 && argv[3].toint() != 0 && argv[3].toint() != 1) {
            if (log != null) {
                log.info("C$XML CXML_GET_CHILD_BY_ATTR_VALUE REGEXP flag not supported[" + argv[3].toint() + "]");
            }
            this.last_error = 15;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        this.node = argv.length > 3 ? this.getChildByAttrValue(this.HANDLE_VAR, this.getXmlValue(argv[2]), argv[3].toint()) : this.getChildByAttrValue(this.HANDLE_VAR, this.getXmlValue(argv[2]), 0);
        if (this.node != null) {
            this.HANDLE.setId(this.node);
            this.HANDLE.moveTo(this.RESULT);
        } else {
            this.last_error = 10;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    public void cxml_GET_SIBLING_BY_NAME(CobolVar[] argv) throws Exception {
        if (argv.length != 3 && argv.length != 4) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        if (argv.length > 3 && argv[3].toint() != 0 && argv[3].toint() != 1) {
            if (log != null) {
                log.info("C$XML CXML_GET_SIBLING_BY_NAME REGEXP flag not supported[" + argv[3].toint() + "]");
            }
            this.last_error = 15;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        this.node = argv.length > 3 ? this.getSiblingByName(this.HANDLE_VAR, this.getXmlValue(argv[2]), argv[3].toint()) : this.getSiblingByName(this.HANDLE_VAR, this.getXmlValue(argv[2]), 0);
        if (this.node != null) {
            this.HANDLE.setId(this.node);
            this.HANDLE.moveTo(this.RESULT);
        } else {
            this.last_error = 11;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    public void cxml_GET_SIBLING_BY_CDATA(CobolVar[] argv) throws Exception {
        if (argv.length != 3 && argv.length != 4) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        if (argv.length > 3 && argv[3].toint() != 0 && argv[3].toint() != 1) {
            if (log != null) {
                log.info("C$XML CXML_GET_SIBLING_BY_CDATA REGEXP flag not supported[" + argv[3].toint() + "]");
            }
            this.last_error = 15;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        this.node = argv.length > 3 ? this.getSiblingByCData(this.HANDLE_VAR, this.getXmlValue(argv[2]), argv[3].toint()) : this.getSiblingByCData(this.HANDLE_VAR, this.getXmlValue(argv[2]), 0);
        if (this.node != null) {
            this.HANDLE.setId(this.node);
            this.HANDLE.moveTo(this.RESULT);
        } else {
            this.last_error = 11;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    public void cxml_GET_SIBLING_BY_ATTR_NAME(CobolVar[] argv) throws Exception {
        if (argv.length != 3 && argv.length != 4) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        if (argv.length > 3 && argv[3].toint() != 0 && argv[3].toint() != 1) {
            if (log != null) {
                log.info("C$XML CXML_GET_SIBLING_BY_ATTR_NAME REGEXP flag not supported[" + argv[3].toint() + "]");
            }
            this.last_error = 15;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        this.node = argv.length > 3 ? this.getSiblingByAttrName(this.HANDLE_VAR, this.getXmlValue(argv[2]), argv[3].toint()) : this.getSiblingByAttrName(this.HANDLE_VAR, this.getXmlValue(argv[2]), 0);
        if (this.node != null) {
            this.HANDLE.setId(this.node);
            this.HANDLE.moveTo(this.RESULT);
        } else {
            this.last_error = 11;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    public void cxml_GET_SIBLING_BY_ATTR_VALUE(CobolVar[] argv) throws Exception {
        if (argv.length != 3 && argv.length != 4) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        this.node = argv.length > 3 ? this.getSiblingByAttrValue(this.HANDLE_VAR, this.getXmlValue(argv[2]), argv[3].toint()) : this.getSiblingByAttrValue(this.HANDLE_VAR, this.getXmlValue(argv[2]), 0);
        if (this.node != null) {
            this.HANDLE.setId(this.node);
            this.HANDLE.moveTo(this.RESULT);
        } else {
            this.last_error = 11;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    public void cxml_GET_COMMENT(CobolVar[] argv) throws Exception {
        if (argv.length != 3 && argv.length != 4) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        if (this.getId(argv[1]) instanceof BufferedReader && this.getComment(argv)) {
            this.RESULT.set(CobolNum.noo(1L, 0), false, false);
        } else if (this.getId(argv[1]) instanceof Node && this.getComment(argv)) {
            this.RESULT.set(CobolNum.noo(1L, 0), false, false);
        } else {
            this.last_error = 11;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    public void cxml_ADD_ATTRIBUTE(CobolVar[] argv) throws Exception {
        if (argv.length < 3 || argv.length > 5) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        Attr attr = null;
        if (this.getId(this.HANDLE_VAR) instanceof Node) {
            if (log != null) {
                log.info("C$XML CXML_ADD_ATTRIBUTE handle of element");
            }
            Element elem = (Element)this.getId(this.HANDLE_VAR);
            attr = elem.getOwnerDocument().createAttribute(this.getXmlValue(argv[2]));
            if (argv.length > 3) {
                attr.setValue(this.getXmlValue(argv[3]));
            }
            elem.setAttributeNode(attr);
        } else if (this.getId(argv[1]) instanceof BufferedReader) {
            Element elem = (Element)this.getId(this.HANDLE_READER);
            attr = elem.getOwnerDocument().createAttribute(this.getXmlValue(argv[2]));
            if (argv.length > 3) {
                attr.setValue(this.getXmlValue(argv[3]));
            }
            elem.setAttributeNode(attr);
        } else {
            this.last_error = 5;
        }
        if (attr != null) {
            this.HANDLE.setId(attr);
            this.HANDLE.moveTo(this.RESULT);
        } else {
            this.last_error = 14;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    public void cxml_ADD_CHILD(CobolVar[] argv) throws Exception {
        if (argv.length < 3 || argv.length > 5) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        if (this.getId(this.HANDLE_VAR) instanceof Document) {
            if (log != null) {
                log.info("C$XML CXML_ADD_CHILD handle of Document");
            }
            this.doc = (Document)this.getId(this.HANDLE_VAR);
            this.node = this.doc.createElement(this.getXmlValue(argv[2]));
            if (argv.length > 3) {
                this.node.appendChild(this.doc.createTextNode(this.getXmlValue(argv[3])));
            }
            this.doc.appendChild((Element)this.node);
        } else if (this.getId(this.HANDLE_VAR) instanceof Node) {
            if (log != null) {
                log.info("C$XML CXML_ADD_CHILD handle of Node");
            }
            Node inpNode = (Node)this.getId(this.HANDLE_VAR);
            this.doc = inpNode.getOwnerDocument();
            this.node = this.doc.createElement(this.getXmlValue(argv[2]));
            if (argv.length > 3) {
                this.node.appendChild(this.doc.createTextNode(this.getXmlValue(argv[3])));
            }
            inpNode.appendChild((Element)this.node);
        } else {
            this.last_error = 5;
        }
        if (this.node != null) {
            this.HANDLE.setId(this.node);
            this.HANDLE.moveTo(this.RESULT);
        } else {
            this.last_error = 11;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    public void cxml_ADD_COMMENT(CobolVar[] argv) throws Exception {
        if (argv.length < 3 || argv.length > 4) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        if (this.getId(this.HANDLE_VAR) instanceof Document) {
            this.doc = (Document)this.getId(this.HANDLE_VAR);
            this.comm = this.doc.createComment(argv[2].toString().trim());
            Element elem = this.doc.getDocumentElement();
            if (elem != null) {
                elem.getParentNode().insertBefore(this.comm, elem);
            } else {
                this.doc.appendChild(this.comm);
            }
        } else {
            this.last_error = 5;
        }
        if (this.comm != null) {
            this.RESULT.set(CobolNum.noo(1L, 0), false, false);
        } else {
            this.last_error = 11;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    public void cxml_APPEND_COMMENT(CobolVar[] argv) throws Exception {
        if (argv.length < 3 || argv.length > 4) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        if (this.getId(this.HANDLE_VAR) instanceof Element) {
            Element elem = (Element)this.getId(this.HANDLE_VAR);
            if (elem != null) {
                this.comm = elem.getOwnerDocument().createComment(argv[2].toString().trim());
                elem.getParentNode().insertBefore(this.comm, elem);
            } else {
                this.last_error = 5;
            }
        } else {
            this.last_error = 5;
        }
        this.setError(11);
    }

    public void cxml_DELETE_ATTRIBUTE(CobolVar[] argv) throws Exception {
        if (argv.length != 3) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        if (this.getId(this.HANDLE_VAR) instanceof Element) {
            this.node = (Node)this.getId(argv[1]);
            NamedNodeMap attrs = this.node.getAttributes();
            int attrNum = argv[2].toint();
            if (attrs != null && attrs.getLength() < attrNum) {
                this.last_error = -1;
                this.RESULT.set(CobolNum.noo(0L, 0), false, false);
                return;
            }
            attrs.removeNamedItem(attrs.item(attrNum).getNodeName());
        } else {
            this.last_error = 5;
        }
        this.setError(11);
    }

    public void cxml_DELETE_ELEMENT(CobolVar[] argv) throws Exception {
        if (argv.length != 2) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        if (this.getId(this.HANDLE_VAR) instanceof Element) {
            this.node = (Node)this.getId(argv[1]);
            if (this.node.getParentNode() != null) {
                this.node.getParentNode().removeChild(this.node);
            } else {
                this.node.getOwnerDocument().removeChild(this.node);
            }
        } else {
            this.last_error = -1;
        }
        this.setError(11);
    }

    public void cxml_DELETE_COMMENT(CobolVar[] argv) throws Exception {
        if (argv.length != 2) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        if (this.getId(this.HANDLE_VAR) instanceof Element) {
            this.node = (Node)this.getId(argv[1]);
            if (this.node.getParentNode() != null) {
                this.node.getParentNode().removeChild(this.node);
            } else {
                this.node.getOwnerDocument().removeChild(this.node);
            }
        } else {
            this.last_error = -1;
        }
        this.setError(11);
    }

    public void cxml_ADD_SIBLING(CobolVar[] argv) throws Exception {
        if (argv.length < 3 || argv.length > 5) {
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        Element newNode = null;
        if (this.getId(this.HANDLE_VAR) instanceof Element) {
            this.node = (Element)this.getId(this.HANDLE_VAR);
            newNode = this.node.getOwnerDocument().createElement(this.getXmlValue(argv[2]));
            if (argv.length > 3) {
                newNode.appendChild(this.node.getOwnerDocument().createTextNode(this.getXmlValue(argv[3])));
            }
            this.node.getParentNode().appendChild(newNode);
        } else {
            this.last_error = 5;
        }
        if (newNode != null) {
            this.HANDLE.setId(newNode);
            this.HANDLE.moveTo(this.RESULT);
        } else {
            this.last_error = 11;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    public void cxml_WRITE_FILE(CobolVar[] argv) throws Exception {
        if (argv.length != 3) {
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        if (this.getId(this.HANDLE_VAR) instanceof Document) {
            this.doc = (Document)this.getId(this.HANDLE_VAR);
        } else if (this.getId(this.HANDLE_VAR) instanceof Node) {
            this.node = (Node)this.getId(this.HANDLE_VAR);
            this.doc = this.node.getOwnerDocument();
        } else if (this.getId(this.HANDLE_VAR) instanceof BufferedReader) {
            this.node = (Node)this.getId(this.HANDLE_READER);
            this.doc = this.node.getOwnerDocument();
        } else {
            this.last_error = 5;
        }
        if (this.last_error == 99999) {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(this.doc);
            StreamResult result = new StreamResult(new File(argv[2].toString().trim()));
            if (INDENT > -1) {
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("doctype-public", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(INDENT));
            }
            if (stand.get(this.doc) != null) {
                if (((String)stand.get(this.doc)).equals("yes")) {
                    transformer.setOutputProperty("standalone", "yes");
                    this.doc.setXmlStandalone(true);
                } else if (((String)stand.get(this.doc)).equals("no")) {
                    transformer.setOutputProperty("standalone", "yes");
                    this.doc.setXmlStandalone(false);
                }
                stand.remove(this.doc);
            }
            if (this.procs.get(this.doc) != null) {
                this.node = this.doc.getDocumentElement();
                this.procInstr = (Vector)this.procs.get(this.doc);
                for (int i = 0; i < this.procInstr.size(); ++i) {
                    if ((ProcessingInstruction)this.procInstr.elementAt(i) == null) continue;
                    this.doc.insertBefore((ProcessingInstruction)this.procInstr.elementAt(i), this.node);
                }
                this.procInstr.clear();
                this.procs.remove(this.doc);
            }
            if (this.encoding.get(this.doc) != null) {
                transformer.setOutputProperty("encoding", (String)this.encoding.get(this.doc));
                this.encoding.remove(this.doc);
            }
            transformer.transform(source, result);
        }
        this.setError(5);
    }

    public void cxml_GET_VERSION(CobolVar[] argv) throws Exception {
        if (argv.length != 3) {
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        if (this.getId(this.HANDLE_VAR) instanceof Document) {
            this.doc = (Document)this.getId(this.HANDLE_VAR);
            this.HANDLE_VAR = argv[2];
            this.HANDLE_VAR.set(this.doc.getXmlVersion());
        } else {
            this.last_error = 5;
        }
        this.setError(9);
    }

    public void cxml_SET_VERSION(CobolVar[] argv) throws Exception {
        if (argv.length != 3) {
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        if (this.getId(this.HANDLE_VAR) instanceof Document) {
            this.doc = (Document)this.getId(this.HANDLE_VAR);
            this.doc.setXmlVersion(argv[2].toString().trim());
        } else {
            this.last_error = 5;
        }
        this.setError(9);
    }

    public void cxml_GET_ENCODING(CobolVar[] argv) throws Exception {
        if (argv.length != 3) {
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        if (this.getId(this.HANDLE_VAR) instanceof Document) {
            Document doc1 = (Document)this.getId(this.HANDLE_VAR);
            this.HANDLE_VAR = argv[2];
            this.HANDLE_VAR.set(doc1.getXmlEncoding());
        } else {
            this.last_error = 5;
        }
        this.setError(9);
    }

    public void cxml_SET_ENCODING(CobolVar[] argv) throws Exception {
        if (argv.length != 3) {
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        if (this.getId(this.HANDLE_VAR) instanceof Document) {
            Document doc1 = (Document)this.getId(this.HANDLE_VAR);
            String encodStr = argv[2].toString().trim().toUpperCase();
            if (this.encoding.get(doc1) != null) {
                this.encoding.remove(doc1);
            }
            this.encoding.put(doc1, encodStr);
        } else {
            this.last_error = 5;
        }
        this.setError(9);
    }

    public void cxml_GET_STANDALONE(CobolVar[] argv) throws Exception {
        if (argv.length != 3) {
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        if (this.getId(this.HANDLE_VAR) instanceof Document) {
            this.doc = (Document)this.getId(this.HANDLE_VAR);
            this.HANDLE_VAR = argv[2];
            if (this.doc.getXmlStandalone()) {
                this.HANDLE_VAR.set("yes");
            } else {
                this.HANDLE_VAR.set("no");
            }
        } else {
            this.last_error = 5;
        }
        this.setError(0);
    }

    public void cxml_SET_STANDALONE(CobolVar[] argv) throws Exception {
        if (argv.length != 3) {
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        if (this.getId(this.HANDLE_VAR) instanceof Document) {
            this.doc = (Document)this.getId(this.HANDLE_VAR);
            if (stand.get(this.doc) != null) {
                stand.remove(this.doc);
            }
            if (argv[2].toString().trim().equalsIgnoreCase("yes")) {
                stand.put(this.doc, "yes");
            } else if (argv[2].toString().trim().equalsIgnoreCase("no")) {
                stand.put(this.doc, "no");
            } else {
                stand.put(this.doc, "-");
            }
        } else {
            this.last_error = 5;
        }
        this.setError(9);
    }

    public void cxml_SET_PROC_INSTR(CobolVar[] argv) throws Exception {
        if (argv.length != 3 && argv.length != 5) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        int idx = argv[2].toint();
        if (this.getId(this.HANDLE_VAR) instanceof Document) {
            this.doc = (Document)this.getId(this.HANDLE_VAR);
        } else {
            this.node = (Node)this.getId(this.HANDLE_VAR);
            this.doc = this.node.getOwnerDocument();
        }
        this.procInstr = (Vector)this.procs.get(this.doc);
        if (this.procInstr == null) {
            this.procInstr = new Vector();
            this.procs.put(this.doc, this.procInstr);
        }
        if (argv.length == 3 || argv[3].toString().trim().equals("")) {
            if (this.procInstr.size() < idx) {
                this.last_error = 17;
                this.RESULT.set(CobolNum.noo(0L, 0), false, false);
                return;
            }
            this.procInstr.removeElementAt(idx - 1);
        } else {
            ProcessingInstruction pi = this.doc.createProcessingInstruction(argv[3].toString().trim(), argv[4].toString().trim());
            while (this.procInstr.size() < idx) {
                this.procInstr.add(null);
            }
            this.procInstr.add(idx - 1, pi);
        }
    }

    public void cxml_GET_PROC_INSTR(CobolVar[] argv) throws Exception {
        if (argv.length != 5) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        int idx = argv[2].toint();
        this.node = (Node)this.getId(this.HANDLE_VAR);
        this.doc = this.node.getOwnerDocument();
        this.procInstr = (Vector)this.procs.get(this.doc);
        if (this.procInstr == null || this.procInstr.size() < idx || this.procInstr.elementAt(idx - 1) == null) {
            this.last_error = 17;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        ProcessingInstruction pi = (ProcessingInstruction)this.procInstr.elementAt(--idx);
        argv[3].setValue(new PicX(pi.getTarget()));
        argv[4].setValue(new PicX(pi.getData()));
    }

    public void cxml_GET_PROC_INSTR_COUNT(CobolVar[] argv) throws Exception {
        if (argv.length != 2) {
            this.last_error = -1;
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        this.node = (Node)this.getId(this.HANDLE_VAR);
        this.doc = this.node.getOwnerDocument();
        this.procInstr = (Vector)this.procs.get(this.doc);
        if (this.procInstr == null) {
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        } else {
            this.RESULT.set(CobolNum.noo(this.procInstr.size(), 0), false, false);
        }
    }

    public void setError(int err) throws Exception {
        if (this.last_error == 99999) {
            this.RESULT.set(CobolNum.noo(1L, 0), false, false);
        } else {
            this.last_error = err;
            if (err != 0) {
                this.last_error_to_return = err;
            }
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
        }
    }

    @Override
    public void finalize() {
    }

    @Override
    public void perform(int begin, int end) {
    }

    public Node parseStream(String xmlFileName) throws Exception {
        int i;
        this.last_error = 3;
        this.factory.setCoalescing(true);
        this.builder = this.factory.newDocumentBuilder();
        try {
            this.doc = this.builder.parse(new File(xmlFileName));
        }
        catch (Exception _ex) {
            if (log != null) {
                log.info("C$XML ignore dtd! ");
            }
            this.factory.setCoalescing(true);
            this.factory.setValidating(false);
            this.factory.setNamespaceAware(true);
            this.factory.setFeature("http://xml.org/sax/features/namespaces", false);
            this.factory.setFeature("http://xml.org/sax/features/validation", false);
            this.factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            this.factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            this.builder = this.factory.newDocumentBuilder();
            this.doc = this.builder.parse(new File(xmlFileName));
        }
        this.doc.getDocumentElement().normalize();
        Element root = this.doc.getDocumentElement();
        Node node = null;
        NodeList nodeL = this.doc.getChildNodes();
        if (nodeL != null) {
            for (i = 0; i < nodeL.getLength(); ++i) {
                node = nodeL.item(i);
                if (!(node instanceof ProcessingInstruction)) continue;
                if (this.procs.get(this.doc) == null) {
                    this.procInstr = new Vector();
                    this.procs.put(this.doc, this.procInstr);
                }
                this.procInstr.add(node);
            }
        }
        if (log != null) {
            log.info("C$XML Root: " + root.getNodeName() + "[" + this.doc + "]");
            try {
                nodeL = this.doc.getChildNodes();
                if (nodeL != null) {
                    for (i = 0; i < nodeL.getLength(); ++i) {
                        node = nodeL.item(i);
                        log.info("C$XML    node: " + node.getNodeName() + " node value [" + node.getNodeValue() + "]" + node.getLocalName() + " getTextContent()[" + node.getTextContent() + "]");
                    }
                }
                root = this.doc.getDocumentElement();
                for (i = 0; root != null && i < root.getChildNodes().getLength(); ++i) {
                    node = root.getChildNodes().item(i);
                    log.info("C$XML    node: " + node.getNodeName() + " node value [" + node.getNodeValue() + "]" + node.getLocalName() + " getTextContent()[" + node.getTextContent() + "]");
                    if (node != null && node.hasAttributes() && node.getChildNodes().getLength() == 0) {
                        for (int k = 0; k < node.getAttributes().getLength(); ++k) {
                            Node attribute = node.getAttributes().item(k);
                            log.info("C$XML             attribute name: " + attribute.getNodeName() + " - attribute value = " + attribute.getNodeValue());
                        }
                        continue;
                    }
                    if (node == null) continue;
                    for (int j = 0; j < node.getChildNodes().getLength(); ++j) {
                        Node element = node.getChildNodes().item(j);
                        if (element.getNodeType() != 1) continue;
                        log.info("C$XML    element name: " + element.getNodeName() + " - element value = " + element.getNodeValue());
                        if (!element.hasAttributes()) continue;
                        for (int k = 0; k < element.getAttributes().getLength(); ++k) {
                            Node attribute = element.getAttributes().item(k);
                            log.info("C$XML               attribute name: " + attribute.getNodeName() + " - attribute value = " + attribute.getNodeValue());
                        }
                    }
                }
            }
            catch (Exception _ex) {
                log.info("C$XML exception" + _ex);
            }
            log.info("C$XML returning aaaa" + this.doc + root);
        }
        if (root != null) {
            this.last_error = 99999;
        }
        return root;
    }

    public Node getFirstChild(CobolVar handle) throws Exception {
        Node firstChild = null;
        this.last_error = 99999;
        if (this.getId(handle) instanceof Node) {
            firstChild = ((Node)this.getId(handle)).getFirstChild();
        } else if (this.getId(handle) instanceof BufferedReader) {
            firstChild = ((Node)this.getId(this.HANDLE_READER)).getFirstChild();
        } else {
            this.last_error = 5;
        }
        if (firstChild != null && (firstChild.getNodeName().equalsIgnoreCase("#text") || firstChild.getNodeName().equalsIgnoreCase("#cdata-section") || firstChild.getNodeName().equalsIgnoreCase("#comment") || firstChild.getNodeName().equalsIgnoreCase("#document") || firstChild.getNodeName().equalsIgnoreCase("#document-fragment"))) {
            ObjectVar intHandle = Factory.getVarObject(new byte[4], 0, 4, false, null, null, null, "intHandle", false, 0, 0, false, false, false);
            intHandle.setId(firstChild);
            firstChild = this.getNextSibling(intHandle);
            intHandle.free();
        }
        if (log != null) {
            if (firstChild != null) {
                log.info("C$XML     handle: " + handle.getClass().getName() + " - node name = " + firstChild.getNodeName());
            } else {
                log.info("C$XML     handle: " + handle.getClass().getName() + " - node name = null");
            }
        }
        return firstChild;
    }

    public Node getNextSibling(CobolVar handle) throws Exception {
        Node nextSibling = null;
        this.last_error = 99999;
        if (this.getId(handle) instanceof Node) {
            nextSibling = ((Node)this.getId(handle)).getNextSibling();
        } else if (this.getId(handle) instanceof BufferedReader) {
            nextSibling = ((Node)this.getId(this.HANDLE_READER)).getNextSibling();
        } else if (nextSibling == null) {
            log.info("getNextSibling hanldle not node");
        }
        if (log != null) {
            if (nextSibling == null) {
                log.info("getNextSibling nextSibling null" + this.getId(handle));
            } else {
                log.info("C$XML    getNextSibling node: " + nextSibling.getNodeName() + " node value [" + nextSibling.getNodeValue() + "]" + nextSibling.getLocalName() + " getTextContent()[" + nextSibling.getTextContent() + "]");
            }
        }
        while (nextSibling != null && (nextSibling.getNodeName().equalsIgnoreCase("#text") || nextSibling.getNodeName().equalsIgnoreCase("#cdata-section") || nextSibling.getNodeName().equalsIgnoreCase("#comment") || nextSibling.getNodeName().equalsIgnoreCase("#document") || nextSibling.getNodeName().equalsIgnoreCase("#document-fragment"))) {
            nextSibling = nextSibling.getNextSibling();
        }
        if (log != null) {
            if (nextSibling != null) {
                log.info("C$XML     handle: " + handle.getClass().getName() + " - node name = " + nextSibling.getNodeName());
            } else {
                log.info("C$XML     handle: " + handle.getClass().getName() + " - node name = null");
            }
        }
        return nextSibling;
    }

    public Node getNextSibling(Node sibling) throws Exception {
        ObjectVar intHandle = Factory.getVarObject(new byte[4], 0, 4, false, null, null, null, "intHandle", false, 0, 0, false, false, false);
        intHandle.setId(sibling);
        Node Return2 = this.getNextSibling(intHandle);
        intHandle.free();
        return Return2;
    }

    public int cxml_GET_DATA(CobolVar[] argv) throws Exception {
        int Return2 = 1;
        int valueLen = 0;
        this.last_error = 99999;
        Node node = null;
        if (this.getId(argv[1]) instanceof Node) {
            node = (Node)this.getId(argv[1]);
        } else if (this.getId(argv[1]) instanceof BufferedReader) {
            node = (Node)this.HANDLE.getId();
        } else {
            Return2 = 0;
            this.last_error = 6;
            argv[2].setValue(new PicX("" + this.getId(argv[1])));
            return Return2;
        }
        if (node.getNodeName() != null) {
            argv[2].setValue(new PicX(node.getNodeName().trim()));
        }
        if (node.getNodeValue() != null) {
            argv[3].setValue(new PicX(node.getNodeValue().trim()));
            valueLen = node.getNodeValue().trim().length();
        } else if (node instanceof Element) {
            argv[3].setValue(new PicX(" "));
            if (node.hasChildNodes()) {
                NodeList nl = node.getChildNodes();
                int l = nl.getLength();
                String tmp = "";
                for (int i = 0; i < l; ++i) {
                    if (nl.item(i).getNodeName().equalsIgnoreCase("#comment") || nl.item(i).getNodeValue() == null) continue;
                    tmp = tmp + nl.item(i).getNodeValue();
                }
                valueLen = tmp.trim().length();
                argv[3].setValue(new PicX(tmp.trim()));
            }
        }
        if (argv.length == 5) {
            argv[4].set(CobolNum.noo(valueLen));
        }
        if (log != null) {
            if (node != null) {
                log.info("C$XML      - node name = " + node.getNodeName() + " - node value = " + node.getNodeValue() + " - node value length = " + valueLen);
            } else {
                log.info("C$XML       - node name = null");
            }
        }
        return Return2;
    }

    public int cxml_GET_ATTRIBUTE_COUNT(CobolVar handle) throws Exception {
        int numAttr = 0;
        this.last_error = 99999;
        if (this.getId(handle) instanceof Document) {
            numAttr = ((Document)this.getId(handle)).hasAttributes() ? ((Document)this.getId(handle)).getAttributes().getLength() : 0;
        } else if (this.getId(handle) instanceof Node) {
            numAttr = ((Node)this.getId(handle)).hasAttributes() ? ((Node)this.getId(handle)).getAttributes().getLength() : 0;
        } else if (this.getId(handle) instanceof BufferedReader) {
            numAttr = ((Node)this.getId(this.HANDLE_READER)).hasAttributes() ? ((Node)this.getId(this.HANDLE_READER)).getAttributes().getLength() : 0;
        } else {
            this.last_error = 5;
        }
        if (log != null) {
            if (this.last_error == 99999) {
                if (this.getId(handle) instanceof Node) {
                    Node node = (Node)this.getId(handle);
                    log.info("C$XML     handle: " + handle.getClass().getName() + " - node name = " + node.getNodeName() + " return [" + numAttr + "]");
                } else if (this.getId(this.HANDLE_READER) instanceof Node) {
                    Node node = (Node)this.getId(this.HANDLE_READER);
                    log.info("C$XML     handle: " + this.HANDLE_READER.getClass().getName() + " - node name = " + node.getNodeName() + " return [" + numAttr + "]");
                } else {
                    Document doc = (Document)this.getId(handle);
                    log.info("C$XML     handle: " + handle.getClass().getName() + " - document name = " + doc.getNodeName() + " return [" + numAttr + "]");
                }
            } else {
                log.info("C$XML     handle: " + handle.getClass().getName() + " - node name = null");
            }
        }
        return numAttr;
    }

    public int cxml_GET_ATTRIBUTE(CobolVar[] argv) throws Exception {
        int numAttr;
        Node attr;
        Node node;
        int Return2;
        block12: {
            Return2 = 1;
            this.last_error = 99999;
            node = null;
            attr = null;
            numAttr = ((NumericVar)argv[2]).integer() - 1;
            if (numAttr < 0) {
                this.last_error = 7;
            } else if (this.getId(argv[1]) instanceof Node || this.getId(argv[1]) instanceof BufferedReader) {
                node = this.getId(argv[1]) instanceof BufferedReader ? (Node)this.HANDLE.getId() : (Node)this.getId(argv[1]);
                try {
                    if (node.hasAttributes() && node.getAttributes().getLength() > numAttr) {
                        attr = node.getAttributes().item(numAttr);
                    }
                    if (attr != null) {
                        argv[3].setValue(new PicX(attr.getNodeName()));
                        argv[4].setValue(new PicX(attr.getNodeValue()));
                        if (argv.length == 6) {
                            argv[5].set(CobolNum.noo(attr.getNodeValue().length()));
                        }
                        break block12;
                    }
                    this.last_error = 7;
                }
                catch (Exception _ex) {
                    this.last_error = 6;
                    Return2 = 0;
                }
            } else {
                Return2 = 0;
                this.last_error = 6;
            }
        }
        if (log != null) {
            if (attr != null) {
                log.info("C$XML      - numAttr[" + numAttr + "] attribute name = " + attr.getNodeName() + " - attr value = " + attr.getNodeValue() + " - attr value length = " + attr.getNodeValue().length());
            } else {
                log.info("C$XML      - node name = " + node.getNodeName() + " - node name = null");
            }
        }
        return Return2;
    }

    private Object getId(CobolVar handle) {
        if (handle instanceof ObjectVar) {
            return ((ObjectVar)handle).getId();
        }
        if (handle instanceof NumericVar) {
            return UserHandles.getId(handle.toint());
        }
        return null;
    }

    private Node parseString(String str) throws Exception {
        this.factory.setCoalescing(true);
        this.factory = RtsUtil.newDocumentBuilderFactory();
        this.builder = this.factory.newDocumentBuilder();
        ByteArrayInputStream stream = new ByteArrayInputStream(str.getBytes());
        Document doc = this.builder.parse(stream);
        doc.getDocumentElement().normalize();
        Element root = doc.getDocumentElement();
        return root;
    }

    public Node getSiblingByName(CobolVar handle, String name, int flag) throws Exception {
        Node nextSibling = null;
        this.last_error = 99999;
        if (this.getId(handle) instanceof Node) {
            nextSibling = this.getNextSibling(handle);
        } else {
            this.last_error = 5;
        }
        if (log != null) {
            if (nextSibling == null) {
                log.info("getSiblingByName nextSibling null");
            } else {
                log.info("C$XML    getSiblingByName node: " + nextSibling.getNodeName() + " node value [" + nextSibling.getNodeValue() + "]" + nextSibling.getLocalName() + " getTextContent()[" + nextSibling.getTextContent() + "]");
            }
        }
        while (nextSibling != null && (flag == 0 && !nextSibling.getNodeName().startsWith(name) || flag == 1 && !nextSibling.getNodeName().toUpperCase().startsWith(name.toUpperCase()))) {
            nextSibling = this.getNextSibling(nextSibling);
            if (log == null) continue;
            log.info("C$XML    in While getSiblingByName node: " + nextSibling.getNodeName() + " node value [" + nextSibling.getNodeValue() + "]" + nextSibling.getLocalName() + " getTextContent()[" + nextSibling.getTextContent() + "]");
        }
        return nextSibling;
    }

    public Node getChildByName(CobolVar handle, String name, int flag) throws Exception {
        Node nextSibling = null;
        this.last_error = 99999;
        if (this.getId(handle) instanceof Node) {
            nextSibling = ((Node)this.getId(handle)).getFirstChild();
        } else if (this.getId(handle) instanceof BufferedReader) {
            nextSibling = ((Node)this.getId(this.HANDLE_READER)).getFirstChild();
        } else {
            this.last_error = 5;
        }
        while (nextSibling != null && (flag == 0 && !nextSibling.getNodeName().startsWith(name) || flag == 1 && !nextSibling.getNodeName().toUpperCase().startsWith(name.toUpperCase()))) {
            nextSibling = this.getNextSibling(nextSibling);
        }
        return nextSibling;
    }

    public Node getSiblingByCData(CobolVar handle, String name, int flag) throws Exception {
        Node nextSibling = null;
        this.last_error = 99999;
        if (this.getId(handle) instanceof Node) {
            nextSibling = this.getNextSibling(handle);
        } else if (this.getId(handle) instanceof BufferedReader) {
            nextSibling = ((Node)this.getId(this.HANDLE_READER)).getFirstChild();
        } else {
            this.last_error = 5;
        }
        while (nextSibling != null && (flag == 0 && !nextSibling.getNodeValue().startsWith(name) || flag == 1 && !nextSibling.getNodeValue().toUpperCase().startsWith(name.toUpperCase()))) {
            nextSibling = this.getNextSibling(nextSibling);
        }
        return nextSibling;
    }

    public Node getSiblingByAttrName(CobolVar handle, String name, int flag) throws Exception {
        Node nextSibling = null;
        Node attr = null;
        this.last_error = 99999;
        if (this.getId(handle) instanceof Node) {
            nextSibling = this.getNextSibling(handle);
        } else if (this.getId(handle) instanceof BufferedReader) {
            nextSibling = ((Node)this.getId(this.HANDLE_READER)).getFirstChild();
        } else {
            this.last_error = 5;
        }
        attr = this.searchAttributeByName(nextSibling, name, null, flag);
        while (nextSibling != null && attr == null) {
            nextSibling = this.getNextSibling(nextSibling);
            attr = this.searchAttributeByName(nextSibling, name, null, flag);
        }
        return nextSibling;
    }

    public Node searchAttributeByName(Node sibling, String name, CobolVar idx, int flag) throws Exception {
        Node attr = null;
        int idxStart = 0;
        int i = 0;
        if (idx != null) {
            idxStart = idx.toint();
        }
        if (sibling.hasAttributes()) {
            for (i = sibling.getAttributes().getLength() - 1; i > idxStart - 1 && attr == null; --i) {
                if (sibling.getAttributes().item(i).getNodeName().startsWith(name)) {
                    attr = sibling.getAttributes().item(i);
                    continue;
                }
                if (flag != 1 || !sibling.getAttributes().item(i).getNodeName().toUpperCase().startsWith(name.toUpperCase())) continue;
                attr = sibling.getAttributes().item(i);
            }
        }
        if (idx != null) {
            idx.set("" + i);
        }
        return attr;
    }

    public Node searchAttributeByValue(Node sibling, String name, int flag) throws Exception {
        Node attr = null;
        if (sibling.hasAttributes()) {
            for (int i = sibling.getAttributes().getLength() - 1; i > -1 && attr == null; --i) {
                if (sibling.getAttributes().item(i).getNodeValue().startsWith(name)) {
                    attr = sibling.getAttributes().item(i);
                    continue;
                }
                if (flag != 1 || !sibling.getAttributes().item(i).getNodeValue().toUpperCase().startsWith(name.toUpperCase())) continue;
                attr = sibling.getAttributes().item(i);
            }
        }
        return attr;
    }

    public Node getSiblingByAttrValue(CobolVar handle, String name, int flag) throws Exception {
        Node nextSibling = null;
        Node attr = null;
        this.last_error = 99999;
        if (this.getId(handle) instanceof Node) {
            nextSibling = this.getNextSibling(handle);
        } else {
            this.last_error = 5;
        }
        attr = this.searchAttributeByValue(nextSibling, name, flag);
        while (nextSibling != null && attr == null) {
            nextSibling = this.getNextSibling(nextSibling);
            attr = this.searchAttributeByValue(nextSibling, name, flag);
        }
        return nextSibling;
    }

    public Node getAttributeByName(CobolVar[] argv) throws Exception {
        Node attr = null;
        this.last_error = 99999;
        if (this.getId(argv[1]) instanceof Node) {
            attr = this.searchAttributeByName((Node)this.getId(argv[1]), this.getXmlValue(argv[2]), argv[4], argv[3].toint());
        } else if (this.getId(argv[1]) instanceof BufferedReader) {
            attr = this.searchAttributeByName((Node)this.getId(this.HANDLE_READER), this.getXmlValue(argv[2]), argv[4], argv[3].toint());
        }
        if (attr != null) {
            if (argv.length > 5) {
                argv[5].setValue(new PicX(attr.getNodeName()));
            }
            if (argv.length > 6) {
                argv[6].setValue(new PicX(attr.getNodeValue()));
            }
            if (argv.length == 8) {
                argv[7].set(CobolNum.noo(attr.getNodeValue().length()));
            }
        } else {
            this.last_error = 5;
        }
        return attr;
    }

    public Node getChildByCData(CobolVar handle, String name, int flag) throws Exception {
        Node nextChild = null;
        this.last_error = 99999;
        if (this.getId(handle) instanceof Node) {
            nextChild = ((Node)this.getId(handle)).getFirstChild();
        } else if (this.getId(handle) instanceof BufferedReader) {
            nextChild = ((Node)this.getId(this.HANDLE_READER)).getFirstChild();
        } else {
            this.last_error = 5;
        }
        while (nextChild != null && (flag == 0 && nextChild.getNodeValue() != null && !nextChild.getNodeValue().startsWith(name) || flag == 1 && nextChild.getNodeValue() != null && !nextChild.getNodeValue().toUpperCase().startsWith(name.toUpperCase()))) {
            nextChild = nextChild.getNextSibling();
        }
        return nextChild;
    }

    public Node getChildByAttrName(CobolVar handle, String name, int flag) throws Exception {
        Node nextChild = null;
        Node attr = null;
        this.last_error = 99999;
        if (this.getId(handle) instanceof Node) {
            nextChild = ((Node)this.getId(handle)).getFirstChild();
        } else if (this.getId(handle) instanceof BufferedReader) {
            nextChild = ((Node)this.getId(this.HANDLE_READER)).getFirstChild();
        } else {
            this.last_error = 5;
        }
        attr = this.searchAttributeByName(nextChild, name, null, flag);
        while (nextChild != null && attr == null) {
            nextChild = this.getNextSibling(nextChild);
            attr = this.searchAttributeByName(nextChild, name, null, flag);
        }
        return nextChild;
    }

    public Node getChildByAttrValue(CobolVar handle, String name, int flag) throws Exception {
        Node nextChild = null;
        Node attr = null;
        this.last_error = 99999;
        if (this.getId(handle) instanceof Node) {
            nextChild = ((Node)this.getId(handle)).getFirstChild();
        } else if (this.getId(handle) instanceof BufferedReader) {
            nextChild = ((Node)this.getId(this.HANDLE_READER)).getFirstChild();
        } else {
            this.last_error = 5;
        }
        attr = this.searchAttributeByValue(nextChild, name, flag);
        while (nextChild != null && attr == null) {
            nextChild = this.getNextSibling(nextChild);
            attr = this.searchAttributeByValue(nextChild, name, flag);
        }
        return nextChild;
    }

    public int cxml_SET_DATA(CobolVar[] argv) throws Exception {
        int Return2 = 1;
        int valueLen = 0;
        this.last_error = 99999;
        Node node = null;
        if (this.getId(argv[1]) instanceof Node) {
            node = (Node)this.getId(argv[1]);
        } else if (this.getId(argv[1]) instanceof BufferedReader) {
            node = (Node)this.HANDLE.getId();
        }
        if (node != null) {
            this.doc = node.getOwnerDocument();
            if (argv.length > 3 && argv[2].toString().length() > argv[3].toint()) {
                valueLen = argv[3].toint();
                if (node.getFirstChild() != null) {
                    node.removeChild(node.getFirstChild());
                }
                node.appendChild(this.doc.createTextNode(this.getXmlValue(argv[2]).substring(0, valueLen)));
            } else {
                if (node.getFirstChild() != null) {
                    node.removeChild(node.getFirstChild());
                }
                node.appendChild(this.doc.createTextNode(this.getXmlValue(argv[2])));
            }
        } else {
            Return2 = 0;
            this.last_error = 6;
        }
        if (log != null) {
            if (node != null) {
                log.info("C$XML      - node name = " + node.getNodeName() + " - node value = " + this.getXmlValue(argv[2]) + " - node value length = " + valueLen);
            } else {
                log.info("C$XML       - node name = null");
            }
        }
        return Return2;
    }

    public int cxml_MODIFY_ATTRIBUTE_VALUE(CobolVar[] argv) throws Exception {
        int Return2 = 1;
        this.last_error = 99999;
        Node node = null;
        if (this.getId(argv[1]) instanceof Node) {
            node = (Node)this.getId(argv[1]);
        } else if (this.getId(argv[1]) instanceof BufferedReader) {
            node = (Node)this.HANDLE.getId();
        }
        if (node != null) {
            NamedNodeMap attrs = node.getAttributes();
            int attrNum = argv[2].toint();
            if (attrs != null && attrs.getLength() < attrNum) {
                Return2 = 0;
                this.last_error = 7;
            } else if (argv.length > 4 && argv[3].toString().length() > argv[4].toint()) {
                attrs.item(attrNum).setNodeValue(this.getXmlValue(argv[3]).substring(0, argv[4].toint()));
            } else {
                attrs.item(attrNum).setNodeValue(this.getXmlValue(argv[3]));
            }
        } else {
            Return2 = 0;
            this.last_error = 6;
        }
        if (log != null) {
            if (node != null) {
                log.info("C$XML      - node name = " + node.getNodeName() + " - new node value = " + node.getNodeValue() + " - node number = " + argv[2].toint());
            } else {
                log.info("C$XML       - node name = null");
            }
        }
        return Return2;
    }

    public void cxml_WRITE_STRING(CobolVar[] argv) throws Exception {
        if (argv.length != 3) {
            this.RESULT.set(CobolNum.noo(0L, 0), false, false);
            return;
        }
        this.HANDLE_VAR = argv[1];
        if (this.getId(this.HANDLE_VAR) instanceof Document) {
            this.doc = (Document)this.getId(this.HANDLE_VAR);
        } else if (this.getId(this.HANDLE_VAR) instanceof Node) {
            this.node = (Node)this.getId(this.HANDLE_VAR);
            this.doc = this.node.getOwnerDocument();
        } else if (this.getId(this.HANDLE_VAR) instanceof BufferedReader) {
            this.node = (Node)this.getId(this.HANDLE_READER);
            this.doc = this.node.getOwnerDocument();
        } else {
            this.last_error = 5;
        }
        if (this.last_error == 99999) {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(this.doc);
            StringWriter writ = new StringWriter();
            StreamResult result = new StreamResult(writ);
            if (INDENT > -1) {
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("doctype-public", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(INDENT));
            }
            if (stand.get(this.doc) != null) {
                if (((String)stand.get(this.doc)).equals("yes")) {
                    transformer.setOutputProperty("standalone", "yes");
                    this.doc.setXmlStandalone(true);
                } else if (((String)stand.get(this.doc)).equals("no")) {
                    transformer.setOutputProperty("standalone", "yes");
                    this.doc.setXmlStandalone(false);
                }
                stand.remove(this.doc);
            }
            if (this.procs.get(this.doc) != null) {
                this.node = this.doc.getDocumentElement();
                this.procInstr = (Vector)this.procs.get(this.doc);
                for (int i = 0; i < this.procInstr.size(); ++i) {
                    if ((ProcessingInstruction)this.procInstr.elementAt(i) == null) continue;
                    this.doc.insertBefore((ProcessingInstruction)this.procInstr.elementAt(i), this.node);
                }
                this.procInstr.clear();
                this.procs.remove(this.doc);
            }
            if (this.encoding.get(this.doc) != null) {
                transformer.setOutputProperty("encoding", (String)this.encoding.get(this.doc));
                this.encoding.remove(this.doc);
            }
            if (INDENT > -1) {
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("doctype-public", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(INDENT));
            }
            transformer.transform(source, result);
            argv[2].set(writ.toString().trim());
        }
        this.setError(5);
    }

    public Node getPrevSibling(CobolVar handle) throws Exception {
        Node prevSibling = null;
        this.last_error = 99999;
        if (this.getId(handle) instanceof Node) {
            prevSibling = ((Node)this.getId(handle)).getPreviousSibling();
        } else if (this.getId(handle) instanceof BufferedReader) {
            prevSibling = ((Node)this.getId(this.HANDLE_READER)).getPreviousSibling();
        } else {
            log.info("getNextSibling handle not node");
        }
        if (log != null) {
            if (prevSibling == null) {
                log.info("getNextSibling prevSibling null");
            } else {
                log.info("C$XML    getNextSibling node: " + prevSibling.getNodeName() + " node value [" + prevSibling.getNodeValue() + "]" + prevSibling.getLocalName() + " getTextContent()[" + prevSibling.getTextContent() + "]");
            }
        }
        while (prevSibling != null && (prevSibling.getNodeName().equalsIgnoreCase("#text") || prevSibling.getNodeName().equalsIgnoreCase("#cdata-section") || prevSibling.getNodeName().equalsIgnoreCase("#comment") || prevSibling.getNodeName().equalsIgnoreCase("#document") || prevSibling.getNodeName().equalsIgnoreCase("#document-fragment"))) {
            prevSibling = prevSibling.getPreviousSibling();
        }
        if (log != null) {
            if (prevSibling != null) {
                log.info("C$XML     handle: " + handle.getClass().getName() + " - node name = " + prevSibling.getNodeName());
            } else {
                log.info("C$XML     handle: " + handle.getClass().getName() + " - node name = null");
            }
        }
        return prevSibling;
    }

    public boolean getComment(CobolVar[] argv) throws Exception {
        Node prevSibling;
        for (prevSibling = this.getId(argv[1]) instanceof BufferedReader ? ((Node)this.HANDLE_READER.getId()).getPreviousSibling() : ((Node)this.getId(argv[1])).getPreviousSibling(); prevSibling != null && !prevSibling.getNodeName().equalsIgnoreCase("#comment"); prevSibling = prevSibling.getPreviousSibling()) {
        }
        if (prevSibling != null) {
            String comm = prevSibling.getNodeValue();
            while (prevSibling != null && prevSibling.getNodeName().equalsIgnoreCase("#comment")) {
                if ((prevSibling = prevSibling.getPreviousSibling()) == null || !prevSibling.getNodeName().equalsIgnoreCase("#comment")) continue;
                comm = prevSibling.getNodeValue() + "\u0000" + comm;
            }
            argv[2].set(comm);
            if (log != null) {
                log.info("C$XML     in getComment comment : " + comm);
            }
            if (argv.length == 4) {
                argv[3].set(comm.length());
            }
            return true;
        }
        if (log != null) {
            log.info("C$XML     in getComment return false");
        }
        this.last_error = 13;
        return false;
    }

    public String getXmlValue(CobolVar var) throws Exception {
        String Return2 = var.toString().trim();
        if (var.isNumeric()) {
            while (Return2.length() < var.length()) {
                Return2 = "0" + Return2;
            }
        }
        return Return2;
    }

    static {
        errDesc.put(new Integer(0), "No errors");
        errDesc.put(new Integer(1), "Unable to create parser due low memory");
        errDesc.put(new Integer(2), "Unable to create parser-expat error");
        errDesc.put(new Integer(3), "Unable to open named file");
        errDesc.put(new Integer(4), "Invalid XML parsing error");
        errDesc.put(new Integer(5), "The passed handle is not a valid parser handle");
        errDesc.put(new Integer(6), "The passed handle is not a valid element handle");
        errDesc.put(new Integer(7), "Invalid attribute number");
        errDesc.put(new Integer(8), "Error accessing URL");
        errDesc.put(new Integer(9), "XML parser is not available on this machine");
        errDesc.put(new Integer(10), "The specified element has no children");
        errDesc.put(new Integer(11), "The specified element has no siblings");
        errDesc.put(new Integer(12), "The specified element is a top-level element");
        errDesc.put(new Integer(13), "The specified element has no value");
        errDesc.put(new Integer(14), "The specified element has no attributes");
        errDesc.put(new Integer(15), "The regular expression given caused an error");
        errDesc.put(new Integer(16), "The specified parser already has a top-level element");
        errDesc.put(new Integer(17), "The specified processing instruction number does not exist");
        errDesc.put(new Integer(18), "No processing instructions are available");
        stand = new Hashtable();
        log = LoggerFactory.get(8);
    }
}

