/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.report;

import com.iscobol.report.ReportGroup;
import com.iscobol.rts.CobValue;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IPicAlphaEdit;
import com.iscobol.rts.IPicNumEdit;
import com.iscobol.types.CobolNum;
import java.util.Vector;

public class ReportVariable {
    ReportGroup parent;
    ICobolVar data;
    CobValue source;
    private int level;
    int line;
    ICobolVar memory;
    private int column;
    private byte[] initValue;
    private byte[] prevValue;
    private CobValue[] sum;
    private ReportGroup[] upon;
    ICobolVar reset;
    private boolean resetFinal;
    private Vector sumToMe;
    private CobolNum sumValue;

    public ReportVariable(int l) {
        this.level = l;
    }

    public ReportVariable(int l, ICobolVar d) {
        this(l);
        this.data = d;
        this.initValue = new byte[d.length()];
        System.arraycopy(d.ieval().getBytes(), 0, this.initValue, 0, this.initValue.length);
    }

    public ReportVariable setLine(int n) {
        this.line = n;
        return this;
    }

    public ReportVariable setLine(int n, ICobolVar mem) {
        this.setLine(n);
        this.memory = mem;
        this.memory.setSpace();
        return this;
    }

    public ReportVariable setColumn(int n) {
        this.column = n;
        return this;
    }

    public ReportVariable setSource(CobValue c) {
        this.source = c;
        return this;
    }

    public ReportVariable setGroupIndicate() {
        this.prevValue = new byte[this.initValue.length];
        return this;
    }

    public ReportVariable setSum(CobValue[] s, ReportGroup[] u) {
        ICobolVar cv;
        CobolNum cn;
        this.sum = s;
        this.upon = u;
        if (this.data != null && (cn = (cv = this.data.ieval()) instanceof INumericVar ? ((INumericVar)cv).num() : (cv instanceof IPicNumEdit ? ((IPicNumEdit)cv).num() : null)) != null) {
            this.sumValue = CobolNum.get(cn.precision(), cn.scale());
        }
        return this;
    }

    public ReportVariable setReset(ICobolVar rv) {
        if (rv != null) {
            this.reset = rv;
        } else {
            this.resetFinal = true;
        }
        return this;
    }

    private static boolean areEqual(byte[] v1, byte[] v2, int len) {
        for (int i = 0; i < len; ++i) {
            if (v1[i] == v2[i]) continue;
            return false;
        }
        return true;
    }

    void ctrlBreak() {
        if (this.prevValue != null) {
            for (int i = this.prevValue.length - 1; i >= 0; --i) {
                this.prevValue[i] = 32;
            }
        }
    }

    void evalBefore() {
        if (this.data != null) {
            if (this.source != null) {
                ICobolVar cvd = this.data.ieval();
                ICobolVar src = this.source.ieval();
                if (cvd instanceof INumericVar) {
                    src.moveTo((INumericVar)this.data);
                    if (this.sumToMe != null) {
                        this.doSum(((INumericVar)this.data).num());
                    }
                } else if (cvd instanceof IPicNumEdit) {
                    src.moveTo((IPicNumEdit)this.data);
                    if (this.sumToMe != null) {
                        this.doSum(((IPicNumEdit)this.data).num());
                    }
                } else if (cvd instanceof IPicAlphaEdit) {
                    src.moveTo((IPicAlphaEdit)this.data);
                } else {
                    src.moveTo(this.data);
                }
            } else if (this.sum != null) {
                this.data.ieval().set(this.sumValue);
                if (this.sumToMe != null) {
                    this.doSum(this.sumValue);
                }
                if (this.reset == null && !this.resetFinal) {
                    this.resetSum();
                }
            } else {
                this.data.ieval().set(this.initValue);
            }
        }
    }

    void evalAfter() {
        if (this.data != null && this.source != null) {
            ICobolVar cvd = this.data.ieval();
            ICobolVar src = this.source.ieval();
            if (cvd instanceof INumericVar) {
                src.moveTo((INumericVar)this.data);
            } else if (cvd instanceof IPicNumEdit) {
                src.moveTo((IPicNumEdit)this.data);
            } else if (cvd instanceof IPicAlphaEdit) {
                src.moveTo((IPicAlphaEdit)this.data);
            } else {
                src.moveTo(this.data);
            }
            if (this.prevValue != null) {
                byte[] sra = this.data.getBytes();
                if (ReportVariable.areEqual(this.prevValue, sra, this.prevValue.length)) {
                    this.data.setSpace();
                } else {
                    System.arraycopy(sra, 0, this.prevValue, 0, this.prevValue.length);
                }
            }
        }
    }

    void eval() {
        if (this.data != null) {
            if (this.source != null) {
                ICobolVar cvd = this.data.ieval();
                ICobolVar src = this.source.ieval();
                if (this.prevValue != null) {
                    byte[] sra = src.getBytes();
                    if (ReportVariable.areEqual(this.prevValue, sra, this.prevValue.length)) {
                        this.data.setSpace();
                        return;
                    }
                    System.arraycopy(sra, 0, this.prevValue, 0, this.prevValue.length);
                }
                if (cvd instanceof INumericVar) {
                    src.moveTo((INumericVar)this.data);
                    if (this.sumToMe != null) {
                        this.doSum(((INumericVar)this.data).num());
                    }
                } else if (cvd instanceof IPicNumEdit) {
                    src.moveTo((IPicNumEdit)this.data);
                    if (this.sumToMe != null) {
                        this.doSum(((IPicNumEdit)this.data).num());
                    }
                } else if (cvd instanceof IPicAlphaEdit) {
                    src.moveTo((IPicAlphaEdit)this.data);
                } else {
                    src.moveTo(this.data);
                }
            } else if (this.sum != null) {
                this.data.ieval().set(this.sumValue);
                if (this.sumToMe != null) {
                    this.doSum(this.sumValue);
                }
                if (this.reset == null && !this.resetFinal) {
                    this.resetSum();
                }
            } else {
                this.data.ieval().set(this.initValue);
            }
        }
    }

    void resetSum() {
        this.sumValue.set(0L, this.sumValue.scale());
    }

    void setToSum(ReportVariable rv) {
        if (this.sumToMe == null) {
            this.sumToMe = new Vector();
        }
        this.sumToMe.add(rv);
    }

    void sumToMe(CobValue cv) {
        ICobolVar cvd = cv.ieval();
        if (cvd instanceof INumericVar) {
            this.sumValue = this.sumValue.add(((INumericVar)cvd).num());
        } else if (cvd instanceof IPicNumEdit) {
            this.sumValue = this.sumValue.add(((IPicNumEdit)cvd).num());
        }
    }

    private void doSum(CobolNum n) {
        for (int i = this.sumToMe.size() - 1; i >= 0; --i) {
            ReportVariable rv = (ReportVariable)this.sumToMe.elementAt(i);
            rv.sumValue = rv.sumValue.add(n);
        }
    }

    CobValue[] getSum() {
        return this.sum;
    }

    ReportGroup[] getUpon() {
        return this.upon;
    }

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return "(null)";
    }
}

