/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.Config;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class Auth
implements RuntimeErrorsNumbers {
    public static final String CRYPT_ALGORITHM = "Blowfish";
    public static final String DEFAULT_HASH = "SHA-1";
    public static final String LEGACY_HASH = "LEGACY";
    private static String HASH_ALGORITHM = Config.getProperty(".as.digest", "SHA-1");

    public static byte[] nullChallenge() {
        return new byte[16];
    }

    public static byte[] newChallenge() {
        byte[] Return2;
        byte[] rnd = SecureRandom.getSeed(16);
        if (LEGACY_HASH.equalsIgnoreCase(HASH_ALGORITHM)) {
            Return2 = rnd;
        } else {
            byte[] b;
            try {
                b = HASH_ALGORITHM.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException ex) {
                b = HASH_ALGORITHM.getBytes();
            }
            byte[] algrthm = b;
            Return2 = new byte[algrthm.length + 1 + rnd.length];
            System.arraycopy(algrthm, 0, Return2, 0, algrthm.length);
            System.arraycopy(rnd, 0, Return2, algrthm.length + 1, rnd.length);
        }
        return Return2;
    }

    public static void newChallenge(ICobolVar challenge) {
        byte[] rnd = Auth.newChallenge();
        challenge.set(rnd, 0, rnd.length, false);
    }

    public static String getHashAlgorithm() {
        return HASH_ALGORITHM;
    }

    public static void setHashAlgorithm(String alg) {
        HASH_ALGORITHM = alg;
    }

    public static String getAlgorithmFromChallenge(ICobolVar challenge) {
        byte[] b = challenge.getBytes();
        if (challenge.getLength() > 16) {
            int i = 0;
            while (b[i] != 0) {
                ++i;
            }
            challenge.set(b, i + 1, b.length - i - 1, false);
            try {
                return new String(b, 0, i, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                return new String(b, 0, i);
            }
        }
        return LEGACY_HASH;
    }

    public static void getDigest(ICobolVar[] cv, String hashAlgrthm) {
        if (cv.length > 1) {
            try {
                MessageDigest md;
                if (LEGACY_HASH.equalsIgnoreCase(hashAlgrthm)) {
                    md = MessageDigest.getInstance("MD5");
                    for (int i = 1; i < cv.length; ++i) {
                        md.update(cv[i].getBytes(), 0, cv[i].getLength());
                    }
                } else {
                    md = MessageDigest.getInstance(hashAlgrthm);
                    for (int i = 1; i < cv.length; ++i) {
                        md.update(cv[i].getBytes(), 0, cv[i].length());
                    }
                }
                cv[0].set(md.digest());
            }
            catch (NoSuchAlgorithmException _ex) {
                throw new IscobolRuntimeException(3, _ex.toString());
            }
        }
        throw new IllegalArgumentException(" [" + cv.length + "]");
    }

    public static void encrypt(ICobolVar data, ICobolVar key, ICobolVar out) {
        Auth.enDeCrypt(data, key, out, false);
    }

    public static void decrypt(ICobolVar data, ICobolVar key, ICobolVar out) {
        Auth.enDeCrypt(data, key, out, true);
    }

    private static void enDeCrypt(ICobolVar data, ICobolVar key, ICobolVar out, boolean decrypt) {
        int mode = decrypt ? 2 : 1;
        try {
            Cipher cipher = Cipher.getInstance(CRYPT_ALGORITHM);
            cipher.init(mode, new SecretKeySpec(key.getBytes(), 0, key.getLength(), CRYPT_ALGORITHM));
            out.set(cipher.doFinal(data.getBytes(), 0, data.getLength()));
        }
        catch (NoSuchPaddingException _ex) {
            throw new IscobolRuntimeException(3, _ex.toString());
        }
        catch (NoSuchAlgorithmException _ex) {
            throw new IscobolRuntimeException(3, _ex.toString());
        }
        catch (InvalidKeyException _ex) {
            throw new IscobolRuntimeException(3, _ex.toString());
        }
        catch (IllegalBlockSizeException _ex) {
            throw new IscobolRuntimeException(3, _ex.toString());
        }
        catch (BadPaddingException _ex) {
            throw new IscobolRuntimeException(3, _ex.toString());
        }
    }

    public static String encode(byte[] in) {
        StringBuffer Return2 = new StringBuffer();
        block36: for (int i = 0; i < in.length; ++i) {
            switch (in[i] & 0xF0) {
                case 0: {
                    Return2.append('0');
                    break;
                }
                case 16: {
                    Return2.append('1');
                    break;
                }
                case 32: {
                    Return2.append('2');
                    break;
                }
                case 48: {
                    Return2.append('3');
                    break;
                }
                case 64: {
                    Return2.append('4');
                    break;
                }
                case 80: {
                    Return2.append('5');
                    break;
                }
                case 96: {
                    Return2.append('6');
                    break;
                }
                case 112: {
                    Return2.append('7');
                    break;
                }
                case 128: {
                    Return2.append('8');
                    break;
                }
                case 144: {
                    Return2.append('9');
                    break;
                }
                case 160: {
                    Return2.append('A');
                    break;
                }
                case 176: {
                    Return2.append('B');
                    break;
                }
                case 192: {
                    Return2.append('C');
                    break;
                }
                case 208: {
                    Return2.append('D');
                    break;
                }
                case 224: {
                    Return2.append('E');
                    break;
                }
                case 240: {
                    Return2.append('F');
                }
            }
            switch (in[i] & 0xF) {
                case 0: {
                    Return2.append('0');
                    continue block36;
                }
                case 1: {
                    Return2.append('1');
                    continue block36;
                }
                case 2: {
                    Return2.append('2');
                    continue block36;
                }
                case 3: {
                    Return2.append('3');
                    continue block36;
                }
                case 4: {
                    Return2.append('4');
                    continue block36;
                }
                case 5: {
                    Return2.append('5');
                    continue block36;
                }
                case 6: {
                    Return2.append('6');
                    continue block36;
                }
                case 7: {
                    Return2.append('7');
                    continue block36;
                }
                case 8: {
                    Return2.append('8');
                    continue block36;
                }
                case 9: {
                    Return2.append('9');
                    continue block36;
                }
                case 10: {
                    Return2.append('A');
                    continue block36;
                }
                case 11: {
                    Return2.append('B');
                    continue block36;
                }
                case 12: {
                    Return2.append('C');
                    continue block36;
                }
                case 13: {
                    Return2.append('D');
                    continue block36;
                }
                case 14: {
                    Return2.append('E');
                    continue block36;
                }
                case 15: {
                    Return2.append('F');
                }
            }
        }
        return Return2.toString();
    }

    public static byte[] decode(String ins) {
        char[] in = ins.toCharArray();
        byte[] Return2 = new byte[in.length >> 1];
        int j = 0;
        for (int i = 0; i < Return2.length; ++i) {
            switch (in[j]) {
                default: {
                    Return2[i] = 0;
                    break;
                }
                case '1': {
                    Return2[i] = 16;
                    break;
                }
                case '2': {
                    Return2[i] = 32;
                    break;
                }
                case '3': {
                    Return2[i] = 48;
                    break;
                }
                case '4': {
                    Return2[i] = 64;
                    break;
                }
                case '5': {
                    Return2[i] = 80;
                    break;
                }
                case '6': {
                    Return2[i] = 96;
                    break;
                }
                case '7': {
                    Return2[i] = 112;
                    break;
                }
                case '8': {
                    Return2[i] = -128;
                    break;
                }
                case '9': {
                    Return2[i] = -112;
                    break;
                }
                case 'A': 
                case 'a': {
                    Return2[i] = -96;
                    break;
                }
                case 'B': 
                case 'b': {
                    Return2[i] = -80;
                    break;
                }
                case 'C': 
                case 'c': {
                    Return2[i] = -64;
                    break;
                }
                case 'D': 
                case 'd': {
                    Return2[i] = -48;
                    break;
                }
                case 'E': 
                case 'e': {
                    Return2[i] = -32;
                    break;
                }
                case 'F': 
                case 'f': {
                    Return2[i] = -16;
                }
            }
            if (++j >= in.length) continue;
            switch (in[j]) {
                default: {
                    int n = i;
                    Return2[n] = (byte)(Return2[n] | 0);
                    break;
                }
                case '1': {
                    int n = i;
                    Return2[n] = (byte)(Return2[n] | 1);
                    break;
                }
                case '2': {
                    int n = i;
                    Return2[n] = (byte)(Return2[n] | 2);
                    break;
                }
                case '3': {
                    int n = i;
                    Return2[n] = (byte)(Return2[n] | 3);
                    break;
                }
                case '4': {
                    int n = i;
                    Return2[n] = (byte)(Return2[n] | 4);
                    break;
                }
                case '5': {
                    int n = i;
                    Return2[n] = (byte)(Return2[n] | 5);
                    break;
                }
                case '6': {
                    int n = i;
                    Return2[n] = (byte)(Return2[n] | 6);
                    break;
                }
                case '7': {
                    int n = i;
                    Return2[n] = (byte)(Return2[n] | 7);
                    break;
                }
                case '8': {
                    int n = i;
                    Return2[n] = (byte)(Return2[n] | 8);
                    break;
                }
                case '9': {
                    int n = i;
                    Return2[n] = (byte)(Return2[n] | 9);
                    break;
                }
                case 'A': 
                case 'a': {
                    int n = i;
                    Return2[n] = (byte)(Return2[n] | 0xA);
                    break;
                }
                case 'B': 
                case 'b': {
                    int n = i;
                    Return2[n] = (byte)(Return2[n] | 0xB);
                    break;
                }
                case 'C': 
                case 'c': {
                    int n = i;
                    Return2[n] = (byte)(Return2[n] | 0xC);
                    break;
                }
                case 'D': 
                case 'd': {
                    int n = i;
                    Return2[n] = (byte)(Return2[n] | 0xD);
                    break;
                }
                case 'E': 
                case 'e': {
                    int n = i;
                    Return2[n] = (byte)(Return2[n] | 0xE);
                    break;
                }
                case 'F': 
                case 'f': {
                    int n = i;
                    Return2[n] = (byte)(Return2[n] | 0xF);
                }
            }
            ++j;
        }
        return Return2;
    }
}

