/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.awt.image.RGBImageFilter;
import java.io.FileInputStream;
import java.io.InputStream;

public class BMPImage {
    private static final int BITMAPFILEHEADER = 14;
    private static final int BITMAPINFOHEADER = 40;

    public static Image createImage(InputStream fs) {
        return BMPImage.createImage(fs, true);
    }

    public static Image createImage(InputStream fs, boolean lightGrayIsTransparent) {
        Image Return2 = null;
        try {
            byte[] bf = new byte[14];
            fs.read(bf, 0, 14);
            if (bf[0] != 66 || bf[1] != 77) {
                return Return2;
            }
            byte[] bi = new byte[40];
            fs.read(bi, 0, 40);
            int nwidth = (bi[7] & 0xFF) << 24 | (bi[6] & 0xFF) << 16 | (bi[5] & 0xFF) << 8 | bi[4] & 0xFF;
            int nheight = (bi[11] & 0xFF) << 24 | (bi[10] & 0xFF) << 16 | (bi[9] & 0xFF) << 8 | bi[8] & 0xFF;
            int nbitcount = (bi[15] & 0xFF) << 8 | bi[14] & 0xFF;
            int nsizeimage = (bi[23] & 0xFF) << 24 | (bi[22] & 0xFF) << 16 | (bi[21] & 0xFF) << 8 | bi[20] & 0xFF;
            if (nsizeimage == 0) {
                nsizeimage = (nwidth * nbitcount + 31 & 0xFFFFFFE0) >> 3;
                nsizeimage *= nheight;
            }
            int nclrused = (bi[35] & 0xFF) << 24 | (bi[34] & 0xFF) << 16 | (bi[33] & 0xFF) << 8 | bi[32] & 0xFF;
            if (nbitcount == 24) {
                int npad = nsizeimage / nheight - nwidth * 3;
                int[] ndata = new int[nheight * nwidth];
                byte[] brgb = new byte[(nwidth + npad) * 3 * nheight];
                fs.read(brgb, 0, (nwidth + npad) * 3 * nheight);
                int nindex = 0;
                for (int j = 0; j < nheight; ++j) {
                    for (int i = 0; i < nwidth; ++i) {
                        ndata[nwidth * (nheight - j - 1) + i] = 0xFF000000 | (brgb[nindex + 2] & 0xFF) << 16 | (brgb[nindex + 1] & 0xFF) << 8 | brgb[nindex] & 0xFF;
                        nindex += 3;
                    }
                    nindex += npad;
                }
                Return2 = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(nwidth, nheight, ndata, 0, nwidth));
            } else if (nbitcount == 8 || nbitcount == 4) {
                byte[] bdata;
                int npad8;
                int nNumColors = 0;
                nNumColors = nclrused > 0 ? nclrused : 1 << nbitcount;
                int[] npalette = new int[nNumColors];
                byte[] bpalette = new byte[nNumColors * 4];
                fs.read(bpalette, 0, nNumColors * 4);
                int nindex8 = 0;
                for (int n = 0; n < nNumColors; ++n) {
                    npalette[n] = 0xFF000000 | (bpalette[nindex8 + 2] & 0xFF) << 16 | (bpalette[nindex8 + 1] & 0xFF) << 8 | bpalette[nindex8] & 0xFF;
                    nindex8 += 4;
                }
                if (nbitcount == 4) {
                    int realWidth = (nwidth * nbitcount + 31 & 0xFFFFFFE0) >> 3;
                    bdata = new byte[((realWidth + (npad8 -= ((npad8 = nsizeimage / nheight * 2 - nwidth) & 1) > 0 ? 1 : 0)) * 2 * nheight + 1) / 2];
                } else {
                    npad8 = nsizeimage / nheight - nwidth;
                    bdata = new byte[(nwidth + npad8) * nheight];
                }
                int[] ndata8 = new int[nwidth * nheight];
                fs.read(bdata, 0, bdata.length);
                nindex8 = 0;
                if (nbitcount == 4) {
                    for (int j4 = 0; j4 < nheight; ++j4) {
                        for (int i4 = 0; i4 < nwidth; ++i4) {
                            ndata8[nwidth * (nheight - j4 - 1) + i4] = npalette[(bdata[nindex8 / 2] & 0xF0) >> 4];
                            ++nindex8;
                            if (++i4 < nwidth) {
                                ndata8[nwidth * (nheight - j4 - 1) + i4] = npalette[bdata[nindex8 / 2] & 0xF];
                            }
                            ++nindex8;
                        }
                        nindex8 += npad8;
                    }
                } else {
                    for (int j8 = 0; j8 < nheight; ++j8) {
                        for (int i8 = 0; i8 < nwidth; ++i8) {
                            ndata8[nwidth * (nheight - j8 - 1) + i8] = npalette[bdata[nindex8] & 0xFF];
                            ++nindex8;
                        }
                        nindex8 += npad8;
                    }
                }
                Return2 = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(nwidth, nheight, ndata8, 0, nwidth));
            }
            fs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Return2 != null && lightGrayIsTransparent) {
            Return2 = BMPImage.makeColorTransparent(Return2, Color.lightGray);
        }
        return Return2;
    }

    public static Image createImage(String fullPath) {
        return BMPImage.createImage(fullPath, true);
    }

    public static Image createImage(String fullPath, boolean lightGrayIsTransparent) {
        Image Return2 = null;
        try {
            FileInputStream fis = new FileInputStream(fullPath);
            Return2 = BMPImage.createImage(fis, lightGrayIsTransparent);
            fis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Return2;
    }

    public static Image makeColorTransparent(Image im, final Color color) {
        RGBImageFilter filter = new RGBImageFilter(){
            public int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
            }

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }
}

