/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.CallManager;
import com.iscobol.rts.Config;
import com.iscobol.rts.EsqlHostVar;
import com.iscobol.rts.EsqlPrepare;
import com.iscobol.rts.EsqlRuntime;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IEsqlCursor;
import com.iscobol.rts.UserHandles;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import com.iscobol.types.ObjectVar;
import com.iscobol.types.PicNativeDouble;
import com.iscobol.types.PicNativeFloat;
import com.iscobol.types.PicX;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;
import java.util.function.Consumer;

public class EsqlCursor
implements IEsqlCursor {
    public static final int SQL_FETCH_NEXT = 1;
    public static final int SQL_FETCH_FIRST = 2;
    public static final int SQL_FETCH_LAST = 3;
    public static final int SQL_FETCH_PRIOR = 4;
    public static final int SQL_FETCH_ABSOLUTE = 5;
    public static final int SQL_FETCH_RELATIVE = 6;
    public static final int SQL_FETCH_OK = 0;
    public static final int SQL_FETCH_TRUNC = 1;
    public static final int SQL_FETCH_NOTFOUND = -1;
    public static final int TRIM_NONE = -1;
    public static final int TRIM_ALL = 0;
    public static final int TRIM_LEAVE1 = 1;
    public static final int TRIM_ALL2 = 2;
    String name;
    Object owner;
    private String query;
    private EsqlPrepare prep;
    protected ResultSet hstmt;
    private Vector params = new Vector();
    private Vector bindCols = new Vector();
    public Vector db2BindCols = new Vector();
    public Vector rowsetCols = new Vector();
    public CobolVar descr;
    private boolean statNoData;
    private boolean call;
    private boolean cursorOutEnd;
    private boolean rowset;
    private int rowCount;
    private int type;
    private int holdability;
    private boolean updt;
    private boolean nullResult;
    private PreparedStatement tmpStmt;
    private SQLWarning warnings;
    private String prepName = "";
    private final Integer withReturn;
    int handle;
    private Consumer<ResultSet> rsListener;
    private final Logger log = LoggerFactory.get(2048);

    public EsqlCursor(String name, int type, Object owner, Object withReturn) {
        this.name = name;
        this.type = type;
        this.owner = owner;
        if (withReturn == Boolean.TRUE) {
            withReturn = Integer.MAX_VALUE;
        }
        if (!(withReturn instanceof Integer)) {
            withReturn = 0;
        }
        this.withReturn = (Integer)withReturn;
        this.handle = UserHandles.ssetId(this);
        if (this.withReturn > 0) {
            String callName = Factory.getd((boolean)true).getTdd().activeCalls.peekName();
            CallManager calls = Factory.getCalls();
            calls.putEsqlCursor(callName, this);
        }
    }

    @Override
    public void setResultSetListener(Consumer<ResultSet> l) {
        this.rsListener = l;
    }

    @Override
    public Integer getWithReturn() {
        return this.withReturn;
    }

    public int getHoldability() {
        return this.holdability;
    }

    public int getType() {
        return this.type;
    }

    public String getQuery() {
        if (this.prep != null) {
            return this.prep.getQuery();
        }
        return this.query;
    }

    public boolean is(String n, Object own) {
        return own == this.owner && this.name.equals(n);
    }

    private void init() throws SQLException {
        this.nullResult = false;
        this.cursorOutEnd = false;
        this.warnings = null;
        if (this.hstmt != null) {
            if (this.log != null) {
                this.log.info("Developers log: EsqlCursor: before close RS " + this.hstmt);
            }
            this.hstmt.close();
            this.setResultSet(null);
        }
        if (this.tmpStmt != null) {
            if (this.log != null) {
                this.log.info("Developers log: EsqlCursor: before close PS " + this.tmpStmt);
            }
            this.tmpStmt.close();
            this.tmpStmt = null;
        }
    }

    protected void setResultSet(ResultSet rs) {
        this.hstmt = rs;
        if (this.rsListener != null) {
            this.rsListener.accept(this.hstmt);
        }
    }

    public void close() throws SQLException {
        if (this.log != null) {
            this.log.info("Developers log: EsqlCursor: in close RS " + this.hstmt);
        }
        this.init();
        this.query = null;
        UserHandles.free(this.handle);
        this.handle = 0;
    }

    public boolean isCursorOutEnd() {
        return this.cursorOutEnd;
    }

    public boolean isStatNoData() {
        return this.statNoData;
    }

    public boolean isCall() {
        return this.call;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setPrepare(EsqlPrepare prep) {
        if (prep == null && this.hstmt != null) {
            try {
                if (this.log != null) {
                    this.log.info("Developers log: EsqlCursor: before close RS " + this.hstmt);
                }
                this.hstmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.prep = prep;
        this.query = null;
        this.cursorOutEnd = false;
        this.statNoData = prep.isStatNoData();
    }

    public void setQuery(String query) {
        this.prep = null;
        this.statNoData = EsqlRuntime.isStatNoData(query);
        this.query = query;
        this.call = EsqlRuntime.isCall(query);
    }

    void setType(int t) {
        this.type = t;
    }

    void setHoldability(int h) {
        this.holdability = h;
    }

    void setUpdatable() {
        this.updt = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean open(Connection con) throws SQLException {
        boolean Return2 = false;
        try {
            this.init();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.prep == null && this.query != null) {
            if (this.rowset) {
                this.type = 1004;
            }
            this.tmpStmt = EsqlRuntime.getStatement(con, this.query, this.type, this.holdability, this.updt);
            if (this.log != null) {
                this.log.info("Developers log: EsqlCursor: after open PS " + this.tmpStmt);
            }
            if (Config.getProperty(".jdbc.fetch_size", 0) != 0) {
                this.tmpStmt.setFetchSize(Config.getProperty(".jdbc.fetch_size", 0));
            }
            this.setParams(this.tmpStmt);
            this.callExecuteHook(this.query, this.tmpStmt);
            this.rowCount = 0;
            this.setResultSet(null);
            try {
                Return2 = this.tmpStmt.execute();
                if (Return2) {
                    this.setResultSet(this.tmpStmt.getResultSet());
                    if (this.log != null) {
                        this.log.info("Developers log: EsqlCursor: after open RS " + this.hstmt);
                    }
                } else {
                    this.rowCount = this.tmpStmt.getUpdateCount();
                }
                this.warnings = this.tmpStmt.getWarnings();
                if (!(this.tmpStmt instanceof CallableStatement)) return Return2;
                EsqlRuntime.fillHostVars((CallableStatement)this.tmpStmt, this.params);
                this.nullResult = EsqlRuntime.searchNullWithoutInd(this.params);
                return Return2;
            }
            finally {
                try {
                    if (this.hstmt == null) {
                        if (this.log != null) {
                            this.log.info("Developers log: EsqlCursor: before close PS " + this.tmpStmt);
                        }
                        this.tmpStmt.close();
                        this.tmpStmt = null;
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        if (this.prep != null && this.query == null) {
            this.prep.setParams(this);
            this.setResultSet(this.prep.exec(this.type, this.holdability, this));
            if (this.log != null) {
                this.log.info("Developers log: EsqlCursor: after open RS " + this.hstmt);
            }
            this.rowCount = this.prep.getRowCount();
            if (this.hstmt == null) return false;
            return true;
        }
        EsqlRuntime.esqlError(3, ": Cursor open");
        return Return2;
    }

    public void bindCol(CobolVar hostVar, int type, int col, NumericVar ind, NumericVar len) throws SQLException {
        for (int bcSize = this.bindCols.size(); bcSize <= col; ++bcSize) {
            this.bindCols.add(null);
        }
        this.bindCols.set(col, new EsqlHostVar(hostVar, type, col, ind, len));
    }

    public void updCol(CobolVar hostVar, String name, int type, int col, NumericVar ind, NumericVar len) throws SQLException {
        int rsCol;
        if (this.hstmt == null) {
            EsqlRuntime.esqlError(3, ": UPDATE ROWSET");
        }
        ResultSetMetaData rsMtd = this.hstmt.getMetaData();
        for (rsCol = 1; rsCol <= rsMtd.getColumnCount() && !name.equalsIgnoreCase(rsMtd.getColumnName(rsCol)); ++rsCol) {
        }
        if (rsCol > rsMtd.getColumnCount()) {
            EsqlRuntime.esqlError(4, ": UPDATE ROWSET " + name);
        }
        for (int bcSize = this.rowsetCols.size(); bcSize <= rsCol; ++bcSize) {
            this.rowsetCols.add(null);
        }
        this.rowsetCols.set(rsCol, new EsqlHostVar(hostVar, type, rsCol, ind, len));
    }

    public void setParam(CobolVar hostVar, int type, int col, NumericVar ind, NumericVar len, String mode) throws SQLException {
        this.setParam(hostVar, type, col, ind, len, mode, (short)-1);
    }

    public void setParam(CobolVar hostVar, int type, int col, NumericVar ind, NumericVar len, String mode, short sqlType) throws SQLException {
        for (int bcSize = this.params.size(); bcSize <= col; ++bcSize) {
            this.params.add(null);
        }
        this.params.set(col, new EsqlHostVar(hostVar, type, col, ind, len, mode, sqlType));
    }

    private boolean fillHostVars() throws SQLException {
        EsqlHostVar hv;
        boolean Return2 = false;
        int end = this.bindCols.size();
        for (int i = 1; i < end && (hv = (EsqlHostVar)this.bindCols.get(i)) != null; ++i) {
            Return2 |= hv.toVar(i, this.hstmt);
        }
        return Return2;
    }

    public boolean updateHostVars() throws SQLException {
        boolean Return2 = true;
        int end = this.rowsetCols.size();
        for (int i = 1; i < end; ++i) {
            EsqlHostVar hv = (EsqlHostVar)this.rowsetCols.get(i);
            if (hv == null) continue;
            hv.updateVar(i, this.hstmt);
        }
        return Return2;
    }

    void callExecuteHook(String query, Statement stmt) {
        EsqlRuntime eRnt = EsqlRuntime.get();
        if (eRnt.hasExecuteHook()) {
            eRnt.callExecuteHook(query, stmt, this.params);
        }
    }

    public void setParams(PreparedStatement st) throws SQLException {
        EsqlRuntime.setParams(st, this.params);
    }

    public int fetch(int fetchType, boolean into, int row) throws SQLException {
        int Return2;
        if (this.hstmt == null) {
            EsqlRuntime.esqlError(3, ": Fetch");
        }
        this.warnings = null;
        switch (fetchType) {
            default: {
                Return2 = this.hstmt.next() ? 0 : -1;
                break;
            }
            case 2: {
                Return2 = this.hstmt.first() ? 0 : -1;
                break;
            }
            case 3: {
                Return2 = this.hstmt.last() ? 0 : -1;
                break;
            }
            case 4: {
                Return2 = this.hstmt.previous() ? 0 : -1;
                break;
            }
            case 5: {
                Return2 = this.hstmt.absolute(row) ? 0 : -1;
                break;
            }
            case 6: {
                Return2 = this.hstmt.relative(row) ? 0 : -1;
            }
        }
        this.warnings = this.hstmt.getWarnings();
        if (Return2 == 0 && into) {
            int n = Return2 = this.fillHostVars() ? 1 : 0;
        }
        if (Return2 == 0) {
            ++this.rowCount;
        }
        this.nullResult = EsqlRuntime.searchNullWithoutInd(this.bindCols);
        if (Return2 == -1) {
            this.cursorOutEnd = true;
        }
        return Return2;
    }

    public int startRowset(int start, boolean absolute) throws SQLException {
        int Return2 = 0;
        if (this.hstmt == null) {
            EsqlRuntime.esqlError(3, ": Fetch");
        }
        this.warnings = null;
        if (absolute) {
            this.hstmt.absolute(start);
        } else {
            this.hstmt.relative(start);
        }
        return Return2;
    }

    public int getHandle() {
        return this.handle;
    }

    public void updateCol(CobolVar hostVar, String name, int type, int col, NumericVar ind, NumericVar len) throws SQLException {
        int trimType = Config.getProperty(".jdbc.kept_spaces", 1);
        if (hostVar instanceof PicNativeFloat) {
            this.hstmt.updateFloat(name, ((PicNativeFloat)hostVar).tofloat());
        } else if (hostVar instanceof PicNativeDouble) {
            this.hstmt.updateDouble(name, ((PicNativeDouble)hostVar).todouble());
        } else if (hostVar instanceof ObjectVar) {
            Object obj = ((ObjectVar)hostVar).getId();
            if (obj != null) {
                if (obj instanceof byte[]) {
                    this.hstmt.updateObject(name, (Object)((byte[])obj));
                } else {
                    this.hstmt.updateObject(name, obj);
                }
            } else {
                this.hstmt.updateNull(name);
            }
        } else if (hostVar instanceof NumericVar) {
            this.hstmt.updateBigDecimal(name, ((NumericVar)hostVar).num().bigDecimalValue());
        } else if (hostVar instanceof PicX && hostVar.isSqlBinary()) {
            int hvlen = hostVar.length();
            ByteArrayInputStream bays = new ByteArrayInputStream(hostVar.getMemory(), hostVar.getOffset(), hvlen);
            this.hstmt.updateBinaryStream(name, (InputStream)bays, hvlen);
        } else {
            switch (trimType) {
                case -1: {
                    if (len != null && len.toint() < hostVar.toString().length()) {
                        this.hstmt.updateString(name, hostVar.toString().substring(0, len.toint()));
                        break;
                    }
                    this.hstmt.updateString(name, hostVar.toString());
                    break;
                }
                case 0: 
                case 2: {
                    if (len != null && len.toint() < EsqlCursor.rtrim(hostVar, 0, trimType).length()) {
                        this.hstmt.updateString(name, EsqlCursor.rtrim(hostVar, 0, trimType).substring(0, len.toint()));
                        break;
                    }
                    this.hstmt.updateString(name, EsqlCursor.rtrim(hostVar, 0, trimType));
                    break;
                }
                default: {
                    if (len != null && len.toint() < EsqlCursor.rtrim(hostVar, 1, trimType).length()) {
                        this.hstmt.updateString(name, EsqlCursor.rtrim(hostVar, 1, trimType).substring(0, len.toint()));
                        break;
                    }
                    this.hstmt.updateString(name, EsqlCursor.rtrim(hostVar, 1, trimType));
                }
            }
        }
    }

    public void updateColDb2Reg(String val, String name, int type, int col, NumericVar ind, NumericVar len) throws SQLException {
        int trimType = Config.getProperty(".jdbc.kept_spaces", 1);
        if (this.hstmt == null) {
            throw new SQLException("Current null ", "99999");
        }
        this.hstmt.updateString(name, val);
    }

    private static String rtrim(CobolVar v, int charToLeave, int trimType) {
        int i;
        char[] ca = v.toString().toCharArray();
        for (i = ca.length - 1; i >= charToLeave && !(trimType == 2 ? ca[i] > ' ' : ca[i] > ' ' || ca[i] == '\u0000'); --i) {
        }
        return new String(ca, 0, i + 1);
    }

    public void updateRow() throws SQLException {
        this.hstmt.updateRow();
    }

    public void updateNull(String name) throws SQLException {
        this.hstmt.updateNull(name);
    }

    public void deleteRow() throws SQLException {
        this.hstmt.deleteRow();
    }

    public boolean next() throws SQLException {
        return this.hstmt.next();
    }

    public boolean absolute(int pos) throws SQLException {
        return this.hstmt.absolute(pos);
    }

    public void beforeFirst() throws SQLException {
        this.hstmt.beforeFirst();
    }

    public int getRow() throws SQLException {
        return this.hstmt.getRow();
    }

    public boolean hasNullResult() {
        return this.nullResult;
    }

    public SQLWarning getWarnings() {
        return this.warnings;
    }

    public String getQueryLog() {
        String quer = "";
        quer = this.prep != null ? this.prep.getQuery() : this.query;
        if (this.params.size() > 0) {
            int trimType = Config.getProperty(".jdbc.kept_spaces", 1);
            quer = quer + " trimType[" + trimType + "] using[";
            for (int col = 1; col < this.params.size(); ++col) {
                if (col > 1) {
                    quer = quer + ", ";
                }
                if (this.params.get(col) != null) {
                    if (trimType == -1) {
                        quer = quer + "'" + ((EsqlHostVar)this.params.get(col)).getVar().toString() + "'";
                        continue;
                    }
                    quer = quer + "'" + EsqlHostVar.rtrim(((EsqlHostVar)this.params.get(col)).getVar(), trimType, trimType) + "'";
                    continue;
                }
                quer = quer + "null";
            }
        }
        return quer;
    }

    public void searchCallExc() throws SQLException {
        if (this.tmpStmt != null && this.call) {
            while (this.tmpStmt.getMoreResults()) {
                if (this.log == null) continue;
                this.log.info("Developers log: EsqlPrepare in while moreResult " + this.hstmt + " call=" + this.call);
            }
            if (this.log != null) {
                this.log.info("Developers log: EsqlPrepare moreResult " + this.hstmt + " call=" + this.call);
            }
        }
    }

    public EsqlPrepare getPrep() {
        return this.prep;
    }

    public ResultSet getResultSet() {
        return this.hstmt;
    }

    public void setRowset(boolean rowSet) {
        this.rowset = rowSet;
    }

    public boolean isRowset() {
        return this.rowset;
    }

    public void setPrepName(String prep) {
        this.prepName = prep;
    }

    public String getPrepName() {
        return this.prepName;
    }
}

