/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.gui.client.swing.SwingErrorBox;
import com.iscobol.rts.Config;
import com.iscobol.rts.OSValidator;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class LicenseCheck {
    private static final String fileSep = Config.filesep;
    private static final String PREFIX = "iscobol.";
    private static final String PREFIX_ND = "iscobol";
    private static final String propFile = "iscobol.properties";
    private static Object[] list = new Object[]{Config.systemDir + fileSep + "iscobol.properties", System.getProperty("user.home") + fileSep + "iscobol.properties", null, null, null};

    public static void main(String[] argv) {
        String title = "isCOBOL license info";
        Image img = Toolkit.getDefaultToolkit().createImage(SwingErrorBox.class.getResource("iscobol.png"));
        ArrayList msgs = LicenseCheck.doCheck();
        for (int i = 1; i < msgs.size(); ++i) {
            msgs.set(i, "(" + msgs.get(i) + ")");
        }
        try {
            JOptionPane.showMessageDialog(null, msgs.toArray(), title, 1, new ImageIcon(img));
        }
        catch (Exception _ex) {
            System.out.println(title);
            System.out.println("");
            for (int i = 0; i < msgs.size(); ++i) {
                System.out.println(msgs.get(i));
            }
        }
    }

    public static ArrayList doCheck() {
        LicenseCheck lc = new LicenseCheck();
        ArrayList<String> Return2 = new ArrayList<String>();
        try {
            ClassLoader loader = lc.getClass().getClassLoader();
            if (loader != null) {
                LicenseCheck.list[2] = loader.getResource(propFile);
            }
        }
        catch (Exception loader) {
            // empty catch block
        }
        LicenseCheck.list[3] = System.getProperty("iscobol.conf");
        String propDir = System.getenv(PREFIX_ND.toUpperCase());
        if (propDir != null) {
            LicenseCheck.list[4] = propDir + fileSep + propFile;
        }
        StringBuffer sb = new StringBuffer();
        lc.check(null, null, sb);
        Return2.add(sb.toString());
        LinkedHashMap<Object, String> files = new LinkedHashMap<Object, String>();
        for (int i = 0; i < list.length; ++i) {
            File f;
            if (list[i] == null) continue;
            if (list[i] instanceof String) {
                String path;
                f = new File((String)list[i]);
                if (!f.exists()) continue;
                try {
                    path = f.getCanonicalFile().getAbsolutePath();
                }
                catch (IOException e) {
                    path = f.getAbsolutePath();
                }
                files.put(path, path);
                continue;
            }
            URL url = (URL)list[i];
            String urlPath = url.getPath();
            f = new File(urlPath);
            if (f.exists()) {
                String path;
                try {
                    path = f.getCanonicalFile().getAbsolutePath();
                }
                catch (IOException e) {
                    path = f.getAbsolutePath();
                }
                files.put(path, path);
                continue;
            }
            try {
                InputStream in = url.openStream();
                int idx = OSValidator.isWindows() ? 6 : 5;
                files.put(in, urlPath.substring(idx).replace('!', ':'));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (Object o : files.keySet()) {
            sb.delete(0, sb.length());
            sb.append((String)files.get(o));
            sb.append(": ");
            if (o instanceof String) {
                lc.check((String)o, null, sb);
            } else {
                lc.check((String)files.get(o), (InputStream)o, sb);
            }
            Return2.add(sb.toString());
        }
        return Return2;
    }

    private LicenseCheck() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(String path, InputStream is, StringBuffer sb) {
        boolean[] lock = new boolean[1];
        Runnable run = () -> {
            Object c;
            block24: {
                block23: {
                    Config.markNoIscobolRuntimeThread();
                    String confOnlySave = System.getProperty("iscobol.conf.only");
                    try {
                        if (is != null) {
                            c = new Config(is, path);
                        } else {
                            c = new Config();
                            if (path != null) {
                                System.setProperty("iscobol.conf.only", path);
                            }
                        }
                        String ver = Config.getProperty((Config)c, ".licinfo", "cracked version!");
                        int indexChr = 0;
                        int chr = 95;
                        if (ver.substring(ver.lastIndexOf(47)).indexOf(95) >= 0 || ver.substring(ver.lastIndexOf(47)).indexOf(64) >= 0) {
                            if (ver.substring(ver.lastIndexOf(47)).indexOf(64) >= 0) {
                                chr = 64;
                            }
                            indexChr = ver.lastIndexOf(47);
                            indexChr += ver.substring(ver.lastIndexOf(47)).indexOf(chr);
                            ver = ver.substring(0, indexChr) + ver.substring(ver.length() - 8);
                        } else {
                            ver = ver.substring(0, ver.length() - 9) + ver.substring(ver.length() - 8);
                        }
                        ver = ver.endsWith("99991231") ? ver.substring(0, ver.length() - 8) + "/permanent" : ver.substring(0, ver.length() - 8) + "/" + ver.substring(ver.length() - 8);
                        sb.append(LicenseCheck.displayLicenseId(ver, false));
                        String expd = Config.getProperty(".expired", "1");
                        if (Config.isTrue(expd)) {
                            sb.append("=> expired license");
                        }
                        if (confOnlySave == null) break block23;
                    }
                    catch (Throwable ex) {
                        try {
                            sb.append("=> invalid or missing license");
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (confOnlySave != null) {
                                System.setProperty("iscobol.conf.only", confOnlySave);
                            } else {
                                System.clearProperty("iscobol.conf.only");
                            }
                            boolean[] blArray = lock;
                            synchronized (lock) {
                                lock[0] = true;
                                lock.notify();
                                // ** MonitorExit[var5_7] (shouldn't be in output)
                            }
                        }
                    }
                    System.setProperty("iscobol.conf.only", confOnlySave);
                    break block24;
                }
                System.clearProperty("iscobol.conf.only");
            }
            c = lock;
            synchronized (lock) {
                lock[0] = true;
                lock.notify();
                // ** MonitorExit[c] (shouldn't be in output)
            }
        };
        new Thread(run).start();
        boolean[] blArray = lock;
        synchronized (lock) {
            if (!lock[0]) {
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    public static String displayLicenseId(String licenseId, boolean cut) {
        int idx;
        if (cut && ((idx = licenseId.indexOf(64)) >= 0 || (idx = licenseId.indexOf(95)) >= 0)) {
            licenseId = licenseId.substring(0, idx);
        }
        String[] ss = licenseId.split("\\/");
        StringBuffer sb = new StringBuffer(ss[0]);
        block4: for (int i = 1; i < ss.length; ++i) {
            sb.append("/");
            switch (i) {
                case 1: 
                case 2: {
                    if ("0".equals(ss[i])) {
                        sb.append("unlim");
                        continue block4;
                    }
                    sb.append(ss[i]);
                    continue block4;
                }
                case 3: {
                    if ("7777777".equals(ss[i])) {
                        sb.append("unlim");
                        continue block4;
                    }
                    sb.append(ss[i]);
                    continue block4;
                }
                default: {
                    sb.append(ss[i]);
                }
            }
        }
        return sb.toString();
    }
}

