/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.lowagie.text.pdf.ArabicLigaturizer;
import java.text.Bidi;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RTL {
    private static final Map<Character, Character> MIRRORED_CHARS;

    private RTL() {
    }

    public static String checkRTL(String s) {
        char[] c = s.toCharArray();
        if (Bidi.requiresBidi(c, 0, c.length)) {
            try {
                return RTL.shapeRTLString(c);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    private static char mirroredChar(char c) {
        Character C2 = MIRRORED_CHARS.get(Character.valueOf(c));
        return C2 != null ? C2.charValue() : c;
    }

    private static String shapeRTLString(char[] c) throws Exception {
        Bidi bidi = new Bidi(c, 0, null, 0, c.length, -2);
        int runCount = bidi.getRunCount();
        byte[] levels = new byte[runCount];
        Object[] runs = new Integer[runCount];
        for (int i = 0; i < runCount; ++i) {
            levels[i] = (byte)bidi.getRunLevel(i);
            runs[i] = i;
        }
        Bidi.reorderVisually(levels, 0, runs, 0, runCount);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < runCount; ++i) {
            int j;
            int runIdx = (Integer)runs[i];
            int start = bidi.getRunStart(runIdx);
            int end = bidi.getRunLimit(runIdx);
            char[] c2 = new char[end - start];
            int ret = ArabicLigaturizer.arabic_shape((char[])c, (int)start, (int)c2.length, (char[])c2, (int)0, (int)c2.length, (int)0);
            if ((levels[runIdx] & 1) == 1) {
                for (j = ret - 1; j >= 0; --j) {
                    sb.append(RTL.mirroredChar(c2[j]));
                }
                continue;
            }
            for (j = 0; j < ret; ++j) {
                sb.append(c2[j]);
            }
        }
        while (Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    static {
        HashMap<Character, Character> m = new HashMap<Character, Character>();
        m.put(Character.valueOf('('), Character.valueOf(')'));
        m.put(Character.valueOf(')'), Character.valueOf('('));
        m.put(Character.valueOf('<'), Character.valueOf('>'));
        m.put(Character.valueOf('>'), Character.valueOf('<'));
        m.put(Character.valueOf('['), Character.valueOf(']'));
        m.put(Character.valueOf(']'), Character.valueOf('['));
        m.put(Character.valueOf('{'), Character.valueOf('}'));
        m.put(Character.valueOf('}'), Character.valueOf('{'));
        m.put(Character.valueOf('\u00ab'), Character.valueOf('\u00bb'));
        m.put(Character.valueOf('\u00bb'), Character.valueOf('\u00ab'));
        m.put(Character.valueOf('\u0f3a'), Character.valueOf('\u0f3b'));
        m.put(Character.valueOf('\u0f3b'), Character.valueOf('\u0f3a'));
        m.put(Character.valueOf('\u0f3c'), Character.valueOf('\u0f3d'));
        m.put(Character.valueOf('\u0f3d'), Character.valueOf('\u0f3c'));
        m.put(Character.valueOf('\u169b'), Character.valueOf('\u169c'));
        m.put(Character.valueOf('\u169c'), Character.valueOf('\u169b'));
        m.put(Character.valueOf('\u2039'), Character.valueOf('\u203a'));
        m.put(Character.valueOf('\u203a'), Character.valueOf('\u2039'));
        m.put(Character.valueOf('\u2045'), Character.valueOf('\u2046'));
        m.put(Character.valueOf('\u2046'), Character.valueOf('\u2045'));
        m.put(Character.valueOf('\u207d'), Character.valueOf('\u207e'));
        m.put(Character.valueOf('\u207e'), Character.valueOf('\u207d'));
        m.put(Character.valueOf('\u208d'), Character.valueOf('\u208e'));
        m.put(Character.valueOf('\u208e'), Character.valueOf('\u208d'));
        m.put(Character.valueOf('\u2208'), Character.valueOf('\u220b'));
        m.put(Character.valueOf('\u2209'), Character.valueOf('\u220c'));
        m.put(Character.valueOf('\u220a'), Character.valueOf('\u220d'));
        m.put(Character.valueOf('\u220b'), Character.valueOf('\u2208'));
        m.put(Character.valueOf('\u220c'), Character.valueOf('\u2209'));
        m.put(Character.valueOf('\u220d'), Character.valueOf('\u220a'));
        m.put(Character.valueOf('\u2215'), Character.valueOf('\u29f5'));
        m.put(Character.valueOf('\u223c'), Character.valueOf('\u223d'));
        m.put(Character.valueOf('\u223d'), Character.valueOf('\u223c'));
        m.put(Character.valueOf('\u2243'), Character.valueOf('\u22cd'));
        m.put(Character.valueOf('\u2252'), Character.valueOf('\u2253'));
        m.put(Character.valueOf('\u2253'), Character.valueOf('\u2252'));
        m.put(Character.valueOf('\u2254'), Character.valueOf('\u2255'));
        m.put(Character.valueOf('\u2255'), Character.valueOf('\u2254'));
        m.put(Character.valueOf('\u2264'), Character.valueOf('\u2265'));
        m.put(Character.valueOf('\u2265'), Character.valueOf('\u2264'));
        m.put(Character.valueOf('\u2266'), Character.valueOf('\u2267'));
        m.put(Character.valueOf('\u2267'), Character.valueOf('\u2266'));
        m.put(Character.valueOf('\u2268'), Character.valueOf('\u2269'));
        m.put(Character.valueOf('\u2269'), Character.valueOf('\u2268'));
        m.put(Character.valueOf('\u226a'), Character.valueOf('\u226b'));
        m.put(Character.valueOf('\u226b'), Character.valueOf('\u226a'));
        m.put(Character.valueOf('\u226e'), Character.valueOf('\u226f'));
        m.put(Character.valueOf('\u226f'), Character.valueOf('\u226e'));
        m.put(Character.valueOf('\u2270'), Character.valueOf('\u2271'));
        m.put(Character.valueOf('\u2271'), Character.valueOf('\u2270'));
        m.put(Character.valueOf('\u2272'), Character.valueOf('\u2273'));
        m.put(Character.valueOf('\u2273'), Character.valueOf('\u2272'));
        m.put(Character.valueOf('\u2274'), Character.valueOf('\u2275'));
        m.put(Character.valueOf('\u2275'), Character.valueOf('\u2274'));
        m.put(Character.valueOf('\u2276'), Character.valueOf('\u2277'));
        m.put(Character.valueOf('\u2277'), Character.valueOf('\u2276'));
        m.put(Character.valueOf('\u2278'), Character.valueOf('\u2279'));
        m.put(Character.valueOf('\u2279'), Character.valueOf('\u2278'));
        m.put(Character.valueOf('\u227a'), Character.valueOf('\u227b'));
        m.put(Character.valueOf('\u227b'), Character.valueOf('\u227a'));
        m.put(Character.valueOf('\u227c'), Character.valueOf('\u227d'));
        m.put(Character.valueOf('\u227d'), Character.valueOf('\u227c'));
        m.put(Character.valueOf('\u227e'), Character.valueOf('\u227f'));
        m.put(Character.valueOf('\u227f'), Character.valueOf('\u227e'));
        m.put(Character.valueOf('\u2280'), Character.valueOf('\u2281'));
        m.put(Character.valueOf('\u2281'), Character.valueOf('\u2280'));
        m.put(Character.valueOf('\u2282'), Character.valueOf('\u2283'));
        m.put(Character.valueOf('\u2283'), Character.valueOf('\u2282'));
        m.put(Character.valueOf('\u2284'), Character.valueOf('\u2285'));
        m.put(Character.valueOf('\u2285'), Character.valueOf('\u2284'));
        m.put(Character.valueOf('\u2286'), Character.valueOf('\u2287'));
        m.put(Character.valueOf('\u2287'), Character.valueOf('\u2286'));
        m.put(Character.valueOf('\u2288'), Character.valueOf('\u2289'));
        m.put(Character.valueOf('\u2289'), Character.valueOf('\u2288'));
        m.put(Character.valueOf('\u228a'), Character.valueOf('\u228b'));
        m.put(Character.valueOf('\u228b'), Character.valueOf('\u228a'));
        m.put(Character.valueOf('\u228f'), Character.valueOf('\u2290'));
        m.put(Character.valueOf('\u2290'), Character.valueOf('\u228f'));
        m.put(Character.valueOf('\u2291'), Character.valueOf('\u2292'));
        m.put(Character.valueOf('\u2292'), Character.valueOf('\u2291'));
        m.put(Character.valueOf('\u2298'), Character.valueOf('\u29b8'));
        m.put(Character.valueOf('\u22a2'), Character.valueOf('\u22a3'));
        m.put(Character.valueOf('\u22a3'), Character.valueOf('\u22a2'));
        m.put(Character.valueOf('\u22a6'), Character.valueOf('\u2ade'));
        m.put(Character.valueOf('\u22a8'), Character.valueOf('\u2ae4'));
        m.put(Character.valueOf('\u22a9'), Character.valueOf('\u2ae3'));
        m.put(Character.valueOf('\u22ab'), Character.valueOf('\u2ae5'));
        m.put(Character.valueOf('\u22b0'), Character.valueOf('\u22b1'));
        m.put(Character.valueOf('\u22b1'), Character.valueOf('\u22b0'));
        m.put(Character.valueOf('\u22b2'), Character.valueOf('\u22b3'));
        m.put(Character.valueOf('\u22b3'), Character.valueOf('\u22b2'));
        m.put(Character.valueOf('\u22b4'), Character.valueOf('\u22b5'));
        m.put(Character.valueOf('\u22b5'), Character.valueOf('\u22b4'));
        m.put(Character.valueOf('\u22b6'), Character.valueOf('\u22b7'));
        m.put(Character.valueOf('\u22b7'), Character.valueOf('\u22b6'));
        m.put(Character.valueOf('\u22c9'), Character.valueOf('\u22ca'));
        m.put(Character.valueOf('\u22ca'), Character.valueOf('\u22c9'));
        m.put(Character.valueOf('\u22cb'), Character.valueOf('\u22cc'));
        m.put(Character.valueOf('\u22cc'), Character.valueOf('\u22cb'));
        m.put(Character.valueOf('\u22cd'), Character.valueOf('\u2243'));
        m.put(Character.valueOf('\u22d0'), Character.valueOf('\u22d1'));
        m.put(Character.valueOf('\u22d1'), Character.valueOf('\u22d0'));
        m.put(Character.valueOf('\u22d6'), Character.valueOf('\u22d7'));
        m.put(Character.valueOf('\u22d7'), Character.valueOf('\u22d6'));
        m.put(Character.valueOf('\u22d8'), Character.valueOf('\u22d9'));
        m.put(Character.valueOf('\u22d9'), Character.valueOf('\u22d8'));
        m.put(Character.valueOf('\u22da'), Character.valueOf('\u22db'));
        m.put(Character.valueOf('\u22db'), Character.valueOf('\u22da'));
        m.put(Character.valueOf('\u22dc'), Character.valueOf('\u22dd'));
        m.put(Character.valueOf('\u22dd'), Character.valueOf('\u22dc'));
        m.put(Character.valueOf('\u22de'), Character.valueOf('\u22df'));
        m.put(Character.valueOf('\u22df'), Character.valueOf('\u22de'));
        m.put(Character.valueOf('\u22e0'), Character.valueOf('\u22e1'));
        m.put(Character.valueOf('\u22e1'), Character.valueOf('\u22e0'));
        m.put(Character.valueOf('\u22e2'), Character.valueOf('\u22e3'));
        m.put(Character.valueOf('\u22e3'), Character.valueOf('\u22e2'));
        m.put(Character.valueOf('\u22e4'), Character.valueOf('\u22e5'));
        m.put(Character.valueOf('\u22e5'), Character.valueOf('\u22e4'));
        m.put(Character.valueOf('\u22e6'), Character.valueOf('\u22e7'));
        m.put(Character.valueOf('\u22e7'), Character.valueOf('\u22e6'));
        m.put(Character.valueOf('\u22e8'), Character.valueOf('\u22e9'));
        m.put(Character.valueOf('\u22e9'), Character.valueOf('\u22e8'));
        m.put(Character.valueOf('\u22ea'), Character.valueOf('\u22eb'));
        m.put(Character.valueOf('\u22eb'), Character.valueOf('\u22ea'));
        m.put(Character.valueOf('\u22ec'), Character.valueOf('\u22ed'));
        m.put(Character.valueOf('\u22ed'), Character.valueOf('\u22ec'));
        m.put(Character.valueOf('\u22f0'), Character.valueOf('\u22f1'));
        m.put(Character.valueOf('\u22f1'), Character.valueOf('\u22f0'));
        m.put(Character.valueOf('\u22f2'), Character.valueOf('\u22fa'));
        m.put(Character.valueOf('\u22f3'), Character.valueOf('\u22fb'));
        m.put(Character.valueOf('\u22f4'), Character.valueOf('\u22fc'));
        m.put(Character.valueOf('\u22f6'), Character.valueOf('\u22fd'));
        m.put(Character.valueOf('\u22f7'), Character.valueOf('\u22fe'));
        m.put(Character.valueOf('\u22fa'), Character.valueOf('\u22f2'));
        m.put(Character.valueOf('\u22fb'), Character.valueOf('\u22f3'));
        m.put(Character.valueOf('\u22fc'), Character.valueOf('\u22f4'));
        m.put(Character.valueOf('\u22fd'), Character.valueOf('\u22f6'));
        m.put(Character.valueOf('\u22fe'), Character.valueOf('\u22f7'));
        m.put(Character.valueOf('\u2308'), Character.valueOf('\u2309'));
        m.put(Character.valueOf('\u2309'), Character.valueOf('\u2308'));
        m.put(Character.valueOf('\u230a'), Character.valueOf('\u230b'));
        m.put(Character.valueOf('\u230b'), Character.valueOf('\u230a'));
        m.put(Character.valueOf('\u2329'), Character.valueOf('\u232a'));
        m.put(Character.valueOf('\u232a'), Character.valueOf('\u2329'));
        m.put(Character.valueOf('\u2768'), Character.valueOf('\u2769'));
        m.put(Character.valueOf('\u2769'), Character.valueOf('\u2768'));
        m.put(Character.valueOf('\u276a'), Character.valueOf('\u276b'));
        m.put(Character.valueOf('\u276b'), Character.valueOf('\u276a'));
        m.put(Character.valueOf('\u276c'), Character.valueOf('\u276d'));
        m.put(Character.valueOf('\u276d'), Character.valueOf('\u276c'));
        m.put(Character.valueOf('\u276e'), Character.valueOf('\u276f'));
        m.put(Character.valueOf('\u276f'), Character.valueOf('\u276e'));
        m.put(Character.valueOf('\u2770'), Character.valueOf('\u2771'));
        m.put(Character.valueOf('\u2771'), Character.valueOf('\u2770'));
        m.put(Character.valueOf('\u2772'), Character.valueOf('\u2773'));
        m.put(Character.valueOf('\u2773'), Character.valueOf('\u2772'));
        m.put(Character.valueOf('\u2774'), Character.valueOf('\u2775'));
        m.put(Character.valueOf('\u2775'), Character.valueOf('\u2774'));
        m.put(Character.valueOf('\u27c3'), Character.valueOf('\u27c4'));
        m.put(Character.valueOf('\u27c4'), Character.valueOf('\u27c3'));
        m.put(Character.valueOf('\u27c5'), Character.valueOf('\u27c6'));
        m.put(Character.valueOf('\u27c6'), Character.valueOf('\u27c5'));
        m.put(Character.valueOf('\u27c8'), Character.valueOf('\u27c9'));
        m.put(Character.valueOf('\u27c9'), Character.valueOf('\u27c8'));
        m.put(Character.valueOf('\u27cb'), Character.valueOf('\u27cd'));
        m.put(Character.valueOf('\u27cd'), Character.valueOf('\u27cb'));
        m.put(Character.valueOf('\u27d5'), Character.valueOf('\u27d6'));
        m.put(Character.valueOf('\u27d6'), Character.valueOf('\u27d5'));
        m.put(Character.valueOf('\u27dd'), Character.valueOf('\u27de'));
        m.put(Character.valueOf('\u27de'), Character.valueOf('\u27dd'));
        m.put(Character.valueOf('\u27e2'), Character.valueOf('\u27e3'));
        m.put(Character.valueOf('\u27e3'), Character.valueOf('\u27e2'));
        m.put(Character.valueOf('\u27e4'), Character.valueOf('\u27e5'));
        m.put(Character.valueOf('\u27e5'), Character.valueOf('\u27e4'));
        m.put(Character.valueOf('\u27e6'), Character.valueOf('\u27e7'));
        m.put(Character.valueOf('\u27e7'), Character.valueOf('\u27e6'));
        m.put(Character.valueOf('\u27e8'), Character.valueOf('\u27e9'));
        m.put(Character.valueOf('\u27e9'), Character.valueOf('\u27e8'));
        m.put(Character.valueOf('\u27ea'), Character.valueOf('\u27eb'));
        m.put(Character.valueOf('\u27eb'), Character.valueOf('\u27ea'));
        m.put(Character.valueOf('\u27ec'), Character.valueOf('\u27ed'));
        m.put(Character.valueOf('\u27ed'), Character.valueOf('\u27ec'));
        m.put(Character.valueOf('\u27ee'), Character.valueOf('\u27ef'));
        m.put(Character.valueOf('\u27ef'), Character.valueOf('\u27ee'));
        m.put(Character.valueOf('\u2983'), Character.valueOf('\u2984'));
        m.put(Character.valueOf('\u2984'), Character.valueOf('\u2983'));
        m.put(Character.valueOf('\u2985'), Character.valueOf('\u2986'));
        m.put(Character.valueOf('\u2986'), Character.valueOf('\u2985'));
        m.put(Character.valueOf('\u2987'), Character.valueOf('\u2988'));
        m.put(Character.valueOf('\u2988'), Character.valueOf('\u2987'));
        m.put(Character.valueOf('\u2989'), Character.valueOf('\u298a'));
        m.put(Character.valueOf('\u298a'), Character.valueOf('\u2989'));
        m.put(Character.valueOf('\u298b'), Character.valueOf('\u298c'));
        m.put(Character.valueOf('\u298c'), Character.valueOf('\u298b'));
        m.put(Character.valueOf('\u298d'), Character.valueOf('\u2990'));
        m.put(Character.valueOf('\u298e'), Character.valueOf('\u298f'));
        m.put(Character.valueOf('\u298f'), Character.valueOf('\u298e'));
        m.put(Character.valueOf('\u2990'), Character.valueOf('\u298d'));
        m.put(Character.valueOf('\u2991'), Character.valueOf('\u2992'));
        m.put(Character.valueOf('\u2992'), Character.valueOf('\u2991'));
        m.put(Character.valueOf('\u2993'), Character.valueOf('\u2994'));
        m.put(Character.valueOf('\u2994'), Character.valueOf('\u2993'));
        m.put(Character.valueOf('\u2995'), Character.valueOf('\u2996'));
        m.put(Character.valueOf('\u2996'), Character.valueOf('\u2995'));
        m.put(Character.valueOf('\u2997'), Character.valueOf('\u2998'));
        m.put(Character.valueOf('\u2998'), Character.valueOf('\u2997'));
        m.put(Character.valueOf('\u29b8'), Character.valueOf('\u2298'));
        m.put(Character.valueOf('\u29c0'), Character.valueOf('\u29c1'));
        m.put(Character.valueOf('\u29c1'), Character.valueOf('\u29c0'));
        m.put(Character.valueOf('\u29c4'), Character.valueOf('\u29c5'));
        m.put(Character.valueOf('\u29c5'), Character.valueOf('\u29c4'));
        m.put(Character.valueOf('\u29cf'), Character.valueOf('\u29d0'));
        m.put(Character.valueOf('\u29d0'), Character.valueOf('\u29cf'));
        m.put(Character.valueOf('\u29d1'), Character.valueOf('\u29d2'));
        m.put(Character.valueOf('\u29d2'), Character.valueOf('\u29d1'));
        m.put(Character.valueOf('\u29d4'), Character.valueOf('\u29d5'));
        m.put(Character.valueOf('\u29d5'), Character.valueOf('\u29d4'));
        m.put(Character.valueOf('\u29d8'), Character.valueOf('\u29d9'));
        m.put(Character.valueOf('\u29d9'), Character.valueOf('\u29d8'));
        m.put(Character.valueOf('\u29da'), Character.valueOf('\u29db'));
        m.put(Character.valueOf('\u29db'), Character.valueOf('\u29da'));
        m.put(Character.valueOf('\u29f5'), Character.valueOf('\u2215'));
        m.put(Character.valueOf('\u29f8'), Character.valueOf('\u29f9'));
        m.put(Character.valueOf('\u29f9'), Character.valueOf('\u29f8'));
        m.put(Character.valueOf('\u29fc'), Character.valueOf('\u29fd'));
        m.put(Character.valueOf('\u29fd'), Character.valueOf('\u29fc'));
        m.put(Character.valueOf('\u2a2b'), Character.valueOf('\u2a2c'));
        m.put(Character.valueOf('\u2a2c'), Character.valueOf('\u2a2b'));
        m.put(Character.valueOf('\u2a2d'), Character.valueOf('\u2a2e'));
        m.put(Character.valueOf('\u2a2e'), Character.valueOf('\u2a2d'));
        m.put(Character.valueOf('\u2a34'), Character.valueOf('\u2a35'));
        m.put(Character.valueOf('\u2a35'), Character.valueOf('\u2a34'));
        m.put(Character.valueOf('\u2a3c'), Character.valueOf('\u2a3d'));
        m.put(Character.valueOf('\u2a3d'), Character.valueOf('\u2a3c'));
        m.put(Character.valueOf('\u2a64'), Character.valueOf('\u2a65'));
        m.put(Character.valueOf('\u2a65'), Character.valueOf('\u2a64'));
        m.put(Character.valueOf('\u2a79'), Character.valueOf('\u2a7a'));
        m.put(Character.valueOf('\u2a7a'), Character.valueOf('\u2a79'));
        m.put(Character.valueOf('\u2a7d'), Character.valueOf('\u2a7e'));
        m.put(Character.valueOf('\u2a7e'), Character.valueOf('\u2a7d'));
        m.put(Character.valueOf('\u2a7f'), Character.valueOf('\u2a80'));
        m.put(Character.valueOf('\u2a80'), Character.valueOf('\u2a7f'));
        m.put(Character.valueOf('\u2a81'), Character.valueOf('\u2a82'));
        m.put(Character.valueOf('\u2a82'), Character.valueOf('\u2a81'));
        m.put(Character.valueOf('\u2a83'), Character.valueOf('\u2a84'));
        m.put(Character.valueOf('\u2a84'), Character.valueOf('\u2a83'));
        m.put(Character.valueOf('\u2a8b'), Character.valueOf('\u2a8c'));
        m.put(Character.valueOf('\u2a8c'), Character.valueOf('\u2a8b'));
        m.put(Character.valueOf('\u2a91'), Character.valueOf('\u2a92'));
        m.put(Character.valueOf('\u2a92'), Character.valueOf('\u2a91'));
        m.put(Character.valueOf('\u2a93'), Character.valueOf('\u2a94'));
        m.put(Character.valueOf('\u2a94'), Character.valueOf('\u2a93'));
        m.put(Character.valueOf('\u2a95'), Character.valueOf('\u2a96'));
        m.put(Character.valueOf('\u2a96'), Character.valueOf('\u2a95'));
        m.put(Character.valueOf('\u2a97'), Character.valueOf('\u2a98'));
        m.put(Character.valueOf('\u2a98'), Character.valueOf('\u2a97'));
        m.put(Character.valueOf('\u2a99'), Character.valueOf('\u2a9a'));
        m.put(Character.valueOf('\u2a9a'), Character.valueOf('\u2a99'));
        m.put(Character.valueOf('\u2a9b'), Character.valueOf('\u2a9c'));
        m.put(Character.valueOf('\u2a9c'), Character.valueOf('\u2a9b'));
        m.put(Character.valueOf('\u2aa1'), Character.valueOf('\u2aa2'));
        m.put(Character.valueOf('\u2aa2'), Character.valueOf('\u2aa1'));
        m.put(Character.valueOf('\u2aa6'), Character.valueOf('\u2aa7'));
        m.put(Character.valueOf('\u2aa7'), Character.valueOf('\u2aa6'));
        m.put(Character.valueOf('\u2aa8'), Character.valueOf('\u2aa9'));
        m.put(Character.valueOf('\u2aa9'), Character.valueOf('\u2aa8'));
        m.put(Character.valueOf('\u2aaa'), Character.valueOf('\u2aab'));
        m.put(Character.valueOf('\u2aab'), Character.valueOf('\u2aaa'));
        m.put(Character.valueOf('\u2aac'), Character.valueOf('\u2aad'));
        m.put(Character.valueOf('\u2aad'), Character.valueOf('\u2aac'));
        m.put(Character.valueOf('\u2aaf'), Character.valueOf('\u2ab0'));
        m.put(Character.valueOf('\u2ab0'), Character.valueOf('\u2aaf'));
        m.put(Character.valueOf('\u2ab3'), Character.valueOf('\u2ab4'));
        m.put(Character.valueOf('\u2ab4'), Character.valueOf('\u2ab3'));
        m.put(Character.valueOf('\u2abb'), Character.valueOf('\u2abc'));
        m.put(Character.valueOf('\u2abc'), Character.valueOf('\u2abb'));
        m.put(Character.valueOf('\u2abd'), Character.valueOf('\u2abe'));
        m.put(Character.valueOf('\u2abe'), Character.valueOf('\u2abd'));
        m.put(Character.valueOf('\u2abf'), Character.valueOf('\u2ac0'));
        m.put(Character.valueOf('\u2ac0'), Character.valueOf('\u2abf'));
        m.put(Character.valueOf('\u2ac1'), Character.valueOf('\u2ac2'));
        m.put(Character.valueOf('\u2ac2'), Character.valueOf('\u2ac1'));
        m.put(Character.valueOf('\u2ac3'), Character.valueOf('\u2ac4'));
        m.put(Character.valueOf('\u2ac4'), Character.valueOf('\u2ac3'));
        m.put(Character.valueOf('\u2ac5'), Character.valueOf('\u2ac6'));
        m.put(Character.valueOf('\u2ac6'), Character.valueOf('\u2ac5'));
        m.put(Character.valueOf('\u2acd'), Character.valueOf('\u2ace'));
        m.put(Character.valueOf('\u2ace'), Character.valueOf('\u2acd'));
        m.put(Character.valueOf('\u2acf'), Character.valueOf('\u2ad0'));
        m.put(Character.valueOf('\u2ad0'), Character.valueOf('\u2acf'));
        m.put(Character.valueOf('\u2ad1'), Character.valueOf('\u2ad2'));
        m.put(Character.valueOf('\u2ad2'), Character.valueOf('\u2ad1'));
        m.put(Character.valueOf('\u2ad3'), Character.valueOf('\u2ad4'));
        m.put(Character.valueOf('\u2ad4'), Character.valueOf('\u2ad3'));
        m.put(Character.valueOf('\u2ad5'), Character.valueOf('\u2ad6'));
        m.put(Character.valueOf('\u2ad6'), Character.valueOf('\u2ad5'));
        m.put(Character.valueOf('\u2ade'), Character.valueOf('\u22a6'));
        m.put(Character.valueOf('\u2ae3'), Character.valueOf('\u22a9'));
        m.put(Character.valueOf('\u2ae4'), Character.valueOf('\u22a8'));
        m.put(Character.valueOf('\u2ae5'), Character.valueOf('\u22ab'));
        m.put(Character.valueOf('\u2aec'), Character.valueOf('\u2aed'));
        m.put(Character.valueOf('\u2aed'), Character.valueOf('\u2aec'));
        m.put(Character.valueOf('\u2af7'), Character.valueOf('\u2af8'));
        m.put(Character.valueOf('\u2af8'), Character.valueOf('\u2af7'));
        m.put(Character.valueOf('\u2af9'), Character.valueOf('\u2afa'));
        m.put(Character.valueOf('\u2afa'), Character.valueOf('\u2af9'));
        m.put(Character.valueOf('\u2e02'), Character.valueOf('\u2e03'));
        m.put(Character.valueOf('\u2e03'), Character.valueOf('\u2e02'));
        m.put(Character.valueOf('\u2e04'), Character.valueOf('\u2e05'));
        m.put(Character.valueOf('\u2e05'), Character.valueOf('\u2e04'));
        m.put(Character.valueOf('\u2e09'), Character.valueOf('\u2e0a'));
        m.put(Character.valueOf('\u2e0a'), Character.valueOf('\u2e09'));
        m.put(Character.valueOf('\u2e0c'), Character.valueOf('\u2e0d'));
        m.put(Character.valueOf('\u2e0d'), Character.valueOf('\u2e0c'));
        m.put(Character.valueOf('\u2e1c'), Character.valueOf('\u2e1d'));
        m.put(Character.valueOf('\u2e1d'), Character.valueOf('\u2e1c'));
        m.put(Character.valueOf('\u2e20'), Character.valueOf('\u2e21'));
        m.put(Character.valueOf('\u2e21'), Character.valueOf('\u2e20'));
        m.put(Character.valueOf('\u2e22'), Character.valueOf('\u2e23'));
        m.put(Character.valueOf('\u2e23'), Character.valueOf('\u2e22'));
        m.put(Character.valueOf('\u2e24'), Character.valueOf('\u2e25'));
        m.put(Character.valueOf('\u2e25'), Character.valueOf('\u2e24'));
        m.put(Character.valueOf('\u2e26'), Character.valueOf('\u2e27'));
        m.put(Character.valueOf('\u2e27'), Character.valueOf('\u2e26'));
        m.put(Character.valueOf('\u2e28'), Character.valueOf('\u2e29'));
        m.put(Character.valueOf('\u2e29'), Character.valueOf('\u2e28'));
        m.put(Character.valueOf('\u3008'), Character.valueOf('\u3009'));
        m.put(Character.valueOf('\u3009'), Character.valueOf('\u3008'));
        m.put(Character.valueOf('\u300a'), Character.valueOf('\u300b'));
        m.put(Character.valueOf('\u300b'), Character.valueOf('\u300a'));
        m.put(Character.valueOf('\u300c'), Character.valueOf('\u300d'));
        m.put(Character.valueOf('\u300d'), Character.valueOf('\u300c'));
        m.put(Character.valueOf('\u300e'), Character.valueOf('\u300f'));
        m.put(Character.valueOf('\u300f'), Character.valueOf('\u300e'));
        m.put(Character.valueOf('\u3010'), Character.valueOf('\u3011'));
        m.put(Character.valueOf('\u3011'), Character.valueOf('\u3010'));
        m.put(Character.valueOf('\u3014'), Character.valueOf('\u3015'));
        m.put(Character.valueOf('\u3015'), Character.valueOf('\u3014'));
        m.put(Character.valueOf('\u3016'), Character.valueOf('\u3017'));
        m.put(Character.valueOf('\u3017'), Character.valueOf('\u3016'));
        m.put(Character.valueOf('\u3018'), Character.valueOf('\u3019'));
        m.put(Character.valueOf('\u3019'), Character.valueOf('\u3018'));
        m.put(Character.valueOf('\u301a'), Character.valueOf('\u301b'));
        m.put(Character.valueOf('\u301b'), Character.valueOf('\u301a'));
        m.put(Character.valueOf('\ufe59'), Character.valueOf('\ufe5a'));
        m.put(Character.valueOf('\ufe5a'), Character.valueOf('\ufe59'));
        m.put(Character.valueOf('\ufe5b'), Character.valueOf('\ufe5c'));
        m.put(Character.valueOf('\ufe5c'), Character.valueOf('\ufe5b'));
        m.put(Character.valueOf('\ufe5d'), Character.valueOf('\ufe5e'));
        m.put(Character.valueOf('\ufe5e'), Character.valueOf('\ufe5d'));
        m.put(Character.valueOf('\ufe64'), Character.valueOf('\ufe65'));
        m.put(Character.valueOf('\ufe65'), Character.valueOf('\ufe64'));
        m.put(Character.valueOf('\uff08'), Character.valueOf('\uff09'));
        m.put(Character.valueOf('\uff09'), Character.valueOf('\uff08'));
        m.put(Character.valueOf('\uff1c'), Character.valueOf('\uff1e'));
        m.put(Character.valueOf('\uff1e'), Character.valueOf('\uff1c'));
        m.put(Character.valueOf('\uff3b'), Character.valueOf('\uff3d'));
        m.put(Character.valueOf('\uff3d'), Character.valueOf('\uff3b'));
        m.put(Character.valueOf('\uff5b'), Character.valueOf('\uff5d'));
        m.put(Character.valueOf('\uff5d'), Character.valueOf('\uff5b'));
        m.put(Character.valueOf('\uff5f'), Character.valueOf('\uff60'));
        m.put(Character.valueOf('\uff60'), Character.valueOf('\uff5f'));
        m.put(Character.valueOf('\uff62'), Character.valueOf('\uff63'));
        m.put(Character.valueOf('\uff63'), Character.valueOf('\uff62'));
        MIRRORED_CHARS = Collections.unmodifiableMap(m);
    }
}

