/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.math.BigCobolDec;
import com.iscobol.math.BigCobolInt;
import com.iscobol.rts.DivideByZeroException;
import com.iscobol.rts.Factory;
import com.iscobol.rts.Memory;
import com.iscobol.types.CobolDouble;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVP18;
import com.iscobol.types.PicDisplay;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CobolVP31
extends CobolNum {
    private BigCobolDec bigDecValue;
    private static boolean[] dummy = new boolean[1];

    CobolVP31(BigCobolDec val) {
        super((byte)1);
        this.bigDecValue = val;
    }

    CobolVP31(BigDecimal val) {
        super((byte)1);
        this.bigDecValue = new BigCobolDec(val.unscaledValue().toByteArray(), true, val.scale());
    }

    CobolVP31(BigInteger val) {
        super((byte)1);
        this.bigDecValue = new BigCobolDec(val.toByteArray(), true, 0);
    }

    @Override
    public float floatValue() {
        return this.bigDecValue.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.bigDecValue.doubleValue();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return new BigDecimal(new BigInteger(this.bigDecValue.toByteArray()), this.bigDecValue.scale());
    }

    @Override
    public BigCobolDec bigCobDecValue() {
        return this.bigDecValue;
    }

    @Override
    public CobolNum set(long nLong, int nScale, boolean rounding) {
        this.bigDecValue = new BigCobolDec(nLong, nScale);
        return this;
    }

    @Override
    public CobolNum set(BigCobolDec bd) {
        this.bigDecValue = new BigCobolDec(bd);
        return this;
    }

    @Override
    public CobolNum set(double db) {
        this.bigDecValue = new BigCobolDec(db);
        return this;
    }

    @Override
    public CobolNum set(float fl) {
        this.bigDecValue = new BigCobolDec(fl);
        return this;
    }

    @Override
    public CobolNum set(CobolNum val, boolean rounded, boolean lenInBytes) {
        if (rounded) {
            this.bigDecValue = val.bigCobDecValue().setScale(this.bigDecValue.scale(), 1);
            return this;
        }
        return this.set(val.bigCobDecValue());
    }

    @Override
    public CobolNum add(CobolNum val) {
        switch (val.type) {
            case 0: {
                return this.addBd(this.bigDecValue, new BigCobolDec(val.lnUnscValue, val.scale()));
            }
            case 2: 
            case 3: {
                return new CobolDouble(this.bigDecValue.doubleValue() + val.doubleValue());
            }
            case 1: {
                return this.addBd(this.bigDecValue, val.bigCobDecValue());
            }
        }
        return null;
    }

    @Override
    public void addToMe(short i) {
        this.bigDecValue = this.bigDecValue.add(BigCobolDec.valueOf(i));
    }

    @Override
    public void subFromMe(short i) {
        this.bigDecValue = this.bigDecValue.subtract(BigCobolDec.valueOf(i));
    }

    @Override
    public void multiplyByMe(short i) {
        this.bigDecValue = this.bigDecValue.multiply(BigCobolDec.valueOf(i));
    }

    @Override
    public void divideIntoMe(boolean checkdivbyzero, short i) {
        if (i == 0) {
            this.divideIntoMeByZero(checkdivbyzero);
        } else {
            this.bigDecValue = this.bigDecValue.divide(BigCobolDec.valueOf(i), 0);
        }
    }

    @Override
    public void divideIntoMeByZero(boolean checkdivbyzero) throws DivideByZeroException {
        int v = checkdivbyzero ? CHECKDIV_PROPERTY : 0;
        switch (v) {
            default: {
                this.bigDecValue = OVERFLOW_BD;
                break;
            }
            case 1: {
                throw new DivideByZeroException();
            }
            case 2: {
                this.bigDecValue = new BigCobolDec();
                break;
            }
            case 3: {
                break;
            }
            case -1: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumend undefined result");
                this.bigDecValue = OVERFLOW_BD;
                break;
            }
            case -2: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed result is 0");
                this.bigDecValue = new BigCobolDec();
                break;
            }
            case -3: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed divide by 1");
            }
        }
    }

    @Override
    public void addToMe(int i) {
        this.bigDecValue = this.bigDecValue.add(BigCobolDec.valueOf(i));
    }

    @Override
    public void subFromMe(int i) {
        this.bigDecValue = this.bigDecValue.subtract(BigCobolDec.valueOf(i));
    }

    @Override
    public void multiplyByMe(int i) {
        this.bigDecValue = this.bigDecValue.multiply(BigCobolDec.valueOf(i));
    }

    @Override
    public void divideIntoMe(boolean checkdivbyzero, int i) {
        if (i == 0) {
            this.divideIntoMeByZero(checkdivbyzero);
        } else {
            this.bigDecValue = this.bigDecValue.divide(BigCobolDec.valueOf(i), 0);
        }
    }

    @Override
    public void addToMe(long i) {
        this.bigDecValue = this.bigDecValue.add(BigCobolDec.valueOf(i));
    }

    @Override
    public void subFromMe(long i) {
        this.bigDecValue = this.bigDecValue.subtract(BigCobolDec.valueOf(i));
    }

    @Override
    public void multiplyByMe(long i) {
        this.bigDecValue = this.bigDecValue.multiply(BigCobolDec.valueOf(i));
    }

    @Override
    public void divideIntoMe(boolean checkdivbyzero, long i) {
        if (i == 0L) {
            this.divideIntoMeByZero(checkdivbyzero);
        } else {
            this.bigDecValue = this.bigDecValue.divide(BigCobolDec.valueOf(i), 0);
        }
    }

    @Override
    public CobolNum add1() {
        return this.addBd(this.bigDecValue, BigCobolDec.valueOf(1L));
    }

    @Override
    public CobolNum subtract(CobolNum val) {
        switch (val.type) {
            case 0: {
                return this.addBd(this.bigDecValue, new BigCobolDec(-((CobolVP18)val).lnUnscValue, ((CobolVP18)val).scale()));
            }
            case 2: 
            case 3: {
                return new CobolDouble(this.bigDecValue.doubleValue() - val.doubleValue());
            }
            case 1: {
                return this.addBd(this.bigDecValue, val.bigCobDecValue().negate());
            }
        }
        return null;
    }

    @Override
    public CobolNum subtract1() {
        return this.addBd(this.bigDecValue, BigCobolDec.valueOf(-1L));
    }

    @Override
    public CobolNum multiply(CobolNum val) {
        switch (val.type) {
            case 0: 
            case 1: {
                return this.multiplyBd(this.bigDecValue, val.bigCobDecValue());
            }
            case 2: 
            case 3: {
                return new CobolDouble(this.bigDecValue.doubleValue() * val.doubleValue());
            }
        }
        return null;
    }

    @Override
    public CobolNum multiply36(CobolNum val) {
        return this.multiplyBd(this.bigCobDecValue(), val.bigCobDecValue());
    }

    @Override
    public CobolNum divide(boolean checkdivbyzero, CobolNum val, int scale, boolean rounding) {
        switch (val.type) {
            case 0: {
                return CobolVP31.divideBd(checkdivbyzero, this.bigDecValue, val.bigCobDecValue(), scale, rounding);
            }
            case 2: 
            case 3: {
                return new CobolDouble(this.bigDecValue.doubleValue() / val.doubleValue());
            }
            case 1: {
                return CobolVP31.divideBd(checkdivbyzero, this.bigDecValue, val.bigCobDecValue(), scale, rounding);
            }
        }
        return null;
    }

    @Override
    public void toCobolByteArray(byte[] Return2, int len, byte[] encoded_digits) {
        this.bigDecValue.toCobolByteArray(Return2, len, encoded_digits);
    }

    @Override
    public int toByteArray(byte[] Return2) {
        return this.bigDecValue.toByteArray(Return2, PicDisplay.encoded_digits);
    }

    @Override
    public boolean isOverflow(CobolNum dest, int destIntPart) {
        switch (dest.type) {
            case 0: 
            case 1: {
                return this.bigDecValue.precision() - this.bigDecValue.scale() > destIntPart;
            }
            case 2: 
            case 3: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isOverflowByte(CobolNum dest, int nBytes, boolean signed) {
        switch (dest.type) {
            case 0: 
            case 1: {
                BigCobolInt myFact = factBytesBigInt[nBytes][signed ? 1 : (nBytes == 8 ? 1 : 0)];
                BigCobolInt myBDV = this.bigDecValue;
                int scaleDiff = this.scale() - dest.scale();
                if (scaleDiff > 0) {
                    myBDV = new BigCobolInt(myBDV);
                    myBDV.shift(-scaleDiff);
                } else if (scaleDiff < 0) {
                    myFact = new BigCobolInt(myFact);
                    myFact.shift(scaleDiff);
                }
                return myBDV.absCompareTo(myFact) > 0;
            }
            case 2: 
            case 3: {
                return false;
            }
        }
        return false;
    }

    @Override
    public int compareTo(CobolNum val) {
        switch (val.type) {
            case 0: 
            case 1: {
                return this.compareBd(this.bigDecValue, val.bigCobDecValue());
            }
            case 3: {
                float fDiff = this.floatValue() - val.floatValue();
                if (fDiff < 0.0f) {
                    return -1;
                }
                if (fDiff > 0.0f) {
                    return 1;
                }
                return 0;
            }
            case 2: {
                double dDiff = this.doubleValue() - val.doubleValue();
                if (dDiff < 0.0) {
                    return -1;
                }
                if (dDiff > 0.0) {
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }

    @Override
    public int compareTo(long val, int scale) {
        return this.compareBd(this.bigDecValue, new BigCobolDec(val, scale));
    }

    @Override
    public long getUnscaledLong(boolean[] overflow) {
        long longVal = this.bigDecValue.setScale(0).unscaled18Digits(0);
        boolean bl = overflow[0] = this.bigDecValue.precision() > 18;
        if (!overflow[0]) {
            int sc = this.bigDecValue.scale();
            longVal = this.bigDecValue.unscaled18Digits(sc);
            if (sc < 0) {
                longVal *= fact[-sc];
            }
        }
        return longVal;
    }

    @Override
    public long getUnscaledLong() {
        return this.getUnscaledLong(dummy);
    }

    @Override
    public void toBinaryByteArray(Memory Return2, int start, int len) {
        byte[] bnum = this.bigDecValue.toByteArray();
        switch (this.bigDecValue.signum()) {
            case -1: {
                while (len > bnum.length) {
                    Return2.put(start++, (byte)-1);
                    --len;
                }
                break;
            }
            case 0: 
            case 1: {
                while (len > bnum.length) {
                    Return2.put(start++, (byte)0);
                    --len;
                }
                break;
            }
        }
        for (int i = bnum.length - len; i < bnum.length; ++i) {
            Return2.put(start++, bnum[i]);
        }
    }

    @Override
    public void toBinaryByteArray(byte[] Return2, int start, int len) {
        byte[] bnum = this.bigDecValue.toByteArray();
        switch (this.bigDecValue.signum()) {
            case -1: {
                while (len > bnum.length) {
                    Return2[start++] = -1;
                    --len;
                }
                break;
            }
            case 0: 
            case 1: {
                while (len > bnum.length) {
                    Return2[start++] = 0;
                    --len;
                }
                break;
            }
        }
        for (int i = bnum.length - len; i < bnum.length; ++i) {
            Return2[start++] = bnum[i];
        }
    }

    @Override
    public void setSizeDigit(int intPart, int decPart) {
        this.bigDecValue.narrowMe(intPart + decPart, decPart);
    }

    @Override
    public void setSizeByteUnsigned(int nBytes) {
        this.bigDecValue.andMe(factBytesBigInt[nBytes][0]);
    }

    @Override
    public void setSizeByteSigned(int nBytes) {
        this.bigDecValue.andMe(factBytesBigInt[nBytes][1]);
    }

    @Override
    public void setScale(int scale, boolean rounding, boolean lenInBytes) {
        this.bigDecValue = this.bigDecValue.setScale(scale, rounding ? 1 : 0);
    }

    @Override
    public final void roundUpIfNeeded(int scaleDiff) {
        this.bigDecValue.roundUpIfNeeded(scaleDiff);
    }

    @Override
    public int scale() {
        return this.bigDecValue.scale();
    }

    @Override
    public int precision() {
        return this.bigDecValue.precision();
    }

    @Override
    public int signum() {
        return this.bigDecValue.signum();
    }

    @Override
    public void negateMe() {
        this.bigDecValue = this.bigDecValue.negate();
    }

    @Override
    public CobolNum negate() {
        return new CobolVP31(this.bigDecValue.negate());
    }

    @Override
    public void shift(int tenExp) {
        this.bigDecValue.shift(tenExp);
    }

    @Override
    public String toString() {
        return this.bigDecValue.toString();
    }

    @Override
    public int shortValue() {
        return this.bigDecValue.shortValue();
    }

    @Override
    public int intValue() {
        return this.bigDecValue.intValue();
    }

    @Override
    public long longValue() {
        return this.bigDecValue.longValue();
    }

    @Override
    public int shortValue(boolean rounding) {
        if (rounding && this.bigDecValue.scale() > 0) {
            return this.bigDecValue.setScale(0, 1).shortValue();
        }
        return this.bigDecValue.shortValue();
    }

    @Override
    public int intValue(boolean rounding) {
        if (rounding && this.bigDecValue.scale() > 0) {
            return this.bigDecValue.setScale(0, 1).intValue();
        }
        return this.bigDecValue.intValue();
    }

    @Override
    public long longValue(boolean rounding) {
        if (rounding && this.bigDecValue.scale() > 0) {
            return this.bigDecValue.setScale(0, 1).longValue();
        }
        return this.bigDecValue.longValue();
    }

    @Override
    public CobolNum integerFunc() {
        BigCobolDec bval = this.bigDecValue.setScale(0);
        if (this.bigDecValue.isNegative() && this.bigDecValue.hasFractionalPart()) {
            bval.addToMe(BigCobolDec.valueOf(-1L));
        }
        return new CobolVP31(bval);
    }

    @Override
    public CobolNum integerPart() {
        return new CobolVP31(this.bigDecValue.setScale(0));
    }
}

