/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IPicN;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.types.CobolVar;
import com.iscobol.types.MemMan;
import com.iscobol.types.NumericLiteralAll;
import com.iscobol.types.NumericVar;
import com.iscobol.types.PicNAnyLength;
import com.iscobol.types.PicNumEdit;
import com.iscobol.types.PicX;
import com.iscobol.types.UTFEndian;

public class PicN
extends PicX
implements IPicN {
    private static final UTFEndian utfHandler = UTFEndian.noo();
    private static final char fillCh = ' ';
    private static final byte[] encoded_digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 46};
    private static final byte[] fillBA = utfHandler.charToByte(new char[]{' '}, new byte[2], 0, 1);
    private static final byte[] zeroBA = utfHandler.charToByte(new char[]{'0'}, new byte[2], 0, 1);
    private static final long serialVersionUID = 123L;

    static byte[] stringToByte(String s, byte[] b) {
        return PicN.stringToByte(s, b, 0, b.length);
    }

    static byte[] stringToByte(String s, byte[] b, int offset, int len) {
        return PicN.charToByte(s.toCharArray(), b, offset, len);
    }

    static byte[] charToByte(char[] c, byte[] b, int offset, int len) {
        return utfHandler.charToByte(c, b, offset, len);
    }

    public static char[] byteToChar(byte[] b, int offset, int len) {
        return utfHandler.byteToChar(b, offset, len);
    }

    public static PicN literalN(String str) {
        return new PicN(str);
    }

    public PicN(byte[] m, int i, int l, int[] dimSize, int[] dim, String n, boolean pComma, boolean isJust) {
        super(m, i, l, dimSize, dim, n, pComma, isJust);
    }

    public PicN(CobolVar par, int i, int l, int[] dimSize, int[] dim, String n, boolean pComma, boolean isJust) {
        super(par, i, l, dimSize, dim, n, pComma, isJust);
    }

    public PicN(String value) {
        super(PicN.stringToByte(value, new byte[value.length() * 2]));
        this.isFinal = true;
    }

    private static byte[] adjByte(byte[] val) {
        if (val.length == 1) {
            byte[] ret = new byte[2];
            ret[1] = val[0];
            ret[0] = ret[1] == -1 ? -1 : 0;
            utfHandler.swapByteArray(ret);
            return ret;
        }
        utfHandler.swapByteArray(val);
        return val;
    }

    public PicN(byte[] value) {
        super(PicN.adjByte(value));
        this.isFinal = true;
    }

    public PicN(int ch) {
        super(new byte[]{(byte)((ch & 0xFF00) >> 8), (byte)(ch & 0xFF)});
        this.isFinal = true;
    }

    @Override
    protected void set(NumericVar nv) {
        char[] srcC;
        int nvLen = nv.intLength() + nv.scale();
        int len = Math.max(this.getLength(), nvLen);
        if (nvLen < 0) {
            nvLen = len;
        }
        byte[] srcB = new byte[len];
        nv.num().toCobolByteArray(srcB, len, encoded_digits);
        int d = len - nvLen;
        if (d > 0) {
            if (this.isJustified) {
                int i;
                srcC = new char[len];
                for (i = 0; i < d; ++i) {
                    srcC[i] = 32;
                }
                while (i < len) {
                    srcC[i] = (char)srcB[i];
                    ++i;
                }
            } else {
                srcC = new char[nvLen];
                for (int i = 0; i < nvLen; ++i) {
                    srcC[i] = (char)srcB[i + d];
                }
            }
        } else {
            srcC = new char[len];
            for (int i = 0; i < len; ++i) {
                srcC[i] = (char)srcB[i];
            }
        }
        this.set(srcC, true);
    }

    @Override
    public boolean set(char[] value, boolean filling) {
        int bLen = value.length * 2;
        byte[] src = PicN.charToByte(value, new byte[bLen], 0, bLen);
        return this.set(src, 0, src.length, filling);
    }

    @Override
    public boolean set(String value, boolean filling) {
        return this.set(value.toCharArray(), filling);
    }

    @Override
    public boolean set(byte[] src, int srcStart, int srcLen, boolean filling) {
        int end = this.getEnd();
        int len = this.getLen();
        int diff = len - srcLen;
        if (this.isFinal) {
            return false;
        }
        if (diff <= 0) {
            if (this.isJustified) {
                Factory.myArraycopy(src, srcStart - diff, this.getMemory(), this.getOffset(), len);
            } else {
                Factory.myArraycopy(src, srcStart, this.getMemory(), this.getOffset(), len);
            }
        } else if (this.isJustified) {
            Factory.myArraycopy(src, srcStart, this.getMemory(), this.getOffset() + diff, srcLen);
            if (filling) {
                Factory.myFill(this.getMemory(), this.getOffset(), end - srcLen, fillBA);
            }
        } else {
            Factory.myArraycopy(src, srcStart, this.getMemory(), this.getOffset(), srcLen);
            if (filling) {
                Factory.myFill(this.getMemory(), this.getOffset() + srcLen, end, fillBA);
            }
        }
        return false;
    }

    @Override
    public void set(PicX px) {
        String val = px.toString();
        this.set(PicN.stringToByte(val, new byte[val.length() * 2]));
    }

    @Override
    public void set(PicNumEdit pe) {
        String val = pe.toString();
        this.set(PicN.stringToByte(val, new byte[val.length() * 2]));
    }

    public void set(PicN px) {
        super.set(px);
    }

    @Override
    public CobolVar moveTo(PicX dest) {
        dest.set(this.toString());
        return this;
    }

    @Override
    public int compareTo(NumericLiteralAll cfrt) {
        return -cfrt.compareTo(this);
    }

    @Override
    public int compareTo(CobolVar val) {
        int i;
        char[] val_mem;
        char[] mem = PicN.byteToChar(this.getMemory(), this.getOffset(), this.getLen());
        int minLen = mem.length <= (val_mem = val.toString().toCharArray()).length ? mem.length : val_mem.length;
        for (i = 0; i < minLen; ++i) {
            if (mem[i] == val_mem[i]) continue;
            return mem[i] - val_mem[i];
        }
        if (mem.length < val_mem.length) {
            while (i < val_mem.length) {
                if (' ' != val_mem[i]) {
                    return 32 - val_mem[i];
                }
                ++i;
            }
        } else {
            while (i < mem.length) {
                if (mem[i] != ' ') {
                    return mem[i] - 32;
                }
                ++i;
            }
        }
        return 0;
    }

    @Override
    public int compareTo(NumericVar nv) {
        return super.compareTo(new PicN(nv.basicToString()));
    }

    @Override
    public int compareTo(NumericLiteralAll cfrt, int[] collSeq) {
        return -cfrt.compareTo(this, collSeq);
    }

    @Override
    public int compareTo(CobolVar val, int[] collSeq) {
        return this.compareTo(val);
    }

    @Override
    public int compareTo(NumericVar nv, int[] collSeq) {
        return super.compareTo(new PicN(nv.basicToString()), collSeq);
    }

    @Override
    public String toString() {
        return new String(PicN.byteToChar(this.getMemory(), this.getOffset(), this.getLen()));
    }

    @Override
    public int getLength() {
        if (this.getMemory() == null) {
            return 0;
        }
        return this.getLen() / 2;
    }

    @Override
    public byte tobyte() {
        String s = this.toString();
        byte Return2 = s.length() > 0 ? (byte)s.charAt(0) : (byte)0;
        return Return2;
    }

    @Override
    public ICobolVar intISub(int start) {
        return this.subN(start);
    }

    @Override
    public ICobolVar intISub(int start, int subLen) {
        return this.subN(start, subLen);
    }

    @Override
    public PicN subN(int start) {
        return this.subN(start, this.getLen() / 2 - start + 1);
    }

    @Override
    public final PicN subN(int start, int subLen) {
        PicN Return2;
        int len = Math.min(this.getMemory().length, this.getLen()) / 2;
        if (this.checkSubLen(start, subLen, len) <= 0) {
            switch (substringCheck) {
                case 1: {
                    throw new IscobolRuntimeException(1, this.name + "(" + start + ":" + subLen + ") [" + len + "]");
                }
                case -1: {
                    Factory.log("CHECK SUBSTRING: detected index out of bound " + this.name + "(" + start + ":" + subLen + ") [" + len + "]");
                }
            }
        }
        if (start < 1) {
            start = 1;
        }
        if (!substr0lenAll && subLen <= 0) {
            Return2 = new PicN("");
        } else {
            if (subLen <= 0) {
                subLen = len - start + 1;
            } else if (!(this instanceof PicNAnyLength)) {
                int maxLen = Factory.substrUnbound ? (this.getMemory().length - this.getOffset()) / 2 : len;
                subLen = Math.max(0, Math.min(subLen, maxLen - start + 1));
            }
            Return2 = new PicN(this.getMemory(), this.getOffset() + (start - 1) * 2, subLen * 2, null, null, this.name, this.isDecPointComma, this.isJustified);
            Return2.memory = this.memory.isDynamic() ? new MemMan(this.getMemory()) : this.getMemMan();
        }
        return Return2;
    }

    @Override
    public void setSpace() {
        Factory.myFill(this.getMemory(), this.getOffset(), this.getEnd(), fillBA);
    }

    @Override
    public void setZero() {
        this.set('0');
    }

    @Override
    public void setAllZero() {
        Factory.myFill(this.getMemory(), this.getOffset(), this.getEnd(), zeroBA);
    }

    @Override
    public String basicToString() {
        return this.toString();
    }

    @Override
    protected void setInspectReplacingValue(char[] source) {
        this.set(new String(source), false);
    }
}

