/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.Memory;
import com.iscobol.rts.SignEncOpt;
import com.iscobol.types.CobolNum;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.NumericVar;

public final class Pic9Comp_3
extends NumericVar
implements SignEncOpt {
    private static final long serialVersionUID = 123L;
    private final byte positive;
    private final byte unsigned;
    private static final byte[] UNSIGNED = new byte[]{15, 12};
    private static final byte[] POSITIVES = new byte[]{15, 12, 12, 11, 12};
    private static final byte NEGATIVE = 13;

    private static byte getPositive(int opt) {
        switch (opt) {
            case 0: {
                return POSITIVES[0];
            }
            case 1: {
                return POSITIVES[1];
            }
            case 3: {
                return POSITIVES[3];
            }
            case 4: {
                return POSITIVES[4];
            }
        }
        return POSITIVES[2];
    }

    private static byte getUnsigned(int opt) {
        switch (opt) {
            case 5: {
                return UNSIGNED[1];
            }
        }
        return UNSIGNED[0];
    }

    public Pic9Comp_3(Memory m, int i, int il, int dl, boolean s, int[] dimSize, int[] dim, String name, int opt, boolean pComma) {
        super(m, i, il, dl, s, (il + dl) / 2 + 1, dimSize, dim, name, pComma);
        this.positive = Pic9Comp_3.getPositive(opt);
        this.unsigned = Pic9Comp_3.getUnsigned(opt);
        if (m != null) {
            this.updateCache(m, this.theValue);
        }
    }

    public Pic9Comp_3(CobolVar par, int i, int il, int dl, boolean s, int[] dimSize, int[] dim, String name, int opt, boolean pComma) {
        super(par, i, il, dl, s, (il + dl) / 2 + 1, dimSize, dim, name, pComma);
        this.positive = Pic9Comp_3.getPositive(opt);
        this.unsigned = Pic9Comp_3.getUnsigned(opt);
    }

    @Override
    int getAlphaBuffSize() {
        return super.getAlphaBuffSize() + 1;
    }

    private void putBDToMem(Memory mem, BigCobolDec _bcd) {
        int i = this.end - 1;
        BigCobolDec val = new BigCobolDec(_bcd);
        byte b = val.isNegative() ? (byte)13 : (this.signed ? (byte)this.positive : (byte)this.unsigned);
        byte nibble = val.getDecDigit(0);
        val.shift(-1);
        b = (byte)(b | (byte)(nibble << 4));
        mem.put(i--, b);
        while (i >= this.curOffset) {
            nibble = val.getDecDigit(0);
            val.shift(-1);
            b = nibble;
            nibble = val.getDecDigit(0);
            val.shift(-1);
            b = (byte)(b | (byte)(nibble << 4));
            mem.put(i--, b);
        }
    }

    private void putLongToMem(Memory mem, long val) {
        byte b;
        int i = this.end - 1;
        if (val < 0L) {
            val = -val;
            b = 13;
        } else {
            b = this.signed ? (byte)this.positive : (byte)this.unsigned;
        }
        byte nibble = (byte)(val % 10L);
        val /= 10L;
        b = (byte)(b | (byte)(nibble << 4));
        mem.put(i--, b);
        while (i >= this.curOffset) {
            nibble = (byte)(val % 10L);
            b = nibble;
            nibble = (byte)((val /= 10L) % 10L);
            val /= 10L;
            b = (byte)(b | (byte)(nibble << 4));
            mem.put(i--, b);
        }
    }

    @Override
    void updateMemory(Memory mem, CobolNum cn) {
        if (this.intLen + this.decLen <= 18) {
            this.putLongToMem(mem, cn.getUnscaledLong());
        } else {
            this.putBDToMem(mem, cn.bigCobDecValue());
        }
    }

    @Override
    void updateMemory(Memory mem) {
        if (this.intLen + this.decLen <= 18) {
            this.putLongToMem(mem, this.num().getUnscaledLong());
        } else {
            this.putBDToMem(mem, this.num().bigCobDecValue());
        }
    }

    @Override
    public void defaultInitialize() {
        this.theValue.lnUnscValue = 0L;
        Memory mem = this.getMemory();
        mem.fill(this.curOffset, this.end, (byte)0);
        if (this.signed) {
            mem.put(this.end - 1, this.positive);
        } else {
            mem.put(this.end - 1, this.unsigned);
        }
    }

    @Override
    void updateCache(Memory mem, CobolNum cn) {
        if (this.intLen + this.decLen <= 18) {
            cn.set(this.getLongFromMem(mem), this.decLen);
        } else {
            cn.set(this.getBDFromMem(mem));
        }
    }

    private long getLongFromMem(Memory mem) {
        int i = this.end;
        long Return2 = 0L;
        long decFact = 1L;
        boolean negative = this.myIsNegative();
        Return2 = mem.get(--i) >> 4 & 0xF;
        decFact = 10L;
        --i;
        while (i >= this.curOffset) {
            Return2 += (long)(mem.get(i) & 0xF) * decFact;
            Return2 += (long)(mem.get(i) >> 4 & 0xF) * (decFact *= 10L);
            decFact *= 10L;
            --i;
        }
        if (negative) {
            return -Return2;
        }
        return Return2;
    }

    private BigCobolDec getBDFromMem(Memory mem) {
        int i = this.end;
        boolean negative = this.myIsNegative();
        char[] cNum = new char[this.intLen + this.decLen + 2];
        int cnIdx = cNum.length;
        cNum[--cnIdx] = (char)(mem.get(--i) >> 4 & 0xF);
        --i;
        while (i >= this.curOffset) {
            cNum[--cnIdx] = (char)(mem.get(i) & 0xF);
            cNum[--cnIdx] = (char)(mem.get(i) >> 4 & 0xF);
            --i;
        }
        return Pic9Comp_3.getBD(cNum, cnIdx, negative, this.decLen);
    }

    @Override
    public boolean isNumeric() {
        Memory mem = this.getMemory();
        int l = this.intLen + this.decLen;
        int k = this.curOffset;
        for (int i = 0; k < this.end && i < l; ++k, ++i) {
            byte c = (byte)(mem.get(k) >> 4 & 0xF);
            if (c < 0 || c > 9) {
                return false;
            }
            if (++i >= l || (c = (byte)(mem.get(k) & 0xF)) >= 0 && c <= 9) continue;
            return false;
        }
        byte c = (byte)(mem.get(this.end - 1) & 0xF);
        return c == this.positive || c == 13 || c == this.unsigned;
    }

    @Override
    public boolean isNegative() {
        return this.isNumeric() && this.myIsNegative();
    }

    private boolean myIsNegative() {
        return (this.getMemory().get(this.end - 1) & 0xF) == 13;
    }
}

