/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler;

import com.veryant.cobol.compiler.ast.AbstractSyntaxTree;
import com.veryant.cobol.compiler.ast.AstCobolProgram;
import com.veryant.cobol.compiler.ast.AstIgnoredNode;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.AstOperand;
import com.veryant.cobol.compiler.directives.SYNTAXTREE;
import com.veryant.cobol.preproc.FixedFactory;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.PrintStream;

public class ASTPrinter
implements Closeable {
    private long dotCluster = 0L;
    private int xmlIndent = 0;
    private PrintStream printStream;

    public ASTPrinter(String string) throws FileNotFoundException {
        this.printStream = new PrintStream(string);
    }

    @Override
    public void close() {
        this.printStream.close();
    }

    public void print(AbstractSyntaxTree abstractSyntaxTree, SYNTAXTREE.SyntaxFormats syntaxFormats) {
        switch (syntaxFormats) {
            case Xml: {
                this.printXml(abstractSyntaxTree);
                break;
            }
            case Dot: {
                this.printDot(abstractSyntaxTree);
            }
        }
    }

    private void printXml(AbstractSyntaxTree abstractSyntaxTree) {
        this.xmlIndent = 0;
        this.printStream.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?> ");
        for (AstCobolProgram astCobolProgram : abstractSyntaxTree.getModules()) {
            this.printXmlTree(astCobolProgram);
        }
    }

    private void printXmlTree(AstNode astNode) {
        String string = new String(FixedFactory.SPACES, 0, this.xmlIndent);
        String string2 = astNode.getClass().getSimpleName();
        String string3 = astNode.toString();
        String string4 = astNode.toStringNoImage();
        if (astNode.getChildrenCount() > 0) {
            if (string3 == null || string3.length() == 0 || string3.equals(string4)) {
                this.printStream.println(string + ASTPrinter.openXmlNone(string2));
            } else {
                this.printStream.println(string + ASTPrinter.openXmlNone(string2) + ASTPrinter.SimpleXmlEscape(string3));
            }
            this.xmlIndent += 2;
            for (AstNode astNode2 : astNode.getChildren()) {
                this.printXmlTree(astNode2);
            }
            this.xmlIndent -= 2;
            this.printStream.println(string + ASTPrinter.closeXmlNone(string2));
        } else if (string3 == null || string3.length() == 0 || string3.equals(string4)) {
            this.printStream.println(string + ASTPrinter.emptyXmlNone(string2));
        } else {
            this.printStream.println(string + ASTPrinter.openXmlNone(string2) + ASTPrinter.SimpleXmlEscape(string3) + ASTPrinter.closeXmlNone(string2));
        }
    }

    private static String openXmlNone(String string) {
        return "<" + string + ">";
    }

    private static String closeXmlNone(String string) {
        return "</" + string + ">";
    }

    private static String emptyXmlNone(String string) {
        return "<" + string + " />";
    }

    private static String SimpleXmlEscape(String string) {
        return string.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;");
    }

    private void printDot(AbstractSyntaxTree abstractSyntaxTree) {
        this.printStream.print("graph{node[shape=box];");
        for (AstCobolProgram astCobolProgram : abstractSyntaxTree.getModules()) {
            this.printDotTree(astCobolProgram);
        }
        this.printStream.print("}");
    }

    private void printDotTree(AstNode astNode) {
        ++this.dotCluster;
        this.printDotLink(astNode);
        if (astNode.getChildrenCount() > 0) {
            this.printStream.print("subgraph cluster_" + this.dotCluster + "{style=invis;");
            for (AstNode astNode2 : astNode.getChildren()) {
                this.printDotTree(astNode2);
            }
            this.printStream.print("};");
        }
    }

    private void printDotLink(AstNode astNode) {
        AstNode astNode2 = astNode.getParent();
        if (astNode2 != null) {
            this.printStream.print("{");
            this.printStream.print(System.identityHashCode(astNode2));
            this.printStream.print("}--");
        }
        String string = "color=gray20;fontcolor=gray20";
        if (astNode instanceof AstOperand) {
            string = "color=slategray;fontcolor=slategray";
        } else if (astNode instanceof AstIgnoredNode) {
            string = "color=gray60;fontcolor=gray60;style=dashed";
        }
        this.printStream.print("{");
        this.printStream.print(System.identityHashCode(astNode));
        this.printStream.print("[");
        this.printStream.print(string);
        this.printStream.print(";label=\"");
        String string2 = astNode.toString();
        if (string2 == null) {
            this.printStream.print("<null>");
        } else {
            this.printStream.print(astNode.toString().replace('\"', '\''));
        }
        this.printStream.print("\"]}[color=gray80];");
    }
}

