/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.Context;
import com.veryant.cobol.compiler.ast.AstOperand;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.types.AbstractOperand;
import com.veryant.cobol.compiler.types.FigurativeConstant;

public class AstFigurativeConstant
extends AstOperand {
    private static final byte[] LOW_VALUE = new byte[]{0};
    private static final byte[] SPACE_ASCII = new byte[]{32};
    private static final byte[] SPACE_EBCDIC = new byte[]{64};
    private static final byte[] APOS_ASCII = new byte[]{39};
    private static final byte[] APOS_EBCDIC = new byte[]{125};
    private static final byte[] QUOTE_ASCII = new byte[]{34};
    private static final byte[] QUOTE_EBCDIC = new byte[]{127};
    private static final byte[] ZERO_ASCII = new byte[]{48};
    private static final byte[] ZERO_EBCDIC = new byte[]{-16};
    private static final byte[] HIGH_VALUE = new byte[]{-1};
    private FigurativeConstant operand;

    protected FigurativeConstant create(byte[] byArray) {
        return new FigurativeConstant(this.getToken(), this.createLiteral(byArray));
    }

    public AstFigurativeConstant(Collector collector, Token token) {
        super(collector, token);
        switch (token.kind) {
            case 694: 
            case 696: {
                this.operand = this.create(this.getContext().isAscii() ? SPACE_ASCII : SPACE_EBCDIC);
                break;
            }
            case 575: 
            case 576: {
                Context context = this.getContext();
                if (context.getDirectives().getQuoteChar() == '\'') {
                    this.operand = this.create(context.isAscii() ? APOS_ASCII : APOS_EBCDIC);
                    break;
                }
                this.operand = this.create(context.isAscii() ? QUOTE_ASCII : QUOTE_EBCDIC);
                break;
            }
            case 832: 
            case 834: 
            case 835: {
                this.operand = this.create(this.getContext().isAscii() ? ZERO_ASCII : ZERO_EBCDIC);
                break;
            }
            case 453: 
            case 454: {
                this.operand = this.create(LOW_VALUE);
                break;
            }
            case 371: 
            case 372: {
                this.operand = this.create(HIGH_VALUE);
                break;
            }
            default: {
                this.consoleWrite(51, token, token.image);
            }
        }
        this.getContext().getLiterals().add(this.operand.getValue());
    }

    @Override
    public AbstractOperand getOperand() {
        return this.operand;
    }
}

