/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.builtin;

import com.veryant.cobol.compiler.emitters.jvm.BuiltInEmitter;
import com.veryant.cobol.compiler.emitters.jvm.JvmCode;
import com.veryant.cobol.compiler.emitters.jvm.Local;
import com.veryant.cobol.compiler.emitters.jvm.VMType;
import com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes;
import com.veryant.cobol.compiler.emitters.jvm.core.Functions;
import com.veryant.cobol.compiler.emitters.jvm.core.Templates;
import com.veryant.cobol.compiler.emitters.jvm.core.VMTypeEx;
import com.veryant.cobol.compiler.memory.IChunk;
import com.veryant.cobol.compiler.memory.Region;
import com.veryant.cobol.compiler.types.AbstractOperand;
import com.veryant.cobol.compiler.types.DataItemReference;
import com.veryant.cobol.compiler.types.IReferenceModable;
import com.veryant.cobol.compiler.types.ISubscriptable;
import com.veryant.cobol.exceptions.COBOLCompilerException;

public abstract class Base {
    static final BuiltInEmitter NEW = (jvmCode, abstractOperand) -> {
        IChunk iChunk = abstractOperand.getChunk();
        if (iChunk.getRegion() != Region.STACK) {
            throw new COBOLCompilerException("Internal error, wrong opcode usage");
        }
        jvmCode.push(abstractOperand, VMTypeEx.IMEMORY, "new LocalMemory(new byte[" + iChunk.getSize() + "])");
    };
    static final BuiltInEmitter LOAD_ADDRESS = (jvmCode, abstractOperand) -> {
        if (abstractOperand.getChunk().getRegion() == Region.LINKAGE) {
            String string = Functions.f_resolve_region_name(abstractOperand) + ((DataItemReference)abstractOperand).getDataItemDeclaration().getRecordIndex();
            jvmCode.push(abstractOperand, VMTypeEx.IMEMORY, string + ".getMemory()");
            jvmCode.push(abstractOperand, VMType.INT32, string + ".getOffset()");
            Base.pushOffset(jvmCode, abstractOperand);
            com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.INJECT(jvmCode, VMType.INT32, Templates.T_REF_MODIFIER_ADD);
            Base.pushSize(jvmCode, abstractOperand);
            return;
        }
        jvmCode.push(abstractOperand, VMTypeEx.IMEMORY, Functions.f_resolve_region_name(abstractOperand));
        Base.pushOffset(jvmCode, abstractOperand);
        Base.pushSize(jvmCode, abstractOperand);
    };

    private static void pushOffset(JvmCode jvmCode, AbstractOperand abstractOperand) {
        IChunk iChunk = abstractOperand.getChunk();
        com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.LOAD_CONST(jvmCode, iChunk.getOffset());
    }

    private static void pushSize(JvmCode jvmCode, AbstractOperand abstractOperand) {
        Object object;
        IChunk iChunk = abstractOperand.getChunk();
        if (abstractOperand instanceof ISubscriptable) {
            object = (ISubscriptable)((Object)abstractOperand);
            for (int i = 0; i < object.getSubscriptsCount(); ++i) {
                if (object.hasExternalSubscripts()) {
                    com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.LOAD_CONST(jvmCode, object.getSubscriptMultiplier(i));
                    com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.INJECT(jvmCode, VMType.INT32, "i" + i);
                    com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.INJECT(jvmCode, VMType.INT32, Templates.T_SUBSCRIPT_MODIFIER);
                    continue;
                }
                AbstractOperand abstractOperand2 = object.getSubscript(i);
                if (abstractOperand2 == null) continue;
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.LOAD_CONST(jvmCode, object.getSubscriptMultiplier(i));
                Opcodes.LOAD(jvmCode, abstractOperand2);
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.SCALE(jvmCode, 0);
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.CAST(jvmCode, VMType.INT32);
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.DEC(jvmCode);
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.INJECT(jvmCode, VMType.INT32, Templates.T_SUBSCRIPT_MODIFIER);
            }
        }
        if (abstractOperand instanceof IReferenceModable) {
            object = (IReferenceModable)((Object)abstractOperand);
            if (object.hasReferenceModifier()) {
                Opcodes.LOAD(jvmCode, object.getFrom());
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.SCALE(jvmCode, 0);
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.CAST(jvmCode, VMType.INT32);
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.DEC(jvmCode);
                if (object.getTo() == null) {
                    Local local = com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.STORE_LOCAL(jvmCode);
                    com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.LOAD_LOCAL(jvmCode, local);
                    com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.INJECT(jvmCode, VMType.INT32, Templates.T_REF_MODIFIER_ADD);
                    com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.LOAD_CONST(jvmCode, iChunk.getSize());
                    com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.LOAD_LOCAL(jvmCode, local);
                    com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.INJECT(jvmCode, VMType.INT32, Templates.T_REF_MODIFIER_SUB);
                } else {
                    com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.INJECT(jvmCode, VMType.INT32, Templates.T_REF_MODIFIER_ADD);
                    Opcodes.LOAD(jvmCode, object.getTo());
                    com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.SCALE(jvmCode, 0);
                    com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.CAST(jvmCode, VMType.INT32);
                }
            } else {
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.LOAD_CONST(jvmCode, iChunk.getSize());
            }
        } else {
            com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.LOAD_CONST(jvmCode, iChunk.getSize());
        }
    }
}

