/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.scope;

import com.veryant.cobol.compiler.Context;
import com.veryant.cobol.compiler.FileControlDescriptor;
import com.veryant.cobol.compiler.IOperand;
import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.Section;
import com.veryant.cobol.compiler.directives.RECMODE;
import com.veryant.cobol.compiler.directives.RM;
import com.veryant.cobol.compiler.directives.SEQUENTIAL;
import com.veryant.cobol.compiler.directives.SORTINDEXEDKEYS;
import com.veryant.cobol.compiler.memory.DataItem;
import com.veryant.cobol.compiler.memory.DynamicChunk;
import com.veryant.cobol.compiler.memory.IChunk;
import com.veryant.cobol.compiler.memory.RecordItem;
import com.veryant.cobol.compiler.scope.AbstractDeclaration;
import com.veryant.cobol.compiler.types.AbstractOperand;
import com.veryant.cobol.compiler.types.DataItemReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class FileDeclaration
extends AbstractDeclaration {
    private final boolean ans85;
    private final boolean autoLock;
    private final int dataCompress;
    private final LockMode defaultLockMode;
    private final boolean icobol;
    private final boolean optionalFile;
    private final RECMODE.Formats recmodeFormat;
    private final boolean rdw;
    private final RECMODE.Formats recordSequentialRecordingMode;
    private final boolean retryLock;
    private final boolean rewriteLs;
    private final RM rm;
    private final boolean singleRecordLocking;
    private final SORTINDEXEDKEYS sortIndexedKeysDirective;
    private final SEQUENTIAL.SequentialType sequentialType;
    private final boolean writeLock;
    private FileControlDescriptor fileControlDescriptor = null;
    private final int fileId;
    private AbstractOperand fileName = null;
    private boolean declaredOnly = true;
    private boolean needsClose = false;
    private IChunk fcdLiteral;
    private IChunk keyBlockLiteral;
    private DataItem fcdDataItem;
    private boolean isSelectDuplicate = false;
    private boolean isSelectMissing = false;
    private boolean isFDMissing = false;
    private Optional optional = null;
    private Assign assign = new Assign();
    private Integer reserveAreas = null;
    private AccessMode accessMode = null;
    private Organization organization = Organization.Undefined;
    private ArrayList<Key> keys = new ArrayList();
    private Key primeKey = null;
    private LockMode lockMode = null;
    private boolean multipleRecordLock = false;
    private boolean withRollback = false;
    private IOperand paddingCharacter;
    private boolean standardRecordDelimiter = false;
    private IOperand recordDelimiter = null;
    private DataItemReference depending = null;
    private DataItemReference[] fileStatuses = new DataItemReference[0];
    private SharingMode sharingMode = null;
    private RecordingMode recordingMode = null;
    private boolean hasRecordContainsFixedClause = false;
    private boolean hasRecordContainsRangeClause = false;
    private boolean hasRecordVaryingClause = false;
    private int maxRecordLength = -1;
    private int minRecordLength = -1;
    private Section declarativeSection = null;
    private final ArrayList<RecordItem> records = new ArrayList();
    private List<String> splitKeyNames = new ArrayList<String>();

    public RECMODE.Formats getRecmodeFormat() {
        if (this.getOrganization() == Organization.RecordSequential && this.recordSequentialRecordingMode != null) {
            return this.recordSequentialRecordingMode;
        }
        return this.recmodeFormat;
    }

    public FileDeclaration(Context context, ISourceReference iSourceReference, String string, int n) {
        super(iSourceReference, string);
        this.fileId = n;
        this.ans85 = context.getANS85().isSet();
        this.autoLock = context.getAUTOLOCK().isSet();
        this.dataCompress = context.getDATACOMPRESS().isSet() ? context.getDATACOMPRESS().getFactor() : 0;
        this.defaultLockMode = context.getLOCKMODE().getLockMode();
        this.icobol = context.getICOBOL().isSet();
        this.optionalFile = context.getOPTIONALFILE().isSet();
        this.rdw = context.getRDW().isSet();
        this.recmodeFormat = context.getRECMODE().getFormat();
        this.recordSequentialRecordingMode = context.getRECORDSEQUENTIALRECORDINGMODE().getFormat();
        this.retryLock = context.getRETRYLOCK().isSet();
        this.rewriteLs = context.getREWRITELS().isSet();
        this.rm = context.getRM();
        this.singleRecordLocking = context.getSINGLERECORDLOCKING().isSet();
        this.sequentialType = context.getSEQUENTIAL().getSequentialType();
        this.sortIndexedKeysDirective = context.getSORTINDEXEDKEYS();
        this.writeLock = context.getWRITELOCK().isSet();
    }

    public String getMethodName(String string) {
        return "$" + string.toUpperCase() + "$" + this.fileId;
    }

    public String getOpenStatusName(String string) {
        return "$" + string.toUpperCase() + "$" + this.fileId + "$OS$";
    }

    public FileControlDescriptor getFileControlDescriptor() {
        if (this.fileControlDescriptor == null) {
            this.fileControlDescriptor = new FileControlDescriptor();
            this.fileControlDescriptor.setFcdOpenClosedValue();
            this.fileControlDescriptor.setFcdDataCompressValue((byte)this.dataCompress);
            if (this.ans85) {
                this.fileControlDescriptor.setFcdAns85StatusBit();
            }
            if (this.autoLock) {
                this.fileControlDescriptor.setFcdAutoLockBitBit();
            }
            if (this.optional == null) {
                if (!this.ans85 && !this.optionalFile) {
                    this.fileControlDescriptor.setFcdNotOptionalBit();
                }
            } else {
                switch (this.optional) {
                    case Optional: {
                        this.fileControlDescriptor.setFcdOptionalFileBit();
                        break;
                    }
                    case NotOptional: {
                        this.fileControlDescriptor.setFcdNotOptionalBit();
                    }
                }
            }
            if (this.accessMode != null) {
                switch (this.accessMode) {
                    case Sequential: {
                        this.fileControlDescriptor.setFcdSequentialAccessBit();
                        break;
                    }
                    case Random: {
                        this.fileControlDescriptor.setFcdRandomAccessBit();
                        break;
                    }
                    case Dynamic: {
                        this.fileControlDescriptor.setFcdDynamicAccessBit();
                    }
                }
            }
            if (this.recordingMode != null) {
                switch (this.recordingMode) {
                    case F: {
                        this.fileControlDescriptor.setFcdRecmodeFixedValue();
                        break;
                    }
                    case V: {
                        this.fileControlDescriptor.setFcdRecmodeVariableValue();
                    }
                }
            }
            if (this.organization != null) {
                switch (this.organization) {
                    case Sequential: {
                        switch (this.sequentialType) {
                            case Advancing: {
                                this.fileControlDescriptor.setFcdLineAdvancingBit();
                                break;
                            }
                            case ANSI: {
                                this.fileControlDescriptor.setFcdAnsiLineAdvBit();
                                break;
                            }
                            case Line: {
                                this.fileControlDescriptor.setFcdLineSequentialOrgValue();
                                break;
                            }
                            case Record: {
                                this.fileControlDescriptor.setFcdSequentialOrgValue();
                            }
                        }
                        break;
                    }
                    case BinarySequential: {
                        this.fileControlDescriptor.setFcdSequentialOrgValue();
                        break;
                    }
                    case LineSequential: {
                        this.fileControlDescriptor.setFcdLineSequentialOrgValue();
                        break;
                    }
                    case RecordSequential: {
                        break;
                    }
                    case Relative: {
                        this.fileControlDescriptor.setFcdRelativeOrgValue();
                        break;
                    }
                    case Indexed: {
                        this.fileControlDescriptor.setFcdIndexedOrgValue();
                    }
                }
            }
            if (this.getLockMode() != null) {
                switch (this.getLockMode()) {
                    case Manual: {
                        this.fileControlDescriptor.setFcdManualLockBitBit();
                        break;
                    }
                    case Automatic: {
                        this.fileControlDescriptor.setFcdAutoLockBitBit();
                        break;
                    }
                    case Exclusive: {
                        this.fileControlDescriptor.setFcdExclusiveBitBit();
                    }
                }
            }
            if (this.multipleRecordLock) {
                this.fileControlDescriptor.setFcdMultilockBitBit();
            }
            if (this.withRollback) {
                this.fileControlDescriptor.setFcdTransactionProcessingBitBit();
                if (!this.singleRecordLocking) {
                    this.fileControlDescriptor.setFcdMultilockBitBit();
                }
            }
            if (this.fileStatuses != null && this.fileStatuses.length > 0) {
                this.fileControlDescriptor.setFcdStatusDefinedBit();
            }
            if (this.sharingMode != null) {
                switch (this.sharingMode) {
                    case WithNoOther: {
                        this.fileControlDescriptor.setFcdExclusiveBitBit();
                        break;
                    }
                    case WithAllOthers: {
                        this.fileControlDescriptor.setFcdManualLockBitBit();
                    }
                }
            }
            if (this.assign.isExternal()) {
                this.fileControlDescriptor.setFcdExternalNameBit();
            }
            if (this.retryLock) {
                this.fileControlDescriptor.setFcdRetryLockBitBit();
            }
            this.fileControlDescriptor.setFcdMinRecLength(this.minRecordLength);
            this.fileControlDescriptor.setFcdMaxRecLength(this.maxRecordLength);
        }
        return this.fileControlDescriptor;
    }

    public byte[] getKeyDefinitionBlockBytes() {
        return new KeyDefinitionBlock(this.keys).toByteArray();
    }

    public int getSizeOfKeyDefinitionBlockBytes() {
        return new KeyDefinitionBlock(this.keys).getByteArraySize();
    }

    private static int storeBinary(int n, byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        n2 += n3;
        while (n3 > 0) {
            byArray[--n2] = (byte)(n & 0xFF);
            n >>= 8;
            --n3;
        }
        return n4;
    }

    public int getFileId() {
        return this.fileId;
    }

    public AbstractOperand getFileName() {
        return this.fileName;
    }

    public void setFileName(AbstractOperand abstractOperand) {
        this.fileName = abstractOperand;
    }

    public boolean isDeclaredOnly() {
        return this.declaredOnly;
    }

    public void setDeclaredOnly(boolean bl) {
        this.declaredOnly = bl;
    }

    public boolean getNeedsClose() {
        return this.needsClose;
    }

    public void setNeedsClose(boolean bl) {
        this.needsClose = bl;
    }

    public IChunk getFcdLiteral() {
        return this.fcdLiteral;
    }

    public void setFcdLiteral(IChunk iChunk) {
        this.fcdLiteral = iChunk;
    }

    public IChunk getKeyBlockLiteral() {
        return this.keyBlockLiteral;
    }

    public void setKeyBlockLiteral(IChunk iChunk) {
        this.keyBlockLiteral = iChunk;
    }

    public DataItem getFcdDataItem() {
        return this.fcdDataItem;
    }

    public void setFcdDataItem(DataItem dataItem) {
        this.fcdDataItem = dataItem;
    }

    public boolean getIsSelectDuplicate() {
        return this.isSelectDuplicate;
    }

    public void setIsSelectDuplicate(boolean bl) {
        this.isSelectDuplicate = bl;
    }

    public boolean getIsSelectMissing() {
        return this.isSelectMissing;
    }

    public void setIsSelectMissing(boolean bl) {
        this.isSelectMissing = bl;
    }

    public boolean getIsFDMissing() {
        return this.isFDMissing;
    }

    public void setIsFDMissing(boolean bl) {
        this.isFDMissing = bl;
    }

    public boolean hasSelectAndFD() {
        return !this.getIsSelectMissing() && !this.getIsFDMissing();
    }

    public Optional getOptional() {
        return this.optional;
    }

    public void setOptional(Optional optional) {
        this.optional = optional;
    }

    public Assign getAssign() {
        return this.assign;
    }

    public Integer getReserveAreas() {
        return this.reserveAreas;
    }

    public void setReserveAreas(Integer n) {
        this.reserveAreas = n;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public void setAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public ArrayList<Key> getKeys() {
        return this.keys;
    }

    public Key getPrimeKey() {
        return this.primeKey;
    }

    public LockMode getLockMode() {
        return this.lockMode != null ? this.lockMode : this.defaultLockMode;
    }

    public void setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
    }

    public boolean isMultipleRecordLock() {
        return this.icobol || this.isWithRollback() || this.multipleRecordLock;
    }

    public void setMultipleRecordLock(boolean bl) {
        this.multipleRecordLock = bl;
    }

    public boolean isWithRollback() {
        return this.withRollback;
    }

    public void setWithRollback(boolean bl) {
        this.withRollback = bl;
    }

    public IOperand getPaddingCharacter() {
        return this.paddingCharacter;
    }

    public void setPaddingCharacter(IOperand iOperand) {
        this.paddingCharacter = iOperand;
    }

    public boolean isStandardRecordDelimiter() {
        return this.standardRecordDelimiter;
    }

    public void setStandardRecordDelimiter(boolean bl) {
        this.standardRecordDelimiter = bl;
    }

    public IOperand getRecordDelimiter() {
        return this.recordDelimiter;
    }

    public void setRecordDelimiter(IOperand iOperand) {
        this.recordDelimiter = iOperand;
    }

    public DataItemReference getDepending() {
        return this.depending;
    }

    public void setDepending(DataItemReference dataItemReference) {
        this.depending = dataItemReference;
    }

    public DataItemReference[] getFileStatuses() {
        return this.fileStatuses;
    }

    public void setFileStatuses(DataItemReference[] dataItemReferenceArray) {
        this.fileStatuses = dataItemReferenceArray;
    }

    public SharingMode getSharingMode() {
        return this.sharingMode;
    }

    public void setSharingMode(SharingMode sharingMode) {
        this.sharingMode = sharingMode;
    }

    public RecordingMode getRecordingMode() {
        return this.recordingMode;
    }

    public void setRecordingMode(RecordingMode recordingMode) {
        this.recordingMode = recordingMode;
    }

    public boolean hasRecordContainsFixedClause() {
        return this.hasRecordContainsFixedClause;
    }

    public void setHasRecordContainsFixedClause(boolean bl) {
        this.hasRecordContainsFixedClause = bl;
    }

    public boolean hasRecordContainsRangeClause() {
        return this.hasRecordContainsRangeClause;
    }

    public void setHasRecordContainsRangeClause(boolean bl) {
        this.hasRecordContainsRangeClause = bl;
    }

    public boolean hasRecordVaryingClause() {
        return this.hasRecordVaryingClause;
    }

    public void setHasRecordVaryingClause(boolean bl) {
        this.hasRecordVaryingClause = bl;
    }

    public int getMaxRecordLength() {
        return this.maxRecordLength;
    }

    public void setMaxRecordLength(int n) {
        this.maxRecordLength = n;
    }

    public int getMinRecordLength() {
        return this.minRecordLength;
    }

    public void setMinRecordLength(int n) {
        this.minRecordLength = n;
    }

    public Section getDeclarativeSection() {
        return this.declarativeSection;
    }

    public void setDeclarativeSection(Section section) {
        this.declarativeSection = section;
    }

    public RecordItem[] getRecords() {
        return this.records.toArray(new RecordItem[this.records.size()]);
    }

    public void addRecord(RecordItem recordItem) {
        this.records.add(recordItem);
    }

    public RecordItem getLargestRecord() {
        RecordItem recordItem = null;
        for (RecordItem recordItem2 : this.records) {
            if (recordItem != null && ((DynamicChunk)recordItem2.getChunk()).getSize() <= ((DynamicChunk)recordItem.getChunk()).getSize()) continue;
            recordItem = recordItem2;
        }
        return recordItem;
    }

    public boolean checkOrganizationAccessKeyCombination() {
        return this.accessMode == AccessMode.Sequential || this.organization == Organization.Indexed || this.organization == Organization.Relative;
    }

    public void addPrimeKey(Key key) {
        if (key != null) {
            this.primeKey = key;
            key.index = 0;
            if (this.keys.size() == 0) {
                this.keys.add(0, key);
            } else {
                this.keys.set(0, key);
            }
        }
    }

    public void addKey(Key key) {
        if (this.keys.size() == 0) {
            this.keys.add(null);
        }
        if (key != null) {
            key.index = this.keys.size();
            this.keys.add(key);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        FileDeclaration.append(stringBuilder, this.getName());
        FileDeclaration.append(stringBuilder, this.assign);
        FileDeclaration.append(stringBuilder, this.reserveAreas, "RESERVE %d AREAS");
        FileDeclaration.append(stringBuilder, (Object)this.organization, "ORGANIZATION IS %s");
        FileDeclaration.append(stringBuilder, (Object)this.accessMode, "ACCESS MODE IS %s");
        FileDeclaration.append(stringBuilder, (Object)this.lockMode, "LOCK MODE IS %s");
        FileDeclaration.append(stringBuilder, this.multipleRecordLock, "WITH LOCK ON MULTIPLE RECORDS");
        FileDeclaration.append(stringBuilder, this.withRollback, "WITH ROLLBACK");
        FileDeclaration.append(stringBuilder, this.paddingCharacter, "PADDING CHARACTER IS %s");
        FileDeclaration.append(stringBuilder, this.standardRecordDelimiter, "RECORD DELIMITER IS STANDARD-1");
        FileDeclaration.append(stringBuilder, this.recordDelimiter, "RECORD DELIMITER IS %s");
        if (this.fileStatuses != null) {
            CharSequence[] charSequenceArray = new String[this.fileStatuses.length];
            for (int i = 0; i < this.fileStatuses.length; ++i) {
                charSequenceArray[i] = String.valueOf(this.fileStatuses[i]);
            }
            FileDeclaration.append(stringBuilder, String.join((CharSequence)", ", charSequenceArray), "FILE STATUS IS %s");
        }
        FileDeclaration.append(stringBuilder, (Object)this.sharingMode, "SHARING %s");
        for (int i = 0; i < this.keys.size(); ++i) {
            String string = i == 0 ? (this.organization == Organization.Indexed ? "RECORD" : "RELATIVE") : "ALTERNATE RECORD";
            FileDeclaration.append(stringBuilder, this.keys.get(i), string + " %s");
        }
        return stringBuilder.toString().trim();
    }

    private static StringBuilder append(StringBuilder stringBuilder, boolean bl, String string) {
        if (bl) {
            stringBuilder.append(string.trim()).append(' ');
        }
        return stringBuilder;
    }

    private static StringBuilder append(StringBuilder stringBuilder, Object object, String string) {
        if (object != null) {
            stringBuilder.append(String.format(string, object).trim()).append(' ');
        }
        return stringBuilder;
    }

    private static StringBuilder append(StringBuilder stringBuilder, Object object) {
        if (object != null) {
            stringBuilder.append(object).append(' ');
        }
        return stringBuilder;
    }

    public Key createKey(DataItemReference dataItemReference) {
        if (dataItemReference != null) {
            return new Key(this, dataItemReference);
        }
        return null;
    }

    public Key createSplitKey(String string, List<AbstractOperand> list) {
        return new Key(this, string, list);
    }

    public void updateKeyInfo() {
        for (Key key : this.keys) {
            key.updateOffsetAndLength();
        }
        if (this.sortIndexedKeysDirective.isSet()) {
            this.keys.sort(Comparator.comparing(Key::getSortOffset));
            for (int i = 0; i < this.keys.size(); ++i) {
                this.keys.get(i).setIndex(i);
            }
        }
    }

    public boolean storeSplitKey(String string) {
        if (!this.splitKeyNames.contains(string)) {
            this.splitKeyNames.add(string);
            return true;
        }
        return false;
    }

    public class Key {
        private final FileDeclaration file;
        private final String name;
        private final DataItemReference dataItemReference;
        private final ArrayList<AbstractOperand> segments = new ArrayList();
        private int index;
        private int offset;
        private String sortOffset = "";
        private int length;
        private int matchLength;
        private boolean withDuplicates = false;
        private IOperand password = null;
        private Suppress suppress = null;
        private IOperand suppressLiteral = null;

        public FileDeclaration getFile() {
            return this.file;
        }

        public String getName() {
            return this.name;
        }

        public DataItemReference getDataItemReference() {
            return this.dataItemReference;
        }

        public ArrayList<AbstractOperand> getSegments() {
            return this.segments;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int n) {
            this.index = n;
        }

        public int getOffset() {
            return this.offset;
        }

        public String getSortOffset() {
            return this.sortOffset;
        }

        public int getLength() {
            return this.length;
        }

        public int getMatchLength() {
            return this.matchLength;
        }

        public boolean isWithDuplicates() {
            return this.withDuplicates || this.getFile() != null && this.getFile().icobol;
        }

        public void setWithDuplicates(boolean bl) {
            this.withDuplicates = bl;
        }

        public IOperand getPassword() {
            return this.password;
        }

        public void setPassword(IOperand iOperand) {
            this.password = iOperand;
        }

        public Suppress getSuppress() {
            return this.suppress;
        }

        public void setSuppress(Suppress suppress) {
            this.suppress = suppress;
        }

        public IOperand getSuppressLiteral() {
            return this.suppressLiteral;
        }

        public void setSuppressLiteral(IOperand iOperand) {
            this.suppressLiteral = iOperand;
        }

        public Key(FileDeclaration fileDeclaration2, DataItemReference dataItemReference) {
            this.file = fileDeclaration2;
            this.name = dataItemReference.getDataItemDeclaration().getName();
            this.dataItemReference = dataItemReference;
        }

        public Key(FileDeclaration fileDeclaration2, String string, List<AbstractOperand> list) {
            this.file = fileDeclaration2;
            this.name = string;
            this.dataItemReference = null;
            this.segments.addAll(list);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("KEY IS ");
            FileDeclaration.append(stringBuilder, this.getDataItemReference());
            if (this.segments.size() > 0) {
                CharSequence[] charSequenceArray = new String[this.segments.size()];
                for (int i = 0; i < charSequenceArray.length; ++i) {
                    charSequenceArray[i] = String.valueOf(this.segments.get(i));
                }
                FileDeclaration.append(stringBuilder, String.join((CharSequence)", ", charSequenceArray), "= %s");
            }
            FileDeclaration.append(stringBuilder, this.password, "PASSWORD IS %d");
            FileDeclaration.append(stringBuilder, this.withDuplicates, "WITH DUPLICATES");
            FileDeclaration.append(stringBuilder, !this.withDuplicates, "WITH NO DUPLICATES");
            if (this.suppress != null) {
                switch (this.suppress) {
                    case Zeroes: 
                    case Spaces: {
                        FileDeclaration.append(stringBuilder, (Object)this.suppress, "SUPPRESS %s");
                        break;
                    }
                    case Literal: {
                        FileDeclaration.append(stringBuilder, this.suppressLiteral, "SUPPRESS %s");
                    }
                }
            }
            return stringBuilder.toString().trim();
        }

        public void updateOffsetAndLength() {
            SORTINDEXEDKEYS sORTINDEXEDKEYS = this.getFile().sortIndexedKeysDirective;
            if (!sORTINDEXEDKEYS.isSet()) {
                this.sortOffset = String.format("%08X", this.getIndex());
            }
            if (this.dataItemReference != null) {
                this.offset = this.dataItemReference.getChunk().getOffset();
                this.length = this.matchLength = this.dataItemReference.getChunk().getSize();
                if (!sORTINDEXEDKEYS.isSet()) {
                    this.sortOffset = String.format("%08X", this.offset);
                }
            } else {
                this.offset = this.segments.get(0).getChunk().getOffset();
                this.matchLength = this.segments.get(0).getChunk().getSize();
                this.length = 0;
                if (sORTINDEXEDKEYS.isSet() && sORTINDEXEDKEYS.getRmStyle()) {
                    this.sortOffset = "";
                }
                for (IOperand iOperand : this.segments) {
                    int n = iOperand.getChunk().getOffset();
                    this.length += n;
                    if (!sORTINDEXEDKEYS.isSet() || !sORTINDEXEDKEYS.getRmStyle()) continue;
                    this.sortOffset = this.sortOffset + String.format("%08X", n);
                }
            }
        }
    }

    public class Assign {
        private boolean external = false;
        private boolean dynamic = false;
        private Device device = null;
        private IOperand[] targets = new IOperand[0];

        public boolean isExternal() {
            return this.external;
        }

        public void setExternal(boolean bl) {
            this.external = bl;
        }

        public boolean isDynamic() {
            return this.dynamic;
        }

        public void setDynamic(boolean bl) {
            this.dynamic = bl;
        }

        public Device getDevice() {
            return this.device;
        }

        public void setDevice(Device device) {
            this.device = device;
        }

        public IOperand[] getTargets() {
            return this.targets;
        }

        public void setTargets(IOperand[] iOperandArray) {
            this.targets = iOperandArray;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ASSIGN TO ");
            if (this.external) {
                stringBuilder.append("EXTERNAL ");
            } else if (this.dynamic) {
                stringBuilder.append("DYNAMIC ");
            }
            if (this.device != null) {
                stringBuilder.append(this.device.toString().toUpperCase()).append(' ');
            }
            for (IOperand iOperand : this.targets) {
                stringBuilder.append(iOperand).append(' ');
            }
            return stringBuilder.toString().trim();
        }
    }

    public static enum RecordingMode {
        F,
        S,
        U,
        V;

    }

    public static enum Suppress {
        Zeroes,
        Spaces,
        Literal;

    }

    public static enum SharingMode {
        WithNoOther,
        WithAllOthers;

    }

    public static enum LockMode {
        Manual,
        Automatic,
        Exclusive;

    }

    public static enum Optional {
        Optional,
        NotOptional;

    }

    public static enum Device {
        MultipleReel,
        MultipleUnit,
        Disk,
        Keyboard,
        Display,
        Print,
        Sort,
        IO,
        Address,
        Random,
        Other;

    }

    public static enum Organization {
        Undefined{

            @Override
            public String getDescription() {
                return "UNDEFINED";
            }
        }
        ,
        Sequential{

            @Override
            public String getDescription() {
                return "SEQUENTIAL";
            }
        }
        ,
        BinarySequential{

            @Override
            public String getDescription() {
                return "BINARY SEQUENTIAL";
            }
        }
        ,
        LineSequential{

            @Override
            public String getDescription() {
                return "LINE SEQUENTIAL";
            }
        }
        ,
        RecordSequential{

            @Override
            public String getDescription() {
                return "RECORD SEQUENTIAL";
            }
        }
        ,
        Relative{

            @Override
            public String getDescription() {
                return "RELATIVE";
            }
        }
        ,
        Indexed{

            @Override
            public String getDescription() {
                return "INDEXED";
            }
        };


        public abstract String getDescription();
    }

    public static enum AccessMode {
        Sequential,
        Random,
        Dynamic;

    }

    class ComponentDefinitionArea {
        public static final int byteSize = 10;
        private static final int duplicatesInOrder = 128;
        private static final int descending = 64;
        private static final int numeric = 128;
        private static final int signed = 64;
        private static final int nonDisplay = 32;
        private static final int commonBitMask = 7;
        private static final int binary = 0;
        private static final int packedDecimal = 1;
        private static final int compX = 2;
        private static final int comp5 = 3;
        private static final int floatingPoint = 4;
        private static final int signTrailingIncluded = 0;
        private static final int signTrailingSeparate = 1;
        private static final int signLeadingIncluded = 2;
        private static final int signLeadingSeparate = 3;
        private static final int applyCollatingSequence = 2;
        public int componentFlags1 = 0;
        public int componentFlags2 = 0;
        public int componentOffset = 0;
        public int componentLength = 0;

        ComponentDefinitionArea() {
        }

        public void setDuplicatesInOrderFlag() {
            this.componentFlags1 |= 0x80;
        }

        public boolean hasDuplicatesInOrderFlag() {
            return (this.componentFlags1 & 0x80) != 0;
        }

        public void setDescendingFlag() {
            this.componentFlags1 |= 0x40;
        }

        public boolean hasDescendingFlag() {
            return (this.componentFlags1 & 0x40) != 0;
        }

        public void setNumericFlag() {
            this.componentFlags2 = !this.hasNumericFlag() ? 128 : (this.componentFlags2 |= 0x80);
        }

        public boolean hasNumericFlag() {
            return (this.componentFlags2 & 0x80) != 0;
        }

        public void setSignedFlag() {
            this.setNumericFlag();
            this.componentFlags2 |= 0x40;
        }

        public boolean hasSignedFlag() {
            return this.hasNumericFlag() && (this.componentFlags2 & 0x40) != 0;
        }

        public void setNonDisplayFlag() {
            this.setNumericFlag();
            this.componentFlags2 &= 0xFFFFFFF8;
            this.componentFlags2 |= 0x20;
        }

        public boolean hasNonDisplayFlag() {
            return this.hasNumericFlag() && (this.componentFlags2 & 0x20) != 0;
        }

        public void setBinaryFlag() {
            this.componentFlags2 = 160;
        }

        public boolean hasBinaryFlag() {
            return this.hasNonDisplayFlag() && (this.componentFlags2 & 7) == 0;
        }

        public void setPackedDecimalFlag() {
            this.componentFlags2 = 161;
        }

        public boolean hasPackedDecimalFlag() {
            return this.hasNonDisplayFlag() && (this.componentFlags2 & 7) == 1;
        }

        public void setCompXFlag() {
            this.componentFlags2 = 162;
        }

        public boolean hasCompXFlag() {
            return this.hasNonDisplayFlag() && (this.componentFlags2 & 7) == 2;
        }

        public void setComp5Flag() {
            this.componentFlags2 = 163;
        }

        public boolean hasComp5Flag() {
            return this.hasNonDisplayFlag() && (this.componentFlags2 & 7) == 3;
        }

        public void setFloatingPointFlag() {
            this.componentFlags2 = 164;
        }

        public boolean hasFloatingPointFlag() {
            return this.hasNonDisplayFlag() && (this.componentFlags2 & 7) == 4;
        }

        public void setSignTrailingIncludedFlag() {
            this.componentFlags2 = 128;
        }

        public boolean hasSignTrailingIncludedFlag() {
            return this.hasNumericFlag() && !this.hasNonDisplayFlag() && (this.componentFlags2 & 7) == 0;
        }

        public void setSignTrailingSeparateFlag() {
            this.componentFlags2 = 129;
        }

        public boolean hasSignTrailingSeparateFlag() {
            return this.hasNumericFlag() && !this.hasNonDisplayFlag() && (this.componentFlags2 & 7) == 1;
        }

        public void setSignLeadingIncludedFlag() {
            this.componentFlags2 = 130;
        }

        public boolean hasSignLeadingIncludedFlag() {
            return this.hasNumericFlag() && !this.hasNonDisplayFlag() && (this.componentFlags2 & 7) == 2;
        }

        public void setSignLeadingSeparateFlag() {
            this.componentFlags2 = 131;
        }

        public boolean hasSignLeadingSeparateFlag() {
            return this.hasNumericFlag() && !this.hasNonDisplayFlag() && (this.componentFlags2 & 7) == 3;
        }

        public void setApplyCollatingSequenceFlag() {
            this.componentFlags2 = 2;
        }

        public boolean hasApplyCollatingSequenceFlag() {
            return !this.hasNumericFlag() && (this.componentFlags2 & 2) != 0;
        }

        public byte[] toByteArray() {
            byte[] byArray = new byte[10];
            int n = 0;
            n = FileDeclaration.storeBinary(this.componentFlags1, byArray, n, 1);
            n = FileDeclaration.storeBinary(this.componentFlags2, byArray, n, 1);
            n = FileDeclaration.storeBinary(this.componentOffset, byArray, n, 4);
            n = FileDeclaration.storeBinary(this.componentLength, byArray, n, 4);
            return byArray;
        }
    }

    public class KeyDefinitionArea {
        public static final int byteSize = 16;
        private static final int duplicatesAllowed = 64;
        private static final int primeKey = 16;
        private static final int sparseKey = 2;
        private static final int compressionOfTrailingNulls = 8;
        private static final int compressionOfTrailingSpaces = 4;
        private static final int compressionOfLeadingCharacters = 2;
        private static final int compressionOfDuplicates = 1;
        public int firstComponentOffset = 0;
        public int keyFlags = 0;
        public int compressionFlags = 0;
        public int sparseCharacter = 0;
        public final ArrayList<ComponentDefinitionArea> components = new ArrayList();

        public void setDuplicatesAllowedFlag() {
            this.keyFlags |= 0x40;
        }

        public boolean hasDuplicatesAllowedFlag() {
            return (this.keyFlags & 0x40) != 0;
        }

        public void setPrimeKeyFlag() {
            this.keyFlags |= 0x10;
        }

        public boolean hasPrimeKeyFlag() {
            return (this.keyFlags & 0x10) != 0;
        }

        public void setSparseKeyFlag() {
            this.keyFlags |= 2;
        }

        public boolean hasSparseKeyFlag() {
            return (this.keyFlags & 2) != 0;
        }

        public void setCompressionOfTrailingNullsFlag() {
            this.compressionFlags |= 8;
        }

        public boolean hasCompressionOfTrailingNullsFlag() {
            return (this.compressionFlags & 8) != 0;
        }

        public void setCompressionOfTrailingSpacesFlag() {
            this.compressionFlags |= 4;
        }

        public boolean hasCompressionOfTrailingSpacesFlag() {
            return (this.compressionFlags & 4) != 0;
        }

        public void setCompressionOfLeadingCharactersFlag() {
            this.compressionFlags |= 2;
        }

        public boolean hasCompressionOfLeadingCharactersFlag() {
            return (this.compressionFlags & 2) != 0;
        }

        public void setCompressionOfDuplicatesFlag() {
            this.compressionFlags |= 1;
        }

        public boolean hasCompressionOfDuplicatesFlag() {
            return (this.compressionFlags & 1) != 0;
        }

        public byte[] toByteArray() {
            byte[] byArray = new byte[16];
            int n = 0;
            n = FileDeclaration.storeBinary(this.components.size(), byArray, n, 2);
            n = FileDeclaration.storeBinary(this.firstComponentOffset, byArray, n, 2);
            n = FileDeclaration.storeBinary(this.keyFlags, byArray, n, 1);
            n = FileDeclaration.storeBinary(this.compressionFlags, byArray, n, 1);
            n = FileDeclaration.storeBinary(this.sparseCharacter, byArray, n, 1);
            byArray[n++] = 32;
            n += 8;
            return byArray;
        }

        private int getComponentByteSize() {
            return this.components.size() * 10;
        }
    }

    public class GlobalInformationArea {
        public static final int byteSize = 14;
        public int arrayLength;
        private final ArrayList<KeyDefinitionArea> keys = new ArrayList();

        private KeyDefinitionArea addKey(Key key) {
            KeyDefinitionArea keyDefinitionArea = new KeyDefinitionArea();
            if (key.getIndex() == 0) {
                keyDefinitionArea.setPrimeKeyFlag();
            }
            if (key.getSegments().size() > 0) {
                for (AbstractOperand abstractOperand : key.getSegments()) {
                    keyDefinitionArea.components.add(this.getComponentDefinitionArea(key, abstractOperand));
                }
            } else {
                keyDefinitionArea.components.add(this.getComponentDefinitionArea(key, key.getDataItemReference()));
            }
            if (key.withDuplicates) {
                keyDefinitionArea.setDuplicatesAllowedFlag();
            }
            this.keys.add(keyDefinitionArea);
            return keyDefinitionArea;
        }

        private ComponentDefinitionArea getComponentDefinitionArea(Key key, AbstractOperand abstractOperand) {
            ComponentDefinitionArea componentDefinitionArea = new ComponentDefinitionArea();
            if (IOperand.isNumeric(abstractOperand)) {
                switch (abstractOperand.getBuiltIn().getUsage()) {
                    case DISPLAY: {
                        componentDefinitionArea.setNumericFlag();
                        break;
                    }
                    case COMP_1: 
                    case COMP_2: {
                        componentDefinitionArea.setFloatingPointFlag();
                        break;
                    }
                    case COMP_3: {
                        componentDefinitionArea.setPackedDecimalFlag();
                        componentDefinitionArea.setSignedFlag();
                        break;
                    }
                    case COMP_4: {
                        componentDefinitionArea.setCompXFlag();
                        componentDefinitionArea.setSignedFlag();
                        break;
                    }
                    case COMP_5: {
                        componentDefinitionArea.setSignedFlag();
                        componentDefinitionArea.setComp5Flag();
                        break;
                    }
                    case COMP_6: {
                        componentDefinitionArea.setPackedDecimalFlag();
                        break;
                    }
                    case COMP_X: {
                        componentDefinitionArea.setCompXFlag();
                        break;
                    }
                    case BIT: {
                        componentDefinitionArea.setBinaryFlag();
                        break;
                    }
                    case STRING: 
                    case OBJECT: 
                    case CHARACTER: 
                    case DECIMAL: 
                    case CONDITION_VALUE: {
                        break;
                    }
                    case BINARY_CHAR_SIGNED: 
                    case BINARY_CHAR_UNSIGNED: 
                    case BINARY_DOUBLE_SIGNED: 
                    case BINARY_DOUBLE_UNSIGNED: 
                    case BINARY_SHORT_SIGNED: 
                    case BINARY_SHORT_UNSIGNED: 
                    case BINARY_LONG_SIGNED: 
                    case BINARY_LONG_UNSIGNED: {
                        componentDefinitionArea.setBinaryFlag();
                        componentDefinitionArea.setSignedFlag();
                        break;
                    }
                    case FLOAT_SHORT: 
                    case FLOAT_LONG: {
                        componentDefinitionArea.setFloatingPointFlag();
                        break;
                    }
                    case INDEX: {
                        componentDefinitionArea.setBinaryFlag();
                        break;
                    }
                    case POINTER: 
                    case POINTER_32: {
                        componentDefinitionArea.setBinaryFlag();
                        break;
                    }
                }
            }
            componentDefinitionArea.componentOffset = abstractOperand.getChunk().getOffset();
            componentDefinitionArea.componentLength = abstractOperand.getChunk().getSize();
            return componentDefinitionArea;
        }

        public byte[] toByteArray() {
            byte[] byArray = new byte[14];
            int n = 0;
            n = FileDeclaration.storeBinary(this.arrayLength, byArray, n, 2);
            byArray[n++] = 2;
            n += 3;
            n = FileDeclaration.storeBinary(this.keys.size(), byArray, n, 2);
            n += 6;
            return byArray;
        }
    }

    public class KeyDefinitionBlock {
        private final GlobalInformationArea globalInformationArea;

        public KeyDefinitionBlock(List<Key> list) {
            this.globalInformationArea = new GlobalInformationArea();
            for (Key object : list) {
                KeyDefinitionArea keyDefinitionArea = this.globalInformationArea.addKey(object);
            }
            int n = this.getFirstComponentOffset();
            for (KeyDefinitionArea keyDefinitionArea : this.globalInformationArea.keys) {
                keyDefinitionArea.firstComponentOffset = n;
                n += keyDefinitionArea.getComponentByteSize();
            }
            this.globalInformationArea.arrayLength = this.getByteArraySize();
        }

        public byte[] toByteArray() {
            byte[] byArray = new byte[this.globalInformationArea.arrayLength];
            int n = 0;
            byte[] byArray2 = this.globalInformationArea.toByteArray();
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            n += byArray2.length;
            for (KeyDefinitionArea keyDefinitionArea : this.globalInformationArea.keys) {
                byArray2 = keyDefinitionArea.toByteArray();
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                n += byArray2.length;
            }
            for (KeyDefinitionArea keyDefinitionArea : this.globalInformationArea.keys) {
                for (ComponentDefinitionArea componentDefinitionArea : keyDefinitionArea.components) {
                    byArray2 = componentDefinitionArea.toByteArray();
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    n += byArray2.length;
                }
            }
            return byArray;
        }

        private int getByteArraySize() {
            int n = this.getFirstComponentOffset();
            for (KeyDefinitionArea keyDefinitionArea : this.globalInformationArea.keys) {
                n += keyDefinitionArea.getComponentByteSize();
            }
            return n;
        }

        private int getFirstComponentOffset() {
            return 14 + FileDeclaration.this.keys.size() * 16;
        }
    }
}

