/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file;

import com.veryant.vision4j.file.internals.FileAddress;
import com.veryant.vision4j.file.internals.FileDescriptor;

abstract class SegmentedFile {
    private static final int INITIAL_SIZE = 10;
    private FileDescriptor[] fileDescriptors = new FileDescriptor[10];
    private long[] segmentSizes = new long[10];
    private int segmentCount;
    private final FileAddress fileSize = new FileAddress();
    private final FileAddress nextBlock = new FileAddress();

    SegmentedFile() {
    }

    void setSegmentSize(int index, long size) {
        if (index >= this.segmentCount) {
            throw new IndexOutOfBoundsException();
        }
        this.segmentSizes[index] = size;
    }

    long getSegmentSize(int index) {
        if (index >= this.segmentCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.segmentSizes[index];
    }

    void addSegment(FileDescriptor fileDescriptor) {
        if (this.segmentCount >= this.fileDescriptors.length) {
            FileDescriptor[] tmpFd = this.fileDescriptors;
            this.fileDescriptors = new FileDescriptor[tmpFd.length + tmpFd.length / 4];
            System.arraycopy(tmpFd, 0, this.fileDescriptors, 0, tmpFd.length);
            long[] tmpSs = this.segmentSizes;
            this.segmentSizes = new long[tmpSs.length + tmpSs.length / 4];
            System.arraycopy(tmpSs, 0, this.segmentSizes, 0, tmpSs.length);
        }
        this.fileDescriptors[this.segmentCount] = fileDescriptor;
        ++this.segmentCount;
    }

    FileDescriptor getSegment(int segmentIndex) {
        if (segmentIndex < this.segmentCount) {
            return this.fileDescriptors[segmentIndex];
        }
        throw new IndexOutOfBoundsException();
    }

    public int getSegmentCount() {
        return this.segmentCount;
    }

    public FileAddress getFileSize() {
        return this.fileSize;
    }

    public FileAddress getNextBlock() {
        return this.nextBlock;
    }
}

