/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file.internals;

public class Block {
    private final byte[] bytes;
    private final int size;

    public int size() {
        return this.size;
    }

    public Block(byte[] bytes) {
        this.bytes = bytes;
        this.size = bytes.length;
    }

    public Block(int size) {
        this(new byte[size]);
    }

    public int compare(int offset, byte[] other, int otherOffset, int length) {
        for (int i = 0; i < length; ++i) {
            int a = this.bytes[offset + i] & 0xFF;
            int b = other[otherOffset + i] & 0xFF;
            if (a == b) continue;
            return a < b ? -1 : 1;
        }
        return 0;
    }

    public int compare(int offset, Block other, int otherOffset, int length) {
        return this.compare(offset, other.bytes, otherOffset, length);
    }

    public void fill(int offset, int length, byte val) {
        int limit = offset + length;
        for (int i = offset; i < limit; ++i) {
            this.bytes[i] = val;
        }
    }

    public Block copy() {
        byte[] copy = new byte[this.bytes.length];
        System.arraycopy(this.bytes, 0, copy, 0, this.bytes.length);
        return new Block(copy);
    }

    public void copy(int offset, byte[] source, int sourceOffset, int sourceLength) {
        System.arraycopy(source, sourceOffset, this.bytes, offset, sourceLength);
    }

    public void copy(int offset, Block source, int sourceOffset, int sourceLength) {
        System.arraycopy(source.bytes, sourceOffset, this.bytes, offset, sourceLength);
    }

    public void shift(int offset, int shift, int size) {
        block3: {
            block2: {
                if (shift <= 0) break block2;
                int i = offset + size - 1;
                int k = offset + size - 1 + shift;
                while (size > 0) {
                    this.bytes[k] = this.bytes[i];
                    --size;
                    --i;
                    --k;
                }
                break block3;
            }
            if (shift >= 0) break block3;
            int i = offset;
            int k = offset + shift;
            while (size > 0) {
                this.bytes[k] = this.bytes[i];
                --size;
                ++i;
                ++k;
            }
        }
    }

    public void put8(int offset, byte value) {
        this.bytes[offset] = value;
    }

    public byte get8(int offset) {
        return this.bytes[offset];
    }

    public void put16(int offset, short value) {
        this.bytes[offset] = (byte)(value >>> 8);
        this.bytes[++offset] = (byte)value;
    }

    public short get16(int offset) {
        return (short)((this.bytes[offset] & 0xFF) << 8 | this.bytes[++offset] & 0xFF);
    }

    public void put32(int offset, int value) {
        this.bytes[offset] = (byte)(value >>> 24);
        this.bytes[++offset] = (byte)(value >>> 16);
        this.bytes[++offset] = (byte)(value >>> 8);
        this.bytes[++offset] = (byte)value;
    }

    public int get32(int offset) {
        return (this.bytes[offset] & 0xFF) << 24 | (this.bytes[++offset] & 0xFF) << 16 | (this.bytes[++offset] & 0xFF) << 8 | this.bytes[++offset] & 0xFF;
    }

    public void put48(int offset, long value) {
        this.bytes[offset] = (byte)(value >>> 40);
        this.bytes[++offset] = (byte)(value >>> 32);
        this.bytes[++offset] = (byte)(value >>> 24);
        this.bytes[++offset] = (byte)(value >>> 16);
        this.bytes[++offset] = (byte)(value >>> 8);
        this.bytes[++offset] = (byte)value;
    }

    public long get48(int offset) {
        return ((long)this.bytes[offset] & 0xFFL) << 40 | ((long)this.bytes[++offset] & 0xFFL) << 32 | ((long)this.bytes[++offset] & 0xFFL) << 24 | ((long)this.bytes[++offset] & 0xFFL) << 16 | ((long)this.bytes[++offset] & 0xFFL) << 8 | (long)this.bytes[++offset] & 0xFFL;
    }

    public long get48s(int offset) {
        return (long)this.bytes[offset] << 40 | ((long)this.bytes[++offset] & 0xFFL) << 32 | ((long)this.bytes[++offset] & 0xFFL) << 24 | ((long)this.bytes[++offset] & 0xFFL) << 16 | ((long)this.bytes[++offset] & 0xFFL) << 8 | (long)this.bytes[++offset] & 0xFFL;
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

