/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.browser.fx;

import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.swing.CobolEvent;
import com.iscobol.gui.client.swing.CobolEventListener;
import com.iscobol.gui.client.swing.PicobolWebBrowser;
import com.iscobol.gui.client.swing.PopupListener;
import com.iscobol.gui.client.swing.SearchKeyEvent;
import com.iscobol.gui.client.swing.SearchKeyEventListener;
import com.iscobol.rts.FindDialog;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.embed.swing.SwingNode;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Window;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import netscape.javascript.JSObject;

public class JFXWebBrowser
extends JPanel
implements PicobolWidget,
PicobolWebBrowser,
FindDialog.FindListener {
    private static final long serialVersionUID = 1L;
    private static Class<?> javafxPrinterJob;
    private JFXPanel jfxPanel;
    private WebView browser;
    private WebEngine webEngine;
    private ContextMenu[] contextMenu;
    private MenuItem backItem;
    private MenuItem forwardItem;
    private MenuItem copyItem;
    private boolean popupMenuEnabled = true;
    private String statusText;
    private URL url;
    private String urlString;
    private String title;
    private int progress;
    private boolean busy;
    private boolean canGoBack;
    private boolean canGoForward;
    private Vector<CobolEventListener> eventListeners = new Vector();
    private Vector<SearchKeyEventListener> searchListeners = new Vector();
    private String saveAsFilename;
    private boolean activated;
    private KeyListener keyListener;
    private KeyListener myKeyListener;
    private ChangeListener<String> locationPropListener;
    private ChangeListener<String> titlePropListener;
    private ChangeListener<Number> progressPropListener;
    private ChangeListener<Boolean> runningPropListener;
    private ChangeListener<String> messagePropListener;
    private ChangeListener<Number> historyPropListener;
    private FindDialog findDialog;

    public JFXWebBrowser() {
        super(new BorderLayout());
        this.jfxPanel = new JFXPanel();
        this.createScene();
        this.add((Component)this.jfxPanel, "Center");
        this.myKeyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!(JFXWebBrowser.this.keyListener == null || JFXWebBrowser.this.contextMenu != null && JFXWebBrowser.this.contextMenu[0] != null && JFXWebBrowser.this.contextMenu[0].isShowing())) {
                    JFXWebBrowser.this.keyListener.keyReleased(e);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (!(JFXWebBrowser.this.keyListener == null || JFXWebBrowser.this.contextMenu != null && JFXWebBrowser.this.contextMenu[0] != null && JFXWebBrowser.this.contextMenu[0].isShowing())) {
                    JFXWebBrowser.this.keyListener.keyPressed(e);
                }
            }
        };
        super.addKeyListener(this.myKeyListener);
    }

    private void createScene() {
        Platform.runLater(() -> {
            this.browser = new WebView();
            this.webEngine = this.browser.getEngine();
            this.browser.setContextMenuEnabled(false);
            this.setCallbacks();
            Scene scene = new Scene((Parent)this.browser);
            this.jfxPanel.setScene(scene);
        });
    }

    private void find() {
        JFrame ownerFrame = null;
        JDialog ownerDialog = null;
        for (Container cnt = this.getParent(); cnt != null; cnt = cnt.getParent()) {
            if (cnt instanceof JFrame) {
                ownerFrame = (JFrame)cnt;
                break;
            }
            if (!(cnt instanceof JDialog)) continue;
            ownerDialog = (JDialog)cnt;
            break;
        }
        if (this.findDialog == null) {
            this.findDialog = ownerFrame != null ? new FindDialog(ownerFrame, "Find", false, false) : (ownerDialog != null ? new FindDialog(ownerDialog, "Find", false, false) : new FindDialog((JFrame)null, "Find", false, false));
            this.findDialog.setFindListener(this);
        }
        if (!this.findDialog.isVisible()) {
            this.findDialog.setLocationRelativeTo(this);
            this.findDialog.open();
            this.findDialog.toFront();
        }
    }

    private void findImpl(FindDialog.FindParam param) {
        try {
            InputStream is = this.getClass().getResourceAsStream("find.js");
            byte[] b = new byte[is.available()];
            is.read(b);
            is.close();
            String function = new String(b);
            function = function + "\nmyfind(window, \"" + param.toSearch + "\", " + param.matchCase + ", " + param.backSearch + ")";
            this.executeScript(function);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setCallbacks() {
        Worker worker = this.webEngine.getLoadWorker();
        this.browser.setOnKeyPressed(e -> {
            boolean issearchkey = false;
            for (SearchKeyEventListener s : this.searchListeners) {
                try {
                    issearchkey = s.isSearchKeyEvent(new SearchKeyEvent(this, this.getKeyCodeAwt(e.getCode()), e.isShiftDown(), e.isControlDown(), e.isAltDown()));
                }
                catch (Exception exception) {}
            }
            if (issearchkey) {
                this.find();
            } else if (e.isControlDown()) {
                switch (e.getCode()) {
                    case C: {
                        this.runInBackground(() -> this.copySelection());
                        break;
                    }
                    case ADD: 
                    case PLUS: {
                        this.browser.setZoom(this.browser.getZoom() + 0.1);
                        break;
                    }
                    case SUBTRACT: 
                    case MINUS: {
                        if (!(this.browser.getZoom() >= 0.2)) break;
                        this.browser.setZoom(this.browser.getZoom() - 0.1);
                        break;
                    }
                }
            }
        });
        this.webEngine.setOnStatusChanged(evt -> {
            this.statusText = evt.getData() != null ? (String)evt.getData() : "";
            this.pushEvent(16434);
        });
        this.locationPropListener = (observable, oldValue, newValue) -> {
            this.setURLString((String)newValue);
            this.pushEvent(16431);
        };
        this.webEngine.locationProperty().addListener(this.locationPropListener);
        this.titlePropListener = (observable, oldValue, newValue) -> {
            this.title = newValue;
            this.pushEvent(16435);
        };
        this.webEngine.titleProperty().addListener(this.titlePropListener);
        this.webEngine.setConfirmHandler(param -> {
            int ret = JOptionPane.showConfirmDialog((Component)this.jfxPanel, param, "", 0);
            return ret == 0;
        });
        this.webEngine.setOnAlert(event -> JOptionPane.showMessageDialog((Component)this.jfxPanel, event.getData(), "", 2));
        this.progressPropListener = (observable, oldValue, newValue) -> {
            this.progress = (int)Math.round(newValue.doubleValue() * 100.0);
            this.pushEvent(16433);
        };
        worker.progressProperty().addListener(this.progressPropListener);
        this.runningPropListener = (observable, oldValue, newValue) -> {
            boolean b = this.busy;
            boolean bl = this.busy = newValue == Boolean.TRUE;
            if (b && !this.busy) {
                this.pushEvent(16432);
            }
        };
        worker.runningProperty().addListener(this.runningPropListener);
        this.messagePropListener = (observable, oldValue, newValue) -> {
            this.statusText = newValue;
            this.pushEvent(16434);
        };
        worker.messageProperty().addListener(this.messagePropListener);
        this.historyPropListener = (observable, oldValue, newValue) -> {
            int historySize = this.webEngine.getHistory().getEntries().size();
            this.canGoBack = newValue.intValue() > 0;
            this.canGoForward = newValue.intValue() < historySize - 1;
        };
        this.webEngine.getHistory().currentIndexProperty().addListener(this.historyPropListener);
        this.browser.setOnScroll(event -> {
            if (event.isControlDown()) {
                if (event.getDeltaY() > 0.0) {
                    this.browser.setZoom(this.browser.getZoom() + 0.1);
                } else if (event.getDeltaY() < 0.0 && this.browser.getZoom() >= 0.2) {
                    this.browser.setZoom(this.browser.getZoom() - 0.1);
                }
                event.consume();
            }
        });
        if (this.contextMenu == null) {
            this.contextMenu = new ContextMenu[]{new ContextMenu()};
            ArrayList<MenuItem> items = new ArrayList<MenuItem>();
            MenuItem item = new MenuItem("Reload");
            item.setOnAction(event -> this.intReload());
            items.add(item);
            item = new SeparatorMenuItem();
            items.add(item);
            item = new MenuItem("Back");
            item.setOnAction(event -> this.intBack());
            items.add(item);
            this.backItem = item;
            item = new MenuItem("Forward");
            item.setOnAction(event -> this.intForward());
            items.add(item);
            this.forwardItem = item;
            item = new SeparatorMenuItem();
            items.add(item);
            item = new MenuItem("Copy");
            item.setOnAction(event -> {
                MenuItem it = (MenuItem)event.getSource();
                this.intCopySelection((String)it.getUserData());
            });
            items.add(item);
            this.copyItem = item;
            item = new MenuItem("Select All");
            item.setOnAction(event -> this.runInBackground(() -> this.selectAll("window")));
            items.add(item);
            item = new SeparatorMenuItem();
            items.add(item);
            item = new MenuItem("Find");
            item.setOnAction(event -> this.find());
            items.add(item);
            item = new SeparatorMenuItem();
            items.add(item);
            item = new MenuItem("Print");
            item.setOnAction(event -> this.print(true));
            items.add(item);
            item = new MenuItem("Save As");
            item.setOnAction(event -> this.runInBackground(() -> this.save(true)));
            items.add(item);
            this.contextMenu[0].getItems().addAll(items);
        }
        this.browser.setOnMousePressed(e -> {
            if (!this.popupMenuEnabled) {
                return;
            }
            if (e.getButton() == MouseButton.SECONDARY) {
                double x = e.getScreenX();
                double y = e.getScreenY();
                if (this.backItem != null) {
                    this.runInBackground(() -> {
                        this.backItem.setDisable(!this.canGoBack);
                        this.forwardItem.setDisable(!this.canGoForward);
                        String selection = this.getSelection("window");
                        this.copyItem.setDisable(selection == null || selection.length() == 0);
                        this.copyItem.setUserData((Object)selection);
                    });
                }
                this.contextMenu[0].show((Node)this.browser, x, y);
            } else {
                this.contextMenu[0].hide();
            }
        });
    }

    private void removeCallbacks() {
        this.webEngine.locationProperty().removeListener(this.locationPropListener);
        this.webEngine.titleProperty().removeListener(this.titlePropListener);
        Worker worker = this.webEngine.getLoadWorker();
        worker.progressProperty().removeListener(this.progressPropListener);
        worker.runningProperty().removeListener(this.runningPropListener);
        worker.messageProperty().removeListener(this.messagePropListener);
        this.webEngine.getHistory().currentIndexProperty().removeListener(this.historyPropListener);
    }

    @Override
    public void addCobolEventListener(CobolEventListener cel) {
        if (!this.eventListeners.contains(cel)) {
            this.eventListeners.addElement(cel);
        }
    }

    @Override
    public void removeCobolEventListener(CobolEventListener cel) {
        this.eventListeners.removeElement(cel);
    }

    @Override
    public void addMouseListener(MouseListener ml) {
        if (ml instanceof PopupListener) {
            PopupListener pl = (PopupListener)ml;
            JPopupMenu popup = pl.getPopupMenu();
            if (this.contextMenu == null) {
                this.contextMenu = new ContextMenu[1];
            } else {
                this.copyItem = null;
                this.forwardItem = null;
                this.backItem = null;
            }
            Platform.runLater(() -> {
                if (this.contextMenu[0] == null) {
                    this.contextMenu[0] = new ContextMenu();
                }
                this.contextMenu[0].getItems().clear();
                this.contextMenu[0].getItems().addAll(this.getItems(popup.getComponents()));
            });
            this.popupMenuEnabled = true;
        } else {
            super.addMouseListener(ml);
        }
    }

    private List<MenuItem> getItems(Component[] cs) {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        for (Component c : cs) {
            SeparatorMenuItem newItem;
            JMenuItem jmItem;
            if (c instanceof JMenu) {
                jmItem = (JMenuItem)c;
                Menu menu = new Menu(jmItem.getText());
                newItem = menu;
                menu.getItems().addAll(this.getItems(((JMenu)c).getMenuComponents()));
            } else if (c instanceof JMenuItem) {
                jmItem = (JMenuItem)c;
                newItem = new MenuItem(jmItem.getText());
                newItem.setOnAction(event -> jmItem.getActionListeners()[0].actionPerformed(null));
            } else if (c instanceof JPopupMenu.Separator) {
                newItem = new SeparatorMenuItem();
                jmItem = null;
            } else {
                newItem = null;
                jmItem = null;
            }
            if (newItem == null) continue;
            if (jmItem != null) {
                int idx;
                String text;
                newItem.setDisable(!jmItem.isEnabled());
                if (jmItem.getIcon() != null) {
                    SwingNode sn = new SwingNode();
                    sn.setContent((JComponent)new JLabel(jmItem.getIcon()));
                    newItem.setGraphic((Node)sn);
                }
                if (jmItem.getMnemonic() != 0 && (text = jmItem.getText()) != null && (idx = text.indexOf((char)jmItem.getMnemonic())) >= 0) {
                    newItem.setMnemonicParsing(true);
                    newItem.setText(new StringBuilder(text).insert(idx, '_').toString());
                }
            }
            items.add((MenuItem)newItem);
        }
        return items;
    }

    @Override
    public void addSearchKeyEventListener(SearchKeyEventListener skl) {
        if (!this.searchListeners.contains(skl)) {
            this.searchListeners.addElement(skl);
        }
    }

    @Override
    public void removeSearchKeyEventListener(SearchKeyEventListener skl) {
        this.searchListeners.removeElement(skl);
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public String getURLString() {
        return this.urlString;
    }

    @Override
    public void setURL(URL u) {
        this.url = u;
        this.urlString = this.url != null ? this.url.toExternalForm() : null;
        this.loadURL();
    }

    public void setURL(String url) {
        this.urlString = url;
        this.url = this.urlString != null ? JFXWebBrowser.toURL(url) : null;
        this.loadURL();
    }

    @Override
    public void setValue(String url) {
        this.setURL(url);
    }

    @Override
    public void setContent(String c) {
        Platform.runLater(() -> this.webEngine.loadContent(c));
    }

    private void loadURL() {
        if (this.url != null) {
            String newUrl = this.urlString;
            Platform.runLater(() -> this.webEngine.load(newUrl));
        }
    }

    @Override
    public boolean isBusy() {
        return this.busy;
    }

    @Override
    public String getStatusText() {
        return this.statusText;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getProgress() {
        return String.valueOf(this.progress);
    }

    @Override
    public void back() {
        if (this.canGoBack) {
            Platform.runLater(() -> this.intBack());
        }
    }

    private void intBack() {
        this.webEngine.getHistory().go(-1);
    }

    @Override
    public void forward() {
        if (this.canGoForward) {
            Platform.runLater(() -> this.intForward());
        }
    }

    private void intForward() {
        this.webEngine.getHistory().go(1);
    }

    @Override
    public void refresh() {
        Platform.runLater(() -> this.intReload());
    }

    private void intReload() {
        this.webEngine.reload();
    }

    @Override
    public void stop() {
        Platform.runLater(() -> this.webEngine.getLoadWorker().cancel());
    }

    @Override
    public void abortOpenURL() {
    }

    @Override
    public void doOpenURL() {
    }

    @Override
    public void destroy() {
        super.removeKeyListener(this.myKeyListener);
        Platform.runLater(() -> this.removeCallbacks());
        this.jfxPanel.removeAll();
        if (this.findDialog != null) {
            this.findDialog.dispose();
            this.findDialog = null;
        }
    }

    @Override
    public void printContent(boolean unused) {
        this.print(true);
    }

    @Override
    public void printNoPrompt(boolean unused) {
        this.print(false);
    }

    private void print(boolean showPrintDialog) {
        if (javafxPrinterJob == null) {
            return;
        }
        Platform.runLater(() -> {
            try {
                Object job = javafxPrinterJob.getMethod("createPrinterJob", new Class[0]).invoke(null, new Object[0]);
                if (job != null) {
                    boolean doPrint = true;
                    if (showPrintDialog) {
                        doPrint = (Boolean)javafxPrinterJob.getMethod("showPrintDialog", Window.class).invoke(job, new Object[]{null});
                    }
                    if (doPrint) {
                        this.webEngine.getClass().getMethod("print", javafxPrinterJob).invoke((Object)this.webEngine, job);
                        job.getClass().getMethod("endJob", new Class[0]).invoke(job, new Object[0]);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    @Override
    public void saveAs(boolean unused) {
        this.save(true);
    }

    @Override
    public void saveAsNoPrompt(boolean b) {
        this.save(false);
    }

    private File getFileFromChooser(String dirfile, int type, String[] exts, String desc) {
        JFileChooser jfc = new JFileChooser(dirfile);
        jfc.setDialogType(type);
        class ChooserFileFilter
        extends FileFilter {
            private String[] arrayext;
            private String descriptor;

            public ChooserFileFilter(String[] exts, String desc) {
                StringBuffer sbdescr = new StringBuffer(desc + " (");
                this.arrayext = exts;
                for (int i = 0; i < this.arrayext.length; ++i) {
                    if (i > 0) {
                        sbdescr.append(", ");
                    }
                    sbdescr.append("*." + this.arrayext[i]);
                }
                sbdescr.append(")");
                this.descriptor = sbdescr.toString();
            }

            @Override
            public boolean accept(File file) {
                boolean Return2 = false;
                if (file.isDirectory()) {
                    return true;
                }
                String fname = file.getName();
                String fext = fname.substring(fname.lastIndexOf(".") + 1, fname.length()).toLowerCase();
                if (fext != null) {
                    for (int i = 0; i < this.arrayext.length; ++i) {
                        if (!fext.equals(this.arrayext[i])) continue;
                        Return2 = true;
                    }
                }
                return Return2;
            }

            @Override
            public String getDescription() {
                return this.descriptor;
            }
        }
        jfc.setFileFilter(new ChooserFileFilter(exts, desc));
        int returnChooser = 1;
        KeyboardBuffer.enable(null);
        returnChooser = jfc.showSaveDialog(this);
        if (returnChooser == 0) {
            return jfc.getSelectedFile();
        }
        return null;
    }

    private void save(boolean showSaveDialog) {
        String html = this.getContents();
        if (showSaveDialog) {
            File selectedFile = this.getFileFromChooser(".", 1, new String[]{"html"}, "HTML Files");
            if (selectedFile != null) {
                this.save(selectedFile, html);
            }
        } else if (this.saveAsFilename != null) {
            this.save(new File(this.saveAsFilename), html);
        }
    }

    private void save(File outputFile, String html) {
        try {
            PrintWriter pw = new PrintWriter(outputFile);
            pw.write(html);
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public String getContents() {
        return (String)this.executeScript("document.documentElement.outerHTML");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeScript(String script) {
        Object[] Return2 = new Object[]{Boolean.FALSE, null};
        Platform.runLater(() -> {
            Object o = this.webEngine.executeScript(script);
            Object[] objectArray = Return2;
            synchronized (Return2) {
                Return2[0] = Boolean.TRUE;
                Return2[1] = o;
                Return2.notify();
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        });
        Object[] objectArray = Return2;
        synchronized (Return2) {
            while (Return2[0] == Boolean.FALSE) {
                try {
                    Return2.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return Return2[1];
        }
    }

    @Override
    public void setFileName(String fileName) {
        this.saveAsFilename = fileName;
    }

    public String getFileName() {
        return this.saveAsFilename;
    }

    private static URL toURL(String str) {
        try {
            return new URL(str);
        }
        catch (MalformedURLException exception) {
            try {
                return new URL("http://" + str);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
    }

    @Override
    public void setNoMsgBeforeNavigate(boolean b) {
    }

    @Override
    public void setActiveAccept(boolean b) {
        this.activated = b;
    }

    @Override
    public boolean getActiveAccept() {
        return this.activated;
    }

    @Override
    public void setSelfAct(boolean b) {
    }

    @Override
    public boolean getSelfAct() {
        return false;
    }

    @Override
    public void asyncProcessEvent(AWTEvent e) {
    }

    private void setURLString(String url) {
        this.urlString = url;
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            this.url = null;
        }
    }

    private void pushEvent(int cobev) {
        CobolEvent ce = new CobolEvent(this, 7, cobev);
        for (CobolEventListener l : this.eventListeners) {
            try {
                l.cobolEvent(ce);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void selectAll() {
        this.selectAll("window");
    }

    private void selectAll(String window) {
        String activeElementName = (String)this.executeScript(window + ".document.activeElement.tagName");
        if (activeElementName.equalsIgnoreCase("FRAME")) {
            this.selectAll(window + ".document.activeElement.contentWindow");
            return;
        }
        JSObject activeElement = (JSObject)this.executeScript(window + ".document.activeElement");
        if (activeElementName.equalsIgnoreCase("INPUT")) {
            this.call(activeElement, "select", new Object[0]);
        } else {
            JSObject selection = (JSObject)this.executeScript(window + ".getSelection()");
            JSObject range = (JSObject)this.executeScript(window + ".document.createRange()");
            this.call(range, "selectNodeContents", activeElement);
            this.call(selection, "removeAllRanges", new Object[0]);
            this.call(selection, "addRange", range);
        }
    }

    private String getSelection(String window) {
        Integer frameCount;
        String selection = (String)this.executeScript(window + ".getSelection().toString()");
        if ((selection == null || selection.length() == 0) && (frameCount = (Integer)this.executeScript(window + ".frames.length")) != null) {
            for (int i = 0; i < frameCount && (selection == null || selection.length() == 0); ++i) {
                selection = this.getSelection(window + ".frames[" + i + "]");
            }
        }
        return selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object call(JSObject jsobject, String methodName, Object ... args) {
        Object[] Return2 = new Object[]{Boolean.FALSE, null};
        Platform.runLater(() -> {
            Object o = jsobject.call(methodName, args);
            Object[] objectArray = Return2;
            synchronized (Return2) {
                Return2[0] = Boolean.TRUE;
                Return2[1] = o;
                Return2.notify();
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
        });
        Object[] objectArray = Return2;
        synchronized (Return2) {
            while (Return2[0] == Boolean.FALSE) {
                try {
                    Return2.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return Return2[1];
        }
    }

    @Override
    public void copySelection() {
        String selection = this.getSelection("window");
        if (selection != null && selection.length() > 0) {
            this.intCopySelection(selection);
        }
    }

    private void intCopySelection(String selection) {
        StringSelection ss = new StringSelection(selection);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
    }

    @Override
    public void find(FindDialog.FindParam param) {
        this.runInBackground(() -> this.findImpl(param));
    }

    protected void runInBackground(Runnable run) {
        new Thread(run).start();
    }

    @Override
    public void addKeyListener(KeyListener l) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, l);
    }

    @Override
    public void removeKeyListener(KeyListener l) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, l);
    }

    public int getKeyCodeAwt(KeyCode awtKeyCode) {
        if (awtKeyCode == KeyCode.A) {
            return 65;
        }
        if (awtKeyCode == KeyCode.B) {
            return 66;
        }
        if (awtKeyCode == KeyCode.C) {
            return 67;
        }
        if (awtKeyCode == KeyCode.D) {
            return 68;
        }
        if (awtKeyCode == KeyCode.E) {
            return 69;
        }
        if (awtKeyCode == KeyCode.F) {
            return 70;
        }
        if (awtKeyCode == KeyCode.G) {
            return 71;
        }
        if (awtKeyCode == KeyCode.H) {
            return 72;
        }
        if (awtKeyCode == KeyCode.I) {
            return 73;
        }
        if (awtKeyCode == KeyCode.J) {
            return 74;
        }
        if (awtKeyCode == KeyCode.K) {
            return 75;
        }
        if (awtKeyCode == KeyCode.L) {
            return 76;
        }
        if (awtKeyCode == KeyCode.M) {
            return 77;
        }
        if (awtKeyCode == KeyCode.N) {
            return 78;
        }
        if (awtKeyCode == KeyCode.O) {
            return 79;
        }
        if (awtKeyCode == KeyCode.P) {
            return 80;
        }
        if (awtKeyCode == KeyCode.Q) {
            return 81;
        }
        if (awtKeyCode == KeyCode.R) {
            return 82;
        }
        if (awtKeyCode == KeyCode.S) {
            return 83;
        }
        if (awtKeyCode == KeyCode.T) {
            return 84;
        }
        if (awtKeyCode == KeyCode.U) {
            return 85;
        }
        if (awtKeyCode == KeyCode.V) {
            return 86;
        }
        if (awtKeyCode == KeyCode.W) {
            return 87;
        }
        if (awtKeyCode == KeyCode.X) {
            return 88;
        }
        if (awtKeyCode == KeyCode.Y) {
            return 89;
        }
        if (awtKeyCode == KeyCode.Z) {
            return 90;
        }
        return 0;
    }

    @Override
    public void setPopupMenuEnabled(boolean en) {
        this.popupMenuEnabled = en;
    }

    static {
        try {
            javafxPrinterJob = Class.forName("javafx.print.PrinterJob");
        }
        catch (ClassNotFoundException e) {
            javafxPrinterJob = null;
        }
        Platform.setImplicitExit((boolean)false);
    }
}

