/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import java.util.ArrayList;
import java.util.List;

public class Close
extends Verb
implements CobolToken,
ErrorsNumbers {
    public static final int HND_NO_HANDLE = 0;
    private final List filesToClose;
    boolean closeWindow = false;
    boolean withNoDisplay = false;
    VariableName varName = null;
    boolean ishandle;
    boolean closePopup;
    private boolean httpUnsupportedLog = this.pc.getOption("-whttp") != null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Close(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        this.filesToClose = new ArrayList();
        boolean width = false;
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 813) {
            if (this.httpUnsupportedLog) {
                this.error.print(232, 2, tk, "CLOSE");
            }
            this.closeWindow = true;
            tk = this.tm.getToken();
            if (tk.getToknum() != 10009) return;
            this.tm.ungetToken();
            this.varName = VariableName.get(this.tm, this.error, this.pc);
            this.ishandle = this.isHandle(this.varName);
            if (!this.ishandle) {
                throw new GeneralErrorException(96, 4, tk, tk.getWord(), this.error);
            }
            tk = this.tm.getToken();
            if (tk.getToknum() == 814) {
                tk = this.tm.getToken();
                width = true;
            }
            if (tk.getToknum() == 597) {
                tk = this.tm.getToken();
                if (tk.getToknum() == 409) {
                    this.withNoDisplay = true;
                    return;
                } else {
                    if (width) {
                        this.tm.ungetToken();
                    }
                    this.tm.ungetToken();
                    this.tm.ungetToken();
                }
                return;
            } else {
                if (width) {
                    this.tm.ungetToken();
                }
                this.tm.ungetToken();
            }
            return;
        } else if (tk.getToknum() == 640) {
            if (this.httpUnsupportedLog) {
                this.error.print(232, 2, kw, kw.getWord());
            }
            this.closePopup = true;
            tk = this.tm.getToken();
            if (tk.getToknum() != 10009) return;
            this.tm.ungetToken();
            this.varName = VariableName.get(this.tm, this.error, this.pc);
            if (this.varName == null) {
                throw new UnexpectedTokenException(tk, this.error);
            }
            tk = this.tm.getToken();
            if (tk.getToknum() == 814) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 373) {
                tk = this.tm.getToken();
                if (tk.getToknum() == 10001) return;
                if (tk.getToknum() != 10009) throw new UnexpectedTokenException(tk, this.error);
                this.tm.ungetToken();
                VariableName.get(this.tm, this.error, this.pc);
                return;
            } else {
                this.tm.ungetToken();
            }
            return;
        } else {
            while (tk.getToknum() == 10009) {
                Select sel = this.pc.getSelect(tk.getWord());
                if (sel == null) {
                    throw new GeneralErrorException(53, 4, tk, tk.getWord(), this.error);
                }
                if (sel.isSort()) {
                    throw new GeneralErrorException(103, 4, tk, tk.getWord(), this.error);
                }
                boolean reel = false;
                boolean lock = false;
                boolean noRewind = false;
                tk = this.tm.getToken();
                if (tk.getToknum() == 814 || tk.getToknum() == 676 || tk.getToknum() == 786 || tk.getToknum() == 597 || tk.getToknum() == 571) {
                    if (tk.getToknum() == 814) {
                        tk = this.tm.getToken();
                    }
                    switch (tk.getToknum()) {
                        case 676: 
                        case 786: {
                            tk = this.tm.getToken();
                            reel = true;
                            break;
                        }
                        case 571: {
                            tk = this.tm.getToken();
                            lock = true;
                            break;
                        }
                        case 597: {
                            tk = this.tm.getToken();
                            if (tk.getToknum() != 699) {
                                throw new ExpectedFoundException(tk, this.error, "REWIND");
                            }
                            tk = this.tm.getToken();
                            noRewind = true;
                        }
                    }
                }
                this.filesToClose.add(new FileToClose(sel, reel, lock, noRewind));
            }
            this.tm.ungetToken();
            if (!this.filesToClose.isEmpty()) return;
            throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        if (this.closeWindow) {
            Return2.append(this.parent.getIndent());
            this.getCodeDebug(Return2);
            Return2.append("ScrFactory.getGUIEnviroment().close(");
            if (this.varName != null) {
                Return2.append(this.varName.getCode());
                if (this.withNoDisplay) {
                    Return2.append(", true");
                }
            }
            Return2.append(")");
            Return2.append(";" + eol);
        } else if (this.closePopup) {
            Return2.append(this.parent.getIndent());
            this.getCodeDebug(Return2);
            Return2.append("ScrFactory.getGUIEnviroment().closePopup(");
            Return2.append(this.varName.getCode());
            Return2.append(")");
            Return2.append(";" + eol);
        } else {
            boolean hasGlobalDecl = this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
            this.getCodeDebug(Return2);
            for (FileToClose ftc : this.filesToClose) {
                Select sel = ftc.getSel();
                boolean hasDeclaratives = this.pc.getDeclarative(sel) != null || hasGlobalDecl;
                Return2.append(this.parent.getIndent());
                StringBuffer tmp1 = new StringBuffer();
                tmp1.append("try {");
                tmp1.append(eol);
                tmp1.append(this.parent.getIndent());
                StringBuffer tmp2 = new StringBuffer();
                tmp2.append(sel.getName());
                if (ftc.isReel()) {
                    tmp2.append(".closeReel();");
                } else {
                    tmp2.append(".close(");
                    String or = "";
                    if (ftc.isNoRewind()) {
                        tmp2.append(or);
                        tmp2.append("CobolFile.CLOSE_NO_REWIND");
                        or = "|";
                    }
                    tmp2.append(");");
                }
                tmp2.append(eol);
                if (ftc.isLock()) {
                    tmp2.append(this.parent.getIndent());
                    tmp2.append(sel.getName());
                    tmp2.append(".setCloseLock();");
                    tmp2.append(eol);
                }
                StringBuffer tmp3 = new StringBuffer();
                Use.putFileStatus(tmp3, sel, this.parent.getIndent());
                Use.putDeclaratives(tmp3, this.pc, sel, this.parent.getIndent(), hasDeclaratives);
                if (sel.isPrinter()) {
                    boolean sqljOpt = this.pc.getOption("-sqlj") != null;
                    Return2.append("if(" + sel.getName() + " instanceof com.iscobol.io.DeviceFile == false || !((com.iscobol.io.DeviceFile) ");
                    Return2.append(sel.getName());
                    Return2.append(").closeDeferred(");
                    if (sqljOpt) {
                        Return2.append("new Runnable() { public void run() {");
                    } else {
                        Return2.append("() -> {");
                    }
                    Return2.append(eol);
                    Return2.append(this.parent.getIndent());
                    Return2.append("try {");
                    Return2.append(eol);
                    Return2.append(this.parent.getIndent());
                    Return2.append(tmp1);
                    Return2.append("((com.iscobol.io.DeviceFile) ");
                    Return2.append(sel.getName());
                    Return2.append(").print(");
                    if (ftc.isNoRewind()) {
                        Return2.append("CobolFile.CLOSE_NO_REWIND");
                    }
                    Return2.append(");");
                    Return2.append(eol);
                    Return2.append(tmp3);
                    Return2.append(this.parent.getIndent());
                    String rts = this.pc.getOption("-xms") != null || this.pc.getOption("-cp") != null ? "com.iscobol.rts_n." : "";
                    Return2.append("} catch(Throwable t) { " + rts + "ErrorBox.show(t); }");
                    Return2.append(eol);
                    Return2.append(this.parent.getIndent());
                    if (sqljOpt) {
                        Return2.append("}");
                    }
                    Return2.append("})) {");
                    Return2.append(eol);
                    Return2.append(this.parent.getIndent());
                    Return2.append(tmp1);
                    Return2.append(tmp2);
                    Return2.append(tmp3);
                    Return2.append(this.parent.getIndent());
                    Return2.append("}");
                    Return2.append(eol);
                    continue;
                }
                Return2.append(tmp1);
                Return2.append(tmp2);
                Return2.append(tmp3);
            }
        }
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    boolean isWHandle(VariableName t) throws GeneralErrorException {
        VariableDeclaration vds = null;
        if (t == null) {
            return false;
        }
        vds = this.pc.getVar(t);
        return vds != null && (vds.isWindowHandle() || vds.isGenericHandle());
    }

    boolean isHandle(VariableName t) throws GeneralErrorException {
        VariableDeclaration vds = null;
        if (t == null) {
            return false;
        }
        vds = this.pc.getVar(t);
        return vds != null && (vds.isWindowHandle() || vds.isSubWindowHandle());
    }

    public boolean hasGlobalDecl() {
        return this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
    }

    public List getFilesToClose() {
        return this.filesToClose;
    }

    public static class FileToClose {
        private final Select sel;
        private final boolean reel;
        private final boolean lock;
        private final boolean noRewind;

        public FileToClose(Select sel, boolean reel, boolean lock, boolean noRewind) {
            this.sel = sel;
            this.reel = reel;
            this.lock = lock;
            this.noRewind = noRewind;
        }

        public boolean isReel() {
            return this.reel;
        }

        public boolean isLock() {
            return this.lock;
        }

        public boolean isNoRewind() {
            return this.noRewind;
        }

        public Select getSel() {
            return this.sel;
        }
    }
}

