/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.ElkParser;
import com.iscobol.compiler.ErrorInCompilationException;
import com.iscobol.compiler.ErrorLimitReachedException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.GUIControl;
import com.iscobol.compiler.MyStringTokenizer;
import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.OptionListForCodeAnalyzer;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.ReplaceList;
import com.iscobol.compiler.SMAPGenerator;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.remote.XmlParseException;
import com.iscobol.compiler.remote.client.Client;
import com.iscobol.compiler.remote.server.RemoteCompiler;
import com.iscobol.interfaces.compiler.FileFinder;
import com.iscobol.interfaces.compiler.ICompilerExtension8;
import com.iscobol.interfaces.compiler.IError;
import com.iscobol.interfaces.compiler.IErrors;
import com.iscobol.interfaces.compiler.IOptionList;
import com.iscobol.interfaces.compiler.IOptionListForCodeAnalyzer;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPreProcessor;
import com.iscobol.interfaces.compiler.IPreProcessorReaderProvider;
import com.iscobol.interfaces.compiler.IRealTimePreProcessor;
import com.iscobol.interfaces.compiler.IToken;
import com.iscobol.interfaces.compiler.ITokenList;
import com.iscobol.interfaces.compiler.ITokenManager;
import com.iscobol.interfaces.compiler.IVariableDeclaration;
import com.iscobol.interfaces.compiler.InvokeNotifier;
import com.iscobol.interfaces.compiler.ReferencedPccNotifier;
import com.iscobol.interfaces.compiler.VerbNotifier;
import com.iscobol.interfaces.compiler.remote.IRemoteCompiler;
import com.iscobol.interfaces.compiler.remote.IRemoteCompilerClient;
import com.iscobol.rts.Config;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Element;

public class CompilerImpl
implements ICompilerExtension8 {
    private static Map<Integer, Set<String>> wd2UnsupportedEvents;
    private static Collection<String> windowWd2UnsupportedStyles;
    private static Collection<String> windowWd2UnsupportedProperties;
    private static Set<String> wd2UnsupportedControls;
    private static Set<Integer> wd2UnsupportedControlsTypes;
    private static final Hashtable nrw;

    @Override
    public IOptionList newOptionList(String[] compOpts) {
        return new OptionList(compOpts);
    }

    @Override
    public IErrors newErrors() {
        return new Errors();
    }

    @Override
    public IPreProcessor newPreProcessor(String filename, String dir, IOptionList ol, IErrors errs) {
        if (ol != null && !(ol instanceof OptionList)) {
            throw new IllegalArgumentException(ol.toString());
        }
        if (errs != null && !(errs instanceof Errors)) {
            throw new IllegalArgumentException(errs.toString());
        }
        return new PreProcessor(filename, dir, (OptionList)ol, (Errors)errs);
    }

    @Override
    public IPreProcessor newPreProcessor(String filename, String dir, IOptionList ol, IErrors errs, FileFinder fileFinder) {
        if (ol != null && !(ol instanceof OptionList)) {
            throw new IllegalArgumentException(ol.toString());
        }
        if (errs != null && !(errs instanceof Errors)) {
            throw new IllegalArgumentException(errs.toString());
        }
        return new PreProcessor(filename, dir, (OptionList)ol, (Errors)errs, fileFinder, null);
    }

    @Override
    public ITokenManager newTokenManager(IPreProcessor pp, IOptionList ol, IErrors errs) {
        if (pp != null && !(pp instanceof PreProcessor)) {
            throw new IllegalArgumentException(pp.toString());
        }
        if (ol != null && !(ol instanceof OptionList)) {
            throw new IllegalArgumentException(ol.toString());
        }
        if (errs != null && !(errs instanceof Errors)) {
            throw new IllegalArgumentException(errs.toString());
        }
        return new TokenManager((PreProcessor)pp, (OptionList)ol, (Errors)errs);
    }

    @Override
    public IPcc newPcc(String name, String srcDir, String dir, ITokenManager tm, IOptionList ol, IErrors errs) {
        if (tm != null && !(tm instanceof TokenManager)) {
            throw new IllegalArgumentException(tm.toString());
        }
        if (ol != null && !(ol instanceof OptionList)) {
            throw new IllegalArgumentException(ol.toString());
        }
        if (errs != null && !(errs instanceof Errors)) {
            throw new IllegalArgumentException(errs.toString());
        }
        return new Pcc(name, srcDir, dir, (TokenManager)tm, (OptionList)ol, (Errors)errs, null);
    }

    @Override
    public IToken newToken(IToken tk) {
        if (!(tk instanceof Token)) {
            throw new IllegalArgumentException("" + tk);
        }
        return new Token((Token)tk);
    }

    @Override
    public IToken newToken(char c, int fln, int offs, String fn) {
        return new Token(c, fln, offs, fn);
    }

    @Override
    public IToken newToken(int tok, String s, int fln, int offs, String fn) {
        return new Token(tok, s, fln, offs, fn);
    }

    @Override
    public IVariableDeclaration newVariableDeclaration(IPcc pcc, IToken fileName, ITokenManager tm) {
        if (pcc != null && !(pcc instanceof Pcc)) {
            throw new IllegalArgumentException(pcc.toString());
        }
        if (fileName != null && !(fileName instanceof Token)) {
            throw new IllegalArgumentException(fileName.toString());
        }
        if (!(tm instanceof TokenManager)) {
            throw new IllegalArgumentException("" + tm);
        }
        return new VariableDeclaration((Pcc)pcc, (Token)fileName, (TokenManager)tm);
    }

    @Override
    public IVariableDeclaration newVariableDeclaration(IPcc pcc, ITokenManager tm, IErrors errs, IVariableDeclaration virtualParent) throws Exception {
        if (pcc != null && !(pcc instanceof Pcc)) {
            throw new IllegalArgumentException(pcc.toString());
        }
        if (!(tm instanceof TokenManager)) {
            throw new IllegalArgumentException("" + tm);
        }
        if (errs != null && !(errs instanceof Errors)) {
            throw new IllegalArgumentException(errs.toString());
        }
        if (virtualParent != null && !(virtualParent instanceof VariableDeclaration)) {
            throw new IllegalArgumentException(virtualParent.toString());
        }
        return new VariableDeclaration((Pcc)pcc, (TokenManager)tm, (Errors)errs, (VariableDeclaration)virtualParent);
    }

    @Override
    public ITokenList tokenizer(StringBuffer cLine, char decimalPoint, boolean putKeywords) {
        return PreProcessor.tokenizer(cLine, decimalPoint, putKeywords, nrw);
    }

    @Override
    public ITokenList tokenizer(StringBuffer cLine, char decimalPoint, boolean debugListing, boolean putKeywords) {
        return PreProcessor.tokenizer(cLine, decimalPoint, debugListing, putKeywords, nrw);
    }

    @Override
    public boolean tokenizer(ITokenList tl, StringBuffer cLine, int lineNumber, String fileName, boolean nextStrHex, char decimalPoint, IErrors error, boolean inExecSql, boolean debugListing, int format, boolean printTasks) {
        if (!(tl instanceof TokenList)) {
            throw new IllegalArgumentException("" + tl);
        }
        if (error != null && !(error instanceof Errors)) {
            throw new IllegalArgumentException(error.toString());
        }
        boolean[] compFlags = new boolean[5];
        compFlags[2] = printTasks;
        int r = PreProcessor.tokenizer((TokenList)tl, cLine, lineNumber, fileName, nextStrHex ? 2 : 0, decimalPoint, compFlags, (Errors)error, inExecSql, debugListing, format);
        return r == 2;
    }

    @Override
    public Enumeration<String> getCompilerOptionsStringTokenizer(String str) {
        return new MyStringTokenizer(str);
    }

    @Override
    public void resetAllCounters() {
        Pcc.resetAllCounters();
        Token.restoreKeywords();
    }

    @Override
    public void setInvokeNotifier(InvokeNotifier notifier) {
        Pcc.setInvokeNotifier(notifier);
    }

    @Override
    public InvokeNotifier getInvokeNotifier() {
        return Pcc.getInvokeNotifier();
    }

    @Override
    public void setVerbNotifier(VerbNotifier notifier) {
        Pcc.setVerbNotifier(notifier);
    }

    @Override
    public VerbNotifier getVerbNotifier() {
        return Pcc.getVerbNotifier();
    }

    @Override
    public IPcc analyze(String filename, IOptionList ol, IErrors errs, Reader reader, FileFinder fileFinder) {
        if (ol != null && !(ol instanceof OptionList)) {
            throw new IllegalArgumentException(ol.toString());
        }
        if (errs != null && !(errs instanceof Errors)) {
            throw new IllegalArgumentException(errs.toString());
        }
        return Pcc.analyze(filename, (OptionList)ol, (Errors)errs, reader, fileFinder, null);
    }

    @Override
    public IPcc run(String filename, String outDir, IOptionList ol, String javac, IErrors errs, Reader reader, boolean generateCode, FileFinder fileFinder) throws ErrorInCompilationException {
        if (ol != null && !(ol instanceof OptionList)) {
            throw new IllegalArgumentException(ol.toString());
        }
        if (errs != null && !(errs instanceof Errors)) {
            throw new IllegalArgumentException(errs.toString());
        }
        return Pcc.run(filename, outDir, (OptionList)ol, javac, (Errors)errs, reader, generateCode, fileFinder, null);
    }

    @Override
    public IPcc getPcc(Exception ex) {
        if (ex instanceof ErrorInCompilationException) {
            return ((ErrorInCompilationException)ex).pcc;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean optionValueIsDirectory(String opt) {
        return OptionList.valueIsDirectory(opt);
    }

    @Override
    public boolean optionValueIsPath(String opt) {
        return OptionList.valueIsPath(opt);
    }

    @Override
    public boolean optionValueIsFile(String opt) {
        return OptionList.valueIsFile(opt);
    }

    @Override
    public boolean optionHasValue(String opt) {
        return OptionList.hasValue(opt);
    }

    @Override
    public boolean optionIsImplicit(String opt) {
        return OptionList.isImplicit(opt);
    }

    @Override
    public boolean optionIsExperimental(String opt) {
        return OptionList.isExperimental(opt);
    }

    @Override
    public Map<String, String[]> getImplicitOptions() {
        return OptionList.getImplicits();
    }

    @Override
    public Enumeration<String> getAllOptionKeys(boolean sort) {
        return OptionList.getAllOptionKeys(sort);
    }

    @Override
    public int getAllOptionCount() {
        return OptionList.getAllOptionCount();
    }

    @Override
    public IOptionListForCodeAnalyzer newOptionListForCodeAnalyzer(String[] compOpts) {
        return OptionListForCodeAnalyzer.newInstance(compOpts);
    }

    @Override
    public IErrors newErrorsForCodeAnalyzer() {
        return new ErrorsExt(false);
    }

    @Override
    public IErrors newErrorsForCodeAnalyzer(boolean wuOption) {
        return new ErrorsExt(wuOption);
    }

    @Override
    public ITokenList newTokenList() {
        return new TokenList();
    }

    @Override
    public IError newError(String msg) {
        return new ErrorObj(0, 0, 0, 0, null, msg, null);
    }

    @Override
    public IRemoteCompilerClient newRemoteCompilerClient() {
        return new Client();
    }

    @Override
    public void generateSMAPInfos(String classFilename) throws IOException {
        new SMAPGenerator(classFilename);
    }

    @Override
    public void generateSMAPInfos(String classFilename, FileFinder ff) throws IOException {
        new SMAPGenerator(classFilename);
    }

    @Override
    public IRealTimePreProcessor newRealTimePreProcessor(String fileName, FileFinder fileFinder, IPreProcessorReaderProvider readerProvider) {
        return new RealTimePreProcessor(fileName, fileFinder, readerProvider);
    }

    @Override
    public IRemoteCompiler newRemoteCompiler(Element remoteCompilerElem) throws XmlParseException {
        return new RemoteCompiler(remoteCompilerElem);
    }

    @Override
    public String getOptionDesc(String opt) {
        return OptionList.getOptionDesc(opt);
    }

    @Override
    public Vector getGlobalStyleWords() {
        return new Vector<String>(this.getAttributesWords(0, true, false));
    }

    @Override
    public Vector getGlobalPropertyWords() {
        return new Vector<String>(this.getAttributesWords(0, false, false));
    }

    @Override
    public Vector getBarStyleWords() {
        return new Vector<String>(this.getAttributesWords(11, true, false));
    }

    @Override
    public Vector getBarPropertyWords() {
        return new Vector<String>(this.getAttributesWords(11, false, false));
    }

    @Override
    public Vector getBitmapStyleWords() {
        return new Vector<String>(this.getAttributesWords(13, true, false));
    }

    @Override
    public Vector getBitmapPropertyWords() {
        return new Vector<String>(this.getAttributesWords(13, false, false));
    }

    @Override
    public Vector getCheckBoxStyleWords() {
        return new Vector<String>(this.getAttributesWords(4, true, false));
    }

    @Override
    public Vector getCheckBoxPropertyWords() {
        return new Vector<String>(this.getAttributesWords(4, false, false));
    }

    @Override
    public Vector getComboBoxStyleWords() {
        return new Vector<String>(this.getAttributesWords(8, true, false));
    }

    @Override
    public Vector getComboBoxPropertyWords() {
        return new Vector<String>(this.getAttributesWords(8, false, false));
    }

    @Override
    public Vector getDateEntryStyleWords() {
        return new Vector<String>(this.getAttributesWords(20, true, false));
    }

    @Override
    public Vector getDateEntryPropertyWords() {
        return new Vector<String>(this.getAttributesWords(20, false, false));
    }

    @Override
    public Vector getEntryFieldStyleWords() {
        return new Vector<String>(this.getAttributesWords(2, true, false));
    }

    @Override
    public Vector getEntryFieldPropertyWords() {
        return new Vector<String>(this.getAttributesWords(2, false, false));
    }

    @Override
    public Vector getFrameStyleWords() {
        return new Vector<String>(this.getAttributesWords(9, true, false));
    }

    @Override
    public Vector getFramePropertyWords() {
        return new Vector<String>(this.getAttributesWords(9, false, false));
    }

    @Override
    public Vector getGridStyleWords() {
        return new Vector<String>(this.getAttributesWords(12, true, false));
    }

    @Override
    public Vector getGridPropertyWords() {
        return new Vector<String>(this.getAttributesWords(12, false, false));
    }

    @Override
    public Vector getJavaBeanStyleWords() {
        return new Vector<String>(this.getAttributesWords(19, true, false));
    }

    @Override
    public Vector getJavaBeanPropertyWords() {
        return new Vector<String>(this.getAttributesWords(19, false, false));
    }

    @Override
    public Vector getLabelStyleWords() {
        return new Vector<String>(this.getAttributesWords(1, true, false));
    }

    @Override
    public Vector getLabelPropertyWords() {
        return new Vector<String>(this.getAttributesWords(1, false, false));
    }

    @Override
    public Vector getListBoxStyleWords() {
        return new Vector<String>(this.getAttributesWords(7, true, false));
    }

    @Override
    public Vector getListBoxPropertyWords() {
        return new Vector<String>(this.getAttributesWords(7, false, false));
    }

    @Override
    public Vector getPushButtonStyleWords() {
        return new Vector<String>(this.getAttributesWords(3, true, false));
    }

    @Override
    public Vector getPushButtonPropertyWords() {
        return new Vector<String>(this.getAttributesWords(3, false, false));
    }

    @Override
    public Vector getRadioButtonStyleWords() {
        return new Vector<String>(this.getAttributesWords(5, true, false));
    }

    @Override
    public Vector getRadioButtonPropertyWords() {
        return new Vector<String>(this.getAttributesWords(5, false, false));
    }

    @Override
    public Vector getScrollBarStyleWords() {
        return new Vector<String>(this.getAttributesWords(6, true, false));
    }

    @Override
    public Vector getScrollBarPropertyWords() {
        return new Vector<String>(this.getAttributesWords(6, false, false));
    }

    @Override
    public Vector getSliderStyleWords() {
        return new Vector<String>(this.getAttributesWords(18, true, false));
    }

    @Override
    public Vector getSliderPropertyWords() {
        return new Vector<String>(this.getAttributesWords(18, false, false));
    }

    @Override
    public Vector getStatusBarStyleWords() {
        return new Vector<String>(this.getAttributesWords(17, true, false));
    }

    @Override
    public Vector getStatusBarPropertyWords() {
        return new Vector<String>(this.getAttributesWords(17, false, false));
    }

    @Override
    public Vector getTabControlStyleWords() {
        return new Vector<String>(this.getAttributesWords(10, true, false));
    }

    @Override
    public Vector getTabControlPropertyWords() {
        return new Vector<String>(this.getAttributesWords(10, false, false));
    }

    @Override
    public Vector getTreeViewStyleWords() {
        return new Vector<String>(this.getAttributesWords(14, true, false));
    }

    @Override
    public Vector getTreeViewPropertyWords() {
        return new Vector<String>(this.getAttributesWords(14, false, false));
    }

    @Override
    public Vector getWebBrowserStyleWords() {
        return new Vector<String>(this.getAttributesWords(15, true, false));
    }

    @Override
    public Vector getWebBrowserPropertyWords() {
        return new Vector<String>(this.getAttributesWords(15, false, false));
    }

    public Vector getChipsBoxStyleWords() {
        return new Vector<String>(this.getAttributesWords(24, true, false));
    }

    public Vector getChipsBoxPropertyWords() {
        return new Vector<String>(this.getAttributesWords(24, false, false));
    }

    @Override
    public Vector getControlTypeNames() {
        return new Vector<String>(GUIControl.controlNames.values());
    }

    @Override
    public Set<String> getElkTypeNames() {
        return ElkParser.getAllTypes();
    }

    @Override
    public Set<String> getAttributesWords(int controlType, boolean getStylesWords, boolean getWd2Unsupported) {
        Collection<Object> c;
        switch (controlType) {
            case 0: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = GUIControl.globalUnsupportedWD2StyleWords;
                        break;
                    }
                    c = GUIControl.globalStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = GUIControl.globalUnsupportedWD2PropertiesWords;
                    break;
                }
                c = GUIControl.globalPropertyWords;
                break;
            }
            case 11: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = GUIControl.barUnsupportedWD2StyleWords;
                        break;
                    }
                    c = GUIControl.barStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = Collections.EMPTY_LIST;
                    break;
                }
                c = GUIControl.barPropertiesWords;
                break;
            }
            case 13: {
                if (getStylesWords) {
                    c = Collections.EMPTY_LIST;
                    break;
                }
                if (getWd2Unsupported) {
                    c = GUIControl.bitmapUnsupportedWD2PropertiesWords;
                    break;
                }
                c = GUIControl.bitmapPropertiesWords;
                break;
            }
            case 4: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = GUIControl.checkBoxUnsupportedWD2StyleWords;
                        break;
                    }
                    c = GUIControl.checkBoxStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = GUIControl.checkBoxUnsupportedWD2PropertiesWords;
                    break;
                }
                c = GUIControl.checkBoxPropertiesWords;
                break;
            }
            case 8: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = GUIControl.comboBoxUnsupportedWD2StyleWords;
                        break;
                    }
                    c = GUIControl.comboBoxStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = GUIControl.comboBoxUnsupportedWD2PropertiesWords;
                    break;
                }
                c = GUIControl.comboBoxPropertiesWords;
                break;
            }
            case 20: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = GUIControl.dateEntryUnsupportedWD2StyleWords;
                        break;
                    }
                    c = GUIControl.dateEntryStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = GUIControl.dateEntryUnsupportedWD2PropertiesWords;
                    break;
                }
                c = GUIControl.dateEntryPropertiesWords;
                break;
            }
            case 2: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = GUIControl.entryFieldUnsupportedWD2StyleWords;
                        break;
                    }
                    c = GUIControl.entryFieldStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = GUIControl.entryFieldUnsupportedWD2PropertiesWords;
                    break;
                }
                c = GUIControl.entryFieldPropertiesWords;
                break;
            }
            case 9: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = GUIControl.frameUnsupportedWD2StyleWords;
                        break;
                    }
                    c = GUIControl.frameStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = GUIControl.frameUnsupportedWD2PropertiesWords;
                    break;
                }
                c = GUIControl.framePropertiesWords;
                break;
            }
            case 12: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = GUIControl.gridUnsupportedWD2StyleWords;
                        break;
                    }
                    c = GUIControl.gridStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = GUIControl.gridUnsupportedWD2PropertiesWords;
                    break;
                }
                c = GUIControl.gridPropertiesWords;
                break;
            }
            case 19: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = GUIControl.javaBeanUnsupportedWD2StyleWords;
                        break;
                    }
                    c = GUIControl.javaBeanStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = GUIControl.javaBeanUnsupportedWD2PropertiesWords;
                    break;
                }
                c = GUIControl.javaBeanPropertiesWords;
                break;
            }
            case 1: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = GUIControl.labelUnsupportedWD2StyleWords;
                        break;
                    }
                    c = GUIControl.labelStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = GUIControl.labelUnsupportedWD2PropertiesWords;
                    break;
                }
                c = GUIControl.labelPropertiesWords;
                break;
            }
            case 7: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = GUIControl.listBoxUnsupportedWD2StyleWords;
                        break;
                    }
                    c = GUIControl.listBoxStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = GUIControl.listBoxUnsupportedWD2PropertiesWords;
                    break;
                }
                c = GUIControl.listBoxPropertiesWords;
                break;
            }
            case 16: {
                c = Collections.EMPTY_LIST;
                break;
            }
            case 3: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = GUIControl.pushButtonUnsupportedWD2StyleWords;
                        break;
                    }
                    c = GUIControl.pushButtonStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = GUIControl.pushButtonUnsupportedWD2PropertiesWords;
                    break;
                }
                c = GUIControl.pushButtonPropertiesWords;
                break;
            }
            case 5: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = GUIControl.radioButtonUnsupportedWD2StyleWords;
                        break;
                    }
                    c = GUIControl.radioButtonStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = GUIControl.radioButtonUnsupportedWD2PropertiesWords;
                    break;
                }
                c = GUIControl.radioButtonPropertiesWords;
                break;
            }
            case 21: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = Collections.EMPTY_LIST;
                        break;
                    }
                    c = GUIControl.ribbonStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = Collections.EMPTY_LIST;
                    break;
                }
                c = GUIControl.ribbonPropertiesWords;
                break;
            }
            case 23: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = Collections.EMPTY_LIST;
                        break;
                    }
                    c = GUIControl.iwcPanelStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = Collections.EMPTY_LIST;
                    break;
                }
                c = GUIControl.iwcPanelPropertiesWords;
                break;
            }
            case 22: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = Collections.EMPTY_LIST;
                        break;
                    }
                    c = GUIControl.scrollPaneStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = Collections.EMPTY_LIST;
                    break;
                }
                c = GUIControl.scrollPanePropertiesWords;
                break;
            }
            case 6: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = Collections.EMPTY_LIST;
                        break;
                    }
                    c = GUIControl.scrollBarStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = Collections.EMPTY_LIST;
                    break;
                }
                c = GUIControl.scrollBarPropertiesWords;
                break;
            }
            case 18: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = Collections.EMPTY_LIST;
                        break;
                    }
                    c = GUIControl.sliderStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = Collections.EMPTY_LIST;
                    break;
                }
                c = GUIControl.sliderPropertiesWords;
                break;
            }
            case 17: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = Collections.EMPTY_LIST;
                        break;
                    }
                    c = GUIControl.statusBarStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = Collections.EMPTY_LIST;
                    break;
                }
                c = GUIControl.statusBarPropertiesWords;
                break;
            }
            case 10: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = GUIControl.tabUnsupportedWD2StyleWords;
                        break;
                    }
                    c = GUIControl.tabStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = GUIControl.tabUnsupportedWD2PropertiesWords;
                    break;
                }
                c = GUIControl.tabPropertiesWords;
                break;
            }
            case 14: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = GUIControl.treeUnsupportedWD2StyleWords;
                        break;
                    }
                    c = GUIControl.treeStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = GUIControl.treeUnsupportedWD2PropertiesWords;
                    break;
                }
                c = GUIControl.treePropertiesWords;
                break;
            }
            case 15: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = Collections.EMPTY_LIST;
                        break;
                    }
                    c = GUIControl.webBrowserStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = Collections.EMPTY_LIST;
                    break;
                }
                c = GUIControl.webBrowserPropertiesWords;
                break;
            }
            case 24: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = GUIControl.chipsBoxUnsupportedWD2StyleWords;
                        break;
                    }
                    c = GUIControl.chipsBoxStyleWords;
                    break;
                }
                if (getWd2Unsupported) {
                    c = GUIControl.chipsBoxUnsupportedWD2PropertiesWords;
                    break;
                }
                c = GUIControl.chipsBoxPropertiesWords;
                break;
            }
            case 100: {
                if (getStylesWords) {
                    if (getWd2Unsupported) {
                        c = windowWd2UnsupportedStyles;
                        break;
                    }
                    c = Collections.EMPTY_LIST;
                    break;
                }
                if (getWd2Unsupported) {
                    c = windowWd2UnsupportedProperties;
                    break;
                }
                c = Collections.EMPTY_LIST;
                break;
            }
            default: {
                c = Collections.EMPTY_LIST;
            }
        }
        return new HashSet<String>(c);
    }

    @Override
    public Set<String> getWd2UnsupportedEvents(int controlType) {
        Set Return2 = wd2UnsupportedEvents.get(controlType);
        if (Return2 == null) {
            Return2 = Collections.EMPTY_SET;
        }
        return Return2;
    }

    @Override
    public Set<String> getWd2UnsupportedControls() {
        return wd2UnsupportedControls;
    }

    @Override
    public Set<Integer> getWd2UnsupportedControlsTypes() {
        return wd2UnsupportedControlsTypes;
    }

    @Override
    public void removeClasses(String dir, String name, boolean verboseOutput) {
        Pcc.removeClasses(dir, name, verboseOutput);
    }

    @Override
    public ReferencedPccNotifier getReferencedPccNotifier() {
        return Pcc.getReferencedPccNotifier();
    }

    @Override
    public void setReferencedPccNotifier(ReferencedPccNotifier referencedPccNotifier) {
        Pcc.setReferencedPccNotifier(referencedPccNotifier);
    }

    static {
        windowWd2UnsupportedStyles = new ArrayList<String>();
        windowWd2UnsupportedStyles.add("CONTROLS-UNCROPPED");
        windowWd2UnsupportedStyles.add("SCROLL");
        windowWd2UnsupportedStyles.add("SHADOW");
        windowWd2UnsupportedProperties = new ArrayList<String>();
        windowWd2UnsupportedProperties.add("AUTO-RESIZE");
        windowWd2UnsupportedProperties.add("MIN-SIZE");
        windowWd2UnsupportedProperties.add("MIN-LINES");
        windowWd2UnsupportedProperties.add("MAX-SIZE");
        windowWd2UnsupportedProperties.add("MAX-LINES");
        windowWd2UnsupportedProperties.add("LAYOUT-MANAGER");
        windowWd2UnsupportedProperties.add("WINDOW-STATE");
        wd2UnsupportedControls = new HashSet<String>();
        wd2UnsupportedControls.add("RIBBON");
        wd2UnsupportedControls.add("SCROLL-BAR");
        wd2UnsupportedControls.add("SLIDER");
        wd2UnsupportedControls.add("STATUS-BAR");
        wd2UnsupportedControls.add("WEB-BROWSER");
        wd2UnsupportedControls.add("IWC-PANEL");
        wd2UnsupportedControlsTypes = new HashSet<Integer>();
        wd2UnsupportedControlsTypes.add(21);
        wd2UnsupportedControlsTypes.add(23);
        wd2UnsupportedControlsTypes.add(6);
        wd2UnsupportedControlsTypes.add(18);
        wd2UnsupportedControlsTypes.add(17);
        wd2UnsupportedControlsTypes.add(15);
        wd2UnsupportedControlsTypes.add(23);
        wd2UnsupportedEvents = new HashMap<Integer, Set<String>>();
        HashSet<String> set = new HashSet<String>();
        wd2UnsupportedEvents.put(11, set);
        set = new HashSet();
        set.add("MSG-MOUSE-ENTERED");
        set.add("MSG-MOUSE-EXITED");
        set.add("MSG-MOUSE-CLICKED");
        set.add("MSG-MOUSE-DBLCLICK");
        set.add("EVENT PROCEDURE");
        wd2UnsupportedEvents.put(13, set);
        set = new HashSet();
        set.add("CMD-DBLCLICK");
        wd2UnsupportedEvents.put(8, set);
        set = new HashSet();
        set.add("MSG-SPIN-DOWN");
        set.add("MSG-SPIN-UP");
        wd2UnsupportedEvents.put(2, set);
        set = new HashSet();
        set.add("MSG-BEGIN-ENTRY");
        set.add("MSG-BEGIN-DRAG");
        set.add("MSG-BEGIN-HEADING-DRAG");
        set.add("MSG-COL-WIDTH-CHANGED");
        set.add("MSG-END-DRAG");
        set.add("MSG-END-HEADING-DRAG");
        set.add("MSG-GOTO-CELL");
        set.add("MSG-GOTO-CELL-DRAG");
        set.add("MSG-HEADING-DRAGGED");
        wd2UnsupportedEvents.put(12, set);
        set = new HashSet();
        set.add("MSG-TV-EXPANDING");
        set.add("MSG-TV-SELCHANGING");
        set.add("MSG-BEGIN-ENTRY");
        set.add("MSG-CANCEL-ENTRY");
        set.add("MSG-FINISH-ENTRY");
        wd2UnsupportedEvents.put(9, set);
        set = new HashSet();
        set.add("AFTER PROCEDURE");
        set.add("BEFORE PROCEDURE");
        wd2UnsupportedEvents.put(10, set);
        set = new HashSet();
        set.add("CMD-ACTIVATE");
        set.add("NTF-RESIZED");
        wd2UnsupportedEvents.put(100, set);
        nrw = new Hashtable();
    }

    private static class ErrorsExt
    extends Errors {
        private static final long serialVersionUID = 1L;
        public static final int TASK_TYPE = 1001;
        private boolean wu;

        public ErrorsExt(boolean wu) {
            this.wu = wu;
        }

        @Override
        public void printTask(int severity, int lineNum, int offset, String message, String file) {
            this.allMessages.addElement(new ErrorObj(1001, severity, lineNum, offset, file, message, null));
        }

        @Override
        public void print(int errorNumber, int severity, int lineNum, int offset, String other, Exception syserr, String file) {
            String mess;
            if (this.ignoreErrors) {
                return;
            }
            severity = Config.getProperty(".compiler.messagelevel." + errorNumber, severity);
            switch (severity) {
                case 0: {
                    return;
                }
                case 1: {
                    mess = "--I: ";
                    break;
                }
                case 2: {
                    mess = "--W: ";
                    break;
                }
                case 3: {
                    mess = "--E: ";
                    break;
                }
                case 4: {
                    mess = "--S: ";
                    break;
                }
                default: {
                    mess = "--?: ";
                }
            }
            mess = mess + "#" + errorNumber + " ";
            String desc = (String)errorDesc.get(new Integer(errorNumber));
            mess = mess + desc;
            if (other != null) {
                mess = mess + " " + other;
            }
            this.allMessages.addElement(new ErrorObj(errorNumber, severity, lineNum, offset, file, mess, other));
            switch (severity) {
                case 1: {
                    ++this.info;
                    break;
                }
                case 2: {
                    ++this.warning;
                    break;
                }
                case 3: {
                    ++this.rErrors;
                    break;
                }
                case 4: {
                    ++this.sErrors;
                    break;
                }
            }
            if (this.getMaxErrors() > 0 && this.sErrors >= this.getMaxErrors()) {
                throw new ErrorLimitReachedException();
            }
        }

        @Override
        public boolean printEndMessage() {
            return this.sErrors > 0;
        }

        @Override
        public int getTotalErrorCount() {
            int Return2 = this.info + this.warning + this.rErrors + this.sErrors;
            if (!this.wu) {
                for (int i = 0; i < this.allMessages.size() && Return2 > 0; ++i) {
                    ErrorObj err = (ErrorObj)this.allMessages.elementAt(i);
                    if (err.getErrorNumber() != 108) continue;
                    --Return2;
                }
            }
            return Return2;
        }

        @Override
        public int getErrorCount(int s) {
            switch (s) {
                case 1: {
                    return this.info;
                }
                case 2: {
                    int Return2 = this.warning;
                    if (!this.wu) {
                        for (int i = 0; i < this.allMessages.size() && Return2 > 0; ++i) {
                            ErrorObj err = (ErrorObj)this.allMessages.elementAt(i);
                            if (err.getErrorNumber() != 108) continue;
                            --Return2;
                        }
                    }
                    return Return2;
                }
                case 3: {
                    return this.rErrors;
                }
                case 4: {
                    return this.sErrors;
                }
            }
            return 0;
        }

        @Override
        public Vector getAllMessages() {
            Vector<ErrorObj> Return2 = new Vector<ErrorObj>();
            if (this.wu) {
                Return2.addAll(this.allMessages);
            } else {
                for (int i = 0; i < this.allMessages.size(); ++i) {
                    ErrorObj err = (ErrorObj)this.allMessages.elementAt(i);
                    if (err.getErrorNumber() == 108) continue;
                    Return2.addElement(err);
                }
            }
            return Return2;
        }
    }

    private static class ErrorObj
    implements IError {
        private int errorNumber;
        private int errorType;
        private int lineNumber;
        private int offset;
        private String message;
        private String filename;
        private String pathFilename;
        private String other;

        public ErrorObj(int num, int severity, int line, int offs, String file, String msg, String other) {
            this.errorNumber = num;
            this.errorType = severity;
            this.lineNumber = line;
            this.offset = offs;
            this.message = msg;
            this.pathFilename = file = file.replace('\\', '/');
            this.filename = new File(file).getName();
            this.other = other;
        }

        @Override
        public int getErrorNumber() {
            return this.errorNumber;
        }

        @Override
        public int getErrorType() {
            return this.errorType;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public String getPathFilename() {
            return this.pathFilename;
        }

        @Override
        public String getOther() {
            return this.other;
        }

        @Override
        public String getFilename() {
            return this.filename;
        }

        public String toString() {
            String mess;
            if (this.errorNumber != 1001) {
                switch (this.errorType) {
                    case 1: {
                        mess = "--I: ";
                        break;
                    }
                    case 2: {
                        mess = "--W: ";
                        break;
                    }
                    case 3: {
                        mess = "--E: ";
                        break;
                    }
                    case 4: {
                        mess = "--S: ";
                        break;
                    }
                    default: {
                        mess = "--?: ";
                    }
                }
                mess = mess + "#" + this.errorNumber + " ";
                mess = mess + Errors.getErrorDescription(this.errorNumber);
                if (this.other != null) {
                    mess = mess + " " + this.other;
                }
            } else {
                mess = "--Task: " + this.message;
            }
            mess = mess + "; file = " + this.filename;
            if (this.lineNumber > 0) {
                mess = mess + ", line = " + this.lineNumber;
            }
            if (this.offset > 0) {
                mess = mess + ", col " + this.offset;
            }
            return mess;
        }
    }

    private static class RealTimePreProcessor
    extends PreProcessor
    implements IRealTimePreProcessor {
        private List<Token> copyStatementTokens = new ArrayList<Token>();
        private IPreProcessorReaderProvider readerProvider;

        public RealTimePreProcessor(String fileName, FileFinder fFinder, IPreProcessorReaderProvider readerProvider) {
            super(fileName, null, new OptionList(new String[0]), new Errors(), fFinder, null);
            if (readerProvider == null) {
                throw new IllegalArgumentException("readerProvider = null");
            }
            this.readerProvider = readerProvider;
        }

        private RealTimePreProcessor(PreProcessor par, File f, Writer l, int fmt, ReplaceList repList, Errors err, OptionList o, char decPoint) {
            super(par, f, l, fmt, repList, err, o, decPoint);
        }

        @Override
        protected PreProcessor createCopyPreProcessor(PreProcessor par, File f, Writer l, int fmt, ReplaceList repList, Errors err, OptionList o, char decPoint) {
            return new RealTimePreProcessor(par, f, l, fmt, repList, err, o, decPoint);
        }

        @Override
        protected boolean open(String fileName) {
            LineNumberReader lnr = this.getRoot().readerProvider.getReader(fileName);
            if (lnr != null) {
                this.src = lnr;
                return true;
            }
            return super.open(fileName);
        }

        @Override
        public RealTimePreProcessor getRoot() {
            PreProcessor pp = this;
            while (pp.getParent() != null) {
                pp = pp.getParent();
            }
            return pp;
        }

        public List getCopyStatementTokens() {
            return this.getRoot().copyStatementTokens;
        }

        @Override
        protected int readCopy(Token t0, String copyName, boolean suppress, ReplaceList repList) {
            int ret = super.readCopy(t0, copyName, suppress, repList);
            if (ret == 0) {
                this.getRoot().copyStatementTokens.add(t0);
            }
            return ret;
        }
    }
}

