/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.LambdaExpression;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.MyField;
import com.iscobol.compiler.MyMethod;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.VariableNameList;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class DefaultClass
extends MyClass {
    final Class extClass;
    final String extClassName;
    final Pcc intClass;
    MyMethod[] ctors;
    MyMethod[] methods;
    MyMethod[] methodsProt;
    MyField[] fields;
    MyField[] fieldsProt;
    MyMethod[] funcMethod;
    int dimensions;
    final MyClass[] parameters;
    final String[] parametersNames;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DefaultClass(String className, Pcc pc, int d) throws ClassNotFoundException {
        Pcc intCl;
        String extCln;
        Class extCl;
        MyClass[] params;
        String[] paramsNames = null;
        int idx = className.indexOf(60);
        if (idx >= 0) {
            if (!className.endsWith(">")) throw new ClassNotFoundException(className);
            String paramsStr = className.substring(idx);
            ArrayList<MyClass> al = new ArrayList<MyClass>();
            StringTokenizer stn = new StringTokenizer(paramsStr, "<>,", true);
            String param = null;
            int open = 0;
            block12: while (stn.hasMoreTokens()) {
                String tk;
                switch (tk = stn.nextToken()) {
                    case "<": {
                        param = open == 0 ? "" : param + tk;
                        ++open;
                        continue block12;
                    }
                    case ">": {
                        if (open == 1) {
                            if ((param = param.trim()).length() > 0) {
                                al.add(MyClass.getInstance(param));
                            }
                            param = null;
                        } else {
                            param = param + tk;
                        }
                        --open;
                        continue block12;
                    }
                    case ",": {
                        if (open == 1) {
                            if ((param = param.trim()).length() > 0) {
                                al.add(MyClass.getInstance(param));
                            }
                            param = "";
                            continue block12;
                        }
                        param = param + tk;
                        continue block12;
                    }
                }
                param = param + tk;
            }
            params = al.toArray(new MyClass[al.size()]);
        } else {
            params = null;
        }
        String cn = idx >= 0 ? className.substring(0, idx) : className;
        try {
            extCl = DefaultClass.forName(cn);
            if (params != null) {
                paramsNames = new String[params.length];
                if (params.length > 0) {
                    TypeVariable<Class<T>>[] tv = extCl.getTypeParameters();
                    if (tv == null || tv.length != params.length) {
                        throw new ClassNotFoundException(className);
                    }
                    for (int i = 0; i < tv.length; ++i) {
                        paramsNames[i] = tv[i].getTypeName();
                    }
                }
            }
            extCln = className;
            intCl = null;
        }
        catch (ClassNotFoundException ex) {
            if (pc == null) throw ex;
            Pcc refPc = pc.getReferencedPcc(className);
            if (refPc == Pcc.CLASS_NOT_FOUND) throw ex;
            extCl = null;
            extCln = null;
            intCl = refPc;
            this.dimensions = d;
        }
        this.parameters = params;
        this.parametersNames = paramsNames;
        this.extClass = extCl;
        this.extClassName = extCln;
        this.intClass = intCl;
    }

    DefaultClass(Class e) {
        this.extClass = e;
        this.extClassName = e.getName();
        this.intClass = null;
        this.parameters = null;
        this.parametersNames = null;
    }

    DefaultClass(Pcc i, int d) {
        this.extClass = null;
        this.extClassName = null;
        this.intClass = i;
        if (this.intClass == null) {
            throw new NullPointerException();
        }
        this.dimensions = d;
        this.parameters = null;
        this.parametersNames = null;
    }

    @Override
    public String getName() {
        return this.getName(false);
    }

    @Override
    public String getName(boolean autoboxing) {
        if (this.intClass != null) {
            if (this.dimensions > 0) {
                String r = "";
                for (int i = 0; i < this.dimensions; ++i) {
                    r = r + "[";
                }
                return r + "L" + this.intClass.getFullClassName() + ";";
            }
            return this.intClass.getFullClassName();
        }
        if (autoboxing) {
            String s = (String)autoboxingClassNames.get(this.extClassName);
            return s != null ? s : this.extClassName;
        }
        return this.extClassName;
    }

    @Override
    public String getNotParameterizedName() {
        if (this.intClass != null) {
            return this.getName(false);
        }
        String Return2 = this.extClassName;
        int idx = this.extClassName.indexOf(60);
        if (idx >= 0) {
            Return2 = Return2.substring(0, idx);
        }
        return Return2;
    }

    @Override
    public MyMethod[] getConstructors() {
        if (this.ctors == null) {
            this.ctors = this.retrieveConstructors();
        }
        return this.ctors;
    }

    @Override
    public MyMethod[] retrieveConstructors() {
        MyMethod[] ctors;
        if (this.extClass != null) {
            String cn = this.extClass.getName();
            if (this.isArray()) {
                String cName = this.extClassName;
                int i = 0;
                while (cName.charAt(i) == '[') {
                    ++i;
                }
                ctors = new MyMethod[i];
                while (i > 0) {
                    MyClass[] mc = new MyClass[i];
                    for (int j = i - 1; j >= 0; --j) {
                        mc[j] = MyClass.getInstance(Integer.TYPE);
                    }
                    ctors[i - 1] = new MyMethod(this, false, "new", this, mc, 9, null);
                    --i;
                }
            } else {
                Constructor<?>[] c = this.extClass.getConstructors();
                ctors = new MyMethod[c.length];
                for (int i = 0; i < c.length; ++i) {
                    ctors[i] = new MyMethod(c[i], (MyClass)this);
                }
            }
        } else {
            String cn = this.intClass.getFullClassName();
            if (this.isArray()) {
                ctors = new MyMethod[this.dimensions];
                for (int i = this.dimensions; i > 0; --i) {
                    MyClass[] mc = new MyClass[i];
                    for (int j = i - 1; j >= 0; --j) {
                        mc[j] = MyClass.getInstance(Integer.TYPE);
                    }
                    ctors[i - 1] = new MyMethod(this, false, "new", this, mc, 9, null);
                }
            } else {
                MyMethod[] mm = this.getMethods(true);
                ArrayList<MyMethod> ctList = new ArrayList<MyMethod>();
                for (int i = 0; i < mm.length; ++i) {
                    if (!mm[i].getName().equals("new")) continue;
                    ctList.add(mm[i]);
                }
                if (ctList.isEmpty()) {
                    ctList.add(new MyMethod(this, false, "new", this, new MyClass[0], 9, null));
                }
                ctors = ctList.toArray(new MyMethod[ctList.size()]);
            }
        }
        return ctors;
    }

    @Override
    public MyClass[] getInterfaces() {
        ArrayList<MyClass> result;
        block6: {
            block5: {
                result = new ArrayList<MyClass>();
                if (this.extClass == null) break block5;
                Class<?>[] cls = this.extClass.getInterfaces();
                if (cls == null) break block6;
                for (Class<?> cl : cls) {
                    result.add(MyClass.getInstance(cl));
                }
                break block6;
            }
            String[] cls = this.intClass.getImplementsClass();
            if (cls != null) {
                for (String cl : cls) {
                    try {
                        result.add(MyClass.getInstance(cl, this.intClass, 0));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
        }
        return result.toArray(new MyClass[result.size()]);
    }

    @Override
    public MyClass[] getParameters() {
        return this.parameters;
    }

    @Override
    public String[] getParametersNames() {
        return this.parametersNames;
    }

    @Override
    public MyClass getParameter(String name) {
        if (this.parametersNames != null) {
            for (int i = 0; i < this.parametersNames.length; ++i) {
                if (!name.equals(this.parametersNames[i])) continue;
                return this.parameters[i];
            }
        }
        return null;
    }

    @Override
    public MyClass getSuperclass() {
        MyClass Return2;
        if (this.extClass != null) {
            Class sc = this.extClass.getSuperclass();
            Return2 = sc != null ? MyClass.getInstance(sc) : null;
        } else {
            String parClass = this.intClass.getInheritsClass();
            if (parClass != null) {
                try {
                    Return2 = MyClass.getInstance(parClass, this.intClass, 0);
                }
                catch (ClassNotFoundException e) {
                    Return2 = MyClass.getInstance(Object.class);
                }
            } else {
                Return2 = MyClass.getInstance(Object.class);
            }
        }
        return Return2;
    }

    @Override
    public MyMethod[] getMethods(boolean protoo) {
        if (protoo) {
            if (this.methodsProt == null) {
                this.methodsProt = this.retrieveMethods(protoo);
            }
            return this.methodsProt;
        }
        if (this.methods == null) {
            this.methods = this.retrieveMethods(protoo);
        }
        return this.methods;
    }

    private static void add(MyMethod m, TreeSet<MyMethod> result) {
        result.remove(m);
        result.add(m);
    }

    private MyMethod[] retrieveMethods(boolean protoo) {
        MyMethod[] methods;
        if (this.extClass != null) {
            Method[] m = DefaultClass.getAllMethods(this.extClass, protoo);
            methods = new MyMethod[m.length];
            for (int i = 0; i < m.length; ++i) {
                methods[i] = new MyMethod(m[i], (MyClass)this);
            }
        } else {
            MyClass[] intfs;
            TreeSet<MyMethod> result = new TreeSet<MyMethod>();
            MyClass parClass = this.getSuperclass();
            if (parClass != null) {
                for (MyMethod m : parClass.getMethods(protoo)) {
                    DefaultClass.add(m, result);
                }
            }
            if ((intfs = this.getInterfaces()) != null) {
                for (MyClass intf : intfs) {
                    for (MyMethod m : intf.getMethods(protoo)) {
                        if (!m.isDefault()) continue;
                        DefaultClass.add(m, result);
                    }
                }
            }
            CobolMethod[] cms = this.intClass.getMethods();
            MyMethod[] mms = this.intClass.getMyMethods();
            String cn = this.intClass.getFullClassName();
            boolean im = this.intClass.isInterface();
            for (CobolMethod cm : cms) {
                MyMethod mm = new MyMethod(this, im, cm.getMethodName(), cm.getReturnType(), cm.getParameterTypes(), cm.getModifiers(), cm.procedure.raising, cm.isDefault(), cm.isVarArgs());
                DefaultClass.add(mm, result);
            }
            MyClass objClass = null;
            try {
                objClass = MyClass.getInstance("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            DefaultClass.add(new MyMethod(objClass, false, "finalize", MyClass.getInstance(Void.TYPE), new MyClass[0], 1, new VariableNameList(), false, false), result);
            for (MyMethod m : mms) {
                DefaultClass.add(m, result);
            }
            methods = result.toArray(new MyMethod[result.size()]);
        }
        return methods;
    }

    private static Field[] getAllFields(Class clazz, boolean prot) {
        Field[] Return2;
        TreeSet<Field> allFields = new TreeSet<Field>(new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        do {
            Return2 = clazz.getDeclaredFields();
            if (prot) {
                for (Field field : Return2) {
                    if ((allFields.contains(field) || !Modifier.isPublic(field.getModifiers())) && !Modifier.isProtected(field.getModifiers())) continue;
                    allFields.add(field);
                }
            } else {
                for (Field field : Return2) {
                    if (allFields.contains(field) || !Modifier.isPublic(field.getModifiers())) continue;
                    allFields.add(field);
                }
            }
            for (AnnotatedElement annotatedElement : clazz.getInterfaces()) {
                for (Field f : Return2 = ((Class)annotatedElement).getFields()) {
                    if (allFields.contains(f)) continue;
                    allFields.add(f);
                }
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        Return2 = allFields.toArray(new Field[allFields.size()]);
        return Return2;
    }

    private static void fillMethodWProt(Method[] mts, TreeSet<Method> am) {
        for (Method m : mts) {
            if (!Modifier.isPublic(m.getModifiers()) && !Modifier.isProtected(m.getModifiers()) || am.contains(m)) continue;
            am.add(m);
        }
    }

    private static Method[] getAllMethods(Class clazz, boolean prot) {
        TreeSet<Method> allMethods = new TreeSet<Method>(new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                Class<?>[] pt2;
                Class<?>[] pt1;
                int r = m1.getName().compareTo(m2.getName());
                if (r == 0 && (r = (pt1 = m1.getParameterTypes()).length - (pt2 = m2.getParameterTypes()).length) == 0) {
                    for (int i = 0; i < pt1.length && r == 0; ++i) {
                        r = pt1[i].getName().compareTo(pt2[i].getName());
                    }
                }
                return r;
            }
        });
        if (prot) {
            do {
                DefaultClass.fillMethodWProt(clazz.getDeclaredMethods(), allMethods);
            } while ((clazz = clazz.getSuperclass()) != null);
        } else {
            for (Method m : clazz.getMethods()) {
                try {
                    Method m2 = clazz.getMethod(m.getName(), m.getParameterTypes());
                    if (allMethods.contains(m2)) continue;
                    allMethods.add(m2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return allMethods.toArray(new Method[allMethods.size()]);
    }

    @Override
    public MyField[] getFields(boolean protoo) {
        if (protoo) {
            if (this.fieldsProt == null) {
                this.fieldsProt = this.retrieveFields(protoo);
            }
            return this.fieldsProt;
        }
        if (this.fields == null) {
            this.fields = this.retrieveFields(protoo);
        }
        return this.fields;
    }

    private MyField[] retrieveFields(boolean protoo) {
        MyField[] fields;
        if (this.extClass != null) {
            Field[] f = DefaultClass.getAllFields(this.extClass, protoo);
            fields = new MyField[f.length];
            for (int i = 0; i < f.length; ++i) {
                fields[i] = new MyField(f[i]);
            }
        } else {
            MyClass parClass = this.getSuperclass();
            if (parClass == null) {
                parClass = MyClass.getInstance(Object.class);
            }
            MyField[] parFld = parClass.getFields(protoo);
            MyField[] myFld = this.intClass.getMyFields();
            fields = new MyField[parFld.length + myFld.length];
            System.arraycopy(parFld, 0, fields, 0, parFld.length);
            System.arraycopy(myFld, 0, fields, parFld.length, myFld.length);
        }
        return fields;
    }

    @Override
    public MyField getField(String n, boolean protoo) throws NoSuchFieldException {
        MyField[] fields = this.getFields(protoo);
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals(n)) continue;
            return fields[i];
        }
        throw new NoSuchFieldException(n);
    }

    @Override
    public boolean isString() {
        return this.extClass != null ? this.isString(this.extClass) : false;
    }

    @Override
    public boolean isBoolean() {
        return this.extClass != null ? this.isBoolean(this.extClass) : false;
    }

    @Override
    public boolean isFunctionalInterface() {
        return this.getFunctionalMethod() != null;
    }

    @Override
    public boolean isAbstract() {
        return this.extClass != null ? Modifier.isAbstract(this.extClass.getModifiers()) : false;
    }

    @Override
    public MyMethod getFunctionalMethod() {
        if (this.funcMethod == null) {
            MyMethod fm = null;
            if (this.isInterface()) {
                MyMethod[] mths;
                for (MyMethod mm : mths = this.getMethods(false)) {
                    if (!mm.isInterfaceMethod() || mm.isStatic() || mm.isDefault()) continue;
                    if (fm != null) {
                        fm = null;
                        break;
                    }
                    fm = mm;
                }
            }
            this.funcMethod = new MyMethod[]{fm};
        }
        return this.funcMethod[0];
    }

    @Override
    public boolean isPrimitiveOrString() {
        if (this.isClass(String.class)) {
            return true;
        }
        return this.isPrimitive();
    }

    @Override
    public MyClass getWrappedType() {
        if (this.extClass == null) {
            return null;
        }
        if (this.extClass == Byte.class) {
            return MyClass.getInstance(Byte.TYPE);
        }
        if (this.extClass == Short.class) {
            return MyClass.getInstance(Short.TYPE);
        }
        if (this.extClass == Integer.class) {
            return MyClass.getInstance(Integer.TYPE);
        }
        if (this.extClass == Long.class) {
            return MyClass.getInstance(Long.TYPE);
        }
        if (this.extClass == Float.class) {
            return MyClass.getInstance(Float.TYPE);
        }
        if (this.extClass == Double.class) {
            return MyClass.getInstance(Double.TYPE);
        }
        if (this.extClass == Character.class) {
            return MyClass.getInstance(Character.TYPE);
        }
        if (this.extClass == Boolean.class) {
            return MyClass.getInstance(Boolean.TYPE);
        }
        return null;
    }

    @Override
    public boolean isStrictPrimitive() {
        if (this.extClass != null) {
            return this.extClass.isPrimitive();
        }
        return false;
    }

    @Override
    public boolean isPrimitiveWrapper() {
        if (this.extClass != null) {
            return DefaultClass.isPrimitiveWrapper(this.extClass);
        }
        return false;
    }

    @Override
    public boolean isPrimitiveNumericWrapper() {
        if (this.extClass != null) {
            return DefaultClass.isPrimitiveNumericWrapper(this.extClass);
        }
        return false;
    }

    @Override
    public boolean isPrimitiveInteger() {
        if (this.extClass != null) {
            return DefaultClass.isPrimitiveInteger(this.extClass);
        }
        return false;
    }

    @Override
    public boolean isPrimitive() {
        if (this.extClass != null) {
            return DefaultClass.isPrimitive(this.extClass);
        }
        return false;
    }

    @Override
    public boolean isAssignableFrom(Class c) {
        return this.isAssignableFrom(c, true);
    }

    @Override
    public boolean isAssignableFrom(Class c, boolean strict) {
        if (c == null) {
            return true;
        }
        if (c.isInterface()) {
            return true;
        }
        if (this.extClass != null) {
            if (this.extClass.isAssignableFrom(c)) {
                return true;
            }
            if (DefaultClass.isPrimitive(this.extClass) && DefaultClass.isPrimitive(c)) {
                return DefaultClass.isPrimitiveAssignableFrom(this.extClass, c);
            }
            if (!strict && this.isPrimitiveOrString(c) && this.isCobolVar()) {
                return true;
            }
            return this.isPrimitiveOrString() && DefaultClass.isCobolVar(c);
        }
        String fcn = this.intClass.getFullClassName();
        int d = this.dimensions;
        if (d > 0) {
            while (d > 0 && c.isArray()) {
                c = c.getComponentType();
                --d;
            }
            return d == 0 && !c.isArray() && fcn.equals(c.getName());
        }
        if (fcn.equals(c.getName())) {
            return true;
        }
        for (Class sc = c.getSuperclass(); sc != null; sc = sc.getSuperclass()) {
            if (!fcn.equals(sc.getName())) continue;
            return true;
        }
        if (this.intClass.isInterface()) {
            for (Class<?> intf : c.getInterfaces()) {
                if (!fcn.equals(intf.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAssignableFrom(MyClass c) {
        return this.isAssignableFrom(c, true);
    }

    @Override
    public boolean isAssignableFrom(MyClass mc, boolean strict) {
        if (mc == null) {
            return true;
        }
        if (mc instanceof DefaultClass) {
            DefaultClass c = (DefaultClass)mc;
            if (c.extClass != null) {
                return this.isAssignableFrom(c.extClass, strict);
            }
            if (c.getName().equals(this.getName())) {
                return true;
            }
            String[] implClasses = c.intClass.getImplementsClass();
            if (implClasses != null) {
                for (String ic : implClasses) {
                    try {
                        MyClass myic = c.intClass.existsClass(ic);
                        if (this.isAssignableFrom(myic, strict)) {
                            return true;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
            return this.isAssignableFrom(c.getSuperclass(), strict);
        }
        return ((LambdaExpression)mc).isAssignableTo(this);
    }

    @Override
    public boolean isNumericVar() {
        return this.extClass != null && DefaultClass.isNumericVar(this.extClass);
    }

    @Override
    public boolean isCobolVar() {
        return this.extClass != null && DefaultClass.isCobolVar(this.extClass);
    }

    @Override
    public boolean isNumericEditedVar() {
        return this.extClass != null && DefaultClass.isNumericEditedVar(this.extClass);
    }

    @Override
    public boolean isAssignableTo(MyClass c, boolean strict) {
        return c.isAssignableFrom(this, strict);
    }

    @Override
    public boolean isAssignableTo(MyClass c) {
        return c.isAssignableFrom(this, true);
    }

    @Override
    public boolean isAssignableTo(Class c) {
        if (this.extClass != null) {
            return DefaultClass.isAssignableFrom(c, this.extClass);
        }
        return this.getSuperclass().isAssignableTo(c);
    }

    @Override
    public boolean isClass(Class c) {
        return this.extClass != null && this.extClass.equals(c);
    }

    @Override
    public boolean isArray() {
        if (this.extClass != null) {
            return this.extClass.isArray();
        }
        return this.dimensions > 0;
    }

    @Override
    public MyClass getComponentType() {
        if (this.extClass != null) {
            return MyClass.getInstance(this.extClass.getComponentType());
        }
        return MyClass.getInstance(this.intClass, 0);
    }

    @Override
    public int getDimensions() {
        if (this.extClass != null) {
            if (this.extClass.isArray()) {
                int i;
                String n = this.extClass.getName();
                int length = n.length();
                for (i = 0; i < length; ++i) {
                    if (n.charAt(i) == '[') continue;
                    return i;
                }
                return i;
            }
            return 0;
        }
        return this.dimensions;
    }

    public String toString() {
        return "MyClass::" + this.getName();
    }

    public boolean equals(Object c) {
        if (c instanceof Class) {
            if (this.extClass != null) {
                return this.extClass.equals((Class)c);
            }
            return false;
        }
        if (c instanceof DefaultClass) {
            if (this.extClass != null) {
                if (((DefaultClass)c).extClass != null) {
                    return this.extClass.equals(((DefaultClass)c).extClass);
                }
                return false;
            }
            return ((DefaultClass)c).extClass == null;
        }
        return c.equals(this);
    }

    @Override
    public String getPackageName() {
        if (this.intClass != null) {
            return this.intClass.getPackageName();
        }
        Package pkg = this.extClass.getPackage();
        if (pkg != null) {
            return pkg.getName();
        }
        return "";
    }

    @Override
    public boolean isPublic() {
        if (this.extClass != null) {
            return Modifier.isPublic(this.extClass.getModifiers());
        }
        return true;
    }

    @Override
    public boolean isClassAccessible(MyClass clazz) {
        if (this.getPackageName().equals(clazz.getPackageName())) {
            return true;
        }
        return clazz.isPublic();
    }

    @Override
    public boolean isInterface() {
        if (this.intClass != null) {
            return this.intClass.isInterface();
        }
        return this.extClass.isInterface();
    }

    @Override
    public boolean isEnclosedClass() {
        if (this.extClass != null) {
            return this.extClass.getEnclosingClass() != null;
        }
        return false;
    }
}

