/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.interfaces.compiler.IElkParserExtension3;
import com.iscobol.interfaces.compiler.IToken;
import java.util.Hashtable;
import java.util.Set;
import java.util.TreeSet;

public class ElkParser
implements ErrorsNumbers,
IElkParserExtension3 {
    public static final int HIDDEN = -2;
    public static final int NOMODE = -1;
    public static final int IO = 0;
    public static final int INPUT = 1;
    public static final int OUTPUT = 2;
    public static final int BYTE = 0;
    public static final int UNSIGNEDBYTE = 1;
    public static final int SHORT = 2;
    public static final int UNSIGNEDSHORT = 3;
    public static final int INT = 4;
    public static final int UNSIGNEDINT = 5;
    public static final int LONG = 6;
    public static final int UNSIGNEDLONG = 7;
    public static final int FLOAT = 8;
    public static final int DOUBLE = 9;
    public static final int DECIMAL = 10;
    public static final int INTEGER = 11;
    public static final int STRING = 12;
    public static final int BOOLEAN = 13;
    public static final int BASE64BINARY = 14;
    public static final int HEXBINARY = 15;
    private Token first;
    private Errors error;
    private TokenList tl;
    private int mode = -1;
    private boolean isInput;
    private boolean isOutput;
    private int actMode = -1;
    private boolean group;
    private Boolean groupIn;
    private Boolean groupOut;
    private boolean hidden;
    private boolean mandatory;
    private Boolean mandatoryIn;
    private Boolean mandatoryOut;
    private boolean nullable;
    private Boolean nullableIn;
    private Boolean nullableOut;
    private String name;
    private String nameReal;
    private Token nameToken;
    private String nameIn;
    private String nameInReal;
    private Token nameInToken;
    private String nameOut;
    private String nameOutReal;
    private Token nameOutToken;
    private String value;
    private String operation;
    private String type;
    private String typeIn;
    private String typeOut;
    private static Hashtable types = new Hashtable();

    public ElkParser() {
    }

    public ElkParser(TokenList t, Errors err) {
        this.error = err;
        this.tl = t;
        this.first = this.tl.getFirst();
        Token tk = this.tl.getNext();
        while (tk != null) {
            block52: {
                if (tk.getToknum() != 44 && tk.getToknum() != 92) {
                    try {
                        if ("INPUT".equalsIgnoreCase(tk.getWord())) {
                            this.actMode = 1;
                            this.isInput = true;
                            break block52;
                        }
                        if ("OUTPUT".equalsIgnoreCase(tk.getWord())) {
                            this.actMode = 2;
                            this.isOutput = true;
                            break block52;
                        }
                        if ("MANDATORY".equalsIgnoreCase(tk.getWord())) {
                            if (this.actMode == -1) {
                                this.mandatory = true;
                            } else if (this.actMode == 1) {
                                this.mandatoryIn = Boolean.TRUE;
                            } else if (this.actMode == 2) {
                                this.mandatoryOut = Boolean.TRUE;
                            }
                            break block52;
                        }
                        if ("NULLABLE".equalsIgnoreCase(tk.getWord())) {
                            if (this.actMode == -1) {
                                this.nullable = true;
                            } else if (this.actMode == 1) {
                                this.nullableIn = Boolean.TRUE;
                            } else if (this.actMode == 2) {
                                this.nullableOut = Boolean.TRUE;
                            }
                            break block52;
                        }
                        if ("USE".equalsIgnoreCase(tk.getWord())) {
                            if ("GROUP".equalsIgnoreCase(this.tl.getNext().getWord())) {
                                if (this.actMode == -1) {
                                    this.group = true;
                                } else if (this.actMode == 1) {
                                    this.groupIn = Boolean.TRUE;
                                } else if (this.actMode == 2) {
                                    this.groupOut = Boolean.TRUE;
                                }
                                break block52;
                            }
                            this.error.print(226, 4, this.first, this.first.getWord());
                            return;
                        }
                        if ("HIDDEN".equalsIgnoreCase(tk.getWord())) {
                            this.hidden = true;
                            this.mode = -2;
                            this.actMode = -2;
                            break block52;
                        }
                        if ("VALUE".equalsIgnoreCase(tk.getWord())) {
                            if (this.tl.getNext().getToknum() == 61) {
                                if (this.value != null) {
                                    this.error.print(221, 2, this.first, this.first.getWord());
                                }
                                this.value = this.tl.getNext().getOriginalWord();
                                break block52;
                            }
                            this.error.print(226, 4, this.first, this.first.getWord());
                            return;
                        }
                        if ("TYPE".equalsIgnoreCase(tk.getWord())) {
                            String typeI = null;
                            if (this.tl.getNext().getToknum() == 61) {
                                typeI = (String)types.get(this.tl.getNext().getWord().toLowerCase());
                                if (typeI == null) {
                                    this.error.print(226, 4, this.first, this.first.getWord() + "  invalid type");
                                }
                                if (this.actMode == -1) {
                                    this.type = typeI;
                                } else if (this.actMode == 1) {
                                    this.typeIn = typeI;
                                } else if (this.actMode == 2) {
                                    this.typeOut = typeI;
                                }
                                break block52;
                            }
                            this.error.print(226, 4, this.first, this.first.getWord());
                            return;
                        }
                        if ("NAME".equalsIgnoreCase(tk.getWord())) {
                            if (this.tl.getNext().getToknum() == 61) {
                                Token tkTmp;
                                if (this.actMode == 1) {
                                    if (this.nameIn != null) {
                                        this.error.print(221, 2, this.first, this.first.getWord());
                                    }
                                    this.nameInToken = tkTmp = this.tl.getNext();
                                    this.nameIn = tkTmp.getCode();
                                    if (tkTmp.getWord().charAt(0) == '\"' || tkTmp.getWord().charAt(0) == '\'') {
                                        this.nameInReal = tkTmp.getWord().substring(1, tkTmp.getWord().length() - 1);
                                    }
                                } else if (this.actMode == 2) {
                                    if (this.nameOut != null) {
                                        this.error.print(221, 2, this.first, this.first.getWord());
                                    }
                                    this.nameOutToken = tkTmp = this.tl.getNext();
                                    this.nameOut = tkTmp.getCode();
                                    if (tkTmp.getWord().charAt(0) == '\"' || tkTmp.getWord().charAt(0) == '\'') {
                                        this.nameOutReal = tkTmp.getWord().substring(1, tkTmp.getWord().length() - 1);
                                    }
                                } else {
                                    if (this.name != null) {
                                        this.error.print(221, 2, this.first, this.first.getWord());
                                    }
                                    this.nameToken = tkTmp = this.tl.getNext();
                                    this.name = tkTmp.getCode();
                                    if (tkTmp.getWord().charAt(0) == '\"' || tkTmp.getWord().charAt(0) == '\'') {
                                        this.nameReal = tkTmp.getWord().substring(1, tkTmp.getWord().length() - 1);
                                    }
                                }
                                break block52;
                            }
                            this.error.print(226, 4, this.first, this.first.getWord());
                            return;
                        }
                        if ("OPERATION".equalsIgnoreCase(tk.getWord())) {
                            if (this.tl.getNext().getToknum() == 61) {
                                if (this.operation != null) {
                                    this.error.print(221, 2, this.first, this.first.getWord());
                                }
                                this.operation = this.tl.getNext().getOriginalWord();
                                break block52;
                            }
                            this.error.print(226, 4, this.first, this.first.getWord());
                            return;
                        }
                        this.error.print(120, 4, this.first, this.first.getWord());
                        return;
                    }
                    catch (NullPointerException _ex) {
                        this.error.print(120, 4, this.first, this.first.getWord());
                        return;
                    }
                }
            }
            tk = this.tl.getNext();
        }
        this.mode = this.actMode != 0 && this.actMode != -2 ? (this.isInput && this.isOutput ? 0 : (this.isInput ? 1 : (this.isOutput ? 2 : -1))) : this.actMode;
    }

    @Override
    public boolean isIO() {
        return this.mode == 0;
    }

    @Override
    public boolean isINPUT() {
        return this.mode == 1 || this.mode == 0;
    }

    @Override
    public boolean isOUTPUT() {
        return this.mode == 2 || this.mode == 0;
    }

    @Override
    public boolean isGroup() {
        return this.group;
    }

    @Override
    public Boolean isGroupIn() {
        return this.groupIn;
    }

    @Override
    public Boolean isGroupOut() {
        return this.groupOut;
    }

    @Override
    public boolean isGroup(boolean input) {
        if (input) {
            if (this.groupIn != null) {
                return this.groupIn;
            }
        } else if (this.groupOut != null) {
            return this.groupOut;
        }
        return this.group;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public Boolean isMandatoryIn() {
        return this.mandatoryIn;
    }

    @Override
    public Boolean isMandatoryOut() {
        return this.mandatoryOut;
    }

    @Override
    public boolean isMandatory(boolean input) {
        if (input) {
            if (this.mandatoryIn != null) {
                return this.mandatoryIn;
            }
        } else if (this.mandatoryOut != null) {
            return this.mandatoryOut;
        }
        return this.mandatory;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public Boolean isNullableIn() {
        return this.nullableIn;
    }

    @Override
    public Boolean isNullableOut() {
        return this.nullableOut;
    }

    @Override
    public boolean isNullable(boolean input) {
        if (input) {
            if (this.nullableIn != null) {
                return this.nullableIn;
            }
        } else if (this.nullableOut != null) {
            return this.nullableOut;
        }
        return this.nullable;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameIn() {
        return this.nameIn;
    }

    @Override
    public String getNameOut() {
        return this.nameOut;
    }

    @Override
    public IToken getNameToken() {
        return this.nameToken;
    }

    @Override
    public IToken getNameInToken() {
        return this.nameInToken;
    }

    @Override
    public IToken getNameOutToken() {
        return this.nameOutToken;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTypeIn() {
        return this.typeIn;
    }

    @Override
    public String getTypeOut() {
        return this.typeOut;
    }

    @Override
    public String getName(boolean input) {
        if (input) {
            if (this.nameIn != null) {
                return this.nameIn;
            }
        } else if (this.nameOut != null) {
            return this.nameOut;
        }
        return this.name;
    }

    public String getNameReal(boolean input) {
        if (input) {
            if (this.nameInReal != null) {
                return this.nameInReal;
            }
            if (this.nameIn != null) {
                return this.nameIn.replace("-", "_");
            }
        } else {
            if (this.nameOutReal != null) {
                return this.nameOutReal;
            }
            if (this.nameOut != null) {
                return this.nameOut.replace("-", "_");
            }
        }
        if (this.nameReal != null) {
            return this.nameReal;
        }
        if (this.name != null) {
            return this.name.replace("-", "_");
        }
        return this.name;
    }

    public String getNameGetSet(boolean input) {
        if (input) {
            if (this.nameIn != null) {
                return this.nameIn;
            }
        } else if (this.nameOut != null) {
            return this.nameOut;
        }
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getType(boolean input) {
        if (input) {
            if (this.typeIn != null) {
                return this.typeIn;
            }
        } else if (this.typeOut != null) {
            return this.typeOut;
        }
        return this.type;
    }

    @Override
    public Token getFirstToken() {
        return this.first;
    }

    public static Set getAllTypes() {
        return new TreeSet(types.values());
    }

    static {
        types.put("byte", "byte");
        types.put("unsignedbyte", "unsignedByte");
        types.put("short", "short");
        types.put("unsignedshort", "unsignedShort");
        types.put("int", "int");
        types.put("unsignedint", "unsignedInt");
        types.put("long", "long");
        types.put("unsignedlong", "unsignedLong");
        types.put("float", "float");
        types.put("double", "double");
        types.put("decimal", "decimal");
        types.put("integer", "integer");
        types.put("string", "string");
        types.put("boolean", "boolean");
        types.put("base64binary", "base64Binary");
        types.put("hexbinary", "hexBinary");
    }
}

