/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.ReportDescriptor;
import com.iscobol.compiler.ReportGroup;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.Verb;

public class Generate
extends Verb {
    private ReportDescriptor rd;
    private ReportGroup rg;

    public Generate(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
        Token name = tk;
        tk = this.tm.getToken();
        if (tk.getToknum() == 610 || tk.getToknum() == 527) {
            tk = this.tm.getToken();
            if (tk.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
            }
            this.rd = this.pc.getReport(tk);
            if (this.rd == null) {
                throw new GeneralErrorException(181, 4, tk, tk.getWord(), this.error);
            }
            this.rg = this.rd.getDetail(name);
            if (this.rg == null) {
                throw new GeneralErrorException(181, 4, name, name.getWord(), this.error);
            }
        } else {
            this.tm.ungetToken();
            this.rd = this.pc.getReport(name);
            if (this.rd == null) {
                this.rg = this.pc.getDetail(name);
                if (this.rg == null) {
                    throw new GeneralErrorException(181, 4, name, name.getWord(), this.error);
                }
                this.rd = this.rg.rd;
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        boolean hasDeclaratives = this.pc.getDeclarative(this.rd.fd.sel) != null || this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
        this.getCodeDebug(Return2);
        Return2.append("try {");
        Return2.append(eol);
        Return2.append(this.parent.getIndent());
        if (this.rg == null) {
            Return2.append(this.rd.getName());
            Return2.append(".generate();");
        } else {
            Return2.append(this.rg.rd.getName());
            Return2.append(".generate(");
            Return2.append(this.rg.getUnivoqueName());
            Return2.append(");");
        }
        Use.putDeclaratives(Return2, this.pc, this.rd.fd.sel, this.parent.getIndent(), hasDeclaratives);
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public ReportDescriptor getReportDescriptor() {
        return this.rd;
    }

    public ReportGroup getReportGroup() {
        return this.rg;
    }
}

