/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolClass;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.LocalStorageSection;
import com.iscobol.compiler.OffsetHelper;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Subscript;
import com.iscobol.compiler.ThreadLocalStorageSection;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.interfaces.compiler.IDataSection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Initialize
extends Verb
implements CobolToken,
ErrorsNumbers {
    public static final Integer T_ALPHABETIC = 1;
    public static final Integer T_ALPHANUMERIC = 2;
    public static final Integer T_ALPHANUMERIC_EDITED = 3;
    public static final Integer T_NUMERIC = 4;
    public static final Integer T_NUMERIC_EDITED = 5;
    public static final Integer T_BOOLEAN = 6;
    private VariableNameList destList = new VariableNameList();
    private boolean withFiller;
    private Token anyLengthSizeTk;
    private VariableName anyLengthSizeVn;
    private boolean toDefault;
    private Set<Integer> valueCats = new LinkedHashSet<Integer>();
    private boolean allToValue;
    private Map<Integer, Object> repCats = new LinkedHashMap<Integer, Object>();
    private boolean defaultInitialize;

    public Initialize(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        boolean dx = this.pc.getOption("-dx") != null;
        int i = 0;
        while (true) {
            VariableName vn;
            if (tk.getToknum() == 10009) {
                this.tm.ungetToken();
                vn = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1, true));
                vn.getVarDecl().setUsedAll(true, !dx);
                if (vn.getVarDecl().containsRenames()) {
                    throw new GeneralErrorException(59, 4, tk, tk.getWord(), this.error);
                }
            } else {
                if (i != 0) break;
                throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
            }
            this.destList.addItem(vn);
            tk = this.tm.getToken();
            ++i;
        }
        block0 : switch (tk.getToknum()) {
            case 814: {
                tk = this.tm.getToken();
                switch (tk.getToknum()) {
                    case 487: {
                        this.withFiller = true;
                        tk = this.tm.getToken();
                        break block0;
                    }
                    case 729: {
                        this.withSize();
                        return;
                    }
                }
                throw new ExpectedFoundException(tk, this.error, "'FILLER'");
            }
            case 487: {
                this.withFiller = true;
                tk = this.tm.getToken();
                break;
            }
            case 729: {
                this.withSize();
                return;
            }
        }
        if (this.withFiller) {
            VariableName vn = this.destList.getFirst();
            while (vn != null) {
                vn.getVarDecl().setInitializedWithFiller();
                vn = this.destList.getNext();
            }
        }
        if (tk.getToknum() == 262) {
            this.allToValue = true;
        } else {
            block30: while (true) {
                switch (tk.getToknum()) {
                    case 266: {
                        this.valueCats.add(T_ALPHABETIC);
                        break;
                    }
                    case 269: {
                        this.valueCats.add(T_ALPHANUMERIC);
                        break;
                    }
                    case 270: {
                        this.valueCats.add(T_ALPHANUMERIC_EDITED);
                        break;
                    }
                    case 604: {
                        this.valueCats.add(T_NUMERIC);
                        break;
                    }
                    case 605: {
                        this.valueCats.add(T_NUMERIC_EDITED);
                        break;
                    }
                    case 10009: {
                        if ("BOOLEAN".equals(tk.getWord())) {
                            this.valueCats.add(T_BOOLEAN);
                            break;
                        }
                    }
                    default: {
                        break block30;
                    }
                }
                tk = this.tm.getToken();
            }
        }
        if (!this.valueCats.isEmpty() || this.allToValue) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 774 ? (tk = this.tm.getToken()).getToknum() != 804 : tk.getToknum() != 804) {
                throw new ExpectedFoundException(tk, this.error, "'VALUE'");
            }
            tk = this.tm.getToken();
        }
        switch (tk.getToknum()) {
            case 763: {
                tk = this.tm.getToken();
                if (tk.getToknum() == 684) {
                    tk = this.initializeRepr(this.tm.getToken());
                    break;
                }
                if (tk.getToknum() == 774) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 397) {
                        throw new ExpectedFoundException(tk, this.error, "'DEFAULT'");
                    }
                    this.toDefault = true;
                } else if (tk.getToknum() == 397) {
                    this.toDefault = true;
                } else {
                    throw new UnexpectedTokenException(tk, this.error);
                }
                tk = this.tm.getToken();
                break;
            }
            case 774: {
                tk = this.tm.getToken();
                if (tk.getToknum() != 397) {
                    throw new ExpectedFoundException(tk, this.error, "'DEFAULT'");
                }
                this.toDefault = true;
                tk = this.tm.getToken();
                break;
            }
            case 397: {
                this.toDefault = true;
                tk = this.tm.getToken();
                break;
            }
            case 684: {
                tk = this.initializeRepr(this.tm.getToken());
            }
        }
        if (!this.toDefault) {
            switch (tk.getToknum()) {
                case 763: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 774) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() != 397) {
                            throw new ExpectedFoundException(tk, this.error, "'DEFAULT'");
                        }
                        this.toDefault = true;
                        break;
                    }
                    if (tk.getToknum() == 397) {
                        this.toDefault = true;
                        break;
                    }
                    throw new UnexpectedTokenException(tk, this.error);
                }
                case 774: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 397) {
                        throw new ExpectedFoundException(tk, this.error, "'DEFAULT'");
                    }
                    this.toDefault = true;
                    break;
                }
                case 397: {
                    this.toDefault = true;
                    break;
                }
                default: {
                    this.tm.ungetToken();
                    break;
                }
            }
        } else {
            this.tm.ungetToken();
        }
        this.defaultInitialize = !this.allToValue && this.valueCats.isEmpty() && this.repCats.isEmpty();
    }

    private void withSize() throws GeneralErrorException, EndOfProgramException {
        VariableName d = this.destList.getFirst();
        while (d != null) {
            if (!d.getVarDecl().isAnyLength()) {
                throw new GeneralErrorException(256, 4, d.getNameToken(), d.getName(), this.error);
            }
            d = this.destList.getNext();
        }
        Token tk = this.tm.getToken();
        switch (tk.getToknum()) {
            case 10002: {
                this.anyLengthSizeTk = tk;
                break;
            }
            case 10001: {
                if (tk.isNull()) {
                    tk.setZero();
                    this.anyLengthSizeTk = tk;
                    break;
                }
            }
            case 10017: {
                throw new GeneralErrorException(22, 4, tk, tk.getWord(), this.error);
            }
            case 10009: {
                this.tm.ungetToken();
                this.anyLengthSizeVn = VariableName.get(this.tm, this.error, this.pc);
                if (this.anyLengthSizeVn.isInteger()) break;
                throw new GeneralErrorException(46, 4, this.anyLengthSizeVn.getNameToken(), this.anyLengthSizeVn.getName(), this.error);
            }
            default: {
                throw new UnexpectedTokenException(tk, this.error);
            }
        }
    }

    private Token initializeRepr(Token catTk) throws GeneralErrorException, EndOfProgramException {
        int i = 0;
        block12: while (true) {
            Token tk;
            Integer category;
            switch (catTk.getToknum()) {
                case 266: {
                    category = T_ALPHABETIC;
                    if (!this.repCats.containsKey(category)) break;
                    throw new GeneralErrorException(63, 4, catTk, catTk.getWord(), this.error);
                }
                case 269: {
                    category = T_ALPHANUMERIC;
                    if (!this.repCats.containsKey(category)) break;
                    throw new GeneralErrorException(63, 4, catTk, catTk.getWord(), this.error);
                }
                case 270: {
                    category = T_ALPHANUMERIC_EDITED;
                    if (!this.repCats.containsKey(category)) break;
                    throw new GeneralErrorException(63, 4, catTk, catTk.getWord(), this.error);
                }
                case 604: {
                    category = T_NUMERIC;
                    if (!this.repCats.containsKey(category)) break;
                    throw new GeneralErrorException(63, 4, catTk, catTk.getWord(), this.error);
                }
                case 605: {
                    category = T_NUMERIC_EDITED;
                    if (!this.repCats.containsKey(category)) break;
                    throw new GeneralErrorException(63, 4, catTk, catTk.getWord(), this.error);
                }
                default: {
                    if (i != 0) break block12;
                    throw new UnexpectedTokenException(catTk, this.error);
                }
            }
            if ((tk = this.tm.getToken()).getToknum() == 388) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() != 312) {
                throw new ExpectedFoundException(tk, this.error, "'BY'");
            }
            tk = this.tm.getToken();
            switch (tk.getToknum()) {
                case 10017: {
                    if (this.illegalInitialize(catTk.getToknum(), tk.getToknum())) {
                        throw new GeneralErrorException(59, 4, catTk, catTk.getWord(), this.error);
                    }
                }
                case 10001: 
                case 10002: {
                    this.repCats.put(category, tk);
                    break;
                }
                case 10009: {
                    this.tm.ungetToken();
                    VariableName vn = VariableName.get(this.tm, this.error, this.pc);
                    if (this.illegalInitialize(catTk.getToknum(), vn.getVarDecl())) {
                        throw new GeneralErrorException(59, 4, catTk, catTk.getWord(), this.error);
                    }
                    this.repCats.put(category, vn);
                    break;
                }
                default: {
                    throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
                }
            }
            catTk = this.tm.getToken();
            ++i;
        }
        return catTk;
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    private boolean illegalInitialize(int dest, VariableDeclaration src) {
        return src.isNumeric() && !src.isInteger() && !src.isEdited() && !this.isNumeric(dest) || !src.isNumeric() && src.isEdited() && this.isNumeric(dest);
    }

    private boolean illegalInitialize(int dest, int src) {
        return !this.isNumeric(dest) && src == 10017;
    }

    private boolean isNumeric(int toknum) {
        return toknum == 604 || toknum == 605;
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        if (this.anyLengthSizeTk != null || this.anyLengthSizeVn != null) {
            this.getCodeWithSize(Return2);
        } else {
            this.getCode(Return2);
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    private void getCodeWithSize(StringBuffer Return2) {
        boolean first = true;
        VariableName vn = this.destList.getFirst();
        while (vn != null) {
            if (first) {
                first = false;
            } else {
                Return2.append(eol);
                Return2.append(this.parent.getIndent());
            }
            Return2.append("((com.iscobol.rts.IPicAnyLength) ");
            Return2.append(vn.getCode());
            Return2.append(").setSize(");
            if (this.anyLengthSizeTk != null) {
                Return2.append(this.anyLengthSizeTk.getCode());
            } else {
                Return2.append(this.anyLengthSizeVn.getCode());
                Return2.append(".toint()");
            }
            Return2.append(");");
            vn = this.destList.getNext();
        }
    }

    private void getCode(StringBuffer Return2) {
        Enumeration e = this.destList.elements();
        while (e.hasMoreElements()) {
            block47: {
                VariableDeclaration[] children;
                VariableDeclaration vd;
                VariableName vn;
                block48: {
                    block49: {
                        block46: {
                            vn = (VariableName)e.nextElement();
                            vd = vn.getVarDecl();
                            children = this.getValidChildren(vd);
                            if (!vd.isInDynamic() || vn.hasSubValue() || children.length <= 0) break block46;
                            Return2.append(vn.getCode());
                            Return2.append(".initialize(null,null,false);");
                            Return2.append(eol);
                            break block47;
                        }
                        if (!vn.hasSubValue()) break block48;
                        Object v = this.repCats.get(T_ALPHANUMERIC);
                        if (v == null) break block49;
                        if (v instanceof Token) {
                            Return2.append(this.getCodeLiteral((Token)v));
                        } else {
                            Return2.append(((VariableName)v).getCode());
                        }
                        Return2.append(".moveTo(");
                        Return2.append(vn.getCode());
                        Return2.append(");");
                        Return2.append(eol);
                        break block47;
                    }
                    if (!this.toDefault && (this.allToValue || !this.valueCats.isEmpty() || !this.repCats.isEmpty())) break block47;
                    Return2.append(vn.getCode());
                    Return2.append(".setSpace();");
                    Return2.append(eol);
                    break block47;
                }
                if (this.pc.optionMS) {
                    Iterator<Integer> it;
                    Return2.append(vn.getCode());
                    StringBuffer cats = new StringBuffer();
                    StringBuffer src = new StringBuffer();
                    if (this.allToValue) {
                        cats.append("CobolVar.ALL_TO_VALUE");
                        src.append("null");
                        if (!this.repCats.isEmpty() || this.toDefault) {
                            cats.append(", ");
                            src.append(", ");
                        }
                    } else if (!this.valueCats.isEmpty()) {
                        it = this.valueCats.iterator();
                        while (it.hasNext()) {
                            switch (it.next()) {
                                case 1: {
                                    cats.append("CobolVar.ALPHABETIC");
                                    break;
                                }
                                case 2: {
                                    cats.append("CobolVar.ALPHANUMERIC");
                                    break;
                                }
                                case 3: {
                                    cats.append("CobolVar.ALPHANUMERIC_EDITED");
                                    break;
                                }
                                case 4: {
                                    cats.append("CobolVar.NUMERIC");
                                    break;
                                }
                                case 5: {
                                    cats.append("CobolVar.NUMERIC_EDITED");
                                    break;
                                }
                                case 6: {
                                    cats.append("CobolVar.BOOLEAN");
                                }
                            }
                            src.append("null");
                            if (!it.hasNext()) continue;
                            cats.append(", ");
                            src.append(", ");
                        }
                        if (!this.repCats.isEmpty() || this.toDefault) {
                            cats.append(", ");
                            src.append(", ");
                        }
                    }
                    if (!this.repCats.isEmpty()) {
                        it = this.repCats.keySet().iterator();
                        while (it.hasNext()) {
                            Integer k = it.next();
                            switch (k) {
                                case 1: {
                                    cats.append("CobolVar.ALPHABETIC");
                                    break;
                                }
                                case 2: {
                                    cats.append("CobolVar.ALPHANUMERIC");
                                    break;
                                }
                                case 3: {
                                    cats.append("CobolVar.ALPHANUMERIC_EDITED");
                                    break;
                                }
                                case 4: {
                                    cats.append("CobolVar.NUMERIC");
                                    break;
                                }
                                case 5: {
                                    cats.append("CobolVar.NUMERIC_EDITED");
                                    break;
                                }
                                case 6: {
                                    cats.append("CobolVar.BOOLEAN");
                                }
                            }
                            Object v = this.repCats.get(k);
                            if (v instanceof Token) {
                                src.append(this.getCodeLiteral((Token)v));
                            } else {
                                src.append(((VariableName)v).getCode());
                            }
                            if (!it.hasNext()) continue;
                            cats.append(", ");
                            src.append(", ");
                        }
                        if (this.toDefault) {
                            cats.append(", ");
                            src.append(", ");
                        }
                    }
                    if (this.toDefault) {
                        cats.append("CobolVar.TO_DEFAULT");
                        src.append("null");
                    }
                    Return2.append(".initialize(");
                    if (cats.length() > 0) {
                        Return2.append(eol).append(this.parent.getIndent()).append("   ");
                        Return2.append("new int[] { ");
                        Return2.append(cats);
                        Return2.append(" },");
                        Return2.append(eol).append(this.parent.getIndent()).append("   ");
                        Return2.append("new CobolVar[] { ");
                        Return2.append(src);
                        Return2.append(" },");
                        Return2.append(eol).append(this.parent.getIndent()).append("   ");
                        Return2.append(this.withFiller);
                    } else if (this.withFiller) {
                        Return2.append("null, null, true");
                    }
                    Return2.append(");");
                    Return2.append(eol);
                } else {
                    ArrayList<String> idxs = new ArrayList<String>();
                    if (vn.hasIndexes()) {
                        String initIdx = "initIdx$" + Initialize.getUniqueId();
                        Return2.append("int[] ");
                        Return2.append(initIdx);
                        Return2.append(" = new int[] { ");
                        int i = 0;
                        Enumeration e1 = vn.getIndexes().elements();
                        while (e1.hasMoreElements()) {
                            if (vd.hasVariableOffset()) {
                                Return2.append("(");
                            }
                            Return2.append(((Subscript)e1.nextElement()).getCode());
                            if (vd.hasVariableOffset()) {
                                Return2.append("-1)");
                            }
                            idxs.add(initIdx + "[" + i + "]");
                            if (e1.hasMoreElements()) {
                                Return2.append(", ");
                            }
                            ++i;
                        }
                        Return2.append("};");
                        Return2.append(eol);
                        Return2.append(this.parent.getIndent());
                        if (!vd.hasVariableOffset()) {
                            this.getUnivoqueName(vd, Return2);
                            Return2.append(".atNC(");
                            Return2.append(initIdx);
                            Return2.append(");");
                            Return2.append(eol);
                            Return2.append(this.parent.getIndent());
                        }
                    }
                    if (children.length == 0) {
                        this.getInitCode(vd, Return2, idxs);
                    } else {
                        for (int i = 0; i < children.length; ++i) {
                            String code = this.getCode(children[i], 0, idxs);
                            if (code.length() <= 0) continue;
                            if (i > 0) {
                                Return2.append(this.parent.getIndent());
                            }
                            Return2.append(code);
                        }
                    }
                }
            }
            if (!e.hasMoreElements()) continue;
            Return2.append(this.parent.getIndent());
        }
    }

    private boolean canBeOptimized(VariableDeclaration vd, boolean gun) {
        if (!this.canBeOptimized0(vd, gun)) {
            return false;
        }
        VariableDeclaration[] children = this.getValidChildren(vd);
        for (int c = 0; c < children.length; ++c) {
            if (this.canBeOptimized(children[c], gun)) continue;
            return false;
        }
        return true;
    }

    private boolean canBeOptimized0(VariableDeclaration vd, boolean gun) {
        return !vd.isNumeric() && !vd.isPic1() && !vd.isAnyLength() && !vd.isDynamic() && !(gun ^ vd.isNational()) && !vd.isPicG() && (this.withFiller || !vd.isFiller());
    }

    private String getCode(VariableDeclaration vd, int deep, ArrayList idxs) {
        StringBuffer Return2 = new StringBuffer();
        String spaces = "";
        boolean initialized = false;
        for (int i = 0; i < deep; ++i) {
            spaces = spaces + "   ";
        }
        Return2.append(spaces);
        if (vd.isDynamic()) {
            initialized = true;
            this.getDynVarCode(vd, Return2, idxs);
        } else {
            VariableDeclaration[] children = this.getValidChildren(vd);
            if (vd.redefines == null && vd.getLevel() <= 49 && (children.length > 0 || this.withFiller || !vd.isFiller())) {
                int i;
                boolean canOptimize;
                boolean gun = vd.isGroupUsageNational();
                boolean bl = canOptimize = this.defaultInitialize && this.canBeOptimized0(vd, gun);
                if (canOptimize) {
                    for (i = 0; i < children.length; ++i) {
                        if (this.canBeOptimized(children[i], gun)) continue;
                        canOptimize = false;
                        break;
                    }
                }
                if (vd.getOccurs() > 0) {
                    int ii;
                    String idxName = "i" + deep;
                    Return2.append(spaces);
                    Return2.append("for(int ");
                    Return2.append(idxName);
                    if (vd.hasVariableOffset()) {
                        Return2.append("=0;");
                        Return2.append(idxName);
                        Return2.append("<");
                    } else {
                        Return2.append("=1;");
                        Return2.append(idxName);
                        Return2.append("<=");
                    }
                    Return2.append(vd.getOccurs());
                    Return2.append(";");
                    Return2.append(idxName);
                    Return2.append("++) {");
                    Return2.append(eol);
                    ArrayList<String> newIdxs = new ArrayList<String>();
                    newIdxs.addAll(idxs);
                    newIdxs.add(idxName);
                    if (canOptimize) {
                        this.getDefaultInitializeCode(vd, Return2, newIdxs, true, gun);
                        initialized = true;
                    } else if (children.length == 0) {
                        Return2.append(this.parent.getIndent());
                        for (ii = 0; ii < deep + 1; ++ii) {
                            Return2.append("   ");
                        }
                        initialized |= this.getInitCode(vd, Return2, newIdxs);
                    } else {
                        for (int c = 0; c < children.length; ++c) {
                            String code = this.getCode(children[c], deep + 1, newIdxs);
                            initialized |= code.length() > 0;
                            Return2.append(code);
                        }
                    }
                    Return2.append(this.parent.getIndent());
                    for (ii = 0; ii < deep - 1; ++ii) {
                        Return2.append("   ");
                    }
                    Return2.append("}");
                    Return2.append(eol);
                } else if (canOptimize) {
                    this.getDefaultInitializeCode(vd, Return2, idxs, true, gun);
                    initialized = true;
                } else if (children.length == 0 || canOptimize) {
                    initialized |= this.getInitCode(vd, Return2, idxs);
                } else {
                    for (i = 0; i < children.length; ++i) {
                        String code = this.getCode(children[i], deep + 1, idxs);
                        initialized |= code.length() > 0;
                        Return2.append(code);
                    }
                }
            }
        }
        return initialized ? Return2.toString() : "";
    }

    private VariableDeclaration[] getValidChildren(VariableDeclaration vd) {
        Vector<VariableDeclaration> Return2 = new Vector<VariableDeclaration>();
        Enumeration e = vd.getChildren().elements();
        while (e.hasMoreElements()) {
            VariableDeclaration v = (VariableDeclaration)e.nextElement();
            if (v.level > 49) continue;
            Return2.addElement(v);
        }
        VariableDeclaration[] validChildren = new VariableDeclaration[Return2.size()];
        Return2.toArray(validChildren);
        return validChildren;
    }

    private boolean getInitCode(VariableDeclaration vd, StringBuffer Return2, ArrayList idxs) {
        boolean initialized = true;
        Integer category = this.varDeclToCategory(vd);
        if ((this.allToValue || this.valueCats.contains(category)) && vd.value != null) {
            Return2.append(this.getCodeLiteral(vd.value));
            Return2.append(".moveTo(");
            this.getVarCode(vd, Return2, true, idxs);
            Return2.append(");");
            Return2.append(eol);
        } else {
            Object v = this.repCats.get(category);
            if (v != null) {
                if (v instanceof Token) {
                    Return2.append(this.getCodeLiteral((Token)v));
                } else {
                    Return2.append(((VariableName)v).getCode());
                }
                Return2.append(".moveTo(");
                this.getVarCode(vd, Return2, true, idxs);
                Return2.append(");");
                Return2.append(eol);
            } else if (this.toDefault || this.defaultInitialize) {
                this.getDefaultInitializeCode(vd, Return2, idxs, false, false);
            } else {
                initialized = false;
            }
        }
        return initialized;
    }

    private void getDefaultInitializeCode(VariableDeclaration vd, StringBuffer Return2, ArrayList idxs, boolean optimized, boolean gun) {
        this.getUnivoqueName(vd, Return2);
        if (vd.hasVariableOffset()) {
            Object[] ss = new String[idxs.size()];
            idxs.toArray(ss);
            Return2.append(".offsNC(" + new OffsetHelper(vd, ss) + ")");
            Return2.append(".defaultInitialize();");
        } else {
            boolean setSpace;
            boolean bl = setSpace = optimized || this.canBeOptimized0(vd, gun);
            if (idxs.size() > 0) {
                if (idxs.size() > 1) {
                    if (setSpace) {
                        Return2.append(".atNC");
                    } else {
                        Return2.append(".atDefaultInitialize");
                    }
                    Return2.append("(new int[] {");
                    Return2.append(idxs.get(0));
                    for (int i = 1; i < idxs.size(); ++i) {
                        Return2.append("," + idxs.get(i));
                    }
                    Return2.append("})");
                } else {
                    if (setSpace) {
                        Return2.append(".atNC");
                    } else {
                        Return2.append(".atDefaultInitialize");
                    }
                    Return2.append("(");
                    Return2.append(idxs.get(0));
                    Return2.append(")");
                }
                if (setSpace) {
                    Return2.append(".setSpace()");
                }
                Return2.append(";");
            } else if (setSpace) {
                Return2.append(".setSpace();");
            } else {
                Return2.append(".defaultInitialize();");
            }
        }
        Return2.append(eol);
    }

    private void getVarCode(VariableDeclaration vd, StringBuffer Return2, boolean printCast, ArrayList idxs) {
        if ((idxs.size() > 0 || vd.hasVariableOffset()) && printCast) {
            Return2.append("(");
            if (vd.isNumeric()) {
                if (vd.isEdited()) {
                    Return2.append("PicNumEdit");
                } else {
                    Return2.append("NumericVar");
                }
            } else if (vd.isNational()) {
                Return2.append("PicN");
            } else {
                Return2.append("PicX");
            }
            Return2.append(")");
        }
        this.getUnivoqueName(vd, Return2);
        if (vd.hasVariableOffset()) {
            Object[] ss = new String[idxs.size()];
            idxs.toArray(ss);
            Return2.append(".offsNC(" + new OffsetHelper(vd, ss) + ")");
        } else if (idxs.size() > 0) {
            Return2.append(".atNC(new int[] {");
            Return2.append(idxs.get(0));
            for (int i = 1; i < idxs.size(); ++i) {
                Return2.append("," + idxs.get(i));
            }
            Return2.append("})");
        }
    }

    private void getUnivoqueName(VariableDeclaration vd, StringBuffer Return2) {
        if (vd.getClass() == VariableDeclaration.class) {
            IDataSection ps = vd.getParentSection();
            if (ps instanceof ThreadLocalStorageSection || ps instanceof FileDescriptor && ((FileDescriptor)ps).threadLocal) {
                if (!this.pc.optionMS) {
                    Return2.append("$my_thloc_stg$.");
                }
            } else if (ps instanceof LocalStorageSection) {
                if (!this.pc.optionMS) {
                    Return2.append("$my_loc_stg$.");
                }
            } else if (vd.pc instanceof CobolMethod) {
                Return2.append("this.");
            } else if (vd.pc instanceof CobolClass) {
                Pcc rootPcc = this.pc.getRoot();
                Return2.append(rootPcc.getFullClassName() + ".");
                if (!this.pc.isFactory()) {
                    Return2.append("this.");
                }
            }
        }
        Return2.append(vd.getUnivoqueName());
    }

    private void getDynVarCode(VariableDeclaration vd, StringBuffer Return2, ArrayList idxs) {
        this.getUnivoqueName(vd, Return2);
        Return2.append(".dynInitialize(");
        if (idxs.size() > 0) {
            Return2.append("new int[] {");
            Return2.append(idxs.get(0));
            for (int i = 1; i < idxs.size(); ++i) {
                Return2.append("," + idxs.get(i));
            }
            Return2.append("}");
        } else {
            Return2.append("null");
        }
        Return2.append(");");
        Return2.append(eol);
    }

    private Integer varDeclToCategory(VariableDeclaration vd) {
        if (vd.isNumeric()) {
            if (vd.isEdited) {
                return T_NUMERIC_EDITED;
            }
            return T_NUMERIC;
        }
        if (vd.isEdited) {
            return T_ALPHANUMERIC_EDITED;
        }
        if (vd.isAlphabetic()) {
            return T_ALPHABETIC;
        }
        if (vd.isPic1()) {
            return T_BOOLEAN;
        }
        return T_ALPHANUMERIC;
    }
}

