/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.BlockException;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.rts.JSONException;
import java.util.LinkedHashMap;

public class Json
extends Verb {
    private VariableName var1;
    private VariableName var2;
    private VariableName count;
    private LinkedHashMap<VariableDeclaration, Object[]> namesVnMap = new LinkedHashMap();
    private VariableNameList supprVnList;
    private BlockException onException;
    private Block notOnException;
    private boolean parse;

    public Json(Token kw, Block blk, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, blk, p, t, err);
        Token tk;
        if (!this.pc.jsonVarsDeclared) {
            this.pc.addImport("import com.iscobol.rts.JSONParseGenerate;");
            this.pc.addImport("import com.iscobol.rts.JSONException;");
        }
        if ((tk = this.tm.getToken()).getToknum() == 632) {
            this.parse();
        } else if (tk.getToknum() == 502) {
            this.generate();
        } else {
            throw new ExpectedFoundException(tk, this.error, "PARSE|GENERATE");
        }
    }

    private void parse() throws GeneralErrorException, EndOfProgramException {
        this.parse = true;
        this.header();
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 814) {
            tk = this.tm.getToken();
            if (tk.getToknum() != 405) {
                throw new ExpectedFoundException(tk, this.error, "DETAIL");
            }
            tk = this.tm.getToken();
        } else if (tk.getToknum() == 405) {
            tk = this.tm.getToken();
        }
        this.footer(tk);
    }

    private void generate() throws GeneralErrorException, EndOfProgramException {
        this.header();
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 382) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 527) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.count = VariableName.get(this.tm, this.error, this.pc);
            tk = this.tm.getToken();
        }
        this.footer(tk);
    }

    private void header() throws GeneralErrorException, EndOfProgramException {
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.var1 = VariableName.get(this.tm, this.error, this.pc);
        tk = this.tm.getToken();
        if (this.parse) {
            if (tk.getToknum() != 543) {
                throw new ExpectedFoundException(tk, this.error, "INTO");
            }
        } else if (tk.getToknum() != 499) {
            throw new ExpectedFoundException(tk, this.error, "FROM");
        }
        if ((tk = this.tm.getToken()).getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.var2 = VariableName.get(this.tm, this.error, this.pc, GetVarOpts.DYN_GRP_ALLOW);
        if (!this.parse) {
            this.var2.getVarDecl().setAutoIdentifiedBy();
        }
        this.var2.getVarDecl().setUsedAll();
    }

    private void footer(Token tk) throws GeneralErrorException, EndOfProgramException {
        VariableDeclarationList children;
        VariableName vn;
        if ("NAME".equals(tk.getWord())) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 610) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
            }
            while (tk.getToknum() == 10009) {
                this.tm.ungetToken();
                vn = VariableName.get(this.tm, this.error, null, this.pc, false, true, true, true, GetVarOpts.DYN_GRP_ALLOW);
                tk = this.tm.getToken();
                if (tk.getToknum() == 546) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() != 10001) {
                    throw new GeneralErrorException(97, 4, tk, tk.getWord(), this.error);
                }
                this.namesVnMap.put(vn.getVarDecl(), new Object[]{vn, tk});
                tk = this.tm.getToken();
            }
        }
        if (this.pc.getOption("-ostrip") != null && (children = this.var2.getVarDecl().getChildren()) != null) {
            VariableDeclaration vd = children.getFirst();
            while (vd != null) {
                this.fillNamesMap(vd);
                vd = children.getNext();
            }
        }
        if (tk.getToknum() == 749) {
            this.supprVnList = new VariableNameList();
            tk = this.tm.getToken();
            if (tk.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
            }
            while (tk.getToknum() == 10009) {
                this.tm.ungetToken();
                vn = VariableName.get(this.tm, this.error, null, this.pc, false, true, true, true, GetVarOpts.DYN_GRP_ALLOW);
                this.supprVnList.addItem(vn);
                tk = this.tm.getToken();
            }
        }
        if (tk.getToknum() == 599 || tk.getToknum() == 614 || tk.getToknum() == 473) {
            boolean on = false;
            boolean not = false;
            if (tk.getToknum() == 599) {
                not = true;
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 614) {
                on = true;
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 473) {
                if (not) {
                    this.notOnException = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 2);
                } else {
                    this.onException = new BlockException(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, MyClass.getInstance(JSONException.class));
                }
                TokenManager.Marker mk = this.tm.getMarker();
                this.tm.setMarker(mk);
                tk = this.tm.getToken();
                if (!not && tk.getToknum() == 599) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 614) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() != 473) {
                        this.tm.rewindToMarker(mk);
                    } else {
                        this.notOnException = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                    }
                } else {
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
                if (not) {
                    this.tm.ungetToken();
                }
                if (on) {
                    this.tm.ungetToken();
                }
            }
        } else {
            this.tm.ungetToken();
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 436) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
    }

    private void fillNamesMap(VariableDeclaration vd) {
        if (vd.getLevel() >= 2 && vd.getLevel() <= 49 && !vd.isFiller() && !vd.isRedefines()) {
            VariableDeclarationList children;
            if (!this.namesVnMap.containsKey(vd)) {
                Token tk = new Token(vd.getNameToken());
                tk.setToknum(10001);
                tk.setWord("\"" + tk.getOriginalWord() + "\"");
                this.namesVnMap.put(vd, new Object[]{new VariableName(vd), tk});
            }
            if ((children = vd.getChildren()) != null) {
                VariableDeclaration c = children.getFirst();
                while (c != null) {
                    this.fillNamesMap(c);
                    c = children.getNext();
                }
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        String myIndent = this.parent.getIndent();
        StringBuffer Return2 = new StringBuffer();
        this.getCodeDebug(Return2);
        Return2.append(myIndent);
        Return2.append("try {");
        Return2.append(eol);
        myIndent = myIndent + "   ";
        Return2.append(myIndent);
        Return2.append("new JSONParseGenerate ()");
        if (!this.namesVnMap.isEmpty()) {
            for (Object[] o : this.namesVnMap.values()) {
                Return2.append(".name(");
                Return2.append(((VariableName)o[0]).getCode());
                Return2.append(", ");
                Return2.append(this.tm.getCodeLiteral((Token)o[1]));
                Return2.append(")");
            }
        }
        if (this.supprVnList != null) {
            VariableName vn = this.supprVnList.getFirst();
            while (vn != null) {
                Return2.append(".suppress(");
                Return2.append(vn.getCode());
                Return2.append(")");
                vn = this.supprVnList.getNext();
            }
        }
        if (this.parse) {
            Return2.append(".parse(");
        } else {
            Return2.append(".generate(");
        }
        Return2.append(this.var1.getCode());
        Return2.append(",");
        Return2.append(this.var2.getCode());
        if (!this.parse && this.count != null) {
            Return2.append(",");
            Return2.append(this.count.getCode());
        }
        Return2.append(");");
        Return2.append(eol);
        if (this.notOnException != null) {
            Return2.append(this.notOnException.getCode());
        }
        Return2.append(eol);
        Return2.append(this.parent.getIndent());
        Return2.append("} catch (JSONException ");
        Return2.append(this.parent.getExceptName());
        Return2.append(")");
        if (this.onException != null) {
            Return2.append(this.onException.getCode());
        } else {
            Return2.append("{ }");
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }
}

