/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.ReportDescriptor;
import com.iscobol.compiler.ReportGroup;
import com.iscobol.compiler.SyntaxErrorException;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.interfaces.compiler.IReportVariable;
import java.util.List;
import java.util.Vector;

public class ReportVariable
implements CobolToken,
ErrorsNumbers,
IReportVariable {
    private Pcc pc;
    private TokenManager tm;
    private Errors error;
    private final ReportDescriptor rd;
    private final ReportGroup group;
    private final ReportVariable parent;
    private Token name;
    private int level;
    private int line;
    private int column;
    private int offset;
    private boolean groupIndicate;
    private VariableName source;
    private boolean sumReset;
    private VariableName reset;
    private VariableDeclaration cobvar;
    private Vector sum = new Vector();
    private Vector upon = new Vector();
    private Vector children = new Vector();
    private VariableDeclaration memory;
    private static int cnt;

    public ReportVariable(ReportDescriptor r, ReportGroup rg, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        this(r, rg, p, t, err, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReportVariable(ReportDescriptor r, ReportGroup rg, Pcc p, TokenManager t, Errors err, ReportVariable par) throws GeneralErrorException, EndOfProgramException {
        TokenManager.Marker mk = t.getMarker();
        TokenManager.Marker mkt = t.getMarker();
        boolean hasCobVar = false;
        this.rd = r;
        this.group = rg;
        this.pc = p;
        this.error = err;
        this.tm = t;
        this.parent = par;
        this.tm.setMarker(mk);
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 10002) {
            throw new GeneralErrorException(27, 4, tk, tk.getWord(), this.error);
        }
        this.level = tk.longValue();
        tk.setWord("77");
        tk = this.tm.getToken();
        if (tk.getToknum() == 10009) {
            this.name = tk;
        } else {
            this.tm.ungetToken();
        }
        block6: while ((tk = this.tm.getToken()).getToknum() != 10006) {
            switch (tk.getToknum()) {
                case 304: 
                case 323: 
                case 546: 
                case 548: 
                case 549: 
                case 557: 
                case 634: 
                case 635: 
                case 701: 
                case 716: 
                case 725: 
                case 777: 
                case 804: 
                case 811: 
                case 10001: 
                case 10002: 
                case 10017: 
                case 10023: {
                    hasCobVar = true;
                    continue block6;
                }
                case 409: 
                case 510: 
                case 798: {
                    continue block6;
                }
                case 566: {
                    this.tm.setMarker(mkt);
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 603) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 546) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 596) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() != 630) throw new ExpectedFoundException(tk, this.error, "PAGE");
                        this.line = 0x20000001;
                    } else {
                        boolean plus = false;
                        if (tk.getToknum() == 638) {
                            plus = true;
                            tk = this.tm.getToken();
                        }
                        if (!Token.isIntLit(tk)) {
                            throw new GeneralErrorException(22, 4, tk, tk.getWord(), this.error);
                        }
                        this.line = tk.longValue();
                        if (this.line < 0 || this.line == 0 && !plus) {
                            throw new GeneralErrorException(183, 4, tk, tk.getWord(), this.error);
                        }
                        if (plus) {
                            this.line += 0x10000000;
                        } else {
                            tk = this.tm.getToken();
                            if (tk.getToknum() == 614 || tk.getToknum() == 596) {
                                if (tk.getToknum() == 614 && (tk = this.tm.getToken()).getToknum() != 596) {
                                    throw new ExpectedFoundException(tk, this.error, "NEXT");
                                }
                                tk = this.tm.getToken();
                                if (tk.getToknum() != 630) {
                                    throw new ExpectedFoundException(tk, this.error, "PAGE");
                                }
                                this.line += 0x20000000;
                            } else {
                                this.tm.ungetToken();
                            }
                        }
                    }
                    mkt.removeUntilHere();
                    continue block6;
                }
                case 338: {
                    this.tm.setMarker(mkt);
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 603) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 546) {
                        tk = this.tm.getToken();
                    }
                    if (!Token.isIntLit(tk)) {
                        throw new GeneralErrorException(22, 4, tk, tk.getWord(), this.error);
                    }
                    this.column = tk.longValue();
                    mkt.removeUntilHere();
                    continue block6;
                }
            }
            if ("SOURCE".equals(tk.getWord())) {
                this.tm.setMarker(mkt);
                tk = this.tm.getToken();
                if (tk.getToknum() == 546) {
                    tk = this.tm.getToken();
                }
                if ("LINE-COUNTER".equals(tk.getWord()) || "PAGE-COUNTER".equals(tk.getWord())) {
                    this.tm.ungetToken();
                    this.source = VariableName.get(this.tm, this.error);
                    this.source.setOf(this.rd.reportVar);
                    this.source.check(this.pc);
                } else {
                    this.tm.ungetToken();
                    int[] openParl = new int[]{0};
                    Expression expr = new Expression(openParl, tk, null, this.pc, this.tm, this.error, false, false);
                    Token et = expr.keyWord;
                    if (expr.isVoid()) {
                        throw new GeneralErrorException(17, 4, et, et.getWord(), this.error);
                    }
                    if (openParl[0] != 0) {
                        throw new GeneralErrorException(44, 4, et, et.getWord(), this.error);
                    }
                    if (expr.hasOperator || expr.firstVar == null) {
                        throw new GeneralErrorException(17, 4, et, et.getWord(), this.error);
                    }
                    this.source = expr.firstVar;
                }
                mkt.removeUntilHere();
                continue;
            }
            if ("GROUP".equals(tk.getWord())) {
                this.tm.setMarker(mkt);
                tk = this.tm.getToken();
                if (!"INDICATE".equals(tk.getWord())) {
                    this.tm.ungetToken();
                }
                this.groupIndicate = true;
                mkt.removeUntilHere();
                continue;
            }
            if (!"SUM".equals(tk.getWord())) throw new UnexpectedTokenException(tk, this.error);
            if (rg.type != 5) {
                throw new GeneralErrorException(186, 4, tk, tk.getWord(), this.error);
            }
            this.tm.setMarker(mkt);
            while ((tk = this.tm.getToken()).getToknum() == 10009) {
                this.tm.ungetToken();
                VariableName vn = VariableName.get(this.tm, this.error, this.pc);
                if (vn == null) throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                this.sum.add(vn);
            }
            if (this.sum.size() == 0) {
                throw new SyntaxErrorException(tk, tk.getWord(), this.error);
            }
            if (tk.getToknum() == 796) {
                while ((tk = this.tm.getToken()).getToknum() == 10009) {
                    rg = this.rd.getReportGroup(tk);
                    if (rg == null) {
                        throw new GeneralErrorException(181, 4, tk, tk.getWord(), this.error);
                    }
                    if (rg.type != 4) {
                        throw new GeneralErrorException(182, 4, tk, tk.getWord(), this.error);
                    }
                    this.upon.add(rg);
                }
            }
            if (tk.getToknum() == 690) {
                this.sumReset = true;
                tk = this.tm.getToken();
                if (tk.getToknum() == 614) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 10009) {
                    this.tm.ungetToken();
                    this.reset = VariableName.get(this.tm, this.error, this.pc);
                    if (this.reset == null) {
                        throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                    }
                } else if (tk.getToknum() != 488) {
                    throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                }
            } else {
                this.tm.ungetToken();
            }
            mkt.removeUntilHere();
        }
        if (this.line != 0 && rg.setLine(this.line)) {
            throw new GeneralErrorException(183, 4, this.name != null ? this.name : this.rd.reportName, "" + this.line, this.error);
        }
        if (this.column != 0 && rg.setColumn(this.column)) {
            throw new GeneralErrorException(184, 4, this.name != null ? this.name : this.rd.reportName, "" + this.column, this.error);
        }
        if (hasCobVar) {
            this.tm.rewindToMarker(mk);
            this.cobvar = new VariableDeclaration(this.pc, this.tm, this.error, null);
            this.cobvar.setUsed();
            this.pc.loadVariable(this.cobvar);
            this.offset = this.column != 0 ? this.column - 1 : rg.getColumn() - 1;
            rg.setColumn(this.offset + 1 + this.cobvar.globalLen());
        } else {
            mk.removeUntilHere();
            if (this.column > 0) {
                rg.setColumn(this.column);
            }
        }
        while ((tk = this.tm.getToken()).getToknum() == 10002 && tk.longValue() > this.level) {
            this.tm.ungetToken();
            this.children.add(new ReportVariable(this.rd, rg, this.pc, this.tm, this.error, this));
        }
        this.tm.ungetToken();
    }

    public static void resetCounters() {
        cnt = 0;
    }

    public void check() throws GeneralErrorException {
        int i;
        if (this.source != null) {
            this.source.check(this.pc);
        }
        for (i = this.sum.size() - 1; i >= 0; --i) {
            ((VariableName)this.sum.elementAt(i)).check(this.pc);
        }
        for (i = this.upon.size() - 1; i >= 0; --i) {
            ((ReportGroup)this.upon.elementAt(i)).check();
        }
        if (this.reset != null) {
            this.reset.check(this.pc);
            if (!this.rd.isControl(this.reset)) {
                throw new GeneralErrorException(185, 4, this.reset.name, this.reset.name.getWord(), this.error);
            }
        }
        if (this.line != 0) {
            Token mNm = new Token(this.name != null ? this.name : this.rd.reportName);
            mNm.setWord("mem$line$" + cnt++);
            this.memory = VariableDeclaration.getPicX(this.pc, this.tm, mNm, this.rd.getLen(), null);
            this.memory.setAccessedByAddress();
            this.memory.setUsed();
        }
        if (this.cobvar != null) {
            this.cobvar.parent = this.getMemoryVar();
            this.cobvar.level = this.cobvar.parent.level + 1;
        }
        for (i = this.children.size() - 1; i >= 0; --i) {
            ((ReportVariable)this.children.elementAt(i)).check();
        }
    }

    public String getCode(StringBuffer dynPart) {
        StringBuffer Return2 = new StringBuffer();
        if (this.name != null) {
            Return2.append(this.tm.getCommentCode(this.name, "   "));
        }
        if (this.memory != null) {
            Return2.append(this.memory.getCode(dynPart));
        }
        if (this.name != null && this.cobvar != null) {
            this.cobvar.setOffset(this.offset);
            Return2.append(this.cobvar.getCode(dynPart));
            dynPart.append(this.rd.getName());
            dynPart.append(".addVar ((new ReportVariable (");
            dynPart.append(this.level);
            dynPart.append(",");
            dynPart.append(this.cobvar.getUnivoqueName());
        } else {
            dynPart.append(this.rd.getName());
            dynPart.append(".addVar ((new ReportVariable (");
            dynPart.append(this.level);
            if (this.cobvar != null) {
                StringBuffer arguments = new StringBuffer();
                dynPart.append(",");
                arguments.append(this.getMemoryVar().getUnivoqueName());
                arguments.append(",");
                arguments.append(this.offset);
                arguments.append(",");
                arguments.append(this.cobvar.globalLen());
                this.cobvar.fillArguments(arguments, false);
                this.cobvar.getFactoryInvoke(arguments, dynPart);
            }
        }
        dynPart.append("))");
        if (this.source != null) {
            dynPart.append(".setSource (");
            this.printVariableName(dynPart, this.source);
            dynPart.append(")");
        }
        if (this.line != 0) {
            dynPart.append(".setLine (0x");
            dynPart.append(Integer.toHexString(this.line));
            if (this.memory != null) {
                dynPart.append(",");
                dynPart.append(this.memory.getUnivoqueName());
            }
            dynPart.append(")");
        }
        if (this.column != 0) {
            dynPart.append(".setColumn (0x");
            dynPart.append(Integer.toHexString(this.column));
            dynPart.append(")");
        }
        if (this.groupIndicate) {
            dynPart.append(".setGroupIndicate ()");
        }
        if (this.sum.size() > 0) {
            dynPart.append(".setSum(new CobValue[] {");
            int i = 0;
            while (true) {
                dynPart.append(((VariableName)this.sum.elementAt(i)).getCode());
                if (++i == this.sum.size()) break;
                dynPart.append(",");
            }
            if (this.upon.size() > 0) {
                dynPart.append("}, new ReportGroup[] {");
                i = 0;
                while (true) {
                    dynPart.append(((ReportGroup)this.upon.elementAt(i)).getUnivoqueName());
                    if (++i == this.sum.size()) break;
                    dynPart.append(",");
                }
                dynPart.append("})");
            } else {
                dynPart.append("}, null)");
            }
        }
        if (this.sumReset) {
            dynPart.append(".setReset (");
            if (this.reset == null) {
                dynPart.append("null");
            } else {
                dynPart.append(this.reset.getCode());
            }
            dynPart.append(")");
        }
        dynPart.append(");");
        dynPart.append(eol);
        for (int i = 0; i < this.children.size(); ++i) {
            Return2.append(((ReportVariable)this.children.elementAt(i)).getCode(dynPart));
        }
        return Return2.toString();
    }

    @Override
    public VariableDeclaration getMemoryVar() {
        if (this.memory != null) {
            return this.memory;
        }
        if (this.parent != null) {
            return this.parent.getMemoryVar();
        }
        return this.rd.vParent;
    }

    private void printVariableName(StringBuffer Return2, VariableName obj) {
        if (obj.hasSubValue() || obj.hasVariableIndex() || obj.isFunction() || obj.isMethod()) {
            Return2.append("new ECV() { public ICobolVar ieval() { return ");
            Return2.append(obj.getCode());
            Return2.append("; } }");
        } else {
            Return2.append(obj.getCode());
        }
    }

    @Override
    public VariableDeclaration getCobVar() {
        return this.cobvar;
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public List getUpon() {
        return this.upon;
    }

    @Override
    public Token getName() {
        return this.name;
    }

    @Override
    public VariableName getSource() {
        return this.source;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public VariableDeclaration getMemory() {
        return this.memory;
    }

    @Override
    public boolean getGroupIndicate() {
        return this.groupIndicate;
    }

    @Override
    public boolean getSumReset() {
        return this.sumReset;
    }

    @Override
    public VariableName getReset() {
        return this.reset;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public List getSum() {
        return this.sum;
    }
}

