/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Alphabet;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.Call;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Goto;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Perform;
import com.iscobol.compiler.SqlStatement;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class SqlWhenever
extends SqlStatement {
    private boolean notFound;
    public final VariableName sqlwarn0;
    private Verb imperative;
    private boolean hasGoto = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SqlWhenever(ExecSql es, Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(es, kw, par, p, t, err);
        Token tk = this.getSqlToken();
        String str = tk.getWord().toUpperCase();
        if (tk.getToknum() == 599) {
            this.sqlwarn0 = null;
            tk = this.getSqlToken();
            if (!"FOUND".equals(tk.getWord().toUpperCase())) throw new ExpectedFoundException(tk, this.error, "FOUND");
            this.notFound = true;
        } else if ("SQLWARNING".equals(str)) {
            this.sqlwarn0 = new VariableName(new Token(10009, "SQLWARN0", kw.getFLN(), kw.getOffset(), kw.getFileName()));
            this.sqlwarn0.check(this.pc);
        } else {
            if (!"SQLERROR".equals(str)) {
                this.sqlwarn0 = null;
                throw new UnexpectedTokenException(tk, this.error);
            }
            this.sqlwarn0 = null;
        }
        tk = this.getSqlToken();
        if ("DO".equals(tk.getWord().toUpperCase())) {
            tk = this.getSqlToken();
        }
        if ("GOTO".equals(tk.getWord().toUpperCase())) {
            tk.setToknum(504);
        }
        if (tk.getToknum() == 504) {
            this.hasGoto = true;
            this.imperative = new Goto(tk, this.parent, this.pc, this.tm, this.error);
            return;
        } else if (tk.getToknum() == 633) {
            this.imperative = new Perform(tk, this.parent, this.pc, this.tm, this.error);
            return;
        } else if (tk.getToknum() == 313) {
            this.imperative = new Call(tk, this.parent, this.pc, this.tm, this.error);
            return;
        } else {
            if (tk.getToknum() == 372) return;
            throw new UnexpectedTokenException(tk, this.error);
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.imperative != null) {
            this.imperative.check();
        }
    }

    public boolean isWarning() {
        return this.sqlwarn0 != null;
    }

    public boolean isNotFound() {
        return this.notFound;
    }

    public boolean hasGoto() {
        return this.hasGoto;
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        if (this.imperative != null) {
            if (this.notFound) {
                Return2.append("{ final int $sqlCode = " + this.sqlcapfx + this.pc.sqlca.SQLCODE + ".toint();");
                Return2.append(eol);
                Return2.append(this.parent.getIndent());
                Return2.append("if ($sqlCode == Esql.getSqlcode100()) {");
            } else if (this.isWarning()) {
                Return2.append("{ if (" + this.sqlcapfx + this.pc.sqlca.SQLWARN0 + ".compareTo(Factory.getStrLiteral(\"W\")");
                Alphabet cs = null;
                if (this.pc != null) {
                    cs = this.pc.getProgramCollatingSeq();
                }
                if (cs != null) {
                    Return2.append("," + cs.getDeclUnivoqueName());
                }
                Return2.append(")==0) {");
            } else {
                Return2.append("{ final int $sqlCode = " + this.sqlcapfx + this.pc.sqlca.SQLCODE + ".toint();");
                Return2.append(eol);
                Return2.append(this.parent.getIndent());
                Return2.append("if ($sqlCode != 0 && $sqlCode != Esql.getSqlcode100()) {");
            }
            Return2.append(eol);
            Return2.append(this.imperative.getCode());
            Return2.append(this.parent.getIndent());
            Return2.append("} }");
            Return2.append(eol);
        }
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public Verb getImperative() {
        return this.imperative;
    }
}

