/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.Expression;
import com.iscobol.interfaces.debugger.IVarNameExtension;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class VarName
implements IVarNameExtension,
DataExternalizable {
    private static final long serialVersionUID = 1000007L;
    private Vector<String> of = new Vector();
    private Vector<Expression> subscript = new Vector();
    private String name;
    private String fullName;
    private Expression leftPos;
    private Expression subLen;
    private transient int type;
    private transient int offset;
    private transient int length;
    private transient String value;

    public VarName() {
    }

    public VarName(String name, String value) {
        this.name = name;
        this.fullName = name;
        this.value = value;
    }

    public VarName(DebugTM tm) throws DebuggerException {
        DebugTM.Marker initMk = tm.setMarker();
        this.analyze(tm);
        tm.ungetToken();
        DebugTM.Marker endMk = tm.setMarker();
        tm.getToken();
        this.fullName = tm.toString(initMk, endMk);
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void clearSubscripts() {
        this.subscript.clear();
    }

    @Override
    public boolean hasSubvalue() {
        return this.leftPos != null;
    }

    @Override
    public boolean hasAncestor() {
        return this.of.size() > 0;
    }

    @Override
    public Enumeration getAncestors() {
        return this.of.elements();
    }

    @Override
    public int getNAncestors() {
        return this.of.size();
    }

    @Override
    public int getNSubscripts() {
        return this.subscript.size();
    }

    @Override
    public String getAncestor(int i) {
        try {
            return this.of.elementAt(i);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public Enumeration getSubscripts() {
        return this.subscript.elements();
    }

    @Override
    public Expression getSubscript(int i) {
        try {
            return this.subscript.elementAt(i);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasSubscript() {
        return this.subscript.size() > 0;
    }

    @Override
    public Expression getLeftPos() {
        return this.leftPos;
    }

    @Override
    public Expression getSubLen() {
        return this.subLen;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String v) {
        this.value = v;
    }

    public void setFullName(String n) {
        this.fullName = n;
    }

    @Override
    public String getFullName() {
        if (this.fullName != null) {
            return this.fullName.toUpperCase();
        }
        return "";
    }

    public boolean equals(Object o) {
        if (!(o instanceof VarName)) {
            return false;
        }
        VarName vn = (VarName)o;
        return this.getFullName().equals(vn.getFullName());
    }

    private void analyze(DebugTM tm) throws DebuggerException {
        String tk;
        this.name = tm.getToken();
        if (this.name == null) {
            throw new DebuggerException(5);
        }
        if (this.name.equals(":")) {
            this.name = tm.getToken();
            if (this.name == null) {
                throw new DebuggerException(5);
            }
        }
        if (this.name.indexOf(46) >= 0) {
            String[] ss = this.name.split("\\.");
            this.name = ss[ss.length - 1];
            for (int i = 0; i < ss.length - 1; ++i) {
                this.of.add(0, ss[i]);
            }
            tk = tm.getToken();
        } else {
            while ((tk = tm.getToken()) != null && (tk.equalsIgnoreCase("OF") || tk.equalsIgnoreCase("IN"))) {
                tk = tm.getToken();
                if (tk != null) {
                    this.of.addElement(tk);
                    continue;
                }
                throw new DebuggerException(5);
            }
        }
        if (tk != null) {
            if (!tk.equals("(")) {
                tm.ungetToken();
                return;
            }
            tk = tm.getToken();
            if (tk == null) {
                throw new DebuggerException(5);
            }
            tm.ungetToken();
            Expression val = new Expression(tm);
            tk = tm.getToken();
            if (tk == null) {
                throw new DebuggerException(5);
            }
            if (tk.equals(":")) {
                this.leftPos = val;
                tk = tm.getToken();
                if (tk == null) {
                    throw new DebuggerException(5);
                }
                if (!tk.equals(")")) {
                    tm.ungetToken();
                    this.subLen = new Expression(tm);
                    tk = tm.getToken();
                    if (tk == null || !tk.equals(")")) {
                        throw new DebuggerException(5);
                    }
                }
            } else {
                this.subscript.addElement(val);
                tm.ungetToken();
                while ((tk = tm.getToken()) != null && !tk.equals(")")) {
                    tm.ungetToken();
                    this.subscript.addElement(new Expression(tm));
                }
                if (tk == null) {
                    throw new DebuggerException(5);
                }
                tk = tm.getToken();
                if (tk != null) {
                    if (tk.equals("(")) {
                        tk = tm.getToken();
                        if (tk == null) {
                            throw new DebuggerException(5);
                        }
                        tm.ungetToken();
                        this.leftPos = new Expression(tm);
                        tk = tm.getToken();
                        if (tk == null || !tk.equals(":")) {
                            throw new DebuggerException(5);
                        }
                        tk = tm.getToken();
                        if (tk == null) {
                            throw new DebuggerException(5);
                        }
                        if (!tk.equals(")")) {
                            tm.ungetToken();
                            this.subLen = new Expression(tm);
                            tk = tm.getToken();
                            if (tk == null || !tk.equals(")")) {
                                throw new DebuggerException(5);
                            }
                        }
                    } else {
                        tm.ungetToken();
                    }
                }
            }
        }
    }

    @Override
    public boolean containsVariables() {
        if (!this.hasSubscript() && !this.hasSubvalue()) {
            return false;
        }
        if (this.hasSubscript()) {
            Enumeration<Expression> en = this.subscript.elements();
            while (en.hasMoreElements()) {
                if (!en.nextElement().containsVariables()) continue;
                return true;
            }
            return false;
        }
        return this.leftPos != null && this.leftPos.containsVariables() || this.subLen != null && this.subLen.containsVariables();
    }

    public String toString() {
        return this.fullName;
    }

    public Object clone() {
        VarName Return2 = new VarName();
        Return2.of = new Vector();
        Return2.of.addAll(this.of);
        Return2.subscript = new Vector();
        Return2.subscript.addAll(this.subscript);
        Return2.fullName = this.fullName;
        Return2.leftPos = this.leftPos;
        Return2.name = this.name;
        Return2.subLen = this.subLen;
        Return2.value = this.value;
        return Return2;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        RtsUtil.writeUTFOptmz(this.fullName, out);
        RtsUtil.writeUTFOptmz(this.name, out);
        out.writeInt(this.of.size());
        for (String s : this.of) {
            RtsUtil.writeUTFOptmz(s, out);
        }
        out.writeInt(this.subscript.size());
        for (Expression e : this.subscript) {
            e.writeExternal(out);
        }
        out.writeBoolean(this.leftPos != null);
        if (this.leftPos != null) {
            this.leftPos.writeExternal(out);
            out.writeBoolean(this.subLen != null);
            if (this.subLen != null) {
                this.subLen.writeExternal(out);
            }
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        int i;
        this.fullName = RtsUtil.readUTFOptmz(in);
        this.name = RtsUtil.readUTFOptmz(in);
        int n = in.readInt();
        this.of = new Vector();
        for (i = 0; i < n; ++i) {
            this.of.addElement(RtsUtil.readUTFOptmz(in));
        }
        n = in.readInt();
        this.subscript = new Vector();
        for (i = 0; i < n; ++i) {
            Expression e = new Expression();
            e.readExternal(in);
            this.subscript.addElement(e);
        }
        if (in.readBoolean()) {
            this.leftPos = new Expression();
            this.leftPos.readExternal(in);
            if (in.readBoolean()) {
                this.subLen = new Expression();
                this.subLen.readExternal(in);
            } else {
                this.subLen = null;
            }
        } else {
            this.leftPos = null;
            this.subLen = null;
        }
    }
}

