/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.VarName;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class GetVariablesCommand
implements DebugCommand {
    private static final long serialVersionUID = 1000007L;
    public static final int ID = 43;
    public static final int MAX_HEX_DUMP_LENGTH_VALUE = 1024;
    public static final int MAX_TEXT_LENGTH_VALUE = 2048;
    public static final int MAX_ARRAY_LENGTH_VALUE = 100;
    private VarName[] variablesNames;
    private boolean getChildren;
    private int maxHexDumpLength;
    private int startHexDumpOffset;
    private int maxArrayLength;
    private int startArrayOffset;
    private int maxTextLength;
    private String[] classNames;

    public GetVariablesCommand() {
        this.maxHexDumpLength = 256;
        this.startHexDumpOffset = 1;
        this.maxArrayLength = 25;
        this.startArrayOffset = 1;
        this.maxTextLength = 512;
    }

    public GetVariablesCommand(VarName[] variablesNames) {
        this(variablesNames, false, 256, 1, 25, 1, 512);
    }

    public GetVariablesCommand(VarName[] variablesNames, int maxHexDumpLength, int startHexDumpOffset, int maxArrayLength, int startArrayOffset, int maxTextLength) {
        this(variablesNames, false, maxHexDumpLength, startHexDumpOffset, maxArrayLength, startArrayOffset, maxTextLength);
    }

    public GetVariablesCommand(VarName variableName) {
        VarName[] varNameArray;
        if (variableName != null) {
            VarName[] varNameArray2 = new VarName[1];
            varNameArray = varNameArray2;
            varNameArray2[0] = variableName;
        } else {
            varNameArray = null;
        }
        this(varNameArray, true, 256, 1, 25, 1, 512);
    }

    public GetVariablesCommand(VarName variableName, int maxHexDumpLength, int startHexDumpOffset, int maxArrayLength, int startArrayOffset, int maxTextLength) {
        VarName[] varNameArray;
        if (variableName != null) {
            VarName[] varNameArray2 = new VarName[1];
            varNameArray = varNameArray2;
            varNameArray2[0] = variableName;
        } else {
            varNameArray = null;
        }
        this(varNameArray, true, maxHexDumpLength, startHexDumpOffset, maxArrayLength, startArrayOffset, maxTextLength);
    }

    private GetVariablesCommand(VarName[] variablesNames, boolean getChildren, int maxHexDumpLength, int startHexDumpOffset, int maxArrayLength, int startArrayOffset, int maxTextLength) {
        this.maxHexDumpLength = 256;
        this.startHexDumpOffset = 1;
        this.maxArrayLength = 25;
        this.startArrayOffset = 1;
        this.maxTextLength = 512;
        if (variablesNames == null || variablesNames.length == 0) {
            throw new IllegalArgumentException("variablesNames cannot be null");
        }
        if (maxHexDumpLength <= 0) {
            throw new IllegalArgumentException("maxHexDumpLength must be > 0");
        }
        if (maxHexDumpLength > 1024) {
            throw new IllegalArgumentException("maxHexDumpLength must be <= 1024");
        }
        if (startHexDumpOffset <= 0) {
            throw new IllegalArgumentException("startHexDumpOffset must be > 0");
        }
        if (maxArrayLength <= 0) {
            throw new IllegalArgumentException("maxArrayLength must be > 0");
        }
        if (maxArrayLength > 100) {
            throw new IllegalArgumentException("maxArrayLength must be <= 100");
        }
        if (startArrayOffset <= 0) {
            throw new IllegalArgumentException("startArrayOffset must be > 0");
        }
        if (maxTextLength <= 0) {
            throw new IllegalArgumentException("maxTextLength must be > 0");
        }
        if (maxTextLength > 2048) {
            throw new IllegalArgumentException("maxTextLength must be <= 2048");
        }
        this.variablesNames = variablesNames;
        this.getChildren = getChildren;
    }

    public VarName[] getVariablesNames() {
        return this.variablesNames;
    }

    public boolean getGetChildren() {
        return this.getChildren;
    }

    @Override
    public int getId() {
        return 43;
    }

    @Override
    public String getStringId() {
        return "???";
    }

    @Override
    public String getShortDescription() {
        return "???";
    }

    @Override
    public String getUsage() {
        return "???";
    }

    @Override
    public String getHelpPage() {
        return "???";
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    public int getMaxHexDumpLength() {
        return this.maxHexDumpLength;
    }

    public int getStartHexDumpOffset() {
        return this.startHexDumpOffset;
    }

    public int getMaxArrayLength() {
        return this.maxArrayLength;
    }

    public int getStartArrayOffset() {
        return this.startArrayOffset;
    }

    public int getMaxTextLength() {
        return this.maxTextLength;
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public void setClassNames(String[] classNames) {
        this.classNames = classNames;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        if (this.variablesNames != null) {
            out.writeInt(this.variablesNames.length);
            for (VarName vn : this.variablesNames) {
                vn.writeExternal(out);
            }
        } else {
            out.writeInt(0);
        }
        out.writeBoolean(this.getChildren);
        out.writeInt(this.maxHexDumpLength);
        out.writeInt(this.startHexDumpOffset);
        out.writeInt(this.maxArrayLength);
        out.writeInt(this.startArrayOffset);
        out.writeInt(this.maxTextLength);
        if (this.classNames != null) {
            out.writeInt(this.classNames.length);
            for (String c : this.classNames) {
                RtsUtil.writeUTFOptmz(c, out);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        int i;
        this.variablesNames = new VarName[in.readInt()];
        for (i = 0; i < this.variablesNames.length; ++i) {
            this.variablesNames[i] = new VarName();
            this.variablesNames[i].readExternal(in);
        }
        this.getChildren = in.readBoolean();
        this.maxHexDumpLength = in.readInt();
        this.startHexDumpOffset = in.readInt();
        this.maxArrayLength = in.readInt();
        this.startArrayOffset = in.readInt();
        this.maxTextLength = in.readInt();
        this.classNames = new String[in.readInt()];
        for (i = 0; i < this.classNames.length; ++i) {
            this.classNames[i] = RtsUtil.readUTFOptmz(in);
        }
    }
}

