/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ListCommand
implements DebugCommand {
    private static final long serialVersionUID = 1000007L;
    public static final int ID = 8;
    public static final String SHORT_DESCRIPTION = " : display source code";
    public static final String STRING_ID = "list";
    public static final String HELP_PAGE = "list.html";
    public static final String USAGE = "usage:" + eol + "   list [fromLine[,toLine]]" + eol + "or list -f" + eol + "or list -get" + eol + "or list -set listsize" + eol + "or list +" + eol + "or list -";
    private int fromLine = -1;
    private int toLine = -1;
    private boolean set;
    private boolean get;
    private boolean fileList;
    private int listSize;
    private String fileName;

    public ListCommand() {
    }

    public ListCommand(int from) {
        this.fromLine = from;
    }

    public ListCommand(int from, int to) {
        this.fromLine = from;
        this.toLine = to;
    }

    public ListCommand(int from, int to, String file) {
        this.fromLine = from;
        this.toLine = to;
        this.fileName = file;
    }

    public static ListCommand Get() {
        ListCommand Return2 = new ListCommand();
        Return2.get = true;
        return Return2;
    }

    public static ListCommand FileList() {
        ListCommand Return2 = new ListCommand();
        Return2.fileList = true;
        return Return2;
    }

    public static ListCommand Set(int listSize) {
        ListCommand Return2 = new ListCommand();
        Return2.set = true;
        Return2.listSize = listSize;
        return Return2;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    public int getFromLine() {
        return this.fromLine;
    }

    public int getToLine() {
        return this.toLine;
    }

    public int getListSize() {
        return this.listSize;
    }

    public boolean isGet() {
        return this.get;
    }

    public boolean isSet() {
        return this.set;
    }

    public boolean isFileList() {
        return this.fileList;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public int getId() {
        return 8;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.fromLine);
        out.writeInt(this.toLine);
        out.writeBoolean(this.set);
        out.writeBoolean(this.get);
        out.writeBoolean(this.fileList);
        out.writeInt(this.listSize);
        RtsUtil.writeUTFOptmz(this.fileName, out);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.fromLine = in.readInt();
        this.toLine = in.readInt();
        this.set = in.readBoolean();
        this.get = in.readBoolean();
        this.fileList = in.readBoolean();
        this.listSize = in.readInt();
        this.fileName = RtsUtil.readUTFOptmz(in);
    }
}

