/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.GraphUtilities;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class DebugDialog
extends JDialog {
    private static final long serialVersionUID = 123L;
    private KeyEventPostProcessor keyEventPostProcessor = e -> {
        if (e.getID() == 401 && e.getKeyCode() == 27) {
            this.closeDialog();
        }
        return false;
    };
    private boolean keyEventPostProcessorAdded;
    private Rectangle lastBounds;
    private JButton defaultButton;
    protected String commandString;

    public DebugDialog(JFrame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DebugDialog.this.closeDialog();
            }
        });
    }

    public String getCommandString() {
        return this.commandString;
    }

    protected void addKeyEventPostProcessor() {
        if (!this.keyEventPostProcessorAdded) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this.keyEventPostProcessor);
            this.keyEventPostProcessorAdded = true;
        }
    }

    public void closeDialog() {
        this.lastBounds = this.getBounds();
        this.dispose();
        this.removeKeyEventPostProcessor();
    }

    public Rectangle getLastBounds() {
        return this.lastBounds;
    }

    protected void removeKeyEventPostProcessor() {
        if (this.keyEventPostProcessorAdded) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this.keyEventPostProcessor);
            this.keyEventPostProcessorAdded = false;
        }
    }

    public Rectangle openDialog(Rectangle bounds) {
        if (this.defaultButton != null) {
            this.getRootPane().setDefaultButton(this.defaultButton);
        }
        if (bounds != null) {
            this.setBounds(bounds);
        } else {
            this.setLocationRelativeTo(this.getOwner());
        }
        this.addKeyEventPostProcessor();
        this.setVisible(true);
        return this.lastBounds;
    }

    protected void setDefaultButton(JButton btn) {
        this.defaultButton = btn;
    }

    public static void setFirstFocusedComponent(JComponent component) {
        GraphUtilities.setFirstFocusedComponent(component);
    }
}

