/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.dialogs.InputDialog;
import com.iscobol.debugger.dialogs.NamesRecorder;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.text.JTextComponent;

public class OffsetLengthDialog
extends InputDialog {
    private NamesRecorder nRec;

    public OffsetLengthDialog(JFrame parent, String title, String[] initialValue) {
        super(parent, title, new String[]{"Variable name:", "Method/Program:"}, null, initialValue, new int[]{20, 20}, false, false);
    }

    @Override
    protected JComponent createAndInitValueCmp(int index, int len, String initValue) {
        if (index > 0) {
            return super.createAndInitValueCmp(index, len, initValue);
        }
        JComboBox<String> cb = new JComboBox<String>();
        Component c = cb.getEditor().getEditorComponent();
        if (c instanceof JTextComponent) {
            c.addMouseListener(new GraphUtilities.TextFieldDefaultPopup((JTextComponent)c));
        }
        cb.setEditable(true);
        if (this.nRec == null) {
            this.nRec = NamesRecorder.getInstance("varname");
        }
        if (initValue != null) {
            this.nRec.removeAndInsert(initValue);
        }
        Iterator<String> it = this.nRec.names();
        while (it.hasNext()) {
            cb.addItem(it.next());
        }
        if (initValue != null) {
            cb.setSelectedItem(initValue);
        }
        return cb;
    }

    @Override
    protected String getValue(int index, JComponent c) {
        if (index > 0) {
            return super.getValue(index, c);
        }
        JComboBox cb = (JComboBox)c;
        Object item = cb.getEditor().getItem();
        if (item != null) {
            this.nRec.removeAndInsert(item.toString());
            return item.toString();
        }
        return null;
    }
}

