/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.extfh;

import com.iscobol.extfh.ExtfhBase;
import com.iscobol.extfh.ExtfhConstants;
import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.io.DataStream;
import com.iscobol.io.FileTypeManager;
import com.iscobol.io.IndexFile;
import com.iscobol.io.LineSeqFile;
import com.iscobol.io.LineSequentialDFile;
import com.iscobol.io.RelativeDFile;
import com.iscobol.io.SequentialDFile;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.DynamicFile;
import com.iscobol.rts.Factory;
import com.iscobol.rts.HandlesManager;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.KeyDescription;
import com.iscobol.types.CobolVar;
import com.iscobol.types.PicX;

public class InExtfh
extends ExtfhBase
implements ExtfhConstants {
    private static HandlesManager handles = new HandlesManager(100);
    private static Logger log = LoggerFactory.get(8);
    private static byte[] dummyRecord = new byte[0];
    private final String fileName;
    private CobolFile file;
    private byte[] recMem;
    private CobolVar record;
    private int lockType;
    private CobolVar[][] keys;
    private static final byte[] dummyKdb = new byte[40];

    private static int getHandle(byte[] fcd) {
        int Return2 = (fcd[28] & 0xFF) << 24;
        Return2 |= (fcd[29] & 0xFF) << 16;
        Return2 |= (fcd[30] & 0xFF) << 8;
        return Return2 |= fcd[31] & 0xFF;
    }

    private static InExtfh newInExtfh(byte[] fcd, String fileName, byte[] kdb) {
        InExtfh Return2 = new InExtfh(fcd, fileName, kdb);
        int hndl = handles.newHandle(Return2);
        fcd[28] = (byte)(hndl >>> 24 & 0xFF);
        fcd[29] = (byte)(hndl >>> 16 & 0xFF);
        fcd[30] = (byte)(hndl >>> 8 & 0xFF);
        fcd[31] = (byte)(hndl & 0xFF);
        return Return2;
    }

    public static void setFileStatus(byte[] fcd, String fs) {
        char[] cfs = fs.toCharArray();
        fcd[0] = (byte)fs.charAt(0);
        fcd[1] = (byte)fs.charAt(1);
    }

    public static void setFileStatus(byte[] fcd, int idx) {
        if ((fcd[33] & 0x80) != 0) {
            fcd[0] = ansi85fs[idx][0];
            fcd[1] = ansi85fs[idx][1];
        } else {
            fcd[0] = ansi74fs[idx][0];
            fcd[1] = ansi74fs[idx][1];
        }
    }

    public static void extfh(char op, byte[] fcd, byte[] record, int recLen, int recOffs, String fileName, byte[] keyDefBlock) {
        block35: {
            if (log != null) {
                log.info("EXTFH:" + fileName + ", OP=" + Integer.toHexString(op) + ", REC-LEN=" + recLen + ", REC-OFFSET=" + recOffs + ", BUF-LEN=" + (record != null ? record.length : -1) + ", OTH-FLG=0x" + Integer.toHexString(fcd[25] & 0xFF));
            }
            if (record == null) {
                record = dummyRecord;
            }
            try {
                switch (op) {
                    case '\ufa00': 
                    case '\ufa01': 
                    case '\ufa02': 
                    case '\ufa03': 
                    case '\ufa04': 
                    case '\ufa05': 
                    case '\ufa08': {
                        InExtfh theFile = InExtfh.newInExtfh(fcd, fileName, keyDefBlock);
                        theFile.open(fcd, op);
                        break;
                    }
                    case '\ufa80': 
                    case '\ufa81': 
                    case '\ufa82': 
                    case '\ufa84': 
                    case '\ufa85': 
                    case '\ufa86': {
                        int hndl = InExtfh.getHandle(fcd);
                        InExtfh theFile = (InExtfh)handles.getObject(hndl);
                        if (theFile != null) {
                            theFile.close(fcd, op);
                            handles.removeHandle(hndl);
                            break;
                        }
                        InExtfh.setFileStatus(fcd, 35);
                        break;
                    }
                    case '\ufa8d': 
                    case '\ufad8': 
                    case '\ufad9': 
                    case '\ufaf5': {
                        InExtfh theFile = (InExtfh)handles.getObject(InExtfh.getHandle(fcd));
                        if (theFile != null) {
                            theFile.next(fcd, op, record);
                            break;
                        }
                        InExtfh.setFileStatus(fcd, 35);
                        break;
                    }
                    case '\ufa8c': 
                    case '\ufade': 
                    case '\ufadf': 
                    case '\ufaf9': {
                        InExtfh theFile = (InExtfh)handles.getObject(InExtfh.getHandle(fcd));
                        if (theFile != null) {
                            theFile.prev(fcd, op, record);
                            break;
                        }
                        InExtfh.setFileStatus(fcd, 35);
                        break;
                    }
                    case '\ufa8e': 
                    case '\ufa8f': 
                    case '\ufac9': 
                    case '\ufad6': 
                    case '\ufad7': 
                    case '\ufada': 
                    case '\ufadb': 
                    case '\ufaf6': {
                        InExtfh theFile = (InExtfh)handles.getObject(InExtfh.getHandle(fcd));
                        if (theFile != null) {
                            theFile.read(fcd, op, record);
                            break;
                        }
                        InExtfh.setFileStatus(fcd, 35);
                        break;
                    }
                    case '\ufaf1': {
                        InExtfh.setFileStatus(fcd, 35);
                        break;
                    }
                    case '\ufae3': 
                    case '\ufae4': 
                    case '\ufaec': 
                    case '\ufaed': {
                        InExtfh.setFileStatus(fcd, 35);
                        break;
                    }
                    case '\ufae1': 
                    case '\ufae2': 
                    case '\ufae5': 
                    case '\ufae6': 
                    case '\ufaf3': {
                        InExtfh theFile = (InExtfh)handles.getObject(InExtfh.getHandle(fcd));
                        if (theFile != null) {
                            theFile.write(fcd, op, record);
                            break;
                        }
                        InExtfh.setFileStatus(fcd, 35);
                        break;
                    }
                    case '\ufaf4': {
                        InExtfh theFile = (InExtfh)handles.getObject(InExtfh.getHandle(fcd));
                        if (theFile != null) {
                            theFile.rewrite(fcd, op, record);
                            break;
                        }
                        InExtfh.setFileStatus(fcd, 35);
                        break;
                    }
                    case '\ufae8': 
                    case '\ufae9': 
                    case '\ufaea': 
                    case '\ufaeb': 
                    case '\ufafe': 
                    case '\ufaff': {
                        InExtfh theFile = (InExtfh)handles.getObject(InExtfh.getHandle(fcd));
                        if (theFile != null) {
                            theFile.start(fcd, op, record);
                            break;
                        }
                        InExtfh.setFileStatus(fcd, 35);
                        break;
                    }
                    case '\ufa90': 
                    case '\ufa92': 
                    case '\ufaca': 
                    case '\ufacc': 
                    case '\ufad0': 
                    case '\ufad1': 
                    case '\ufad4': 
                    case '\ufad5': {
                        InExtfh.setFileStatus(fcd, 35);
                        break;
                    }
                    case '\ufaf7': {
                        InExtfh theFile = (InExtfh)handles.getObject(InExtfh.getHandle(fcd));
                        if (theFile != null) {
                            theFile.delete(fcd, record);
                            break;
                        }
                        InExtfh.setFileStatus(fcd, 35);
                        break;
                    }
                    case '\ufaf8': {
                        InExtfh theFile = (InExtfh)handles.getObject(InExtfh.getHandle(fcd));
                        if (theFile != null) {
                            theFile.deleteFile(fcd, fileName);
                            break;
                        }
                        InExtfh.setFileStatus(fcd, 35);
                        break;
                    }
                    case '\ufa0e': {
                        InExtfh theFile = (InExtfh)handles.getObject(InExtfh.getHandle(fcd));
                        if (theFile != null) {
                            theFile.unlock(fcd);
                            break;
                        }
                        InExtfh.setFileStatus(fcd, 35);
                        break;
                    }
                    case '\ufadc': {
                        IndexFile.commit(0);
                        InExtfh.setFileStatus(fcd, 0);
                        break;
                    }
                    case '\ufadd': {
                        IndexFile.rollback();
                        InExtfh.setFileStatus(fcd, 0);
                        break;
                    }
                    case '\u0006': {
                        InExtfh theFile = InExtfh.newInExtfh(fcd, fileName, keyDefBlock);
                        theFile.info(fcd);
                        int hndl = InExtfh.getHandle(fcd);
                        if (hndl != 0) {
                            handles.removeHandle(hndl);
                        }
                        break;
                    }
                    default: {
                        InExtfh.setFileStatus(fcd, 35);
                        break;
                    }
                }
            }
            catch (Exception _ex) {
                InExtfh.setFileStatus(fcd, 35);
                if (log == null) break block35;
                log.info("EXTFH Exception caught! " + _ex);
            }
        }
        if (log != null) {
            log.info("EXTFH exit FS=[" + (char)fcd[0] + "," + (char)fcd[1] + "]");
        }
    }

    public InExtfh(byte[] fcd, String name, byte[] kdb) {
        super(fcd);
        this.fileName = name;
        this.recMem = new byte[this.FCD_MAX_REC_LENGTH.toint()];
        this.record = new PicX(this.recMem, 0, this.recMem.length, null, null, "", false, false);
        if (kdb != null && kdb.length >= 40) {
            this.buildKey(kdb);
        } else {
            this.buildKey(dummyKdb);
        }
    }

    private void buildKey(byte[] kbd) {
        this.GLOBAL_INFORMATION_AREA = Factory.getVarAlphanum(kbd, 0, kbd.length, false, null, null, null, "GLOBAL-INFORMATION-AREA", false, false);
        this.KEY_DEFINITION_BLOCK_LENGTH = Factory.getVarCompX(this.GLOBAL_INFORMATION_AREA, 0, 2, false, null, null, null, "KEY-DEFINITION-BLOCK-LENGTH", false, 2, 0, false, false, false);
        this.NUMBER_OF_KEY = Factory.getVarCompX(this.GLOBAL_INFORMATION_AREA, 6, 2, false, null, null, null, "NUMBER-OF-KEY", false, 2, 0, false, false, false);
        int nKeys = this.NUMBER_OF_KEY.toint();
        this.KEY_DEFINITION_BLOCK = Factory.getVarAlphanum(this.GLOBAL_INFORMATION_AREA, 14, 16, false, null, new int[]{16}, new int[]{nKeys}, "KEY-DEFINITION-BLOCK", false, false);
        this.COMPONENT_COUNT = Factory.getVarCompX(this.KEY_DEFINITION_BLOCK, 14, 2, false, null, new int[]{16}, new int[]{nKeys}, "COMPONENT-COUNT", false, 2, 0, false, false, false);
        this.FIRST_COMPONENT_OFFSET = Factory.getVarCompX(this.KEY_DEFINITION_BLOCK, 16, 2, false, null, new int[]{16}, new int[]{nKeys}, "FIRST-COMPONENT-OFFSET", false, 2, 0, false, false, false);
        this.KEY_FLAGS = Factory.getVarCompX(this.KEY_DEFINITION_BLOCK, 18, 1, false, null, new int[]{16}, new int[]{nKeys}, "KEY-FLAGS", false, 1, 0, false, false, false);
        this.COMPRESSIONS_FLAGS = Factory.getVarCompX(this.KEY_DEFINITION_BLOCK, 19, 1, false, null, new int[]{16}, new int[]{nKeys}, "COMPRESSIONS-FLAGS", false, 1, 0, false, false, false);
        this.SPARSE_CHARACTER = Factory.getVarCompX(this.KEY_DEFINITION_BLOCK, 20, 1, false, null, new int[]{16}, new int[]{nKeys}, "SPARSE-CHARACTER", false, 1, 0, false, false, false);
        int sSegs = 14 + 16 * nKeys;
        int nSegs = (kbd.length - sSegs) / 10;
        this.COMPONENTS = Factory.getVarAlphanum(this.GLOBAL_INFORMATION_AREA, sSegs, 10, false, null, new int[]{10}, new int[]{nSegs}, "COMPONENTS", false, false);
        this.COMPONENT_OFFSET = Factory.getVarCompX(this.COMPONENTS, sSegs + 2, 4, false, null, new int[]{10}, new int[]{nSegs}, "COMPONENT-OFFSET", false, 4, 0, false, false, false);
        this.COMPONENT_LENGTH = Factory.getVarCompX(this.COMPONENTS, sSegs + 6, 4, false, null, new int[]{10}, new int[]{nSegs}, "COMPONENT-LENGTH", false, 4, 0, false, false, false);
    }

    private void open(byte[] fcd, char mode) {
        int access;
        boolean optional = mode == '\ufa00' || mode == '\ufa04' || mode == '\ufa08' ? (this.FCD_OTHER_FLAGS.toint() & 0x80) != 0 : (this.FCD_OTHER_FLAGS.toint() & 0x20) == 0;
        switch (this.FCD_ACCESS_MODE.toint() & 0xFFFFFF) {
            default: {
                access = 1;
                break;
            }
            case 4: {
                access = 2;
                break;
            }
            case 8: {
                access = 3;
            }
        }
        this.lockType = 0;
        if ((this.FCD_LOCK_MODE.toint() & 1) != 0) {
            this.lockType = 1;
        }
        if ((this.FCD_LOCK_MODE.toint() & 2) != 0) {
            this.lockType |= 0x80;
        }
        if ((this.FCD_LOCK_MODE.toint() & 0x80) != 0) {
            this.lockType |= 0x100;
        }
        boolean ifm = Config.getProperty(".extfh.intrinsic_file_manager", true);
        int minRecLen = this.FCD_MIN_REC_LENGTH.toint();
        int maxRecLen = this.FCD_MAX_REC_LENGTH.toint();
        switch (this.FCD_ORGANIZATION.toint()) {
            case 0: {
                Class clazz;
                if (!ifm && (clazz = FileTypeManager.getLineSequentialIn()) != FileTypeManager.DEF_LineSequential) {
                    this.file = new LineSequentialDFile(this.fileName, maxRecLen, (ICobolVar)this.record, minRecLen, optional, 1, clazz);
                    break;
                }
                if (mode == '\ufa00') {
                    clazz = ifm ? FileTypeManager.DEF_Input : FileTypeManager.getInputIn();
                    this.file = new LineSeqFile(this.fileName, maxRecLen, (ICobolVar)this.record, minRecLen, optional, clazz);
                    break;
                }
                if (mode == '\ufa01' || mode == '\ufa03') {
                    clazz = ifm ? FileTypeManager.DEF_Output : FileTypeManager.getOutputIn();
                    this.file = new LineSeqFile(this.fileName, maxRecLen, (ICobolVar)this.record, minRecLen, optional, clazz);
                    break;
                }
                if (mode == '\ufa02') {
                    clazz = ifm ? FileTypeManager.DEF_LineSequential : FileTypeManager.getLineSequentialIn();
                    this.file = new LineSequentialDFile(this.fileName, maxRecLen, (ICobolVar)this.record, minRecLen, optional, 1, clazz);
                    break;
                }
                InExtfh.setFileStatus(fcd, 35);
                return;
            }
            case 1: {
                Class clazz = minRecLen != 0 && minRecLen != maxRecLen ? (ifm ? FileTypeManager.DEF_VarSeq : FileTypeManager.getSequentialIn(true)) : (ifm ? FileTypeManager.DEF_Sequential : FileTypeManager.getSequentialIn(false));
                this.file = new SequentialDFile(this.fileName, maxRecLen, (ICobolVar)this.record, minRecLen, optional, 1, clazz);
                break;
            }
            case 2: {
                Class clazz = ifm ? FileTypeManager.DEF_Index : FileTypeManager.getIndexIn();
                this.file = new IndexFile(this.fileName, maxRecLen, (ICobolVar)this.record, minRecLen, optional, access, clazz);
                int nKeys = this.NUMBER_OF_KEY.toint();
                this.keys = new CobolVar[nKeys][];
                int coidx = 1;
                for (int i = 1; i <= nKeys; ++i) {
                    int compCnt = this.COMPONENT_COUNT.at(i).toint();
                    CobolVar[] kSegs = new CobolVar[compCnt];
                    int j = 0;
                    while (j < compCnt) {
                        kSegs[j] = new PicX(this.record, this.COMPONENT_OFFSET.at(coidx).toint(), this.COMPONENT_LENGTH.at(coidx).toint(), null, null, "", false, false);
                        ++j;
                        ++coidx;
                    }
                    this.keys[i - 1] = kSegs;
                    this.file.key(kSegs, (this.KEY_FLAGS.at(i).toint() & 0x40) != 0);
                }
                break;
            }
            case 3: {
                Class clazz = ifm ? FileTypeManager.DEF_Relative : FileTypeManager.getRelativeIn();
                this.file = new RelativeDFile(this.fileName, maxRecLen, (ICobolVar)this.record, minRecLen, optional, access, clazz);
                break;
            }
            default: {
                InExtfh.setFileStatus(fcd, 35);
                return;
            }
        }
        this.file.setAssignExt((this.FCD_OTHER_FLAGS.toint() & 0x10) != 0);
        try {
            switch (mode) {
                case '\ufa00': {
                    this.file.open(new PicX(this.fileName), 1, this.lockType);
                    this.FCD_OPEN_MODE.set(0);
                    break;
                }
                case '\ufa01': {
                    this.file.open(new PicX(this.fileName), 2, this.lockType);
                    this.FCD_OPEN_MODE.set(1);
                    break;
                }
                case '\ufa02': {
                    this.file.open(new PicX(this.fileName), 3, this.lockType);
                    this.FCD_OPEN_MODE.set(2);
                    break;
                }
                case '\ufa03': {
                    this.file.open(new PicX(this.fileName), 6, this.lockType);
                    this.FCD_OPEN_MODE.set(3);
                    break;
                }
                case '\ufa04': 
                case '\ufa05': 
                case '\ufa08': {
                    InExtfh.setFileStatus(fcd, 35);
                    return;
                }
            }
            this.FCD_OPEN_MODE.getMemory();
            InExtfh.setFileStatus(fcd, 0);
        }
        catch (CobolIOException ex) {
            InExtfh.setFileStatus(fcd, this.file.getFileStatus());
        }
    }

    private void close(byte[] fcd, char mode) {
        try {
            this.file.close();
            InExtfh.setFileStatus(fcd, 0);
        }
        catch (CobolIOException ex) {
            InExtfh.setFileStatus(fcd, this.file.getFileStatus());
        }
    }

    private void write(byte[] fcd, char mode, byte[] rec) {
        this.record.set(rec);
        this.XFHFCD.set(fcd);
        try {
            int opts = 0;
            switch (this.FCD_ORGANIZATION.toint()) {
                case 0: 
                case 1: {
                    int advType;
                    switch (mode) {
                        case '\ufae1': {
                            advType = 2;
                            break;
                        }
                        case '\ufae2': {
                            advType = 1;
                            break;
                        }
                        case '\ufae5': {
                            advType = 4;
                            break;
                        }
                        case '\ufae6': {
                            advType = 3;
                            break;
                        }
                        default: {
                            advType = 0;
                            opts = 3;
                        }
                    }
                    this.file.writeAdvancing(advType, this.FCD_LINE_COUNT.toint(), false, this.FCD_CURRENT_REC_LEN.toint(), opts);
                    InExtfh.setFileStatus(fcd, 0);
                    break;
                }
                case 2: {
                    this.file.write(false, this.FCD_CURRENT_REC_LEN.toint());
                    InExtfh.setFileStatus(fcd, 0);
                    break;
                }
                case 3: {
                    this.file.relativeKey(this.FCD_RELATIVE_KEY);
                    this.file.write(false, this.FCD_CURRENT_REC_LEN.toint());
                    InExtfh.setFileStatus(fcd, 0);
                    break;
                }
                default: {
                    InExtfh.setFileStatus(fcd, 35);
                    return;
                }
            }
        }
        catch (CobolIOException ex) {
            InExtfh.setFileStatus(fcd, this.file.getFileStatus());
        }
    }

    private void rewrite(byte[] fcd, char mode, byte[] rec) {
        this.record.set(rec);
        this.XFHFCD.set(fcd);
        try {
            switch (this.FCD_ORGANIZATION.toint()) {
                case 0: 
                case 1: 
                case 2: {
                    this.file.rewrite(false, this.FCD_CURRENT_REC_LEN.toint());
                    InExtfh.setFileStatus(fcd, 0);
                    break;
                }
                case 3: {
                    this.file.relativeKey(this.FCD_RELATIVE_KEY);
                    this.file.rewrite(false, this.FCD_CURRENT_REC_LEN.toint());
                    InExtfh.setFileStatus(fcd, 0);
                    break;
                }
                default: {
                    InExtfh.setFileStatus(fcd, 35);
                    return;
                }
            }
        }
        catch (CobolIOException ex) {
            InExtfh.setFileStatus(fcd, this.file.getFileStatus());
        }
    }

    private void next(byte[] fcd, char mode, byte[] rec) {
        int minLen = rec.length < this.recMem.length ? rec.length : this.recMem.length;
        this.record.set(rec);
        this.XFHFCD.set(fcd);
        boolean lock = mode == '\ufaf5' ? (this.lockType & 0x80) != 0 : mode != '\ufa8d';
        try {
            int len = this.file.readNext(lock, null);
            this.FCD_CURRENT_REC_LEN.link(fcd);
            this.FCD_CURRENT_REC_LEN.set(len);
            this.FCD_CURRENT_REC_LEN.getMemory();
            System.arraycopy(this.recMem, 0, rec, 0, minLen);
            InExtfh.setFileStatus(fcd, 0);
        }
        catch (CobolIOException ex) {
            InExtfh.setFileStatus(fcd, this.file.getFileStatus());
        }
    }

    private void prev(byte[] fcd, char mode, byte[] rec) {
        int minLen = rec.length < this.recMem.length ? rec.length : this.recMem.length;
        this.record.set(rec);
        this.XFHFCD.set(fcd);
        boolean lock = mode == '\ufaf9' ? (this.lockType & 0x80) != 0 : mode != '\ufa8c';
        try {
            int len = this.file.readPrev(lock, null);
            this.FCD_CURRENT_REC_LEN.link(fcd);
            this.FCD_CURRENT_REC_LEN.set(len);
            this.FCD_CURRENT_REC_LEN.getMemory();
            System.arraycopy(this.recMem, 0, rec, 0, minLen);
            InExtfh.setFileStatus(fcd, 0);
        }
        catch (CobolIOException ex) {
            InExtfh.setFileStatus(fcd, this.file.getFileStatus());
        }
    }

    private void read(byte[] fcd, char mode, byte[] rec) {
        int minLen = rec.length < this.recMem.length ? rec.length : this.recMem.length;
        this.record.set(rec);
        this.XFHFCD.set(fcd);
        boolean lock = mode == '\ufaf6' || mode == '\ufac9' ? (this.lockType & 0x80) != 0 : mode != '\ufa8e' && mode != '\ufa8f';
        try {
            int len;
            int nKey = 0;
            if (this.FCD_ORGANIZATION.toint() == 3) {
                this.file.relativeKey(this.FCD_RELATIVE_KEY);
                len = this.file.readKey(null, lock, null);
                System.arraycopy(this.recMem, 0, rec, 0, minLen);
                InExtfh.setFileStatus(fcd, 0);
            } else {
                nKey = this.FCD_KEY_ID.toint();
                if (nKey >= 0 && nKey < this.keys.length) {
                    len = this.file.readKey(this.keys[nKey], lock, null);
                    System.arraycopy(this.recMem, 0, rec, 0, minLen);
                    InExtfh.setFileStatus(fcd, 0);
                } else {
                    len = 0;
                    InExtfh.setFileStatus(fcd, 35);
                }
            }
            this.FCD_CURRENT_REC_LEN.link(fcd);
            this.FCD_CURRENT_REC_LEN.set(len);
            this.FCD_CURRENT_REC_LEN.getMemory();
        }
        catch (CobolIOException ex) {
            InExtfh.setFileStatus(fcd, this.file.getFileStatus());
        }
    }

    private void start(byte[] fcd, char mode, byte[] rec) {
        int type;
        int nKey = this.FCD_KEY_ID.toint();
        int keyLen = this.FCD_KEY_LENGTH.toint();
        this.record.set(rec);
        this.XFHFCD.set(fcd);
        switch (mode) {
            default: {
                nKey = 0;
                keyLen = this.recMem.length;
            }
            case '\ufae9': {
                type = 5;
                break;
            }
            case '\ufaea': {
                type = 6;
                break;
            }
            case '\ufaeb': {
                type = 7;
                break;
            }
            case '\ufafe': {
                type = 8;
                break;
            }
            case '\ufaff': {
                type = 9;
            }
        }
        try {
            if (this.FCD_ORGANIZATION.toint() == 3) {
                this.file.relativeKey(this.FCD_RELATIVE_KEY);
                this.file.start((CobolVar[])null, type, keyLen);
                InExtfh.setFileStatus(fcd, 0);
            } else {
                nKey = this.FCD_KEY_ID.toint();
                if (nKey >= 0 && nKey < this.keys.length) {
                    this.file.start(this.keys[nKey], type, keyLen);
                    InExtfh.setFileStatus(fcd, 0);
                } else {
                    InExtfh.setFileStatus(fcd, 35);
                }
            }
        }
        catch (CobolIOException ex) {
            InExtfh.setFileStatus(fcd, this.file.getFileStatus());
        }
    }

    private void delete(byte[] fcd, byte[] rec) {
        this.record.set(rec);
        this.XFHFCD.set(fcd);
        try {
            if (this.FCD_ORGANIZATION.toint() == 3) {
                this.file.relativeKey(this.FCD_RELATIVE_KEY);
            }
            this.file.delete();
            InExtfh.setFileStatus(fcd, 0);
        }
        catch (CobolIOException ex) {
            InExtfh.setFileStatus(fcd, this.file.getFileStatus());
        }
    }

    private void deleteFile(byte[] fcd, String path) {
        this.XFHFCD.set(fcd);
        try {
            this.file.deleteFile(new PicX(path));
            InExtfh.setFileStatus(fcd, 0);
        }
        catch (CobolIOException ex) {
            InExtfh.setFileStatus(fcd, this.file.getFileStatus());
        }
    }

    private void unlock(byte[] fcd) {
        this.XFHFCD.set(fcd);
        try {
            this.file.unlock();
            InExtfh.setFileStatus(fcd, 0);
        }
        catch (CobolIOException ex) {
            InExtfh.setFileStatus(fcd, this.file.getFileStatus());
        }
    }

    private void info(byte[] fcd) {
        this.XFHFCD.set(fcd);
        DummyDataStream ds = new DummyDataStream();
        try {
            DynamicFile theFile = IndexFile.isIdxInConfig(this.fileName);
            if (theFile == null) {
                theFile = IndexFile.getDefaultDynamicFile(this.fileName);
            }
            if (theFile.open(this.fileName, 1, 0, null, 0, 0, 0, 3, false, false) != 0) {
                int maxRecSize = theFile.getMaxRecordSize();
                int minRecSize = theFile.getMinRecordSize();
                this.FCD_ORGANIZATION.set(2);
                this.FCD_FILE_FORMAT.set(0);
                this.FCD_MAX_REC_LENGTH.set(maxRecSize);
                this.FCD_MIN_REC_LENGTH.set(minRecSize);
                if (maxRecSize == minRecSize) {
                    this.FCD_RECORDING_MODE.set(0);
                } else {
                    this.FCD_RECORDING_MODE.set(1);
                }
                this.FCD_RELADDR_OFFSET.set((long)maxRecSize * theFile.getNumRecords());
                this.FCD_DATA_COMPRESS.set(0);
                int nKeys = theFile.getNumKeys();
                this.NUMBER_OF_KEY.set(nKeys);
                this.buildKey(this.GLOBAL_INFORMATION_AREA.getMemory());
                int coidx = 1;
                for (int i = 1; i <= nKeys; ++i) {
                    KeyDescription kd = theFile.getKey(i - 1);
                    int compCnt = kd.getNumSegments();
                    this.COMPONENT_COUNT.at(i).set(compCnt);
                    if (i == 1) {
                        this.KEY_FLAGS.at(i).set(16);
                    } else {
                        this.KEY_FLAGS.at(i).set(kd.isDup() ? 64 : 0);
                    }
                    this.FIRST_COMPONENT_OFFSET.at(i).set(this.COMPONENTS.at(coidx).getOffset());
                    int j = 0;
                    while (j < compCnt) {
                        KeyDescription.Segs seg = kd.getSegment(j);
                        this.COMPONENT_OFFSET.at(coidx).set(seg.offset);
                        this.COMPONENT_LENGTH.at(coidx).set(seg.size);
                        ++j;
                        ++coidx;
                    }
                }
                if (theFile.close() == 0) {
                    CobolIOException.get(theFile.getCobErrno(), "", ds, 2);
                }
            } else {
                CobolIOException.get(theFile.getCobErrno(), "", ds, 1);
            }
            this.GLOBAL_INFORMATION_AREA.getMemory();
            InExtfh.setFileStatus(fcd, 0);
        }
        catch (CobolIOException ex) {
            InExtfh.setFileStatus(fcd, ds.getFileStatus());
        }
    }

    private static class DummyDataStream
    implements DataStream {
        private String fs = "00";
        private String extFs = "00";
        private String statusMsg = "";

        private DummyDataStream() {
        }

        @Override
        public void setFileStatus(String f) {
            this.fs = f;
        }

        @Override
        public String getFileStatus() {
            return this.fs;
        }

        @Override
        public void setExtendedStatus(String f) {
            this.extFs = f;
        }

        @Override
        public String getExtendedStatus() {
            return this.extFs;
        }

        @Override
        public void setStatusMessage(String f) {
            this.statusMsg = f;
        }

        @Override
        public String getStatusMessage() {
            return this.statusMsg;
        }

        @Override
        public void setLastException(CobolIOException ex) {
        }

        @Override
        public CobolIOException getLastException() {
            return null;
        }

        @Override
        public String getLogicName() {
            return "";
        }

        @Override
        public String getOsPath() {
            return "";
        }

        @Override
        public Logger getLogger() {
            return null;
        }

        @Override
        public void finalize() {
        }
    }
}

