/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventObject;

public class EventListenerFactory {
    private static final Character char_0 = new Character('\u0000');
    private static final Byte byte_0 = new Byte(0);

    public static Object create(Class listenerInterface, Object target, String targetMethodName, Class[] parameterTypes) {
        Method targetMethod = EventListenerFactory.getTargetMethod(target, targetMethodName, parameterTypes);
        return EventListenerFactory.create(listenerInterface, target, targetMethod);
    }

    public static Object create(Class listenerInterface, final Object target, final Method targetMethod) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (args != null && args.length == 1 && EventObject.class.isAssignableFrom(args[0].getClass())) {
                    try {
                        return targetMethod.invoke(target, args[0], method.getName(), new Boolean(method.getExceptionTypes().length > 0));
                    }
                    catch (InvocationTargetException t) {
                        Throwable cause = t.getCause();
                        if (cause != null) {
                            Class<?>[] exceptions = method.getExceptionTypes();
                            for (int i = 0; i < exceptions.length; ++i) {
                                if (!exceptions[i].isAssignableFrom(cause.getClass())) continue;
                                throw cause;
                            }
                            System.err.println(cause);
                            throw t;
                        }
                        System.err.println(t);
                        throw t;
                    }
                }
                return EventListenerFactory.standardInvoke(proxy, method, args);
            }
        };
        ClassLoader cl = listenerInterface.getClassLoader();
        return Proxy.newProxyInstance(cl, new Class[]{listenerInterface}, handler);
    }

    private static Object standardInvoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            String methodName = method.getName();
            if (methodName.equals("hashCode")) {
                return EventListenerFactory.proxyHashCode(proxy);
            }
            if (methodName.equals("equals")) {
                return EventListenerFactory.proxyEquals(proxy, args[0]);
            }
            if (methodName.equals("toString")) {
                return EventListenerFactory.proxyToString(proxy);
            }
        }
        return EventListenerFactory.nullValueOf(method.getReturnType());
    }

    private static Integer proxyHashCode(Object proxy) {
        return new Integer(System.identityHashCode(proxy));
    }

    private static Boolean proxyEquals(Object proxy, Object other) {
        return proxy == other ? Boolean.TRUE : Boolean.FALSE;
    }

    private static String proxyToString(Object proxy) {
        return proxy.getClass().getName() + '@' + Integer.toHexString(proxy.hashCode());
    }

    private static final Object nullValueOf(Class rt) {
        if (!rt.isPrimitive()) {
            return null;
        }
        if (rt == Void.TYPE) {
            return null;
        }
        if (rt == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (rt == Character.TYPE) {
            return char_0;
        }
        return byte_0;
    }

    private static Method getTargetMethod(Object target, String targetMethodName, Class[] parameterTypes) {
        Method[] m = target.getClass().getMethods();
        Method result = null;
        block0: for (int i = 0; i < m.length; ++i) {
            Class<?>[] p;
            if (!targetMethodName.equals(m[i].getName()) || (p = m[i].getParameterTypes()).length != parameterTypes.length) continue;
            for (int j = 0; j < p.length; ++j) {
                if (!p[j].isAssignableFrom(parameterTypes[j])) continue block0;
            }
            if (result != null) {
                throw new RuntimeException("ambiguous method: " + m[i] + " vs. " + result);
            }
            result = m[i];
        }
        if (result == null) {
            throw new RuntimeException("no such method " + targetMethodName + " in " + target.getClass());
        }
        return result;
    }
}

