/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class MouseInfo
implements Externalizable {
    private int mouseRowHdths;
    private int mouseColHdths;
    private boolean leftDown;
    private boolean middleDown;
    private boolean rightDown;
    private int mouseColPx;
    private int mouseRowPx;
    private static final long serialVersionUID = 46376471L;

    public MouseInfo() {
    }

    public MouseInfo(int rowHdths, int colHdths, int rPx, int cPx, boolean lD, boolean mD, boolean rD) {
        this.mouseRowHdths = rowHdths;
        this.mouseColHdths = colHdths;
        this.mouseColPx = cPx;
        this.mouseRowPx = rPx;
        this.leftDown = lD;
        this.middleDown = mD;
        this.rightDown = rD;
    }

    public int getRowHundredths() {
        return this.mouseRowHdths;
    }

    public int getColHundredths() {
        return this.mouseColHdths;
    }

    public int getRow() {
        return this.mouseRowHdths / 100;
    }

    public int getCol() {
        return this.mouseColHdths / 100;
    }

    public int getRowPx() {
        return this.mouseRowPx;
    }

    public int getColPx() {
        return this.mouseColPx;
    }

    public boolean isLeftDown() {
        return this.leftDown;
    }

    public boolean isMiddleDown() {
        return this.middleDown;
    }

    public boolean isRightDown() {
        return this.rightDown;
    }

    public void setRowHundredths(int mouseRowHdths) {
        this.mouseRowHdths = mouseRowHdths;
    }

    public void setColHundredths(int mouseColHdths) {
        this.mouseColHdths = mouseColHdths;
    }

    public void setLeftDown(boolean leftDown) {
        this.leftDown = leftDown;
    }

    public void setMiddleDown(boolean middleDown) {
        this.middleDown = middleDown;
    }

    public void setRightDown(boolean rightDown) {
        this.rightDown = rightDown;
    }

    public void setColPx(int mouseColPx) {
        this.mouseColPx = mouseColPx;
    }

    public void setRowPx(int mouseRowPx) {
        this.mouseRowPx = mouseRowPx;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.mouseRowHdths = in.readInt();
        this.mouseColHdths = in.readInt();
        this.mouseColPx = in.readInt();
        this.mouseRowPx = in.readInt();
        this.leftDown = in.readBoolean();
        this.middleDown = in.readBoolean();
        this.rightDown = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.mouseRowHdths);
        out.writeInt(this.mouseColHdths);
        out.writeInt(this.mouseColPx);
        out.writeInt(this.mouseRowPx);
        out.writeBoolean(this.leftDown);
        out.writeBoolean(this.middleDown);
        out.writeBoolean(this.rightDown);
    }
}

