/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.charva;

import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.EventQueue;
import charva.awt.IllegalComponentStateException;
import charva.awt.Insets;
import charva.awt.Rectangle;
import charva.awt.Toolkit;
import charva.awt.Window;
import charva.awt.event.AWTEvent;
import charva.awt.event.WindowEvent;
import charvax.swing.JButton;
import charvax.swing.JDialog;
import charvax.swing.JFrame;
import charvax.swing.JMenuBar;
import com.iscobol.gui.Constants;
import com.iscobol.gui.client.Justification;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.charva.CobolEventCouple;
import com.iscobol.gui.client.charva.ISCharvaUtility;
import com.iscobol.gui.client.charva.KeyboardBufferQueue;
import com.iscobol.gui.client.charva.RemoteBaseGUIControl;
import com.iscobol.gui.client.charva.RemoteDisplayWindow;
import com.iscobol.gui.client.charva.Terminal;
import com.iscobol.gui.client.charva.TerminalModel;
import java.awt.Color;
import java.util.EventObject;
import java.util.LinkedList;

public class BorderedFrame
implements Runnable,
Constants {
    private Window component;
    private boolean isActive;
    private boolean isActiveAccept;
    private LinkedList fifo = new LinkedList();
    private int type;
    private Thread eventThread;
    RemoteDisplayWindow parentDW;
    private Terminal charTerminal;

    public BorderedFrame(RemoteDisplayWindow dw, BorderedFrame owner, int t) {
        this.type = t;
        this.parentDW = dw;
        switch (this.type) {
            case 2: 
            case 3: 
            case 6: {
                this.component = new MyJFrame(this);
            }
        }
        this.charTerminal = new Terminal(this.parentDW.getGuiFactory());
        this.initialize(dw);
    }

    public boolean isJFrame() {
        return this.component instanceof JFrame;
    }

    public boolean isJDialog() {
        return this.component instanceof JDialog;
    }

    public JFrame getJFrame() {
        if (this.component instanceof JFrame) {
            return (JFrame)this.component;
        }
        return null;
    }

    public JDialog getJDialog() {
        if (this.component instanceof JDialog) {
            return (JDialog)this.component;
        }
        return null;
    }

    public Window getWindow() {
        return this.component;
    }

    public MyJFrame getMFWindow() {
        return (MyJFrame)this.component;
    }

    public void resumeRunBody() {
        if (this.component != null) {
            ((MyJFrame)this.component).resumeRunBody();
        }
    }

    public void suspendRunBody() {
        if (this.component != null) {
            ((MyJFrame)this.component).suspendRunBody();
        }
    }

    private void initialize(RemoteDisplayWindow dw) {
        this.eventThread = new Thread(this);
        this.eventThread.setDaemon(true);
        this.eventThread.setName("Picobol-" + this.eventThread.getName());
        this.eventThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.eventThread != null) {
            CobolEventCouple cc;
            LinkedList linkedList = this.fifo;
            synchronized (linkedList) {
                while (this.fifo.isEmpty()) {
                    try {
                        this.fifo.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                cc = (CobolEventCouple)this.fifo.removeLast();
            }
            if (cc.sendToServer()) continue;
            KeyboardBufferQueue.getInstance().enable(null);
            break;
        }
    }

    public void setActiveAccept(boolean a) {
        this.isActiveAccept = a;
    }

    public boolean isActiveAccept() {
        return this.isActiveAccept;
    }

    public void setActive(boolean a) {
        this.isActive = a;
    }

    public boolean isActive() {
        return this.isActive;
    }

    private void putNewLocalControlFocused(CobolEventCouple cc) {
        if (cc != null && this.parentDW != null && cc.getRemoteRecordAccept() != null) {
            RemoteBaseGUIControl rbgc = this.parentDW.getNewLocalFocusOwner();
            if (rbgc != null) {
                cc.getRemoteRecordAccept().setNewControlFocused(rbgc.getServerId());
            }
            this.parentDW.resetNewLocalFocusOwner();
            cc.getRemoteRecordAccept().setOldFocusValues(this.parentDW.getOldFocusValues());
            this.parentDW.resetOldFocusValues();
        }
    }

    protected void push(CobolEventCouple cc) {
        this.push(cc, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pushWithPriority(CobolEventCouple cc) {
        KeyboardBufferQueue.getInstance().disable();
        this.suspendRunBody();
        this.putNewLocalControlFocused(cc);
        LinkedList linkedList = this.fifo;
        synchronized (linkedList) {
            this.fifo.addLast(cc);
            this.fifo.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void push(CobolEventCouple cc, boolean disableKeyboard) {
        if (disableKeyboard) {
            KeyboardBufferQueue.getInstance().disable();
            this.suspendRunBody();
        }
        this.putNewLocalControlFocused(cc);
        LinkedList linkedList = this.fifo;
        synchronized (linkedList) {
            this.fifo.addFirst(cc);
            this.fifo.notify();
        }
    }

    public void setResizable(boolean b) {
    }

    public Container getContentPane() {
        if (this.component != null) {
            return ((MyWindow)this.component).getContentPane();
        }
        return null;
    }

    public void setInitD(int w, int h) {
        this.pack();
    }

    public void setInitD(int w, int h, float cols, float lines, LocalFontCmp font) {
        this.charTerminal.init(cols, lines, w, h);
        this.charTerminal.setBounds(0, 0, w, h);
        this.setInitD(w, h);
    }

    private void installListeners() {
    }

    public Container getPanel() {
        return this.getContentPane();
    }

    public void setJMenuBar(JMenuBar jmb) {
        ((MyWindow)this.component).setJMenuBar(jmb);
    }

    public void setAutoResize(boolean as) {
    }

    private void addScrollbars() {
    }

    private void removeScrollbars() {
    }

    public void pack() {
        ((MyWindow)this.component).myPack();
    }

    void setDefaultButton(JButton btn) {
    }

    public void setVisible(boolean v) {
    }

    public void internalsetVisible(boolean v) {
        ((MyWindow)this.component).mySetVisible(v);
    }

    private void setVisibleSeparateThread() {
    }

    public java.awt.Rectangle getBounds() {
        Rectangle r = this.component.getBounds();
        java.awt.Rectangle Return2 = new java.awt.Rectangle(r.getTop(), r.getLeft(), r.getBottom(), r.getRight());
        return Return2;
    }

    public void setEnabled(boolean b) {
        this.component.setEnabled(b);
    }

    public boolean isEnabled() {
        return this.component.isEnabled();
    }

    public Component getFocusOwner() {
        return null;
    }

    public void setBackground(Color c) {
        this.charTerminal.setBackground(new charva.awt.Color(c.getRed(), c.getGreen(), c.getBlue()));
    }

    public void setBackColor(Color c) {
        this.charTerminal.setBackColor(new charva.awt.Color(c.getRed(), c.getGreen(), c.getBlue()));
    }

    public void setForeground(Color c) {
        this.charTerminal.setForeground(new charva.awt.Color(c.getRed(), c.getGreen(), c.getBlue()));
    }

    public void box(int x, int y, int w, int h, Color fore, int attr, Color back, String[] titles, int[] tPoss, boolean vert) {
        charva.awt.Color cfore = new charva.awt.Color(fore.getRed(), fore.getGreen(), fore.getBlue());
        charva.awt.Color cback = new charva.awt.Color(back.getRed(), back.getGreen(), back.getBlue());
        this.charTerminal.getTerminalModel().box(x, y, w, h, cfore, attr, cback, titles, tPoss, true, vert, this.charTerminal.getGraphics());
    }

    public java.awt.Rectangle display(int x, int y, String s, int len, Color fore, int attrs, Color back, Justification just) {
        Rectangle r = null;
        charva.awt.Color cfore = new charva.awt.Color(fore.getRed(), fore.getGreen(), fore.getBlue());
        charva.awt.Color cback = new charva.awt.Color(back.getRed(), back.getGreen(), back.getBlue());
        r = this.charTerminal.display(x, y, s, len, cfore, attrs, cback, just);
        return new java.awt.Rectangle(r.getTop(), r.getLeft(), r.getBottom(), r.getRight());
    }

    public Terminal getCharTerminal() {
        return this.charTerminal;
    }

    public void erase(int flg, int col, int line, charva.awt.Color bgColor) {
        TerminalModel tm = this.charTerminal.getTerminalModel();
        switch (flg) {
            case 2: {
                tm.move(col, line);
                tm.clrtoeol();
                break;
            }
            case 1: {
                tm.move(col, line);
                if (bgColor != null) {
                    tm.setBackColor(bgColor);
                }
                tm.clrtobot();
                break;
            }
            case 3: {
                if (bgColor != null) {
                    tm.setBackground(bgColor);
                }
                tm.erase();
            }
        }
        this.charTerminal.repaint();
    }

    public void scroll(int nlines, int col, int line) {
        TerminalModel tm = this.charTerminal.getTerminalModel();
        tm.scroll(nlines);
        this.charTerminal.repaint();
    }

    public java.awt.Rectangle display(String str, boolean eol) {
        TerminalModel tm = this.charTerminal.getTerminalModel();
        Rectangle r = tm.addstr(str.toCharArray());
        if (eol) {
            tm.crlf();
        }
        return new java.awt.Rectangle(r.getTop(), r.getLeft(), r.getBottom(), r.getRight());
    }

    public void setModal(boolean b) {
    }

    public boolean isModal() {
        return false;
    }

    public void setTitle(String t) {
        ((MyWindow)this.component).setTitle(t);
    }

    public void setTitleBar(boolean b) {
    }

    public void setLocation(int x, int y) {
        this.component.setLocation(x, y);
    }

    public boolean isResizable() {
        return false;
    }

    public String getTitle() {
        return ((MyWindow)this.component).getTitle();
    }

    public Insets getInsets() {
        return this.component.getInsets();
    }

    public Dimension getSize() {
        return this.component.getSize();
    }

    public void setState(int st) {
    }

    public void dispose() {
        this.getMFWindow().dispose();
        this.charTerminal.end();
        this.charTerminal = null;
    }

    private static class MyJFrame
    extends JFrame
    implements MyWindow {
        BorderedFrame parent;
        private boolean isDestroyed;
        private boolean suspended;
        KeyboardBufferQueue kbq;

        MyJFrame(BorderedFrame parent) {
            this.parent = parent;
            Container contentPane = this.getContentPane();
            contentPane.setLayout(null);
            contentPane.setSize(0, 0);
            this.kbq = KeyboardBufferQueue.getInstance();
        }

        @Override
        public Component getCurrentFocus() {
            return this.getCurrentFocus(true);
        }

        @Override
        public Component getCurrentFocus(boolean printmsg) {
            Component Return2;
            block2: {
                Return2 = null;
                try {
                    Return2 = super.getCurrentFocus();
                }
                catch (IllegalComponentStateException icse) {
                    if (!printmsg) break block2;
                    ISCharvaUtility.printExceptionToStderr("Window [" + this + "] has currentFocus = null", (Exception)((Object)icse));
                }
            }
            return Return2;
        }

        public void run() {
            if (this.parent.type == 2) {
                new Thread(){

                    @Override
                    public void run() {
                        this.runbody();
                    }
                }.start();
            } else {
                this.runbody();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void runbody() {
            EventQueue evtQueue = this._term.getSystemEventQueue();
            Toolkit tkit = null;
            Window topwin = null;
            Component cf = null;
            try {
                this.isDestroyed = false;
                while (!this.isDestroyed && !this.suspended) {
                    Object evt;
                    tkit = Toolkit.getDefaultToolkit();
                    topwin = tkit.getTopWindow();
                    if (topwin != null && this == topwin) {
                        cf = this.getCurrentFocus(false);
                        if (cf == null) {
                            try {
                                Thread.currentThread();
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        } else if (this.kbq.isEmpty()) {
                            this._term.checkForKeystroke();
                        } else {
                            this.kbq.repostBufEvents(this.getTitle());
                        }
                    }
                    while (!this.isDestroyed && !evtQueue.queuesAreEmpty()) {
                        evt = evtQueue.getNextEvent();
                        if ((evt = this.kbq.dispatchEvent((EventObject)evt, this)) == null) continue;
                        this.processEvent((AWTEvent)evt);
                    }
                    evt = this;
                    synchronized (evt) {
                        while (this.suspended) {
                            this.wait();
                        }
                    }
                }
                return;
            }
            catch (Exception e) {
                ISCharvaUtility.printExceptionToStderr("BorderedFrame exit(1)", e);
                System.exit(1);
            }
        }

        public void pack() {
            this.parent.pack();
        }

        public void setVisible(boolean b) {
            this.parent.setVisible(b);
        }

        @Override
        public void myPack() {
            super.pack();
        }

        @Override
        public void mySetVisible(boolean b) {
            if (this.isVisible() != b) {
                super.setVisible(b);
            }
        }

        public void dispose() {
            this.isDestroyed = true;
            this.processEvent((AWTEvent)new WindowEvent((Window)this, 3));
        }

        @Override
        public boolean isDestroyed() {
            return this.isDestroyed;
        }

        @Override
        public void suspendRunBody() {
            this.suspended = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resumeRunBody() {
            if (!this.isDestroyed) {
                MyJFrame myJFrame = this;
                synchronized (myJFrame) {
                    this.suspended = false;
                    this.notify();
                }
            }
        }
    }

    static interface MyWindow {
        public void myPack();

        public void mySetVisible(boolean var1);

        public Container getContentPane();

        public void setDefaultCloseOperation(int var1);

        public void setTitle(String var1);

        public String getTitle();

        public void setJMenuBar(JMenuBar var1);

        public boolean isDestroyed();

        public Component getCurrentFocus();

        public Component getCurrentFocus(boolean var1);

        public void suspendRunBody();

        public void resumeRunBody();
    }
}

