/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.SwingConstants;

public class DoubleIcon
implements Icon,
SwingConstants {
    private Icon icon1;
    private Icon icon2;
    private int position;
    private int hOrientation;
    private int vOrientation;

    public DoubleIcon(Icon i1, Icon i2) {
        this(i1, i2, 1);
    }

    public DoubleIcon(Icon i1, Icon i2, int pos) {
        this(i1, i2, pos, 0, 0);
    }

    public DoubleIcon(Icon i1, Icon i2, int pos, int ho, int vo) {
        this.icon1 = i1;
        this.icon2 = i2;
        this.position = pos;
        this.hOrientation = ho;
        this.vOrientation = vo;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        if (this.position == 2 || this.position == 4) {
            Icon rightIcon;
            Icon leftIcon;
            if (this.position == 2) {
                leftIcon = this.icon1;
                rightIcon = this.icon2;
            } else {
                leftIcon = this.icon2;
                rightIcon = this.icon1;
            }
            this.paintIcon(c, g, leftIcon, x, y, width, height, 2, this.vOrientation);
            this.paintIcon(c, g, rightIcon, x + leftIcon.getIconWidth(), y, width, height, 2, this.vOrientation);
        } else if (this.position == 1 || this.position == 3) {
            Icon bottomIcon;
            Icon topIcon;
            if (this.position == 1) {
                topIcon = this.icon1;
                bottomIcon = this.icon2;
            } else {
                topIcon = this.icon2;
                bottomIcon = this.icon1;
            }
            this.paintIcon(c, g, topIcon, x, y, width, height, this.hOrientation, 1);
            this.paintIcon(c, g, bottomIcon, x, y + topIcon.getIconHeight(), width, height, this.hOrientation, 1);
        } else {
            this.paintIcon(c, g, this.icon1, x, y, width, height, this.hOrientation, this.vOrientation);
            this.paintIcon(c, g, this.icon2, x, y, width, height, this.hOrientation, this.vOrientation);
        }
    }

    void paintIcon(Component c, Graphics g, Icon icon, int x, int y, int w, int h, int ho, int vo) {
        int yIcon;
        int xIcon;
        switch (ho) {
            case 2: {
                xIcon = x;
                break;
            }
            case 4: {
                xIcon = x + w - icon.getIconWidth();
                break;
            }
            default: {
                xIcon = x + (w - icon.getIconWidth()) / 2;
            }
        }
        switch (vo) {
            case 1: {
                yIcon = y;
                break;
            }
            case 3: {
                yIcon = y + h - icon.getIconHeight();
                break;
            }
            default: {
                yIcon = y + (h - icon.getIconHeight()) / 2;
            }
        }
        icon.paintIcon(c, g, xIcon, yIcon);
    }

    @Override
    public int getIconWidth() {
        if (this.position == 2 || this.position == 4) {
            return this.icon1.getIconWidth() + this.icon2.getIconWidth();
        }
        return Math.max(this.icon1.getIconWidth(), this.icon2.getIconWidth());
    }

    @Override
    public int getIconHeight() {
        if (this.position == 1 || this.position == 3) {
            return this.icon1.getIconHeight() + this.icon2.getIconHeight();
        }
        return Math.max(this.icon1.getIconHeight(), this.icon2.getIconHeight());
    }

    public Icon getIcon1() {
        return this.icon1;
    }

    public Icon getIcon2() {
        return this.icon2;
    }
}

