/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.ComboBox;
import com.iscobol.rts.Factory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class FindJPanel
extends JPanel
implements KeyListener {
    private static final long serialVersionUID = 1246L;
    private static final int SIZEIMG = 24;
    private static final String placeholder = Factory.getSysMsg("enter_text_to_search");
    private static final String CS_IMAGE = "vV.png";
    private static final String CIS_IMAGE = "vV2.png";
    JPanel panelbutton = null;
    JPanel panelfind = null;
    JButton closebtn;
    JButton clearbtn;
    JToggleButton casesensitivebtn;
    private JCheckBox filterBtn;
    private JButton prevBtn;
    private JButton nextBtn;
    JTextComponent findfield;
    ComboBox findcombo;
    Font font;
    Border syntaxborderok;
    ImageIcon closeIcon;
    ImageIcon findIcon;
    ImageIcon clearIcon;
    ImageIcon casesensitiveIcon;
    ImageIcon casenotsensitiveIcon;
    JPanel leftPanel;
    JPanel rightPanel;
    int propsearchpanel = 0;
    private FindListener listener;
    private boolean filterItems = true;
    private boolean filterCaseSensitive;
    private boolean showFilterBtn;
    private boolean showCSBtn;
    private boolean showClearBtn;
    private boolean showNavBtns;
    private boolean showCloseBtn = true;

    private Object makeObj(final String item) {
        return new Object(){

            public String toString() {
                return item;
            }
        };
    }

    public FindJPanel(Font font, ImageIcon closeIcon, ImageIcon findIcon, ImageIcon clearIcon, ImageIcon casesensitiveIcon, ImageIcon casenotsensitiveIcon, int propsearchpanel, int findtimerdelay, boolean casesensitiveState, boolean filterItems, boolean showFilterBtn, boolean showCSBtn, boolean showClearBtn, boolean showNavBtns, boolean showSearchBtns) {
        int cc;
        this.font = font;
        this.findIcon = findIcon;
        this.closeIcon = closeIcon;
        this.propsearchpanel = propsearchpanel;
        this.filterItems = filterItems;
        this.showFilterBtn = showFilterBtn;
        this.showCSBtn = showCSBtn;
        this.showClearBtn = showClearBtn;
        this.showNavBtns = showNavBtns;
        this.setLayout(new BorderLayout(2, 2));
        this.setFont(font);
        this.leftPanel = new JPanel(new GridLayout(1, this.getLeftComponentCount()));
        this.findcombo = new ComboBox(false, false){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 24);
            }
        };
        this.findcombo.setEditable(true);
        this.findcombo.setPlaceholder(Factory.getSysMsg("enter_text_to_search"));
        ((JLabel)((Object)this.findcombo.getRenderer())).setVerticalAlignment(0);
        this.findfield = (JTextComponent)this.findcombo.getEditor().getEditorComponent();
        this.syntaxborderok = this.findfield.getBorder();
        this.findfield.addKeyListener(this);
        if (findtimerdelay > 0) {
            this.findfield.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    FindJPanel.this.listenerfindText(FindJPanel.this.findfield.getText());
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    FindJPanel.this.listenerfindText(FindJPanel.this.findfield.getText());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    FindJPanel.this.listenerfindText(FindJPanel.this.findfield.getText());
                }
            });
        }
        if (propsearchpanel == 0) {
            this.closebtn = new JButton(closeIcon);
            this.closebtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindJPanel.this.closeperformed();
                    FindJPanel.this.listener.sendfinishfiltermsg();
                }
            });
            this.closebtn.setIconTextGap(0);
            this.closebtn.addKeyListener(this);
            this.closebtn.setPreferredSize(new Dimension(24, 24));
            this.closebtn.setMinimumSize(new Dimension(0, 24));
            this.closebtn.setToolTipText(Factory.getSysMsg("close_find_bar"));
            this.closebtn.setContentAreaFilled(true);
            this.closebtn.setBorderPainted(true);
            this.closebtn.setFont(font);
            this.leftPanel.add(this.closebtn);
        } else if (this.closebtn != null) {
            this.leftPanel.remove(this.closebtn);
        }
        this.filterBtn = new JCheckBox(new ImageIcon(this.getClass().getResource("funnel.png")));
        this.filterBtn.setFocusable(false);
        this.filterBtn.addActionListener(e -> {
            boolean b = this.filterBtn.isSelected();
            if (b) {
                this.filterBtn.setBorder(BorderFactory.createLoweredBevelBorder());
                this.filterBtn.setBorderPainted(true);
            } else {
                this.filterBtn.setBorder(BorderFactory.createRaisedBevelBorder());
                this.filterBtn.setBorderPainted(false);
            }
            this.intSetFilterItems(b);
        });
        this.filterBtn.setSelected(filterItems);
        if (filterItems) {
            this.filterBtn.setBorder(BorderFactory.createLoweredBevelBorder());
            this.filterBtn.setBorderPainted(true);
        }
        this.filterBtn.setPreferredSize(new Dimension(24, 24));
        if (this.showFilterBtn) {
            this.leftPanel.add(this.filterBtn);
        }
        this.rightPanel = new JPanel(new GridLayout(1, (cc = this.getRightComponentCount()) > 0 ? cc : 1));
        this.prevBtn = new JButton(new ImageIcon(this.getClass().getResource("chevron_left2.png")));
        this.prevBtn.setMargin(new Insets(0, 0, 0, 0));
        this.prevBtn.setIconTextGap(0);
        this.prevBtn.setFocusable(false);
        this.prevBtn.setPreferredSize(new Dimension(24, 24));
        this.prevBtn.addActionListener(e -> this.listener.findPrevText());
        if (this.showNavBtns) {
            this.rightPanel.add(this.prevBtn);
        }
        this.nextBtn = new JButton(new ImageIcon(this.getClass().getResource("chevron_right2.png")));
        this.nextBtn.setMargin(new Insets(0, 0, 0, 0));
        this.nextBtn.setIconTextGap(0);
        this.nextBtn.setFocusable(false);
        this.nextBtn.setPreferredSize(new Dimension(24, 24));
        this.nextBtn.addActionListener(e -> this.listener.findNextText());
        if (this.showNavBtns) {
            this.rightPanel.add(this.nextBtn);
        }
        this.clearbtn = new JButton(clearIcon);
        this.clearbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindJPanel.this.clearperformed();
                FindJPanel.this.listenerfindText(FindJPanel.this.findfield.getText(), false);
                FindJPanel.this.listener.sendfinishfiltermsg();
            }
        });
        this.clearbtn.setIconTextGap(0);
        this.clearbtn.addKeyListener(this);
        this.clearbtn.setPreferredSize(new Dimension(24, 24));
        this.clearbtn.setToolTipText(Factory.getSysMsg("Clear"));
        this.casesensitivebtn = new JToggleButton();
        this.casesensitivebtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindJPanel.this.listenerfindText(FindJPanel.this.findfield.getText());
            }
        });
        if (this.showClearBtn) {
            this.rightPanel.add(this.clearbtn);
        }
        this.casesensitivebtn.setIconTextGap(0);
        this.casesensitivebtn.addKeyListener(this);
        this.casesensitivebtn.setPreferredSize(new Dimension(24, 24));
        this.casesensitivebtn.setToolTipText(Factory.getSysMsg("match_case"));
        this.casesensitivebtn.setContentAreaFilled(true);
        this.casesensitivebtn.setIcon(casenotsensitiveIcon);
        this.casesensitivebtn.setSelectedIcon(casesensitiveIcon);
        this.casesensitivebtn.setSelected(casesensitiveState);
        this.clearbtn.setBorderPainted(true);
        this.casesensitivebtn.setBorderPainted(true);
        this.clearbtn.setContentAreaFilled(true);
        this.clearbtn.setPreferredSize(new Dimension(24, 24));
        if (this.showCSBtn) {
            this.rightPanel.add(this.casesensitivebtn);
        }
        this.findcombo.setFont(font);
        this.clearbtn.setFont(font);
        this.casesensitivebtn.setFont(font);
        this.findcombo.setMinimumSize(new Dimension(0, 24));
        this.clearbtn.setMinimumSize(new Dimension(0, 24));
        this.casesensitivebtn.setMinimumSize(new Dimension(0, 24));
        this.add((Component)this.findcombo, "Center");
        this.add((Component)this.leftPanel, "West");
        if (showSearchBtns && cc > 0) {
            this.add((Component)this.rightPanel, "East");
        }
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.addKeyListener(this);
        this.setVisible(true);
        this.findfield.requestFocus();
    }

    private void findperformed() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.findcombo.getModel();
        String tmp = this.findfield.getText();
        int n = this.findcombo.getItemCount();
        boolean founded = false;
        for (int i = 0; !founded && i < n; ++i) {
            if (!this.findcombo.getItemAt(i).toString().equals(tmp)) continue;
            founded = true;
        }
        if (!founded) {
            this.findcombo.addItem(tmp);
            this.findfield.setText(tmp);
        }
    }

    private int getLeftComponentCount() {
        int count = 0;
        if (this.showCloseBtn && this.propsearchpanel == 0) {
            ++count;
        }
        if (this.showFilterBtn) {
            ++count;
        }
        return count;
    }

    private int getRightComponentCount() {
        int count = 0;
        if (this.showNavBtns) {
            count += 2;
        }
        if (this.showCSBtn) {
            ++count;
        }
        if (this.showClearBtn) {
            ++count;
        }
        return count;
    }

    public void clearperformed() {
        this.findfield.setText("");
        this.findfield.requestFocus();
    }

    public void closeperformed() {
        this.findperformed();
        this.setVisible(false);
        this.listener.refreshSelection();
        this.listener.requestFocus();
        this.findfield.setText("");
        this.listener.findTextClear(false);
    }

    public void setFindListener(FindListener fl) {
        this.listener = fl;
    }

    public FindListener getFindListener() {
        return this.listener;
    }

    public void findfieldsetBorder(Border b) {
        if (this.findfield != null) {
            this.findfield.setBorder(b);
        }
    }

    public void findfieldrequestFocus() {
        if (this.findfield != null) {
            this.findfield.requestFocus();
        }
    }

    public void findfieldfindText() {
        if (this.findfield != null && this.findfield.getText() != null && this.findfield.getText().length() > 0) {
            this.listenerfindText(this.findfield.getText());
        }
    }

    public void findfieldfindText(boolean starttimer) {
        if (this.findfield != null && this.findfield.getText() != null && this.findfield.getText().length() > 0) {
            this.listenerfindText(this.findfield.getText(), starttimer);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        Component src;
        if (!(e.getKeyCode() != 10 || (src = (Component)e.getSource()) != this.findfield && src instanceof JButton)) {
            this.listener.sendfinishfiltermsg();
        }
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        Component src = (Component)evt.getSource();
        switch (evt.getKeyCode()) {
            case 9: {
                if (evt.isShiftDown()) {
                    if (src == this.closebtn) break;
                    src.transferFocusBackward();
                    break;
                }
                if (src == this.casesensitivebtn) break;
                src.transferFocus();
                break;
            }
            case 38: {
                if (src == this.closebtn) break;
                src.transferFocusBackward();
                break;
            }
            case 37: {
                if (src == this.closebtn || src == this.findfield) break;
                src.transferFocusBackward();
                break;
            }
            case 40: {
                if (src == this.clearbtn) break;
                src.transferFocus();
                break;
            }
            case 39: {
                if (src == this.closebtn || src == this.findfield) break;
                src.transferFocus();
                break;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Component src = (Component)e.getSource();
            if (src == this.findfield || !(src instanceof JButton)) {
                this.findperformed();
                this.listenerfindText(this.findfield.getText(), false);
            } else if (src == this.closebtn) {
                this.closebtn.doClick();
                this.listener.sendfinishfiltermsg();
            } else if (src == this.clearbtn) {
                this.clearbtn.doClick();
                this.listener.sendfinishfiltermsg();
            }
        } else if (e.getKeyCode() == 27) {
            if (this.propsearchpanel == 1) {
                this.clearperformed();
            } else {
                this.closeperformed();
                this.listener.sendfinishfiltermsg();
            }
        } else if (this.listener.isFindKeyPressed(e)) {
            this.findfield.selectAll();
            this.findfield.requestFocus();
        }
    }

    private void listenerfindText(String regexptxt) {
        this.listenerfindText(regexptxt, true);
    }

    private void listenerfindText(String regexptxt, boolean starttimer) {
        this.listener.findText(regexptxt, starttimer, this.casesensitivebtn.isSelected(), this.isFilterItems());
    }

    public void setFontFindComponents(Font f) {
        if (this.panelbutton != null) {
            this.panelbutton.setFont(f);
        }
        if (this.panelfind != null) {
            this.panelfind.setFont(f);
        }
        if (this.closebtn != null) {
            this.closebtn.setFont(f);
        }
        if (this.clearbtn != null) {
            this.clearbtn.setFont(f);
        }
        if (this.casesensitivebtn != null) {
            this.casesensitivebtn.setFont(f);
        }
        if (this.findfield != null) {
            this.findfield.setFont(f);
        }
        if (this.findcombo != null) {
            this.findcombo.setFont(f);
        }
    }

    public Font getFontFindComponents() {
        if (this.panelfind != null) {
            return this.panelfind.getFont();
        }
        return null;
    }

    public String getFindFieldText() {
        return this.findfield.getText();
    }

    public boolean isCasesensitive() {
        return this.casesensitivebtn.isSelected();
    }

    public void setSettings(boolean[] s) {
        this.setFilterItems(s[0]);
        this.setShowFilterButton(s[1]);
        this.setShowNavigationButtons(s[2]);
        this.setShowCleanButton(s[3]);
        this.setFilterCaseSensitive(s[4]);
        this.setShowCaseSensitiveButton(s[5]);
    }

    public boolean isFilterItems() {
        return this.filterItems;
    }

    private void intSetFilterItems(boolean b) {
        this.filterItems = b;
        if (this.listener != null) {
            this.listenerfindText(this.findfield.getText());
        }
    }

    public void setFilterItems(boolean b) {
        if (this.filterItems != b) {
            this.filterBtn.setSelected(b);
            this.filterBtn.setBorderPainted(b);
            if (b) {
                this.filterBtn.setBorder(BorderFactory.createLoweredBevelBorder());
            } else {
                this.filterBtn.setBorder(BorderFactory.createRaisedBevelBorder());
            }
            this.intSetFilterItems(b);
        }
    }

    public void setShowFilterButton(boolean b) {
        if (this.showFilterBtn != b) {
            this.showFilterBtn = b;
            int cc = this.getLeftComponentCount();
            if (cc > 0) {
                ((GridLayout)this.leftPanel.getLayout()).setColumns(cc);
            }
            if (this.showFilterBtn) {
                this.leftPanel.add(this.filterBtn);
            } else {
                this.leftPanel.remove(this.filterBtn);
            }
            this.leftPanel.doLayout();
            this.rightPanel.doLayout();
            this.doLayout();
            this.revalidate();
        }
    }

    public void setShowCaseSensitiveButton(boolean b) {
        if (this.showCSBtn != b) {
            this.showCSBtn = b;
            this.updateRightPanel();
        }
    }

    private void updateLeftPanel(boolean add) {
        int cc = this.getLeftComponentCount();
        this.leftPanel.removeAll();
        if (cc > 0) {
            ((GridLayout)this.leftPanel.getLayout()).setColumns(cc);
        }
        if (this.showCloseBtn) {
            this.leftPanel.add(this.closebtn);
        }
        if (this.showFilterBtn) {
            this.leftPanel.add(this.filterBtn);
        }
        if (add) {
            if (cc == 1) {
                this.add((Component)this.leftPanel, "West");
            }
        } else if (cc == 0) {
            this.remove(this.leftPanel);
        }
        this.leftPanel.doLayout();
        this.leftPanel.revalidate();
        this.rightPanel.doLayout();
        this.findcombo.repaint();
        this.doLayout();
        this.revalidate();
    }

    private void updateRightPanel() {
        this.rightPanel.removeAll();
        int cc = this.getRightComponentCount();
        if (cc > 0) {
            ((GridLayout)this.rightPanel.getLayout()).setColumns(cc);
        }
        if (this.showNavBtns) {
            this.rightPanel.add(this.prevBtn);
            this.rightPanel.add(this.nextBtn);
        }
        if (this.showClearBtn) {
            this.rightPanel.add(this.clearbtn);
        }
        if (this.showCSBtn) {
            this.rightPanel.add(this.casesensitivebtn);
        }
        this.doLayout();
        this.rightPanel.doLayout();
        this.leftPanel.doLayout();
        this.findcombo.repaint();
        this.revalidate();
    }

    public void setShowCleanButton(boolean b) {
        if (this.showClearBtn != b) {
            this.showClearBtn = b;
            this.updateRightPanel();
        }
    }

    public void setShowNavigationButtons(boolean b) {
        if (this.showNavBtns != b) {
            this.showNavBtns = b;
            this.updateRightPanel();
        }
    }

    public void setShowCloseButton(boolean v) {
        if (this.showCloseBtn != v) {
            this.showCloseBtn = v;
            this.updateLeftPanel(this.showCloseBtn);
        }
    }

    public boolean isShowCloseButton() {
        return this.showCloseBtn;
    }

    public void setFilterCaseSensitive(boolean b) {
        if (this.filterCaseSensitive != b) {
            this.casesensitivebtn.setIcon(new ImageIcon(this.getClass().getResource(b ? CS_IMAGE : CIS_IMAGE)));
            this.casesensitivebtn.setActionCommand(b ? CIS_IMAGE : CS_IMAGE);
            this.intSetFilterCaseSensitive(b);
        }
    }

    private void intSetFilterCaseSensitive(boolean b) {
        this.filterCaseSensitive = b;
    }

    public void setSearchPanelSetting(short sIdx, boolean s) {
        switch (sIdx) {
            case 0: {
                this.setFilterItems(s);
                break;
            }
            case 1: {
                this.setShowFilterButton(s);
                break;
            }
            case 2: {
                this.setShowNavigationButtons(s);
                break;
            }
            case 3: {
                this.setShowCleanButton(s);
                break;
            }
            case 4: {
                this.setFilterCaseSensitive(s);
                break;
            }
            case 5: {
                this.setShowCaseSensitiveButton(s);
            }
        }
        this.revalidate();
        this.doLayout();
        this.repaint();
    }

    public static interface FindListener {
        public void findText(String var1, boolean var2, boolean var3, boolean var4);

        public void findTextClear(boolean var1);

        public boolean isFindKeyPressed(KeyEvent var1);

        public void refreshSelection();

        public void requestFocus();

        public void sendfinishfiltermsg();

        public void findNextText();

        public void findPrevText();
    }
}

