/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlrenderer;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class CSSStyle {
    public static final String BACKGROUND = "background";
    public static final String BACKGROUND_COLOR = "background-color";
    public static final String BORDER = "border";
    public static final String BORDER_BOTTOM = "border-bottom";
    public static final String BORDER_LEFT = "border-left";
    public static final String BORDER_RIGHT = "border-right";
    public static final String BORDER_TOP = "border-top";
    public static final String BORDER_STYLE = "border-style";
    public static final String BORDER_WIDTH = "border-width";
    public static final String BORDER_COLOR = "border-color";
    public static final String COLOR = "color";
    public static final String FONT_FAMILY = "font-family";
    public static final String FONT_SIZE = "font-size";
    public static final String HEIGHT = "height";
    public static final String LEFT = "left";
    public static final String LETTER_SPACING = "letter-spacing";
    public static final String OVERFLOW = "overflow";
    public static final String POSITION = "position";
    public static final String SOLID = "solid";
    public static final String TEXT_ALIGN = "text-align";
    public static final String TOP = "top";
    public static final String WIDTH = "width";
    public static final Color TRANSPARENT_COLOR = new Color(255, 255, 255, 0);
    static final int POSITION_RELATIVE = 1;
    static final int POSITION_ABSOLUTE = 2;
    static final int OVERFLOW_HIDDEN = 1;
    private static final HashMap properties = new HashMap();
    private final String name;
    private final CharSequence text;
    private final int csLen;
    private int currIdx;
    private final HashMap attributes;
    private boolean isClass;

    public CSSStyle(String s) {
        this.name = "Anonymous";
        this.attributes = new HashMap();
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        sb.append(s);
        sb.append('}');
        this.text = sb;
        this.csLen = this.text.length();
    }

    public CSSStyle(CharSequence cs, int idx) {
        char c;
        this.text = cs;
        this.csLen = this.text.length();
        this.currIdx = idx;
        this.attributes = new HashMap();
        if (this.text.charAt(this.currIdx) == '.') {
            ++this.currIdx;
            this.isClass = true;
        }
        StringBuffer sb = new StringBuffer();
        while (this.currIdx < this.csLen && (c = this.text.charAt(this.currIdx)) > ' ' && c != '{') {
            sb.append(Character.toLowerCase(c));
            ++this.currIdx;
        }
        this.name = sb.toString();
        while (this.currIdx < this.csLen && (c = this.text.charAt(this.currIdx)) <= ' ' && c != '{') {
            ++this.currIdx;
        }
    }

    public CSSStyle(CSSStyle s) {
        this.name = "$copy";
        this.attributes = new HashMap(s.attributes);
        this.text = new StringBuffer(s.text.toString());
        this.csLen = s.csLen;
    }

    public String getName() {
        return this.name;
    }

    public int parse() throws BadFormatException {
        char c = this.text.charAt(this.currIdx);
        if (c != '{') {
            throw new BadFormatException("Expected '{', found '" + c + "'");
        }
        ++this.currIdx;
        StringBuffer sb = new StringBuffer();
        String key = null;
        String val = null;
        boolean bkgImage = false;
        block5: while (this.currIdx < this.csLen) {
            c = Character.toLowerCase(this.text.charAt(this.currIdx));
            switch (c) {
                case ';': {
                    val = sb.toString();
                    sb.delete(0, sb.length());
                    this.set(key, val);
                    val = null;
                    key = null;
                    bkgImage = false;
                    break;
                }
                case '}': {
                    if (key == null) break block5;
                    val = sb.toString();
                    this.set(key, val);
                    break block5;
                }
                case ':': 
                case '=': {
                    if (!bkgImage) {
                        key = sb.toString();
                        bkgImage = BACKGROUND.equals(key);
                        sb.delete(0, sb.length());
                        break;
                    }
                }
                default: {
                    if (c > ' ') {
                        sb.append(c);
                        break;
                    }
                    if (key == null || sb.length() <= 0 || sb.charAt(sb.length() - 1) == ' ') break;
                    sb.append(' ');
                }
            }
            ++this.currIdx;
        }
        return this.currIdx;
    }

    private void set(String key, String val) throws BadFormatException {
        GetObject go = (GetObject)properties.get(key);
        if (go == null) {
            throw new BadFormatException("Unhandled attribute: " + key);
        }
        this.attributes.put(key, go.get(val));
    }

    public Object get(String key) {
        return this.attributes.get(key);
    }

    public void mixUp(CSSStyle classStyle) {
        if (classStyle != null) {
            Set keys = classStyle.attributes.keySet();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                if (this.attributes.get(key) != null) continue;
                this.attributes.put(key, classStyle.attributes.get(key));
            }
        }
    }

    private static String attrToString(Object o) {
        String Return2;
        if (o instanceof Color) {
            StringBuffer sb = new StringBuffer();
            Color c = (Color)o;
            int cc = c.getAlpha();
            if (cc == 0) {
                sb.append("transparent");
            } else {
                sb.append("#");
                cc = c.getRed();
                if (cc < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(cc));
                cc = c.getGreen();
                if (cc < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(cc));
                cc = c.getBlue();
                if (cc < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(cc));
            }
            Return2 = sb.toString();
        } else {
            Return2 = o != null ? o.toString() : "null";
        }
        return Return2;
    }

    public String getContent() {
        StringBuffer Return2 = new StringBuffer();
        Set keys = this.attributes.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            Return2.append(key);
            Return2.append(":");
            Return2.append(CSSStyle.attrToString(this.attributes.get(key)));
            Return2.append("; ");
        }
        return Return2.toString();
    }

    public String toString() {
        StringBuffer Return2 = new StringBuffer();
        if (this.isClass) {
            Return2.append('.');
        }
        Return2.append(this.name);
        Return2.append(" {");
        Return2.append(this.getContent());
        Return2.append("}");
        return Return2.toString();
    }

    static {
        properties.put(BACKGROUND, new GetImage());
        properties.put(BACKGROUND_COLOR, new GetColor());
        properties.put(BORDER, new Border());
        properties.put(BORDER_BOTTOM, new Border());
        properties.put(BORDER_LEFT, new Border());
        properties.put(BORDER_RIGHT, new Border());
        properties.put(BORDER_TOP, new Border());
        properties.put(BORDER_STYLE, new Border());
        properties.put(BORDER_WIDTH, new GetInteger());
        properties.put(BORDER_COLOR, new GetColor());
        properties.put(COLOR, new GetColor());
        properties.put(FONT_FAMILY, new GetString());
        properties.put(FONT_SIZE, new GetFontSizePt());
        properties.put(HEIGHT, new GetInteger());
        properties.put(LEFT, new GetInteger());
        properties.put(LETTER_SPACING, new GetString());
        properties.put(OVERFLOW, new GetString());
        properties.put(POSITION, new GetString());
        properties.put(SOLID, new GetColor());
        properties.put(TEXT_ALIGN, new GetString());
        properties.put(TOP, new GetInteger());
        properties.put(WIDTH, new GetInteger());
    }

    private static class GetFontSizePt
    extends GetObject {
        private GetFontSizePt() {
        }

        @Override
        public Object get(String o) {
            return new FontSizePt(this.getFloat(o));
        }
    }

    private static class GetImage
    extends GetObject {
        private GetImage() {
        }

        @Override
        public Object get(String o) {
            return o;
        }
    }

    private static class GetString
    extends GetObject {
        private GetString() {
        }

        @Override
        public Object get(String o) {
            return o;
        }
    }

    private static class GetColor
    extends GetObject {
        private GetColor() {
        }

        @Override
        public Object get(String o) {
            return this.getColor(o);
        }
    }

    private static class GetFloat
    extends GetObject {
        private GetFloat() {
        }

        @Override
        public Object get(String o) {
            return this.getFloat(o);
        }
    }

    private static class GetInteger
    extends GetObject {
        private GetInteger() {
        }

        @Override
        public Object get(String o) {
            return this.getInteger(o);
        }
    }

    public static class Border
    extends GetObject {
        private Integer depth;
        private String style;
        private Color color;

        @Override
        public Object get(String o) {
            Border Return2 = new Border();
            Integer d = null;
            String s = null;
            Color c = null;
            StringTokenizer st = new StringTokenizer(o);
            if (st.hasMoreElements()) {
                d = this.getInteger(st.nextToken());
                if (st.hasMoreElements()) {
                    s = st.nextToken();
                    if (st.hasMoreElements()) {
                        c = this.getColor(st.nextToken());
                    }
                }
            }
            Return2.depth = d;
            Return2.style = s;
            Return2.color = c;
            return Return2;
        }

        public int getDepth() {
            if (this.depth != null) {
                return this.depth;
            }
            return -1;
        }

        public String getStyle() {
            return this.style;
        }

        public Color getColor() {
            return this.color;
        }

        public String toString() {
            StringBuffer Return2 = new StringBuffer();
            Return2.append(this.depth);
            if (this.style != null) {
                Return2.append(' ');
                Return2.append(this.style);
                if (this.color != null) {
                    Return2.append(' ');
                    Return2.append(CSSStyle.attrToString(this.color));
                }
            }
            return Return2.toString();
        }
    }

    private static abstract class GetObject {
        private GetObject() {
        }

        abstract Object get(String var1);

        private final int getInt(String o) {
            int Return2 = 0;
            char[] w = o.toCharArray();
            for (int i = 0; i < w.length; ++i) {
                if (w[i] < '0' || w[i] > '9') continue;
                Return2 *= 10;
                Return2 += w[i] - 48;
            }
            return Return2;
        }

        public Integer getInteger(String o) {
            return new Integer(this.getInt(o));
        }

        public Float getFloat(String o) {
            return new Float(this.getInt(o));
        }

        public Color getColor(String o) {
            Color Return2;
            if (o.length() == 0) {
                Return2 = null;
            } else if (o.charAt(0) == '#' && o.length() >= 7) {
                try {
                    Return2 = new Color(Integer.valueOf(o.substring(1, 7), 16));
                }
                catch (Exception _ex) {
                    Return2 = null;
                }
            } else {
                Return2 = "transparent".equals(o) ? TRANSPARENT_COLOR : ("red".equals(o) ? Color.red : ("green".equals(o) ? Color.green : ("blue".equals(o) ? Color.blue : ("yellow".equals(o) ? Color.yellow : ("cyan".equals(o) ? Color.cyan : ("magenta".equals(o) ? Color.magenta : ("white".equals(o) ? Color.white : ("black".equals(o) ? Color.black : null))))))));
            }
            return Return2;
        }
    }

    public static class FontSizePt {
        final Float value;

        FontSizePt(Float n) {
            this.value = n;
        }

        public Float getValue() {
            return this.value;
        }

        public String toString() {
            return "" + this.value + "pt";
        }
    }

    public static class BadFormatException
    extends Exception {
        BadFormatException(String msg) {
            super(msg);
        }
    }
}

