/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import IT.picosoft.isam.FLock;
import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.OSFile;
import com.iscobol.io.BufferedOSFile;
import com.iscobol.io.DynamicRelative;
import com.iscobol.rts.KeyDescription;
import java.util.Enumeration;

public class DynamicSequential
extends DynamicRelative {
    protected long currPos;
    protected long fileLen;
    protected FLock lckExt = new FLock();

    @Override
    public int getCobErrno() {
        switch (this.errno) {
            case 100: {
                return 137;
            }
        }
        return super.getCobErrno();
    }

    @Override
    protected OSFile getOSFile(boolean xLock) {
        if (xLock) {
            return new BufferedOSFile();
        }
        return new OSFile();
    }

    private synchronized void unlockAll() throws IsamException {
        Enumeration en = this.allLocks.elements();
        while (en.hasMoreElements()) {
            FLock lck = (FLock)en.nextElement();
            lck.l_type = (short)2;
            this.theFile.fcntl(6, lck);
        }
        this.allLocks.clear();
    }

    protected synchronized void lock(long pos, int len) throws IsamException {
        if (this.exclusiveLock) {
            return;
        }
        FLock lck = new FLock();
        try {
            lck.l_whence = 0;
            lck.l_start = pos;
            lck.l_len = len;
            lck.l_type = this.readLock || this.openMode == 1 ? (short)0 : 1;
            if (!this.multipleLock) {
                this.unlockAll();
            }
            this.theFile.fcntl(6, lck);
            this.allLocks.put(new Long(pos), lck);
        }
        catch (IsamException ex) {
            if (ex.getIserrno() == 113) {
                throw new IsamException(107);
            }
            throw ex;
        }
    }

    @Override
    public int open(String path, int openType, int lockType, KeyDescription[] k, int maxRec, int minRec, int nKeys, int accessMode, boolean optional, boolean assignExt) {
        int Return2 = super.open(path, openType, lockType, k, maxRec, minRec, nKeys, accessMode, optional, assignExt);
        if (Return2 == 1) {
            try {
                this.fileLen = this.theFile.length();
                if (this.openMode == 6) {
                    this.lckExt.l_whence = 0;
                    this.lckExt.l_start = 0L;
                    this.lckExt.l_len = 1;
                    this.currPos = this.fileLen;
                    this.theFile.seek(this.currPos);
                }
            }
            catch (IsamException _ex) {
                return this.mapError(_ex);
            }
        }
        return Return2;
    }

    @Override
    public long write(byte[] record, int offs, int len, boolean lock) {
        block9: {
            this.errno = 0;
            if (len > this.maxRecordSize) {
                len = this.maxRecordSize;
            }
            try {
                if (this.currPos >= this.fileLen) {
                    if (this.openMode == 6) {
                        if (!this.exclusiveLock) {
                            this.lckExt.l_type = 1;
                            this.theFile.fcntl(6, this.lckExt);
                        }
                        this.theFile.seek(this.theFile.length());
                    }
                    this.theFile.write(record, offs, len);
                    if (this.openMode != 6 && len < this.maxRecordSize) {
                        len = this.maxRecordSize;
                        this.theFile.seek(this.currPos + (long)len);
                    } else if (this.openMode == 6 && !this.exclusiveLock) {
                        this.lckExt.l_type = (short)2;
                        this.theFile.fcntl(6, this.lckExt);
                    }
                    this.currPos += (long)len;
                    this.fileLen += (long)len;
                    break block9;
                }
                return this.mapError(new IsamException(100));
            }
            catch (IsamException _ex) {
                return this.mapError(_ex);
            }
        }
        return 1L;
    }

    @Override
    public long rewrite(byte[] record, int offs, int len, boolean lock) {
        this.errno = 0;
        if (len > this.maxRecordSize) {
            len = this.maxRecordSize;
        }
        if (this.currPos == 0L || this.currPos - (long)this.maxRecordSize < 0L) {
            this.errno = -2;
            return 0L;
        }
        try {
            this.theFile.seek(this.currPos - (long)this.maxRecordSize);
            this.theFile.write(record, offs, len);
            if (len < this.maxRecordSize) {
                this.theFile.seek(this.currPos);
            }
        }
        catch (IsamException _ex) {
            return this.mapError(_ex);
        }
        return 1L;
    }

    @Override
    public synchronized long next(byte[] record, int offs, int lock) {
        int Return2;
        int len = record.length - offs;
        this.errno = 0;
        if (len > this.maxRecordSize) {
            len = this.maxRecordSize;
        }
        try {
            if (this.currPos < 0L) {
                return this.mapError(new IsamException(112));
            }
            Return2 = this.theFile.read(record, offs, len);
            if (Return2 <= 0) {
                this.currPos = -1L;
                return this.mapError(new IsamException(110));
            }
            if (lock > 0) {
                this.lock(this.currPos, this.maxRecordSize);
            }
            if (len < this.maxRecordSize) {
                len = this.maxRecordSize;
                this.theFile.seek(this.currPos + (long)len);
            }
            this.currPos += (long)len;
        }
        catch (IsamException _ex) {
            return this.mapError(_ex);
        }
        return Return2;
    }

    @Override
    public synchronized long previous(byte[] record, int offs, int lock) {
        int Return2;
        int len = record.length - offs;
        this.errno = 0;
        if (len > this.maxRecordSize) {
            len = this.maxRecordSize;
        }
        if (this.theFile == null) {
            return this.mapError(new IsamException(110));
        }
        if (this.currPos < 0L) {
            return this.mapError(new IsamException(112));
        }
        long ppos = this.currPos - (long)(this.maxRecordSize << 1);
        if (ppos < 0L) {
            return this.mapError(new IsamException(110));
        }
        try {
            this.currPos = ppos;
            this.theFile.seek(ppos);
            Return2 = this.theFile.read(record, offs, len);
            if (Return2 <= 0) {
                this.currPos = -1L;
                return this.mapError(new IsamException(110));
            }
            if (lock > 0) {
                this.lock(this.currPos, this.maxRecordSize);
            }
            if (len < this.maxRecordSize) {
                len = this.maxRecordSize;
                this.theFile.seek(this.currPos + (long)len);
            }
            this.currPos += (long)len;
        }
        catch (IsamException _ex) {
            return this.mapError(_ex);
        }
        return Return2;
    }

    @Override
    public int unlock() {
        try {
            this.unlockAll();
        }
        catch (IsamException _ex) {
            return this.mapError(_ex);
        }
        return 1;
    }
}

