/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.misc.javabeans;

import com.iscobol.misc.javabeans.StyledTextPane;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Utilities;

public class LineNumberRuler
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int length = 1;
    private int width = 10;
    private StyledTextPane textPane;

    public LineNumberRuler(StyledTextPane textPane) {
        this.textPane = textPane;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        FontMetrics fontMetrics = this.textPane.getFontMetrics(this.getFont());
        Insets insets = this.getInsets();
        int availableWidth = this.getSize().width - insets.left - insets.right;
        Rectangle clip = g.getClipBounds();
        int rowStartOffset = this.textPane.viewToModel(new Point(0, clip.y));
        int endOffset = this.textPane.viewToModel(new Point(0, clip.y + clip.height));
        while (rowStartOffset <= endOffset) {
            try {
                String lineNumber = this.getTextLineNumber(rowStartOffset);
                int stringWidth = fontMetrics.stringWidth(lineNumber);
                int x = this.getOffsetX(availableWidth, stringWidth) + insets.left - 1;
                int y = this.getOffsetY(rowStartOffset, fontMetrics);
                g.setColor(this.getForeground());
                g.drawString(lineNumber, x, y);
                rowStartOffset = Utilities.getRowEnd(this.textPane, rowStartOffset) + 1;
            }
            catch (Exception e) {
                // empty catch block
                break;
            }
        }
        g.setColor(Color.lightGray);
        g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    private int getOffsetY(int rowStartOffset, FontMetrics fontMetrics) throws BadLocationException {
        Rectangle r = this.textPane.modelToView(rowStartOffset);
        int y = r.y + r.height;
        int descent = 0;
        descent = fontMetrics.getDescent();
        return y - descent;
    }

    private int getOffsetX(int availableWidth, int stringWidth) {
        return availableWidth - stringWidth;
    }

    private String getTextLineNumber(int rowStartOffset) {
        int lineNumber = this.textPane.getLineNumber(rowStartOffset);
        return lineNumber > 0 ? Integer.toString(lineNumber) : "";
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.textPane.getPreferredSize().height);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.updateWidth();
    }

    public void setLength(int len) {
        this.length = len;
        this.updateWidth();
    }

    public int getLength() {
        return this.length;
    }

    protected void updateWidth() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.width = fm.charWidth('X') * this.length + 5;
        if (this.textPane != null && this.getParent() != null) {
            this.setPreferredSize(this.getPreferredSize());
            this.getParent().doLayout();
        }
    }
}

